/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.rest;

import com.dtyunxi.cube.commons.beans.ApiResult;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;

public class BaseResource {
    public <T> ApiResult<T> makeResult(String code, String msg, T res) {
        return new ApiResult(code, msg, res);
    }

    public <T> ApiResult<T> makeResult(ExceptionCode status, T res) {
        return new ApiResult(status.getCode(), status.getMsg(), res);
    }

    public <T> ApiResult<T> makeResult(ExceptionCode status, String detail) {
        return new ApiResult(status.getCode(), status.getMsg() + "\uff1a" + detail, null);
    }

    public <T> ApiResult<T> success(String msg, T res) {
        return this.makeResult(ExceptionCode.SUCCESS.getCode(), msg, res);
    }

    public <T> ApiResult<T> success(T res) {
        return this.makeResult(ExceptionCode.SUCCESS, res);
    }

    public <T> ApiResult<T> fail(ExceptionCode error) {
        return this.makeResult(error, null);
    }

    public <T> ApiResult<T> fail(ExceptionCode error, String detail) {
        return this.makeResult(error, detail);
    }

    public <T> ApiResult<T> fail(String code, String msg) {
        return this.makeResult(code, msg, null);
    }

    public <T> ApiResult<T> fail(String code, String msg, T res) {
        return this.makeResult(code, msg, res);
    }

    public <T> ApiResult<T> fail(String msg) {
        return this.makeResult(ExceptionCode.FAIL.getCode(), msg, null);
    }

    public <T> ApiResult<T> fail() {
        return this.makeResult(ExceptionCode.FAIL, null);
    }
}

