/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.rest;

import feign.MethodMetadata;
import feign.Request;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class CubeSpringMvcContract
extends SpringMvcContract {
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        String pathValue;
        if (!RequestMapping.class.isInstance(methodAnnotation) && !methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        Object[] methods = methodMapping.method();
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.GET};
        }
        this.checkOne(method, methods, "method");
        data.template().method(Request.HttpMethod.valueOf((String)methods[0].name()));
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && (pathValue = Util.emptyToNull((String)methodMapping.value()[0])) != null) {
            if (!(pathValue = this.resolve(pathValue)).startsWith("/") && !data.template().path().endsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().uri(pathValue, true);
        }
        this.parseProduces(data, method, methodMapping);
        this.parseConsumes(data, method, methodMapping);
        this.parseHeaders(data, method, methodMapping);
        data.indexToExpander(new LinkedHashMap());
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private String resolve(String value) {
        if (StringUtils.hasText((String)value) && this.resourceLoader instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)this.resourceLoader).getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }

    private void parseProduces(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientAccepts;
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header(ACCEPT, new String[]{clientAccepts});
        }
    }

    private void parseConsumes(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientProduces;
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    private void parseHeaders(MethodMetadata md, Method method, RequestMapping annotation) {
        if (annotation.headers() != null && annotation.headers().length > 0) {
            for (String header : annotation.headers()) {
                int index = header.indexOf(61);
                if (header.contains("!=") || index < 0) continue;
                md.template().header(this.resolve(header.substring(0, index)), new String[]{this.resolve(header.substring(index + 1).trim())});
            }
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

