/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.rest;

import com.dtyunxi.cube.framework.rest.ApiSignatureException;
import com.dtyunxi.cube.framework.rest.RestSignUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class RestClient {
    private final Logger logger = LoggerFactory.getLogger(RestClient.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private ClientHttpRequestInterceptor signInterceptor;
    private final ClientHttpRequestInterceptor headerWrapperInterceptor;
    private final HttpHeaders httpHeaders = new HttpHeaders();
    private SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
    private int defaultConnectTimeout = 3000;
    private int defaultReadTimeout = 20000;

    public RestClient() {
        this.reInitMessageConverter();
        this.headerWrapperInterceptor = new HttpRequestHeaderWrapperInterceptor();
        this.restTemplate.setInterceptors(Collections.singletonList(this.headerWrapperInterceptor));
        this.requestFactory.setConnectTimeout(this.defaultConnectTimeout);
        this.requestFactory.setReadTimeout(this.defaultReadTimeout);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)this.requestFactory);
    }

    public RestClient(int connectTimeout, int readTimeout) {
        this.reInitMessageConverter();
        this.headerWrapperInterceptor = new HttpRequestHeaderWrapperInterceptor();
        this.restTemplate.setInterceptors(Collections.singletonList(this.headerWrapperInterceptor));
        this.requestFactory.setConnectTimeout(connectTimeout);
        this.requestFactory.setReadTimeout(readTimeout);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)this.requestFactory);
    }

    public RestClient(String appkey, String privateKey) {
        this.reInitMessageConverter();
        this.signInterceptor = new HttpRequestSignInterceptor(appkey, privateKey);
        this.headerWrapperInterceptor = new HttpRequestHeaderWrapperInterceptor();
        this.restTemplate.setInterceptors(Arrays.asList(this.signInterceptor, this.headerWrapperInterceptor));
        this.requestFactory.setConnectTimeout(this.defaultConnectTimeout);
        this.requestFactory.setReadTimeout(this.defaultReadTimeout);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)this.requestFactory);
    }

    public RestClient(String appkey, String privateKey, int connectTimeout, int readTimeout) {
        this.reInitMessageConverter();
        this.signInterceptor = new HttpRequestSignInterceptor(appkey, privateKey);
        this.headerWrapperInterceptor = new HttpRequestHeaderWrapperInterceptor();
        this.restTemplate.setInterceptors(Arrays.asList(this.signInterceptor, this.headerWrapperInterceptor));
        this.requestFactory.setConnectTimeout(connectTimeout);
        this.requestFactory.setReadTimeout(readTimeout);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)this.requestFactory);
    }

    public void setNeedSign(boolean needSign) {
        if (this.signInterceptor == null) {
            this.logger.warn("\u7b7e\u540d\u8fc7\u6ee4\u5668\uff08HttpRequestSignInterceptor\uff09\u6ca1\u6709\u521d\u59cb\u5316");
        } else {
            ((HttpRequestSignInterceptor)this.signInterceptor).setNeedSign(needSign);
        }
    }

    public RestClient addHeader(String name, String value) {
        this.httpHeaders.add(name, value);
        return this;
    }

    public void removeHeader(String name) {
        this.httpHeaders.remove((Object)name);
    }

    public RestClient setHeader(String name, String value) {
        this.httpHeaders.set(name, value);
        return this;
    }

    public RestClient clearHeaders() {
        this.httpHeaders.clear();
        return this;
    }

    private void reInitMessageConverter() {
        List converterList = this.restTemplate.getMessageConverters();
        Iterator iterator = converterList.iterator();
        while (iterator.hasNext()) {
            HttpMessageConverter item = (HttpMessageConverter)iterator.next();
            if (!(item instanceof StringHttpMessageConverter)) continue;
            int index = converterList.indexOf(item);
            iterator.remove();
            StringHttpMessageConverter converter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
            converterList.add(index, converter);
            break;
        }
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.restTemplate.setMessageConverters(messageConverters);
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.restTemplate.getMessageConverters();
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.restTemplate.setErrorHandler(errorHandler);
    }

    public ResponseErrorHandler getErrorHandler() {
        return this.restTemplate.getErrorHandler();
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... urlVariables) {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(URI url, Class<T> responseType) {
        return (T)this.restTemplate.getForObject(url, responseType);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... urlVariables) {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) {
        return this.restTemplate.getForEntity(url, responseType);
    }

    public HttpHeaders headForHeaders(String url, Object ... urlVariables) {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(String url, Map<String, ?> urlVariables) {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(URI url) {
        return this.restTemplate.headForHeaders(url);
    }

    public URI postForLocation(String url, Object request, Object ... urlVariables) {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(String url, Object request, Map<String, ?> urlVariables) {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(URI url, Object request) {
        return this.restTemplate.postForLocation(url, request);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        return (T)this.restTemplate.postForObject(url, request, responseType, uriVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) {
        return (T)this.restTemplate.postForObject(url, request, responseType, uriVariables);
    }

    public <T> T postForObject(URI url, Object request, Class<T> responseType) {
        return (T)this.restTemplate.postForObject(url, request, responseType);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.postForEntity(url, request, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.postForEntity(url, request, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(URI url, Object request, Class<T> responseType) {
        return this.restTemplate.postForEntity(url, request, responseType);
    }

    public void put(String url, Object request, Object ... urlVariables) {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(String url, Object request, Map<String, ?> urlVariables) {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(URI url, Object request) {
        this.restTemplate.put(url, request);
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType) {
        HttpEntity req = new HttpEntity(request, (MultiValueMap)this.httpHeaders);
        ResponseEntity resultEntity = this.restTemplate.exchange(url, HttpMethod.PUT, req, responseType, new Object[0]);
        return (T)resultEntity.getBody();
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) {
        HttpEntity req = new HttpEntity(request, (MultiValueMap)this.httpHeaders);
        ResponseEntity resultEntity = this.restTemplate.exchange(url, HttpMethod.PUT, req, responseType, uriVariables);
        return (T)resultEntity.getBody();
    }

    public <T> T putForObject(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity req = new HttpEntity(request, (MultiValueMap)this.httpHeaders);
        ResponseEntity resultEntity = this.restTemplate.exchange(url, HttpMethod.PUT, req, responseType, uriVariables);
        return (T)resultEntity.getBody();
    }

    public void delete(String url, Object ... urlVariables) {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(String url, Map<String, ?> urlVariables) {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(URI url) {
        this.restTemplate.delete(url);
    }

    public Set<HttpMethod> optionsForAllow(String url, Object ... urlVariables) {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> urlVariables) {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(URI url) {
        return this.restTemplate.optionsForAllow(url);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        return this.restTemplate.exchange(url, method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) {
        return this.restTemplate.exchange(requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        return this.restTemplate.exchange(requestEntity, responseType);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Object ... urlVariables) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, ?> urlVariables) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor);
    }

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        this.restTemplate.setInterceptors(interceptors);
    }

    private class HttpRequestHeaderWrapperInterceptor
    implements ClientHttpRequestInterceptor {
        private HttpRequestHeaderWrapperInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request);
            requestWrapper.getHeaders().putAll((Map)RestClient.this.httpHeaders);
            return execution.execute(request, body);
        }
    }

    private class HttpRequestSignInterceptor
    implements ClientHttpRequestInterceptor {
        private final String appKey;
        private final String privateKey;
        private boolean needSign = true;

        public HttpRequestSignInterceptor(String appKey, String privateKey) {
            this.appKey = appKey;
            this.privateKey = privateKey;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            if (this.isNeedSign()) {
                String url = request.getURI().getPath();
                HttpHeaders headers = request.getHeaders();
                String query = request.getURI().getQuery();
                Map<String, String> queryMap = null;
                queryMap = HttpMethod.GET.equals((Object)request.getMethod()) ? this.queryToMap(query) : new HashMap<String, String>();
                this.sign(url, queryMap, body, headers);
            }
            return execution.execute(request, body);
        }

        private void sign(String url, Map<String, String> queryMap, byte[] body, HttpHeaders headers) {
            if (StringUtils.isEmpty((Object)this.appKey)) {
                throw new ApiSignatureException(HttpStatus.BAD_REQUEST, "\u7b7e\u540d\u5931\u8d25\uff0cAppkey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)this.privateKey)) {
                throw new ApiSignatureException(HttpStatus.BAD_REQUEST, "\u7b7e\u540d\u5931\u8d25\uff0c\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MediaType contentType = headers.getContentType();
            String sign = null;
            sign = contentType != null && contentType.includes(MediaType.MULTIPART_FORM_DATA) ? RestSignUtil.sign((String)this.appKey, (String)url, queryMap, (byte[])new byte[0], (String)this.privateKey) : RestSignUtil.sign((String)this.appKey, (String)url, queryMap, (byte[])body, (String)this.privateKey);
            headers.set("Appkey", this.appKey);
            headers.set("sign", sign);
        }

        public boolean isNeedSign() {
            return this.needSign;
        }

        public void setNeedSign(boolean needSign) {
            this.needSign = needSign;
        }

        private Map<String, String> queryToMap(String query) {
            String[] split;
            HashMap<String, String> queryMap = new HashMap<String, String>();
            if (StringUtils.isEmpty((Object)query)) {
                return queryMap;
            }
            for (String str : split = query.split("&")) {
                String[] split2 = str.split("=");
                if (split2.length == 1) {
                    queryMap.put(split2[0], "");
                    continue;
                }
                queryMap.put(split2[0], split2[1]);
            }
            return queryMap;
        }
    }

    public static class HttpHeaderNames {
        public static final String APP_KEY = "Appkey";
        public static final String SIGN = "sign";
    }
}

