/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.apihub.sdkclient.sms;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.apihub.sdkclient.base.SdkReqMethod;
import com.dtyunxi.huieryun.apihub.sdkclient.sms.SmsSdkRequest;
import com.dtyunxi.huieryun.apihub.sdkclient.sms.SmsSdkResponse;
import com.dtyunxi.huieryun.apihub.sdkclient.util.HttpUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsSDKClient {
    private static Logger logger = LoggerFactory.getLogger(SmsSDKClient.class);
    public static final String TPLVALUE_USERNAME = "username";
    public static final String TPLVALUE_ORDERCODE = "ordercode";
    public static final String TPLVALUE_SERVICENAME = "servicename";
    public static final String TPLVALUE_SERVICETIME = "servicetime";
    public static final String TPLVALUE_VERIFYCODE = "verifycode";
    public static final String TPLVALUE_REASON = "reason";
    private SmsSdkRequest request;

    public SmsSDKClient() {
        this.request = new SmsSdkRequest();
    }

    public SmsSDKClient(String requestUrl, String apikey, Map<String, String> requestData, SdkReqMethod method) {
        this.setRequestUrl(requestUrl);
        this.setApikey(apikey);
        this.setRequestMethod(method);
        this.request.setRequestData(requestData);
    }

    public static void main(String[] args) {
        SmsSDKClient client = new SmsSDKClient();
        client.setRequestUrl("http://192.168.33.12:8181/huieryun-apihubservice-real/api/v1/sms/yx/send");
        client.setApikey("223456789");
        client.setRequestMethod(SdkReqMethod.POST);
        client.setMobiles(Lists.newArrayList((Object[])new String[]{"13763319791"}));
        client.setTplId("123");
        HashMap tplValueMap = Maps.newHashMap();
        tplValueMap.put(TPLVALUE_USERNAME, "\u5c0f\u660e\u8c03\u5f8b\u5e08");
        tplValueMap.put(TPLVALUE_REASON, "\u5c31\u662f\u4e0d\u60f3\u8ba9\u4f60\u901a\u8fc7");
        client.setTplValue(tplValueMap);
        SmsSdkResponse response = client.request();
        System.out.println(response.toString());
    }

    public SmsSdkResponse request() {
        SmsSdkResponse response = new SmsSdkResponse();
        try {
            logger.info("\u672c\u6b21\u8bf7\u6c42:{}", (Object)this.request.toString());
            System.out.println("\u672c\u6b21\u8bf7\u6c42:" + this.request.toString());
            HashMap headers = Maps.newHashMap();
            headers.put("apikey", this.getApikey());
            String responseStr = HttpUtil.request(this.getRequestUrl(), this.getRequestMethod(), headers, this.getRequestData());
            response = (SmsSdkResponse)JSON.parseObject((String)responseStr, SmsSdkResponse.class);
            logger.info("\u672c\u6b21\u8bf7\u6c42\u7684\u54cd\u5e94\uff1a{}", (Object)responseStr);
            System.out.println("\u672c\u6b21\u8bf7\u6c42\u7684\u54cd\u5e94\uff1a" + responseStr);
        }
        catch (IOException e) {
            logger.error("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            response.setResultCode(100000);
            response.setResultMsg("Internal error");
        }
        return response;
    }

    public void setMobiles(List<String> mobiles) {
        String mobilesStr = Joiner.on((String)",").join(mobiles);
        this.setRequestData("mobiles", mobilesStr);
    }

    public void setTplId(String tplId) {
        this.setRequestData("tpl_id", tplId);
    }

    public void setTplValue(Map<String, String> tplValue) {
        String tplValueStr = Joiner.on((String)",").withKeyValueSeparator(":").join(tplValue);
        this.setRequestData("tpl_value", tplValueStr);
    }

    public String getApikey() {
        return this.request.getApikey();
    }

    public void setApikey(String apikey) {
        this.request.setApikey(apikey);
    }

    public String getRequestUrl() {
        return this.request.getRequestUrl();
    }

    public void setRequestUrl(String requestUrl) {
        this.request.setRequestUrl(requestUrl);
    }

    public Map<String, String> getRequestData() {
        return this.request.getRequestData();
    }

    private void setRequestData(String param, String paramValue) {
        HashMap requestData = this.request.getRequestData();
        if (requestData == null) {
            requestData = Maps.newHashMap();
            this.request.setRequestData(requestData);
        }
        requestData.put(param, paramValue);
    }

    public SdkReqMethod getRequestMethod() {
        return this.request.getSdkReqMethod();
    }

    public void setRequestMethod(SdkReqMethod sdkReqMethod) {
        this.request.setSdkReqMethod(sdkReqMethod);
    }
}

