/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.CustomListOperations;
import org.springframework.data.redis.core.DefaultListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.CollectionUtils;

public class CustomListOperationsImpl<K, V>
extends DefaultListOperations<K, V>
implements CustomListOperations<K, V> {
    CustomListOperationsImpl(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public List<V> leftPop(K[] keys) {
        return this.leftPop(keys, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public List<V> leftPop(K[] keys, long timeout, TimeUnit unit) {
        byte[][] rawKeys;
        if (keys == null || keys.length == 0) {
            return new ArrayList(0);
        }
        int tm = (int)TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit);
        List rawValues = (List)this.execute(arg_0 -> CustomListOperationsImpl.lambda$leftPop$0(tm, rawKeys = this.rawKeys(Arrays.asList(keys)), arg_0), true);
        if (CollectionUtils.isEmpty((Collection)rawValues)) {
            return new ArrayList(0);
        }
        return this.deserializeValues(rawValues);
    }

    @Override
    public List<V> rightPop(K[] keys) {
        return this.rightPop(keys, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public List<V> rightPop(K[] keys, long timeout, TimeUnit unit) {
        byte[][] rawKeys;
        if (keys == null || keys.length == 0) {
            return new ArrayList(0);
        }
        int tm = (int)TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit);
        List rawValues = (List)this.execute(arg_0 -> CustomListOperationsImpl.lambda$rightPop$1(tm, rawKeys = this.rawKeys(Arrays.asList(keys)), arg_0), true);
        if (CollectionUtils.isEmpty((Collection)rawValues)) {
            return new ArrayList(0);
        }
        return this.deserializeValues(rawValues);
    }

    private static /* synthetic */ List lambda$rightPop$1(int tm, byte[][] rawKeys, RedisConnection connection) throws DataAccessException {
        return connection.bRPop(tm, rawKeys);
    }

    private static /* synthetic */ List lambda$leftPop$0(int tm, byte[][] rawKeys, RedisConnection connection) throws DataAccessException {
        return connection.bLPop(tm, rawKeys);
    }
}

