/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.provider;

import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.constants.WorkModel;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.util.Hashing;
import redis.clients.util.Sharded;

public class RedisCache
extends AbstractCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static ThreadLocal<Jedis> threadLocal = new ThreadLocal();
    private static ThreadLocal<ShardedJedis> shardedThreadLocal = new ThreadLocal();
    private JedisPool jedisPool;
    private ShardedJedisPool shardedJedisPool;
    private JedisCluster jedisCluster;
    private int dbIndex;
    public static final String COLON_NAME = ":";

    @Override
    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        logger.info("group:{}, redis \u914d\u7f6e:{}", (Object)group, (Object)JacksonUtil.toJson((Object)((Object)cacheRegistryVo)));
        super.init(group, cacheRegistryVo);
        this.checkAddress(cacheRegistryVo.getAddresses());
        this.dbIndex = cacheRegistryVo.getDbIndex();
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        this.setConfig((GenericObjectPoolConfig)poolConfig);
        if (WorkModel.SINGLE.getName().equalsIgnoreCase(cacheRegistryVo.getWorkModel())) {
            String address = cacheRegistryVo.getAddresses()[0];
            String host = address.split(COLON_NAME)[0];
            String port = address.split(COLON_NAME)[1];
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, Integer.parseInt(port), 3000, StringUtils.isEmpty((CharSequence)cacheRegistryVo.getAppSecret()) ? null : cacheRegistryVo.getAppSecret(), this.dbIndex, cacheRegistryVo.isSsl());
        } else if (WorkModel.CLUSTER.getName().equalsIgnoreCase(cacheRegistryVo.getWorkModel())) {
            this.jedisCluster = new JedisCluster(this.getHostAndPortSet(cacheRegistryVo), 3000, 3000, 1, StringUtils.isEmpty((CharSequence)cacheRegistryVo.getAppSecret()) ? null : cacheRegistryVo.getAppSecret(), (GenericObjectPoolConfig)poolConfig);
        } else if (WorkModel.SHARDING.getName().equalsIgnoreCase(cacheRegistryVo.getWorkModel())) {
            this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, this.getShardInfoList(cacheRegistryVo), Hashing.MURMUR_HASH, Sharded.DEFAULT_KEY_TAG_PATTERN);
        } else {
            throw new BusinessRuntimeException("\u521d\u59cb\u5316RedisCache\u65f6\u627e\u4e0d\u5230\u6307\u5b9a\u8fd0\u884c\u6a21\u5f0f\uff0cworkModel:" + cacheRegistryVo.getWorkModel());
        }
    }

    private void checkAddress(String[] addresses) {
        if (addresses == null) {
            throw new BusinessRuntimeException("\u8fde\u63a5RedisCache\u65f6\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Set<HostAndPort> getHostAndPortSet(CacheRegistryVo cacheRegistryVo) {
        HashSet<HostAndPort> hostAndPortSet = new HashSet<HostAndPort>();
        if (cacheRegistryVo.getAddresses() != null) {
            String[] addrs = cacheRegistryVo.getAddresses();
            for (int i = 0; i < addrs.length; ++i) {
                HostAndPort hostAndPort = new HostAndPort(this.getHost(addrs[i]), this.getPort(addrs[i]));
                hostAndPortSet.add(hostAndPort);
            }
        } else {
            HostAndPort hostAndPort = new HostAndPort(cacheRegistryVo.getHost(), Integer.parseInt(cacheRegistryVo.getPort()));
            hostAndPortSet.add(hostAndPort);
        }
        return hostAndPortSet;
    }

    private List<JedisShardInfo> getShardInfoList(CacheRegistryVo cacheRegistryVo) {
        ArrayList<JedisShardInfo> shardsList = new ArrayList<JedisShardInfo>();
        if (cacheRegistryVo.getAddresses() != null) {
            String[] addrs = cacheRegistryVo.getAddresses();
            for (int i = 0; i < addrs.length; ++i) {
                this.addShardInfo(this.getHost(addrs[i]), this.getPort(addrs[i]), cacheRegistryVo.getAppSecret(), shardsList);
            }
        } else {
            this.addShardInfo(cacheRegistryVo.getHost(), Integer.parseInt(cacheRegistryVo.getPort()), cacheRegistryVo.getAppSecret(), shardsList);
        }
        return shardsList;
    }

    private void addShardInfo(String host, Integer port, String appSecret, List<JedisShardInfo> shardsList) {
        StringBuilder uriHost = new StringBuilder("redis://").append(host).append(COLON_NAME).append(port);
        if (this.dbIndex > 0) {
            uriHost.append("/").append(this.dbIndex);
        }
        JedisShardInfo jedisShardInfo = new JedisShardInfo(uriHost.toString());
        if (StringUtils.isNotEmpty((CharSequence)appSecret)) {
            jedisShardInfo.setPassword(appSecret);
        }
        jedisShardInfo.setConnectionTimeout(3000);
        jedisShardInfo.setSoTimeout(3000);
        shardsList.add(jedisShardInfo);
    }

    private String getHost(String val) {
        return val.substring(0, val.indexOf(COLON_NAME));
    }

    private int getPort(String val) {
        return Integer.parseInt(val.substring(val.indexOf(COLON_NAME) + 1, val.length()));
    }

    private void setConfig(GenericObjectPoolConfig config) {
        config.setMaxIdle(this.cacheRegistryVo.getMaxIdle());
        config.setMaxTotal(this.cacheRegistryVo.getMaxTotal());
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        config.setMaxWaitMillis((long)this.cacheRegistryVo.getMaxWaitMillis());
    }

    public final Jedis getJedis() {
        if (this.jedisPool == null) {
            return null;
        }
        Jedis jedis = this.jedisPool.getResource();
        return jedis;
    }

    public final ShardedJedis getShardedJedis() {
        if (this.shardedJedisPool == null) {
            return null;
        }
        ShardedJedis shardedJedis = this.shardedJedisPool.getResource();
        return shardedJedis;
    }

    public final JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCache(String group, String key, Object value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String result = "";
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson((Object)value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.setex(combineKey, seconds, jsonValue);
            } else if (shardedJedis != null) {
                result = shardedJedis.setex(combineKey, seconds, jsonValue);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.setex(combineKey, seconds, jsonValue);
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        logger.info("after setCache,key={},seconds={},value={},flag={}", new Object[]{combineKey, seconds, jsonValue, flag});
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPersistCache(String group, String key, Object value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String result = "";
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson((Object)value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.expire(combineKey, 1);
                jds.persist(combineKey);
                result = jds.set(combineKey, jsonValue);
            } else if (shardedJedis != null) {
                shardedJedis.expire(combineKey, 1);
                shardedJedis.persist(combineKey);
                result = shardedJedis.set(combineKey, jsonValue);
            } else if (this.jedisCluster != null) {
                this.jedisCluster.expire(combineKey, 1);
                this.jedisCluster.persist(combineKey);
                result = this.jedisCluster.set(combineKey, jsonValue);
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
            logger.debug("\u8bbe\u7f6e\u6301\u4e45\u5316\u7f13\u5b58: key={}", (Object)key);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key, Class<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Object value = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.get(combineKey);
            } else if (shardedJedis != null) {
                json = shardedJedis.get(combineKey);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.get(combineKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                value = JacksonUtil.readValue((String)json, clz);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delCache(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        Long del = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                del = jds.del(combineKey);
            } else if (shardedJedis != null) {
                del = shardedJedis.del(combineKey);
            } else if (this.jedisCluster != null) {
                del = this.jedisCluster.del(combineKey);
            }
            if (del > 0L) {
                flag = true;
            }
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, Object value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String combineKey = this.combineKey(key);
        String jsonValue = JacksonUtil.toJson((Object)value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                String responCode = jds.set(combineKey, jsonValue, "NX", "EX", seconds);
                boolean bl = responCode != null && responCode.equalsIgnoreCase("OK");
                return bl;
            }
            if (shardedJedis != null) {
                String responCode = shardedJedis.set(combineKey, jsonValue, "NX", "EX", (long)seconds);
                boolean bl = responCode != null && responCode.equalsIgnoreCase("OK");
                return bl;
            }
            if (this.jedisCluster != null) {
                String responCode = this.jedisCluster.set(combineKey, jsonValue, "NX", "EX", (long)seconds);
                boolean bl = responCode != null && responCode.equalsIgnoreCase("OK");
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7f13\u5b58\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key, long initValue) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long incr = 0L;
        String combineKey = this.combineKey(key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                this.expire((int)initValue, jds, combineKey);
                incr = jds.incr(combineKey);
            } else if (shardedJedis != null) {
                this.expire((int)initValue, shardedJedis, combineKey);
                incr = shardedJedis.incr(combineKey);
            } else if (this.jedisCluster != null) {
                this.expire((int)initValue, this.jedisCluster, combineKey);
                incr = this.jedisCluster.incr(combineKey);
            }
            Long l = incr;
            return l;
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return incr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(String key, long count, long initValue) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long incr = 0L;
        String combineKey = this.combineKey(key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                this.expire((int)initValue, jds, combineKey);
                incr = jds.incrBy(combineKey, count);
            } else if (shardedJedis != null) {
                this.expire((int)initValue, shardedJedis, combineKey);
                incr = shardedJedis.incrBy(combineKey, count);
            } else if (this.jedisCluster != null) {
                this.expire((int)initValue, this.jedisCluster, combineKey);
                incr = this.jedisCluster.incrBy(combineKey, count);
            }
            Long l = incr;
            return l;
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return incr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void lpush(String group, String key, List<T> value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (value != null && !value.isEmpty()) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    jds.del(combineKey);
                    String[] obj = this.getList(value);
                    jds.lpush(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    shardedJedis.del(combineKey);
                    String[] obj = this.getList(value);
                    shardedJedis.lpush(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    this.jedisCluster.del(combineKey);
                    String[] obj = this.getList(value);
                    this.jedisCluster.lpush(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("REDIS\u961f\u5217 \u987a\u5e8f\u5b58\u50a8\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void rpush(String group, String key, List<T> value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (value != null && !value.isEmpty()) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    jds.del(combineKey);
                    String[] obj = this.getList(value);
                    jds.rpush(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    shardedJedis.del(combineKey);
                    String[] obj = this.getList(value);
                    shardedJedis.rpush(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    this.jedisCluster.del(combineKey);
                    String[] obj = this.getList(value);
                    this.jedisCluster.rpush(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("REDIS\u961f\u5217\u53cd\u5411\u5b58\u50a8\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
    }

    private <T> String[] getList(List<T> value) {
        String[] obj = new String[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            obj[i] = JacksonUtil.toJson(value.get(i));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getList(String group, String key, Integer from, Integer to, Class<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        ArrayList<Object> tlist = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            List list = null;
            if (jds != null) {
                list = jds.lrange(combineKey, (long)from.intValue(), (long)to.intValue());
            } else if (shardedJedis != null) {
                list = shardedJedis.lrange(combineKey, (long)from.intValue(), (long)to.intValue());
            } else if (this.jedisCluster != null) {
                list = this.jedisCluster.lrange(combineKey, (long)from.intValue(), (long)to.intValue());
            }
            if (!CollectionUtils.isEmpty(list)) {
                tlist = new ArrayList<Object>();
                for (String str : list) {
                    Object t = JacksonUtil.readValue((String)str, clz);
                    tlist.add(t);
                }
            }
            ArrayList<Object> arrayList = tlist;
            return arrayList;
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    public void shutdown(Jedis jds, ShardedJedis shardedJedis) {
        if (null != jds) {
            jds.close();
        }
        if (null != shardedJedis) {
            shardedJedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void hset(String group, String key, String field, T value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson(value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.hset(combineKey, field, jsonValue);
                this.expire(seconds, jds, combineKey);
            } else if (shardedJedis != null) {
                shardedJedis.hset(combineKey, field, jsonValue);
                this.expire(seconds, shardedJedis, combineKey);
            } else if (this.jedisCluster != null) {
                this.jedisCluster.hset(combineKey, field, jsonValue);
                this.expire(seconds, this.jedisCluster, combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6emap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hget(String group, String key, String field, Class<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                json = shardedJedis.hget(combineKey, field);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.hget(combineKey, field);
            }
            Object object = StringUtils.isNotEmpty((CharSequence)json) ? JacksonUtil.readValue((String)json, clz) : null;
            return (T)object;
        }
        catch (Exception e) {
            logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> hget(String group, String key, String field, TypeReference<List<T>> typeReference) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                json = shardedJedis.hget(combineKey, field);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.hget(combineKey, field);
            }
            List list = StringUtils.isNotEmpty((CharSequence)json) ? (List)JacksonUtil.readValue((String)json, typeReference) : null;
            return list;
        }
        catch (Exception e) {
            logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Map<K, V> hgetMap(String group, String key, String field, TypeReference<Map<K, V>> typeReference) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                json = shardedJedis.hget(combineKey, field);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.hget(combineKey, field);
            }
            Map map = StringUtils.isNotEmpty((CharSequence)json) ? (Map)JacksonUtil.readValue((String)json, typeReference) : null;
            return map;
        }
        catch (Exception e) {
            logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hdel(String group, String key, String ... field) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hdel(combineKey, field);
            } else if (shardedJedis != null) {
                result = shardedJedis.hdel(combineKey, field);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hdel(combineKey, field);
            }
            boolean bl = result > 0L;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664map\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire(String group, String key, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.expire(combineKey, seconds);
            } else if (shardedJedis != null) {
                result = shardedJedis.expire(combineKey, seconds);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.expire(combineKey, seconds);
            }
            boolean bl = result > 0L;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return false;
    }

    private void expire(int seconds, Jedis jds, String combineKey) {
        if (seconds > 0) {
            jds.expire(combineKey, seconds);
        }
    }

    protected void expire(int seconds, ShardedJedis shardedJedis, String combineKey) {
        if (seconds > 0) {
            shardedJedis.expire(combineKey, seconds);
        }
    }

    protected void expire(int seconds, JedisCluster jedisCluster, String combineKey) {
        if (seconds > 0) {
            jedisCluster.expire(combineKey, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys(String group, String pattern) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, pattern);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Set set = jds.keys(combineKey);
                return set;
            }
            if (shardedJedis != null) {
                Set<String> set = this.getKeys(combineKey, shardedJedis);
                return set;
            }
            if (this.jedisCluster != null) {
                Set<String> set = this.getKeys(combineKey);
                return set;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u7684\u6240\u6709key\u65f6\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers) {
        Map<String, Double> map;
        String combineKey;
        ShardedJedis shardedJedis;
        Jedis jds;
        block8: {
            block7: {
                jds = null;
                shardedJedis = null;
                combineKey = this.combineKey(group, key);
                map = this.getMap(scoreMembers);
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds == null) break block7;
                Long l = jds.zadd(combineKey, map);
                this.shutdown(jds, shardedJedis);
                return l;
            }
            if (shardedJedis == null) break block8;
            Long l = shardedJedis.zadd(combineKey, map);
            this.shutdown(jds, shardedJedis);
            return l;
        }
        try {
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zadd(combineKey, map);
                this.shutdown(jds, shardedJedis);
                return l;
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("\u5c06\u4e00\u4e2a\u6216\u591a\u4e2amember\u5143\u7d20\u53ca\u5176score\u503c\u52a0\u5165\u5230\u6709\u5e8f\u96c6key\u5f53\u4e2d\u65f6\u51fa\u9519: key:{},scoreMembers:{}", new Object[]{combineKey, scoreMembers, e});
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Map<String, Double> map = this.getMap(scoreMembers);
            if (jds != null) {
                jds.expire(combineKey, seconds);
                Long l = jds.zadd(combineKey, map);
                return l;
            }
            if (shardedJedis != null) {
                shardedJedis.expire(combineKey, seconds);
                Long l = shardedJedis.zadd(combineKey, map);
                return l;
            }
            if (this.jedisCluster != null) {
                this.jedisCluster.expire(combineKey, seconds);
                Long l = this.jedisCluster.zadd(combineKey, map);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u5c06\u4e00\u4e2a\u6216\u591a\u4e2amember\u5143\u7d20\u53ca\u5176score\u503c\u52a0\u5165\u5230\u6709\u5e8f\u96c6key\u5f53\u4e2d\u65f6\u51fa\u9519: key:{},scoreMembers:{}", new Object[]{combineKey, scoreMembers, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrange(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Set set = jds.zrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (shardedJedis != null) {
                Set set = shardedJedis.zrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (this.jedisCluster != null) {
                Set set = this.jedisCluster.zrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u6b63\u5e8f\u5206\u9875\u65f6\u51fa\u9519: key:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrange(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Set set = jds.zrevrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (shardedJedis != null) {
                Set set = shardedJedis.zrevrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (this.jedisCluster != null) {
                Set set = this.jedisCluster.zrevrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u53cd\u5e8f\u5206\u9875\u65f6\u51fa\u9519: key:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(String group, String key, List<String> members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zrem(combineKey, members.toArray(new String[0]));
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zrem(combineKey, members.toArray(new String[0]));
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zrem(combineKey, members.toArray(new String[0]));
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u79fb\u9664\u6709\u5e8f\u96c6key\u4e2d\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u6210\u5458\u65f6\u51fa\u9519: key:{},members:{}", new Object[]{combineKey, members, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcard(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zcard(combineKey);
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zcard(combineKey);
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zcard(combineKey);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u8fd4\u56de\u6709\u5e8f\u96c6key\u7684\u57fa\u6570\u65f6\u51fa\u9519: key:{}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zscore(String group, String key, String members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Double scroce = null;
            if (jds != null) {
                scroce = jds.zscore(combineKey, members);
            } else if (shardedJedis != null) {
                scroce = shardedJedis.zscore(combineKey, members);
            } else if (this.jedisCluster != null) {
                scroce = this.jedisCluster.zscore(combineKey, members);
            }
            Long l = scroce != null ? Long.valueOf(Math.round(scroce)) : null;
            return l;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u67e5\u8be2\u6709\u5e8f\u96c6key\u4e2d\uff0c\u6210\u5458member\u7684score\u503c\u65f6\u51fa\u9519: key:{},members:{}", new Object[]{combineKey, members, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String group, String key, Long min, Long max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zcount(combineKey, (double)min.longValue(), (double)max.longValue());
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zcount(combineKey, (double)min.longValue(), (double)max.longValue());
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zcount(combineKey, (double)min.longValue(), (double)max.longValue());
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u6709\u5e8f\u96c6key\u4e2d\uff0cscore\u503c\u5728min\u548cmax\u4e4b\u95f4(\u9ed8\u8ba4\u5305\u62ecscore\u503c\u7b49\u4e8emin\u6216max)\u7684\u6210\u5458\u65f6\u51fa\u9519: key:{},min:{},max:{}", new Object[]{combineKey, min, max, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String group, String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zcount(combineKey, min, max);
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zcount(combineKey, min, max);
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zcount(combineKey, min, max);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u6709\u5e8f\u96c6key\u4e2d\uff0cscore\u503c\u5728min\u548cmax\u4e4b\u95f4(\u9ed8\u8ba4\u5305\u62ecscore\u503c\u7b49\u4e8emin\u6216max)\u7684\u6210\u5458\u65f6\u51fa\u9519: key:{},min:{},max:{}", new Object[]{combineKey, min, max, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.zscan(this.getGroup(), key, cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Tuple> zscan(String group, String key, String cursor) {
        Jedis jds = threadLocal.get();
        ShardedJedis shardedJedis = shardedThreadLocal.get();
        String combineKey = this.combineKey(group, key);
        try {
            if (jds == null) {
                jds = this.getJedis();
            }
            if (shardedJedis == null) {
                shardedJedis = this.getShardedJedis();
            }
            ScanResult result = null;
            ScanParams params = new ScanParams();
            if (jds != null) {
                threadLocal.set(jds);
                result = jds.zscan(combineKey, cursor, params.count(Integer.valueOf(1000)));
            } else if (shardedJedis != null) {
                shardedThreadLocal.set(shardedJedis);
                result = shardedJedis.zscan(combineKey, cursor, params.count(Integer.valueOf(1000)));
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zscan(combineKey, cursor, params.count(Integer.valueOf(1000)));
            }
            if ("0".equals(result.getStringCursor())) {
                threadLocal.remove();
                shardedThreadLocal.remove();
            }
            ScanResult scanResult = result;
            return scanResult;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}, zscan\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrangeWithScores(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set list = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                list = jds.zrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (shardedJedis != null) {
                list = shardedJedis.zrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (this.jedisCluster != null) {
                list = this.jedisCluster.zrangeWithScores(combineKey, start.longValue(), end.longValue());
            }
            Map<Long, String> map = RedisCache.getMap(list);
            return map;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u6b63\u5e8f\u5206\u9875\u65f6\u51fa\u9519\uff0ckey:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrevrangeWithScores(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set list = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                list = jds.zrevrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (shardedJedis != null) {
                list = shardedJedis.zrevrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (this.jedisCluster != null) {
                list = this.jedisCluster.zrevrangeWithScores(combineKey, start.longValue(), end.longValue());
            }
            Map<Long, String> map = RedisCache.getMap(list);
            return map;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u53cd\u5e8f\u5206\u9875\u65f6\u51fa\u9519\uff0ckey:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(String group, String key, String value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long count = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                count = jds.setnx(combineKey, value);
            } else if (shardedJedis != null) {
                count = shardedJedis.setnx(combineKey, value);
            } else if (this.jedisCluster != null) {
                count = this.jedisCluster.setnx(combineKey, value);
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey SETNX\u65f6\u51fa\u9519\uff0ckey:{},value:{}", new Object[]{combineKey, value, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    @Override
    public Transaction multi() {
        Jedis jds = threadLocal.get();
        if (jds == null && (jds = this.getJedis()) != null) {
            threadLocal.set(jds);
        }
        Transaction transaction = null;
        try {
            if (jds != null) {
                transaction = jds.multi();
            }
            return transaction;
        }
        catch (Exception e) {
            logger.error("\u6253\u5f00\u4e8b\u52a1\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    public void shutdown() {
        Jedis jds = threadLocal.get();
        this.shutdown(jds, null);
        threadLocal.remove();
    }

    @Override
    public String watch(String ... key) {
        Jedis jds = threadLocal.get();
        if (jds == null) {
            try {
                jds = this.getJedis();
                if (jds != null) {
                    threadLocal.set(jds);
                    return jds.watch(key);
                }
                logger.error("\u83b7\u53d6\u4e0d\u5230redis\u8fde\u63a5");
                return null;
            }
            catch (Exception e) {
                logger.error("watch\u51fa\u9519", (Throwable)e);
                return null;
            }
        }
        return jds.watch(key);
    }

    @Override
    public void unwatch() {
        Jedis jds = threadLocal.get();
        if (jds != null) {
            jds.unwatch();
        }
    }

    private Map<String, Double> getMap(Map<String, Long> scoreMembers) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (!CollectionUtils.isEmpty(scoreMembers)) {
            for (Map.Entry<String, Long> m : scoreMembers.entrySet()) {
                map.put(m.getKey(), (double)m.getValue());
            }
        }
        return map;
    }

    private static Map<Long, String> getMap(Set<Tuple> list) {
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>();
        for (Tuple tuple : list) {
            map.put(Math.round(tuple.getScore()), tuple.getElement());
        }
        return map;
    }

    public Set<String> getKeys(String pattern, ShardedJedis shardedJedis) {
        HashSet<String> list = new HashSet<String>();
        Collection allShards = shardedJedis.getAllShards();
        for (Jedis jedis : allShards) {
            Set keys = jedis.keys(pattern);
            list.addAll(keys);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys(String pattern) {
        logger.debug("Start getting keys...");
        HashSet<String> keys = new HashSet<String>();
        Map clusterNodes = this.jedisCluster.getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            logger.debug("Getting keys from: {}", (Object)k);
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            Jedis connection = jp.getResource();
            try {
                keys.addAll(connection.keys(pattern));
            }
            catch (Exception e) {
                logger.error("Getting keys error: {}", (Throwable)e);
            }
            finally {
                logger.debug("Connection closed.");
                connection.close();
            }
        }
        logger.debug("Keys gotten!");
        return keys;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.hgetAll(this.getGroup(), key);
    }

    @Override
    public Map<String, String> hgetAll(String group, String key) {
        logger.debug("start to hgetall---------");
        String combineKey = this.combineKey(group, key);
        Map content = null;
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (jds != null) {
                content = jds.hgetAll(combineKey);
            } else if (shardedJedis != null) {
                content = shardedJedis.hgetAll(combineKey);
            } else if (this.jedisCluster != null) {
                content = this.jedisCluster.hgetAll(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\uff1a{}\uff0chgetAll\u5f02\u5e38", (Object)key, (Object)e);
        }
        return content;
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(this.getGroup(), key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String group, String key, String cursor) {
        logger.debug("start to hscan-------");
        String combineKey = this.combineKey(group, key);
        ScanResult content = null;
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (null != jds) {
                content = jds.hscan(combineKey, cursor);
            } else if (null != shardedJedis) {
                content = shardedJedis.hscan(combineKey, cursor);
            } else if (null != this.jedisCluster) {
                content = this.jedisCluster.hscan(combineKey, cursor);
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}\uff0chscan\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getToLiveTime(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.ttl(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.ttl(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.ttl(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }
}

