/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.app;

import com.dtyunxi.app.AppVo;
import java.io.Serializable;
import java.util.Properties;
import org.springframework.core.env.Environment;

public class AppEnv
implements Serializable {
    private static final long serialVersionUID = -3708718809348562700L;
    private String appId;
    private String appSecret;
    private AppVo appVo;
    private Properties properties = new Properties();

    public AppEnv() {
    }

    public AppEnv(Environment env) {
        this();
        String envModule = env.getProperty("dtyunxi.env.module");
        if (envModule != null) {
            this.putProperty("dtyunxi.env.module", envModule);
        }
    }

    public AppVo getAppVo() {
        return this.appVo;
    }

    public void setAppVo(AppVo appVo) {
        this.appVo = appVo;
        this.appId = appVo.getAppId();
        this.appSecret = appVo.getAppSecret();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void putProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Object getObject(String key) {
        return this.properties.getProperty(key);
    }

    public <T> T getObject(String key, Class<T> valueClass) {
        return valueClass.cast(this.properties.get(key));
    }

    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    public void putObject(String key, Object value) {
        this.properties.put(key, value);
    }

    public String getEnvProfile() {
        return this.getProperty("dtyunxi.env.profile", "dev");
    }

    public String getEnvModule() {
        return this.getProperty("dtyunxi.env.module");
    }
}

