/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.dto;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.dto.BaseDtoUtil;
import com.dtyunxi.dto.CamelToUnderline;
import com.dtyunxi.dto.SqlFilter;
import com.dtyunxi.util.SqlUtil;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BaseDto
extends BaseVo {
    private static final long serialVersionUID = -6797987329209542967L;
    private static final transient Logger logger = LoggerFactory.getLogger(BaseDto.class);
    private static transient Map<Class<? extends BaseDto>, List<Map<String, String>>> mapColumns = new HashMap<Class<? extends BaseDto>, List<Map<String, String>>>();
    private static transient Map<Class<? extends BaseDto>, String> mapId = new HashMap<Class<? extends BaseDto>, String>();
    @Id
    protected Long id;
    @Column(name="tenant_id")
    private Long tenantId;
    @Column(name="create_person")
    private String createPerson;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="update_person")
    private String updatePerson;
    @Column(name="update_time")
    private Date updateTime;
    @Column
    private int dr;
    @Transient
    private String orderByDesc;
    @Transient
    private String orderBy;
    @Transient
    private List<SqlFilter> sqlFilters;
    @Transient
    private String DTO_ATTRIBUTE = "dtoAttribute";
    @Transient
    private String TAB_COLUMN = "tabColumn";

    @JsonIgnore
    public List<SqlFilter> getSqlFilters() {
        return this.sqlFilters;
    }

    public void setSqlFilters(List<SqlFilter> sqlFilters) {
        this.sqlFilters = sqlFilters;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getCreatePerson() {
        return this.createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+08:00")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+08:00")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public int getDr() {
        return this.dr;
    }

    public void setDr(int dr) {
        this.dr = dr;
    }

    @JsonIgnore
    public String getOrderByDesc() {
        return this.orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    @JsonIgnore
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String tableName() {
        return BaseDtoUtil.tableName(this.getClass());
    }

    public String idName() {
        String idFieldName = mapId.get(this.getClass());
        if (idFieldName == null) {
            idFieldName = BaseDtoUtil.idName(this.getClass());
            mapId.put(this.getClass(), idFieldName);
        }
        return idFieldName;
    }

    private boolean isWhereNull(String fieldName) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            if (field.get(this) != null && !"".equals(field.get(this))) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean isNull(String fieldName) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            if (field.get(this) != null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void calcColumnList() {
        if (mapColumns.containsKey(this.getClass())) {
            return;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        ArrayList columnList = new ArrayList(fields.length);
        HashMap<String, String> map = null;
        String columnName = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            columnName = field.getName();
            Column column = field.getAnnotation(Column.class);
            map = new HashMap<String, String>();
            map.put(this.DTO_ATTRIBUTE, columnName);
            map.put(this.TAB_COLUMN, !"".equals(column.name()) ? column.name() : CamelToUnderline.camelToUnderline(columnName));
            columnList.add(map);
        }
        mapColumns.put(this.getClass(), columnList);
    }

    public String returnSelectColumnsName() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map<String, String> map : this.getColumnList()) {
            if (i++ != 0) {
                sb.append(',');
            } else {
                sb.append("id,create_time as createTime,create_person as createPerson,update_time as updateTime,update_person as updatePerson,tenant_id as tenantId,dr as dr,");
            }
            sb.append(map.get(this.TAB_COLUMN));
            sb.append(" as ");
            sb.append(map.get(this.DTO_ATTRIBUTE));
        }
        return sb.toString();
    }

    public String returnInsertColumnsName() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        for (Map<String, String> map : this.getColumnList()) {
            if (this.isNull(map.get(this.DTO_ATTRIBUTE))) continue;
            sb.append(map.get(this.TAB_COLUMN)).append(",");
        }
        sb.append(this.insertColumn());
        return sb.toString();
    }

    public String returnInsertColumnsDef() {
        StringBuilder sb = new StringBuilder();
        for (Map<String, String> map : this.getColumnList()) {
            if (this.isNull(map.get(this.DTO_ATTRIBUTE))) continue;
            sb.append("#{").append(map.get(this.DTO_ATTRIBUTE)).append("},");
        }
        sb.append(this.insertValue(false));
        return sb.toString();
    }

    public String returnInsertColumnsNameBatch() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        for (Map<String, String> map : this.getColumnList()) {
            sb.append(map.get(this.TAB_COLUMN)).append(",");
        }
        sb.append(this.insertColumn());
        return sb.toString();
    }

    public String returnInsertColumnsDefBatch() {
        StringBuilder sb = new StringBuilder("(");
        boolean i = false;
        for (Map<String, String> map : this.getColumnList()) {
            sb.append("#'{'objList[{0}].").append(map.get(this.DTO_ATTRIBUTE)).append("'}',");
        }
        sb.append(this.insertValue(true)).append(")");
        return sb.toString();
    }

    private String insertColumn() {
        StringBuilder sb = new StringBuilder();
        sb.append("create_time,update_time,create_person,tenant_id,update_person,dr");
        return sb.toString();
    }

    private String insertValue(Boolean isBatch) {
        StringBuilder sb = new StringBuilder();
        sb.append("now(),now(),");
        String createPerson = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isEmpty((CharSequence)createPerson)) {
            createPerson = "#createPerson";
        }
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (isBatch.booleanValue()) {
            sb.append("''").append(createPerson).append("''").append(",").append(tenantId).append(",''").append(createPerson).append("'',0");
        } else {
            sb.append("'").append(createPerson).append("'").append(",").append(tenantId).append(",'").append(createPerson).append("',0");
        }
        return sb.toString();
    }

    public String returnUpdateSet() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (this.getColumnList() != null && this.getColumnList().size() > 0) {
            sb.append(this.updateColumn());
            i = 1;
        }
        for (Map<String, String> map : this.getColumnList()) {
            if (i++ != 0) {
                sb.append(',');
            }
            sb.append(map.get(this.TAB_COLUMN)).append("=#{").append(map.get(this.DTO_ATTRIBUTE)).append('}');
        }
        return sb.toString();
    }

    private String updateColumn() {
        Long tenantId;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dr").append("=#{dr},");
        stringBuilder.append("update_time").append("=now()");
        String createPerson = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isNotEmpty((CharSequence)createPerson)) {
            stringBuilder.append(",update_person").append("='").append(createPerson).append("'");
        }
        if ((tenantId = ServiceContext.getContext().getRequestTenantId()) != null) {
            stringBuilder.append(",tenant_id").append("=").append(tenantId);
        }
        return stringBuilder.toString();
    }

    public String returnUpdateSetNotNull() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (this.getColumnList() != null && this.getColumnList().size() > 0) {
            sb.append(this.updateColumn());
            i = 1;
        }
        for (Map<String, String> map : this.getColumnList()) {
            if (this.isNull(map.get(this.DTO_ATTRIBUTE))) continue;
            if (i++ != 0) {
                sb.append(',');
            }
            sb.append(map.get(this.TAB_COLUMN)).append("=#{").append(map.get(this.DTO_ATTRIBUTE)).append('}');
        }
        return sb.toString();
    }

    public String returnWhereColumnNames() {
        this.calcColumnList();
        StringBuilder sb = new StringBuilder();
        String columns = ",";
        if (this.sqlFilters != null && this.sqlFilters.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (SqlFilter sqlFilter : this.sqlFilters) {
                if (sqlFilter == null || StringUtils.isEmpty((CharSequence)sqlFilter.getProperty())) continue;
                if (!"".equals(sb.toString())) {
                    sb.append(" and ");
                }
                sb.append(this.getSqlFilterWhere(sqlFilter, sdf));
                columns = columns + sqlFilter.getProperty() + ",";
            }
        }
        String col = ",id,dr,";
        if (columns.indexOf("dr") == -1) {
            if (!"".equals(sb.toString())) {
                sb.append(" and ");
            }
            if (this.getDr() == 1) {
                sb.append("dr").append("=1");
            } else {
                sb.append("dr").append("=0");
            }
        }
        for (Map map : this.getColumnList()) {
            if (this.isWhereNull((String)map.get(this.DTO_ATTRIBUTE)) || columns.indexOf(col = "," + (String)map.get(this.DTO_ATTRIBUTE) + ",") != -1) continue;
            if (!"".equals(sb.toString())) {
                sb.append(" and ");
            }
            sb.append((String)map.get(this.TAB_COLUMN)).append("=#{").append((String)map.get(this.DTO_ATTRIBUTE)).append("}");
        }
        return sb.toString();
    }

    private String getSqlFilterWhere(SqlFilter filter, SimpleDateFormat sdf) {
        StringBuilder sqlWhere = new StringBuilder();
        sqlWhere.append(CamelToUnderline.camelToUnderline(filter.getProperty()));
        if (filter.getOperator() == SqlFilter.Operator.eq && filter.getValue() != null) {
            if (filter.getValue() instanceof String) {
                sqlWhere.append(" = '").append(filter.getValue() + "'");
            } else {
                sqlWhere.append(" = ").append(filter.getValue());
            }
        } else if (filter.getOperator() == SqlFilter.Operator.ne && filter.getValue() != null) {
            if (filter.getValue() instanceof String) {
                sqlWhere.append(" <> '").append(filter.getValue() + "'");
            } else {
                sqlWhere.append(" <> ").append(filter.getValue());
            }
        } else if ((filter.getOperator() == SqlFilter.Operator.gt || filter.getOperator() == SqlFilter.Operator.lt) && filter.getValue() != null) {
            String time = " 00:00:01'";
            if (filter.getOperator() == SqlFilter.Operator.gt) {
                sqlWhere.append(" > ");
            } else {
                sqlWhere.append(" < ");
                time = " 23:59:59'";
            }
            if (filter.getValue() instanceof Date) {
                sqlWhere.append("'").append(sdf.format(filter.getValue())).append(time);
            } else if (filter.getValue() instanceof String) {
                sqlWhere.append("'").append(filter.getValue()).append("'");
            } else {
                sqlWhere.append(filter.getValue());
            }
        } else if ((filter.getOperator() == SqlFilter.Operator.ge || filter.getOperator() == SqlFilter.Operator.le) && filter.getValue() != null) {
            if (filter.getOperator() == SqlFilter.Operator.ge) {
                sqlWhere.append(" >= ");
            } else {
                sqlWhere.append(" <= ");
            }
            if (filter.getValue() instanceof Date) {
                sqlWhere.append("'").append(sdf.format(filter.getValue())).append("'");
            } else if (filter.getValue() instanceof String) {
                sqlWhere.append("'").append(filter.getValue()).append("'");
            } else {
                sqlWhere.append(filter.getValue());
            }
        } else if (filter.getOperator() == SqlFilter.Operator.like && filter.getValue() != null) {
            sqlWhere.append(" like '").append(filter.getValue().toString().replaceAll("'", "''")).append("'");
        } else if (filter.getOperator() == SqlFilter.Operator.in && filter.getValue() != null) {
            sqlWhere.append(" in (").append(filter.getValue()).append(")");
        } else if (filter.getOperator() == SqlFilter.Operator.isNull) {
            sqlWhere.append(" is null");
        } else if (filter.getOperator() == SqlFilter.Operator.isNotNull) {
            sqlWhere.append(" is not null");
        }
        return sqlWhere.toString();
    }

    public String returnUpdateWhereColumnNames() {
        StringBuilder sb = new StringBuilder();
        if (this.sqlFilters != null && this.sqlFilters.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (SqlFilter filter : this.sqlFilters) {
                if (filter == null || StringUtils.isEmpty((CharSequence)filter.getProperty())) continue;
                if (!"".equals(sb.toString())) {
                    sb.append(" and ");
                }
                sb.append(this.getSqlFilterWhere(filter, sdf));
            }
            if (StringUtils.isNotEmpty((CharSequence)sb)) {
                if (SqlUtil.isSpiteParams(sb.toString().toLowerCase())) {
                    sb.append(" and dr = 0");
                } else {
                    logger.error("Malice SQL keyword : {}", (Object)sb.toString());
                }
            }
        }
        return sb.toString();
    }

    public String resultOrderBy() {
        String[] strs;
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.orderByDesc)) {
            for (String s : strs = this.orderByDesc.split(",")) {
                if (!"".equals(sb.toString())) {
                    sb.append(",");
                }
                sb.append(CamelToUnderline.camelToUnderline(s)).append(" desc");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.orderBy)) {
            if (!StringUtils.isEmpty((CharSequence)sb.toString())) {
                sb.append(",");
            }
            for (String s : strs = this.orderBy.split(",")) {
                if (!"".equals(sb.toString())) {
                    sb.append(",");
                }
                sb.append(CamelToUnderline.camelToUnderline(s)).append(" asc");
            }
        }
        if ("".equals(sb.toString())) {
            sb.append("id").append(" desc");
        }
        return sb.toString();
    }

    private List<Map<String, String>> getColumnList() {
        return mapColumns.get(this.getClass());
    }

    public String toString() {
        Field[] fields = this.getClass().getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Field f : fields) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            Object value = null;
            try {
                f.setAccessible(true);
                value = f.get(this);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value == null) continue;
            sb.append(f.getName()).append('=').append(value).append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

