/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.dto;

import com.dtyunxi.constant.RpcExceptionCode;
import com.dtyunxi.lang.Null;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDto<T>
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(ResponseDto.class);
    public static ResponseDto<Boolean> TRUE = new ResponseDto<Boolean>(Boolean.TRUE);
    public static ResponseDto<Boolean> FALSE = new ResponseDto<Boolean>(Boolean.FALSE);
    public static ResponseDto<Void> VOID = new ResponseDto<Object>(null);
    public static ResponseDto<Null> NULL = new ResponseDto<Object>(null);
    public static final String RESULT_ACCEPT = "ACCEPT";
    public static final String RESULT_ERROR = "ERROR";
    public static final String RESULT_SUCCESS = "SUCCESS";
    public static final String RESULT_FAIL = "FAIL";
    private String result;
    private String errorCode;
    private String errorMsg;
    private T data;

    public ResponseDto() {
    }

    public ResponseDto(T data) {
        this.result = RESULT_SUCCESS;
        this.data = data;
    }

    public ResponseDto(String result, T data, String errorCode) {
        this.result = result;
        this.data = data;
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            this.errorCode = errorCode;
            this.errorMsg = RpcExceptionCode.getExceptionMsg(errorCode);
        }
    }

    public ResponseDto(String result, T data, String errorCode, Class<? extends RpcExceptionCode> ExceptionClass) {
        this.result = result;
        this.data = data;
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            this.errorCode = errorCode;
            if (ExceptionClass == null) {
                this.errorMsg = RpcExceptionCode.getExceptionMsg(errorCode);
            } else {
                try {
                    Method getExceptionMsg = ExceptionClass.getMethod("getExceptionMsg", String.class);
                    Object invokeResult = getExceptionMsg.invoke((Object)ExceptionClass.newInstance(), errorCode);
                    if (invokeResult != null) {
                        this.errorMsg = invokeResult.toString();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ResponseDto(String result, T data, String errorCode, String errorMsg) {
        this.result = result;
        this.data = data;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public static ResponseDto<Long> createLong(Long value) {
        return new ResponseDto<Long>(value);
    }

    public static ResponseDto<Short> createShort(Short value) {
        return new ResponseDto<Short>(value);
    }

    public static ResponseDto<Integer> createInteger(Integer value) {
        return new ResponseDto<Integer>(value);
    }

    public static ResponseDto<Float> createFloat(Float value) {
        return new ResponseDto<Float>(value);
    }

    public static ResponseDto<Double> createDouble(Double value) {
        return new ResponseDto<Double>(value);
    }

    public static ResponseDto<BigDecimal> createBigDecimal(BigDecimal value) {
        return new ResponseDto<BigDecimal>(value);
    }

    public static ResponseDto<Object> createObject(Object obj) {
        return new ResponseDto<Object>(obj);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String toString() {
        return "ResponseDto [errorCode=" + this.errorCode + ", errorMsg=" + this.errorMsg + ", data=" + this.data + "]";
    }
}

