/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.rest;

import com.dtyunxi.vo.BaseVo;
import java.util.List;

public class Page<T>
extends BaseVo {
    private static final long serialVersionUID = -1697965327165172428L;
    private int currentPage;
    private int pageSize = 20;
    private int pageCount;
    private long total;
    private List<T> data;

    public Page() {
    }

    public Page(int total, List<T> data) {
        this.currentPage = 0;
        this.total = total;
        this.data = data;
    }

    public Page(int currentPage, int pageSize, int total, List<T> data) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.total = total;
        this.data = data;
    }

    public Page(int currentPage, int pageSize, int pageCount, int total, List<T> data) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.pageCount = pageCount;
        this.total = total;
        this.data = data;
    }

    public int getPageCount() {
        if (this.pageCount >= 1) {
            return this.pageCount;
        }
        if (this.pageSize <= 0) {
            return 1;
        }
        return (int)Math.ceil((double)this.total / ((double)this.pageSize * 1.0));
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getFirstResult() {
        if (this.currentPage <= 0) {
            return 0;
        }
        return (this.currentPage - 1) * this.pageSize;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }
}

