/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.spi;

import com.dtyunxi.annotation.Activate;
import com.dtyunxi.annotation.SPI;
import com.dtyunxi.spi.Holder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExtensionLoader<T> {
    private static Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private final Holder<Map<String, Map<String, Class<?>>>> cachedClasses = new Holder();
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Class<?> type;
    private static final String CLASSPATH_EXTENSION_DIR = "META-INF/extension/";
    private static final String CLASSPATH_EXTENSION_INTERNAL_DIR = "META-INF/extension/internal/";
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private String cachedDefaultName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionLoader(Class<?> type) {
        Class<ExtensionLoader> clazz = ExtensionLoader.class;
        synchronized (ExtensionLoader.class) {
            this.type = type;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not interface!");
        }
        if (!type.isAnnotationPresent(SPI.class)) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not extension, because WITHOUT @" + SPI.class.getSimpleName() + " Annotation!");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            EXTENSION_LOADERS.putIfAbsent(type, new ExtensionLoader<T>(type));
            loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Class<?>>> getExtensionClasses() {
        Map<String, Map<String, Class<?>>> classes = this.cachedClasses.get();
        if (CollectionUtils.isEmpty(classes)) {
            Holder<Map<String, Map<String, Class<?>>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (CollectionUtils.isEmpty(classes)) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Map<String, Class<?>>> loadExtensionClasses() {
        String value;
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation != null && (value = defaultAnnotation.value()) != null && (value = value.trim()).length() > 0) {
            Object[] names = NAME_SEPARATOR.split(value);
            if (names.length > 1) {
                throw new IllegalStateException("more than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
            }
            if (names.length == 1) {
                this.cachedDefaultName = names[0];
            }
        }
        HashMap extensionClasses = new HashMap();
        this.loadfile(extensionClasses, CLASSPATH_EXTENSION_INTERNAL_DIR);
        this.loadfile(extensionClasses, CLASSPATH_EXTENSION_DIR);
        return extensionClasses;
    }

    private void loadfile(Map<String, Map<String, Class<?>>> extensionClasses, String classpathExtensionDir) {
        Class<?> clazz = null;
        String name = null;
        String line = null;
        URL url = null;
        Enumeration<URL> urls = null;
        HashMap classes = new HashMap();
        try {
            String fileName = classpathExtensionDir + this.type.getName();
            ClassLoader classLoader = ExtensionLoader.class.getClassLoader();
            urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        int i = line.indexOf(61);
                        if (i > 0) {
                            name = line.substring(0, i).trim();
                            line = line.substring(i + 1).trim();
                        }
                        if (line.length() <= 0 || (clazz = Class.forName(line, true, classLoader)) == null) continue;
                        if (!this.type.isAssignableFrom(clazz)) {
                            throw new IllegalStateException("Error when load extension class(interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + "is not subtype of interface.");
                        }
                        String[] names = NAME_SEPARATOR.split(name);
                        if (names == null || names.length <= 0) continue;
                        for (String n : names) {
                            if (!StringUtils.isNotBlank((CharSequence)this.cachedDefaultName)) continue;
                            if (!this.cachedNames.containsKey(clazz)) {
                                this.cachedNames.put(clazz, n);
                            }
                            classes.putIfAbsent(n, clazz);
                        }
                    }
                    extensionClasses.put(this.type.getName(), classes);
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public String getExtensionName(T extensionInstance) {
        return this.getExtensionName(extensionInstance.getClass());
    }

    public String getExtensionName(Class<?> extensionClass) {
        return (String)this.cachedNames.get(extensionClass);
    }

    public Map<String, Class<?>> getClasses() {
        Map<String, Map<String, Class<?>>> classes = this.getExtensionClasses();
        Map<String, Class<?>> classMap = classes.get(this.type.getName());
        return classMap;
    }

    public T getExtension() {
        Class<?> clazz = null;
        T obj = null;
        try {
            clazz = this.getExtensionClass();
            if (clazz == null) {
                throw new IllegalStateException("Error when load extension class( interface [ " + this.type.getName() + " ] haven't extension of Class !)");
            }
            obj = (T)clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public T getExtension(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> clazz = null;
        T instance = null;
        try {
            Map<String, Map<String, Class<?>>> classes = this.getExtensionClasses();
            Map<String, Class<?>> classMap = classes.get(this.type.getName());
            if (classMap != null) {
                for (String key : classMap.keySet()) {
                    if (!key.equals(name)) continue;
                    clazz = classMap.get(key);
                    break;
                }
            }
            if (clazz == null) {
                throw new IllegalStateException("Error when load extension class( interface [ " + this.type.getName() + " ] haven't extension of Class !)");
            }
            instance = clazz.newInstance();
            return instance;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public Class<?> getExtensionClass() {
        Class<?> clazz = null;
        try {
            Map<String, Map<String, Class<?>>> classes = this.getExtensionClasses();
            Map<String, Class<?>> classMap = classes.get(this.type.getName());
            if (classMap != null) {
                TreeMap activateClassMap = new TreeMap();
                for (String key : classMap.keySet()) {
                    Class<?> existClazz;
                    Class<?> tmpClazz = classMap.get(key);
                    Boolean isActivate = tmpClazz.getAnnotation(Activate.class) == null ? false : tmpClazz.getAnnotation(Activate.class).value();
                    if (!isActivate.booleanValue() || tmpClazz.equals(existClazz = activateClassMap.putIfAbsent(tmpClazz.getAnnotation(Activate.class).order(), tmpClazz)) || !key.equals(this.cachedDefaultName)) continue;
                    activateClassMap.put(tmpClazz.getAnnotation(Activate.class).order(), tmpClazz);
                }
                if (!CollectionUtils.isEmpty(activateClassMap)) {
                    clazz = (Class<?>)activateClassMap.lastEntry().getValue();
                }
                if (clazz == null && StringUtils.isNotBlank((CharSequence)this.cachedDefaultName)) {
                    clazz = classMap.get(this.cachedDefaultName);
                }
                if (clazz == null && classMap != null && classMap.size() > 0) {
                    clazz = classMap.entrySet().iterator().next().getValue();
                }
            }
            if (clazz == null) {
                throw new IllegalStateException("Error when load extension class( interface [ " + this.type.getName() + " ] haven't extension of Class !)");
            }
            return clazz;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }
}

