/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ClassScannerUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassScannerUtil.class);
    private static ConcurrentMap<String, Set<Class<?>>> packageClasses = Maps.newConcurrentMap();

    public static Set<Class<?>> getAnnotationClasses(String pack, Class annotationClass) {
        Set<Class<?>> classes = ClassScannerUtil.getClassesByPack(pack);
        HashSet filterClasses = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(classes)) {
            for (Class<?> tClass : classes) {
                if (tClass.getAnnotation(annotationClass) == null) continue;
                filterClasses.add(tClass);
            }
        }
        return filterClasses;
    }

    public static Set<Class<?>> getAllSubClassOfInteface(String pack, Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            return Sets.newHashSet();
        }
        Set<Class<?>> classes = ClassScannerUtil.getClassesByPack(pack);
        HashSet filterClasses = Sets.newHashSet();
        if (classes != null && classes.size() > 0) {
            for (Class<?> tClass : classes) {
                Object[] interfaceClasses = tClass.getInterfaces();
                ArrayList interfaceClassList = Lists.newArrayList((Object[])interfaceClasses);
                if (!interfaceClassList.contains(interfaceClass)) continue;
                filterClasses.add(tClass);
            }
        }
        return filterClasses;
    }

    private static Set<Class<?>> getClassesByPack(String packName) {
        Set cacheClasses = (Set)packageClasses.get(packName);
        if (!CollectionUtils.isEmpty((Collection)cacheClasses)) {
            return cacheClasses;
        }
        int position = packName.indexOf(".*");
        Set<Class<?>> classes = null;
        if (position > 0) {
            String searchPack = packName.substring(0, position);
            String matchPack = packName.substring(packName.lastIndexOf("*") + 1);
            classes = ClassScannerUtil.getClasses(searchPack);
            if (classes != null && classes.size() > 0) {
                Iterator<Class<?>> iterator = classes.iterator();
                while (iterator.hasNext()) {
                    Class<?> tClass = iterator.next();
                    if (tClass.getName().substring(0, tClass.getName().lastIndexOf(".")).contains(matchPack)) continue;
                    iterator.remove();
                }
            }
        } else {
            classes = ClassScannerUtil.getClasses(packName);
        }
        packageClasses.putIfAbsent(packName, classes);
        return classes;
    }

    private static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassScannerUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        String packName = packageName;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packName.length() + 1, name.length() - 6);
                        try {
                            if ("AppStartedListener".equals(className) || !name.contains("com/dtyunxi") || name.contains("com/dtyunxi/huieryun/")) continue;
                            classes.add(Class.forName(packName + '.' + className));
                        }
                        catch (Exception e) {
                            logger.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6", (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassScannerUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

