/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.PropertyUtil;
import com.dtyunxi.util.ValidationRule;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ParamConverter {
    public static Date convertToDate(String dateTime, DatePattern pattern) {
        if (pattern == null) {
            throw new BusinessRuntimeException("\u65e5\u671f\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Date datetime = null;
        if (StringUtils.isNotBlank((CharSequence)dateTime)) {
            try {
                datetime = DateUtils.parseDate((String)dateTime, (String[])new String[]{pattern.getPattern()});
            }
            catch (Exception e) {
                throw new BusinessRuntimeException("\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0f \uff1a" + dateTime + ", \u6b63\u786e\u683c\u5f0f[ " + pattern.getPattern() + "]");
            }
        }
        return datetime;
    }

    public static Long convertToLong(Object param) throws BusinessRuntimeException {
        return (Long)ParamConverter.numberConverter(param, Long.class);
    }

    public static Integer convertToInteger(Object param) throws BusinessRuntimeException {
        Long value = (Long)ParamConverter.numberConverter(param, Integer.class);
        if (value == null) {
            return null;
        }
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new BusinessRuntimeException("\u6570\u503c\u8d85\u8fc7\u6570\u636e\u8303\u56f4: " + value);
        }
        return value.intValue();
    }

    public static Byte convertToByte(Object param) {
        Long value = (Long)ParamConverter.numberConverter(param, Integer.class);
        if (value == null) {
            return null;
        }
        if (value > 127L || value < -128L) {
            throw new BusinessRuntimeException("\u6570\u503c\u8d85\u8fc7\u6570\u636e\u8303\u56f4: " + value);
        }
        return value.byteValue();
    }

    public static Double convertToDouble(Object param) {
        return (Double)ParamConverter.numberConverter(param, Double.class);
    }

    public static String convertToString(Object param) {
        if (param == null) {
            return null;
        }
        return param.toString().trim();
    }

    public static BigDecimal convertToBigDecimal(Object param) {
        if (param == null || StringUtils.isBlank((CharSequence)param.toString())) {
            return null;
        }
        if (!NumberUtils.isNumber((String)param.toString())) {
            throw new BusinessRuntimeException("\u65e0\u6548\u7684\u6570\u636e\u5b57\u7b26");
        }
        return NumberUtils.createBigDecimal((String)param.toString());
    }

    public static String convertToStringWithLengthCheck(String paramName, Object paramValue, int maxLength, int minLength) {
        String s = ParamConverter.convertToString(paramValue);
        int length = StringUtils.length((CharSequence)s);
        if (length < minLength || length > maxLength) {
            throw new BusinessRuntimeException(paramName + "\u957f\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u6700\u5c11 " + minLength + " \u4f4d\uff0c\u6700\u591a " + maxLength + " \u4f4d\u3002");
        }
        return s;
    }

    public static String convertToStringWithLengthCheck(Object value, String key) {
        String rules = PropertyUtil.getPropertyByKey(key);
        if (StringUtils.isBlank((CharSequence)rules)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230 " + key + " \u5bf9\u5e94\u7684\u53c2\u6570\u6821\u9a8c\u89c4\u5219\u914d\u7f6e\u3002");
        }
        ValidationRule validationRule = ValidationRule.generate(rules);
        return ParamConverter.convertToStringWithLengthCheck(validationRule.getParamName(), value, validationRule.getMaxLength(), validationRule.getMinLength());
    }

    public static void isNumber(String key, Object value) {
        if (null != value && !StringUtils.isNumeric((CharSequence)value.toString())) {
            throw new BusinessRuntimeException("\u53c2\u6570: " + key + "\u9519\u8bef\uff0c \u5e94\u8f93\u5165\u7eaf\u6570\u5b57\uff01");
        }
    }

    private static Object numberConverter(Object object, Class type) {
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return null;
        }
        if (Number.class.isAssignableFrom(type)) {
            String param = object.toString();
            if (!NumberUtils.isNumber((String)param)) {
                throw new BusinessRuntimeException("\u65e0\u6548\u7684\u6570\u5b57\u5b57\u7b26: " + param);
            }
            if (Double.class.isAssignableFrom(type)) {
                return Double.parseDouble(param);
            }
            return Long.parseLong(param);
        }
        return object;
    }
}

