/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.eo;

import com.dtyunxi.eo.ColumnInfo;
import com.dtyunxi.eo.TableInfo;
import com.dtyunxi.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class SqlConditioner {
    private String field;
    private Object val;
    private String operator;
    private boolean isRoot;
    private String rootSql;
    private SqlConditioner root;
    private SqlConditioner last;
    private SqlConditioner next;
    private SqlConditioner child;
    private String[] illegalSymbols = new String[]{"\"", "=", ">", "<", "(", ")", "'", ";", "%", "or ", "--"};

    public static void main(String[] args) {
        SqlConditioner.testSearcher();
    }

    private static void testSearcher() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "1235");
        params.put("age.xxxx", new Date());
        params.put("fff.bbb", "1235");
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("1");
        ids.add("2");
        ids.add("3");
        String sf = SqlConditioner.create("select * from tr_tarde where ").eq("name", "#{param.name}").in("id", ids).isNotNull("AAFAS").isNull("AAFAS").and().isNull("szva2").or().isNull("sfa25").or().lt("point", "money").eq("fff", "#{param.fff.bbb}").and().le("age", new Date()).or(SqlConditioner.create(SqlConditioner.create().eq("name5", "bbb").le("gg", "bb")).or().eq("xxx", "hhh")).like("title", "#{param.fff.bbb}").sql();
        System.out.println(sf);
    }

    public SqlConditioner(String field, Object val, String operator, boolean isRoot) {
        this.field = field;
        this.val = val;
        this.operator = operator;
        this.isRoot = isRoot;
    }

    private SqlConditioner(String field, Object val, String operator, boolean isRoot, String rootSql) {
        this.field = field;
        this.val = val;
        this.operator = operator;
        this.isRoot = isRoot;
        this.rootSql = rootSql;
    }

    public static SqlConditioner create() {
        SqlConditioner builder = new SqlConditioner(null, null, null, true);
        builder.setRoot(builder);
        return builder;
    }

    public static SqlConditioner create(SqlConditioner sqlCond) {
        SqlConditioner root = new SqlConditioner(null, null, null, true);
        root.setRoot(root);
        root.setChild(sqlCond);
        return root;
    }

    public static SqlConditioner create(String rootSql) {
        SqlConditioner builder = new SqlConditioner(null, null, null, true, rootSql);
        builder.setRoot(builder);
        return builder;
    }

    private SqlConditioner createOperator(String name, Object val, String operator) {
        SqlConditioner sqlCond = new SqlConditioner(name, val, operator, false);
        sqlCond.setRoot(this.getRoot());
        sqlCond.setLast(this);
        this.setNext(sqlCond);
        return sqlCond;
    }

    public String sql() {
        return this.sql(null);
    }

    public String sql(TableInfo tableInfo) {
        SqlConditioner root = this.findRoot(this);
        StringBuilder sql = new StringBuilder();
        this.buildSqlCond(root, sql, tableInfo);
        if (root.getRootSql() != null) {
            return root.getRootSql().concat(sql.toString());
        }
        return sql.toString();
    }

    private void buildSqlCond(SqlConditioner sqlCond, StringBuilder sql, TableInfo tableInfo) {
        SqlConditioner last = sqlCond.getLast();
        String sqlVal = this.getCondVal(sqlCond);
        boolean isAppendCondition = this.isAppendCondition(sqlVal, sqlCond);
        if (sqlCond.hasLast() && !last.isRoot() && last.isConditionNode() && isAppendCondition || sqlCond.isAnd() && !sqlCond.hasChild() || sqlCond.hasLast() && !last.isConditionNode() && last.hasChild()) {
            sql.append(Operator.AND.symbol());
        } else if (sqlCond.isOr() && !sqlCond.hasChild() && sqlCond.hasLast()) {
            sql = sql.append(Operator.OR.symbol());
        }
        if (sqlCond.isAnd() && sqlCond.hasChild()) {
            sql = sql.append(Operator.AND.symbol());
            sql = this.appendChild(sql, sqlCond, tableInfo);
        } else if (sqlCond.isOr() && sqlCond.hasChild()) {
            sql = sql.append(Operator.OR.symbol());
            sql = this.appendChild(sql, sqlCond, tableInfo);
        } else if (sqlCond.isRoot && sqlCond.hasChild()) {
            sql = this.appendChild(sql, sqlCond, tableInfo);
        } else if (isAppendCondition) {
            sql = Operator.IS_NULL.isEqualSymbol(sqlCond.getOperator()) || Operator.IS_NOT_NULL.isEqualSymbol(sqlCond.getOperator()) ? sql.append(this.getFieldName(sqlCond, tableInfo)).append(sqlCond.getOperator()).append(" ") : sql.append(this.getFieldName(sqlCond, tableInfo)).append(sqlCond.getOperator()).append(sqlVal).append(" ");
        }
        if (sqlCond.getNext() != null) {
            this.buildSqlCond(sqlCond.getNext(), sql, tableInfo);
        }
    }

    private boolean isAppendCondition(String sqlVal, SqlConditioner sqlCond) {
        return sqlVal != null || Operator.IS_NULL.isEqualSymbol(sqlCond.getOperator()) || Operator.IS_NOT_NULL.isEqualSymbol(sqlCond.getOperator());
    }

    private SqlConditioner findRoot(SqlConditioner sqlCond) {
        if (sqlCond == null) {
            return null;
        }
        if (sqlCond.isRoot()) {
            return sqlCond;
        }
        return this.findRoot(sqlCond.getLast());
    }

    private String getFieldName(SqlConditioner sqlCond, TableInfo tableInfo) {
        String field = sqlCond.getField();
        if (tableInfo == null) {
            return field;
        }
        ColumnInfo columnInfo = tableInfo.getColumnInfo(field);
        if (columnInfo == null) {
            return field;
        }
        return columnInfo.getColumn();
    }

    private String getCondVal(SqlConditioner sqlCond) {
        Object value = sqlCond.getVal();
        if (value == null) {
            return null;
        }
        String strVal = null;
        if (value instanceof String) {
            strVal = this.replaceIllegalSymbols((String)value);
        } else if (value instanceof Date) {
            strVal = DateUtil.format((Date)value, "yyyy-MM-dd HH:mm:ss");
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (!collection.isEmpty()) {
                Object collectionValue = collection.stream().findFirst().get();
                strVal = collectionValue instanceof String ? "'" + StringUtils.join((Iterable)collection, (String)"','") + "'" : StringUtils.join((Iterable)collection, (String)",");
            }
        } else {
            strVal = value.toString();
        }
        if (Operator.LIKE.isEqualSymbol(sqlCond.getOperator())) {
            strVal = "'%" + strVal + "%'";
        } else if (Operator.LEFT_LIKE.isEqualSymbol(sqlCond.getOperator())) {
            strVal = "'%" + strVal + "'";
        } else if (Operator.RIGHT_LIKE.isEqualSymbol(sqlCond.getOperator())) {
            strVal = "'" + strVal + "%'";
        } else if (Operator.IN.isEqualSymbol(sqlCond.getOperator()) || Operator.NOT_IN.isEqualSymbol(sqlCond.getOperator())) {
            strVal = "(" + strVal + ")";
        } else if (!this.isBaseType(value).booleanValue()) {
            return "'" + strVal + "'";
        }
        return strVal;
    }

    private Boolean isBaseType(Object value) {
        return value instanceof Integer || value instanceof BigDecimal || value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Short || value instanceof Byte || value instanceof Boolean || value instanceof Character;
    }

    private String replaceIllegalSymbols(String value) {
        String result = value;
        for (String str : this.illegalSymbols) {
            result = result.replace(str, "");
        }
        return result;
    }

    public SqlConditioner eq(String field, Object val) {
        return this.createOperator(field, val, Operator.EQ.symbol());
    }

    public SqlConditioner neq(String field, Object val) {
        return this.createOperator(field, val, Operator.NEQ.symbol());
    }

    public SqlConditioner gt(String field, Object val) {
        return this.createOperator(field, val, Operator.GT.symbol());
    }

    public SqlConditioner lt(String field, Object val) {
        return this.createOperator(field, val, Operator.LT.symbol());
    }

    public SqlConditioner ge(String field, Object val) {
        return this.createOperator(field, val, Operator.GE.symbol());
    }

    public SqlConditioner le(String field, Object val) {
        return this.createOperator(field, val, Operator.LE.symbol());
    }

    public SqlConditioner like(String field, Object val) {
        return this.createOperator(field, val, Operator.LIKE.symbol());
    }

    public SqlConditioner rightLike(String field, Object val) {
        return this.createOperator(field, val, Operator.RIGHT_LIKE.symbol());
    }

    public SqlConditioner leftLike(String field, Object val) {
        return this.createOperator(field, val, Operator.LEFT_LIKE.symbol());
    }

    public SqlConditioner in(String field, Object val) {
        return this.createOperator(field, val, Operator.IN.symbol());
    }

    public SqlConditioner notIn(String field, Object val) {
        return this.createOperator(field, val, Operator.NOT_IN.symbol());
    }

    public SqlConditioner isNull(String field) {
        return this.createOperator(field, null, Operator.IS_NULL.symbol());
    }

    public SqlConditioner isNotNull(String field) {
        return this.createOperator(field, null, Operator.IS_NOT_NULL.symbol());
    }

    public SqlConditioner and() {
        return this.createOperator(null, null, Operator.AND.symbol());
    }

    public SqlConditioner or() {
        return this.createOperator(null, null, Operator.OR.symbol());
    }

    public SqlConditioner and(SqlConditioner sqlCond) {
        SqlConditioner and = this.createOperator(null, null, Operator.AND.symbol());
        and.setChild(sqlCond);
        return and;
    }

    public SqlConditioner or(SqlConditioner sqlCond) {
        SqlConditioner or = this.createOperator(null, null, Operator.OR.symbol());
        or.setChild(sqlCond);
        return or;
    }

    private StringBuilder appendChild(StringBuilder sql, SqlConditioner sqlCond, TableInfo tableInfo) {
        sql.append(" ( ");
        this.buildSqlCond(this.findRoot(sqlCond.getChild()), sql, tableInfo);
        sql = sql.append(" ) ");
        return sql;
    }

    public boolean isAnd() {
        return Operator.AND.isEqualSymbol(this.getOperator());
    }

    public boolean isOr() {
        return Operator.OR.isEqualSymbol(this.getOperator());
    }

    public boolean hasChild() {
        return this.getChild() != null;
    }

    public boolean hasLast() {
        return this.getLast() != null;
    }

    public boolean isConditionNode() {
        return !Operator.AND.isEqualSymbol(this.getOperator()) && !Operator.OR.isEqualSymbol(this.getOperator());
    }

    public String getField() {
        return this.field;
    }

    public Object getVal() {
        return this.val;
    }

    public String getOperator() {
        return this.operator;
    }

    private SqlConditioner getLast() {
        return this.last;
    }

    private void setLast(SqlConditioner last) {
        this.last = last;
    }

    private SqlConditioner getNext() {
        return this.next;
    }

    private void setNext(SqlConditioner next) {
        this.next = next;
    }

    private SqlConditioner getChild() {
        return this.child;
    }

    private void setChild(SqlConditioner child) {
        this.child = child;
    }

    private String getRootSql() {
        return this.rootSql;
    }

    private boolean isRoot() {
        return this.isRoot;
    }

    private SqlConditioner getRoot() {
        return this.root;
    }

    private void setRoot(SqlConditioner root) {
        this.root = root;
    }

    private static enum Operator {
        EQ("EQ", " = "),
        NEQ("NEQ", " != "),
        GT("GT", " > "),
        LT("LT", " < "),
        GE("GE", " >= "),
        LE("LE", " <= "),
        IN("IN", " in "),
        NOT_IN("NOT_IN", " not in "),
        IS_NULL("IS_NULL", " is null "),
        IS_NOT_NULL("IS_NOT_NULL", " is not null "),
        LIKE("LIKE", " like "),
        RIGHT_LIKE("RIGHT_LIKE", " like "),
        LEFT_LIKE("LEFT_LIKE", " like "),
        AND("AND", " and "),
        OR("OR", " or "),
        BK("BK", " bk ");

        private String symbol;
        private String operatorName;

        private Operator(String operatorName, String symbol) {
            this.operatorName = operatorName;
            this.symbol = symbol;
        }

        public static Operator getOperator(String operatorName) {
            for (Operator operator : Operator.values()) {
                if (!operator.isEqualName(operatorName)) continue;
                return operator;
            }
            return null;
        }

        public boolean isEqualName(String operatorName) {
            return this.operatorName.equals(operatorName);
        }

        public boolean isEqualSymbol(String symbol) {
            return this.symbol.equals(symbol);
        }

        public String symbol() {
            return this.symbol;
        }

        public String operatorName() {
            return this.operatorName;
        }

        public boolean equals(Operator operator) {
            return this.operatorName.equals(operator.name()) && this.symbol.equals(operator.symbol());
        }
    }
}

