/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.io.ClassPathResource;

public class PropertiesUtils {
    private static Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);
    private final Properties properties;

    public PropertiesUtils(String resourcesPath) {
        this.properties = this.loadProperties(resourcesPath);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String getValue(String key) {
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        return this.properties.getProperty(key);
    }

    public String getProperty(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public Integer getInteger(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Integer.valueOf(value);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.getValue(key);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public Double getDouble(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Double.valueOf(value);
    }

    public Double getDouble(String key, Integer defaultValue) {
        String value = this.getValue(key);
        return value != null ? Double.valueOf(value) : (double)defaultValue.intValue();
    }

    public Boolean getBoolean(String key) {
        String value = this.getValue(key);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return Boolean.valueOf(value);
    }

    public Boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getValue(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String resourcesPath) {
        Properties props = new Properties();
        ClassPathResource fileRource = new ClassPathResource(resourcesPath);
        InputStream inputStream = null;
        try {
            inputStream = fileRource.getInputStream();
            props.load(inputStream);
        }
        catch (IOException ex) {
            logger.warn("Could not load properties from path:{}, {} ", (Object)resourcesPath, (Object)ex.getMessage());
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            PropertyUtils.copyProperties((Object)dest, (Object)orig);
        }
        catch (Exception e) {
            logger.error("Bean \u62f7\u8d1d\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static <T> T getProperty(Object bean, String name) {
        if ("this".equals(name)) {
            return (T)bean;
        }
        if (bean instanceof Map) {
            Map map = (Map)bean;
            return (T)map.get(name);
        }
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        bw.setAutoGrowNestedPaths(true);
        return (T)bw.getPropertyValue(name);
    }

    public static void setProperty(Object bean, String name, Object value) {
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        bw.setAutoGrowNestedPaths(true);
        bw.setPropertyValue(name, value);
    }

    public static Field[] getAllDeclaredFields(Class<?> clz) {
        Object[] fields = new Field[]{};
        for (Class<?> curClz = clz; curClz != Object.class; curClz = curClz.getSuperclass()) {
            fields = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])curClz.getDeclaredFields());
        }
        return fields;
    }

    public static boolean isReadable(Object bean, String name) {
        return PropertyUtils.isReadable((Object)bean, (String)name);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        return PropertyUtils.getPropertyDescriptors((Object)bean);
    }

    public static Method getReadMethod(PropertyDescriptor descriptor) {
        return PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
    }
}

