/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.dto;

import com.dtyunxi.constant.RpcExceptionCode;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.lang.Null;
import com.dtyunxi.rest.RestResponse;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ResponseDto<T>
extends RestResponse<T>
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(ResponseDto.class);
    public static ResponseDto<Boolean> TRUE = new ResponseDto<Boolean>(Boolean.TRUE);
    public static ResponseDto<Boolean> FALSE = new ResponseDto<Boolean>(Boolean.FALSE);
    public static ResponseDto<Void> VOID = new ResponseDto<Object>(null);
    public static ResponseDto<Null> NULL = new ResponseDto<Object>(null);
    public static final String RESULT_ACCEPT = "ACCEPT";
    public static final String RESULT_ERROR = "ERROR";
    public static final String RESULT_SUCCESS = "SUCCESS";
    public static final String RESULT_FAIL = "FAIL";
    private String result;

    public ResponseDto() {
    }

    public ResponseDto(T data) {
        this(RESULT_SUCCESS, data, SUCCEED.getResultCode(), SUCCEED.getResultMsg());
    }

    public ResponseDto(String errorCode, String errorMsg) {
        this(RESULT_FAIL, null, errorCode, errorMsg);
    }

    public ResponseDto(String result, T data, String errorCode) {
        this.result = result;
        this.setData(data);
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            this.setErrorCode(errorCode);
            this.setErrorMsg(RpcExceptionCode.getExceptionMsg(errorCode));
        }
    }

    public ResponseDto(String result, T data, String errorCode, Class<? extends RpcExceptionCode> ExceptionClass) {
        this.result = result;
        this.setData(data);
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            this.setErrorCode(errorCode);
            if (ExceptionClass == null) {
                this.setErrorMsg(RpcExceptionCode.getExceptionMsg(errorCode));
            } else {
                try {
                    Method getExceptionMsg = ExceptionClass.getMethod("getExceptionMsg", String.class);
                    Object invokeResult = getExceptionMsg.invoke((Object)ExceptionClass.newInstance(), errorCode);
                    if (invokeResult != null) {
                        this.setErrorMsg(invokeResult.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ResponseDto(String result, T data, String errorCode, String errorMsg) {
        this.result = result;
        this.setData(data);
        this.setErrorCode(errorCode);
        this.setErrorMsg(errorMsg);
    }

    public static ResponseDto<Long> createLong(Long value) {
        return new ResponseDto<Long>(value);
    }

    public static ResponseDto<Short> createShort(Short value) {
        return new ResponseDto<Short>(value);
    }

    public static ResponseDto<Integer> createInteger(Integer value) {
        return new ResponseDto<Integer>(value);
    }

    public static ResponseDto<Float> createFloat(Float value) {
        return new ResponseDto<Float>(value);
    }

    public static ResponseDto<Double> createDouble(Double value) {
        return new ResponseDto<Double>(value);
    }

    public static ResponseDto<BigDecimal> createBigDecimal(BigDecimal value) {
        return new ResponseDto<BigDecimal>(value);
    }

    public static ResponseDto<Object> createObject(Object obj) {
        return new ResponseDto<Object>(obj);
    }

    public static ResponseDto<?> toResponseDto(Object obj) {
        if (obj.getClass().isEnum()) {
            Method[] methods = obj.getClass().getDeclaredMethods();
            String code = null;
            String msg = null;
            Object[] args = null;
            try {
                for (Method method : methods) {
                    if (method.getName().equals("getCode")) {
                        code = (String)method.invoke(obj, args);
                        continue;
                    }
                    if (!method.getName().equals("getMsg")) continue;
                    msg = (String)method.invoke(obj, args);
                }
            }
            catch (Exception e) {
                throw new BusinessRuntimeException("convert ReponseDto error", e);
            }
            return new ResponseDto(code, msg);
        }
        return null;
    }

    public void setErrorCode(String errorCode) {
        this.setResultCode(errorCode);
    }

    public void setErrorMsg(String errorMsg) {
        this.setResultMsg(errorMsg);
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return "ResponseDto [result=" + this.result + ", errorCode=" + this.getResultCode() + ", errorMsg=" + this.getResultMsg() + ", data=" + this.getData() + "]";
    }
}

