/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.localcache.impl.caffeine;

import com.dtyunxi.huieryun.localcache.api.AbstractLocalCacheService;
import com.dtyunxi.huieryun.localcache.vo.LocalCacheRegistryVo;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CaffeineCacheServiceImpl
extends AbstractLocalCacheService {
    private Cache<String, Object> cache;

    public void init(String group, LocalCacheRegistryVo cacheRegistryVo) {
        super.init(group, cacheRegistryVo);
        Caffeine caffeineBuilder = Caffeine.newBuilder();
        caffeineBuilder.initialCapacity(cacheRegistryVo.getInitialCapacity());
        caffeineBuilder.maximumSize((long)cacheRegistryVo.getMaximumSize());
        caffeineBuilder.expireAfterWrite((long)cacheRegistryVo.getExpireTime(), TimeUnit.SECONDS);
        this.cache = caffeineBuilder.build();
    }

    public boolean setCache(String group, String key, Object value) {
        this.cache.put((Object)this.combineKey(group, key), value);
        return true;
    }

    public void setCacheValues(String group, Map<String, Object> dataMap) {
        this.cache.putAll(this.convertMap(group, dataMap));
    }

    public <T> T getCache(String group, String key, Class<T> clz) {
        try {
            return clz.cast(this.cache.getIfPresent((Object)this.combineKey(group, key)));
        }
        catch (ClassCastException | NullPointerException e) {
            return null;
        }
    }

    public <T> Map<String, T> getCacheValues(String group, Set<String> keys, Class<T> clz) {
        keys = this.combineKeys(group, keys);
        return this.cache.getAllPresent((Iterable)keys);
    }

    public boolean delCache(String group, String key) {
        this.cache.invalidate((Object)this.combineKey(group, key));
        return true;
    }

    public boolean delCacheValues(String group, Set<String> keys) {
        keys = this.combineKeys(group, keys);
        this.cache.invalidateAll((Iterable)keys);
        return true;
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public Object getNativeCache() {
        return this.cache;
    }
}

