/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.LogConstants;
import com.dtyunxi.huieryun.log.LogUtil;
import com.dtyunxi.huieryun.log.RequestId;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggerServletFilter
implements Filter,
LogConstants {
    private static final Logger logger = LoggerFactory.getLogger(LoggerServletFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.beforeFilter(request);
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            ((HttpServletResponse)response).setStatus(500);
        }
        finally {
            this.afterFilter();
        }
    }

    void beforeFilter(ServletRequest request) {
        MDC.put((String)"yes.req.remoteHost", (String)request.getRemoteHost());
        MDC.put((String)"yes.req.remoteAddr", (String)request.getRemoteAddr());
        MDC.put((String)"yes.req.remotePort", (String)String.valueOf(request.getRemotePort()));
        MDC.put((String)"yes.req.localAddr", (String)request.getLocalAddr());
        MDC.put((String)"yes.req.localPort", (String)String.valueOf(request.getLocalPort()));
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            MDC.put((String)"yes.req.requestURI", (String)httpServletRequest.getRequestURI());
            StringBuffer requestURL = httpServletRequest.getRequestURL();
            if (requestURL != null) {
                MDC.put((String)"yes.req.requestURL", (String)requestURL.toString());
            }
            MDC.put((String)"yes.req.method", (String)httpServletRequest.getMethod());
            MDC.put((String)"yes.req.queryString", (String)httpServletRequest.getQueryString());
            MDC.put((String)"yes.req.userAgent", (String)httpServletRequest.getHeader("User-Agent"));
            MDC.put((String)"yes.req.xForwardedFor", (String)httpServletRequest.getHeader("X-Forwarded-For"));
        }
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        if (request instanceof HttpServletRequest) {
            ServiceContext.getContext().setAttachment("yes.req.remoteIp", LogUtil.getRemoteIp((HttpServletRequest)request));
        }
        MDC.put((String)"yes.req.userId", (String)"anonymous");
    }

    void afterFilter() {
        MDC.remove((String)"yes.req.remoteHost");
        MDC.remove((String)"yes.req.remoteAddr");
        MDC.remove((String)"yes.req.remotePort");
        MDC.remove((String)"yes.req.localAddr");
        MDC.remove((String)"yes.req.localPort");
        MDC.remove((String)"yes.req.requestURI");
        MDC.remove((String)"yes.req.requestURL");
        MDC.remove((String)"yes.req.method");
        MDC.remove((String)"yes.req.queryString");
        MDC.remove((String)"yes.req.userAgent");
        MDC.remove((String)"yes.req.xForwardedFor");
        MDC.remove((String)"yes.req.requestId");
        MDC.remove((String)"yes.req.userId");
        ServiceContext.getContext().removeAttachment("yes.req.requestId");
    }

    public void destroy() {
    }
}

