/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.IMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqServiceImpl;
import com.dtyunxi.cube.plugin.mq.impl.DefaultMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.runner.MQRegisterRunner;
import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.MQFactory;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@ComponentScan(value={"com.dtyunxi.cube.plugin.mq"})
@EnableConfigurationProperties(value={TopicRegistryVo.class})
public class MQRunnerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MQRunnerAutoConfiguration.class);
    private final MessageRegistryVo messageRegistryVo;
    @Value(value="${cube.starter.mq.default.consumer:}")
    private String defaultConsumer;
    @Value(value="${spring.application.name:}")
    private String envModule;
    private final TopicRegistryVo topicRegistryVo;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;

    public MQRunnerAutoConfiguration(MessageRegistryVo messageRegistryVo, TopicRegistryVo topicRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
        this.topicRegistryVo = topicRegistryVo;
    }

    @Bean(value={"rabbitMessageProperties"})
    @ConditionalOnProperty(prefix="huieryun.mq.rabbit.registryvo", name={"type"}, havingValue="RABBIT")
    @ConfigurationProperties(prefix="huieryun.mq.rabbit.registryvo")
    public MessageRegistryVo rabbitMessageProperties() {
        return new MessageRegistryVo();
    }

    @Bean(value={"rocketMessageProperties"})
    @ConditionalOnProperty(prefix="huieryun.mq.rocket.registryvo", name={"type"}, havingValue="ROCKET")
    @ConfigurationProperties(prefix="huieryun.mq.rocket.registryvo")
    public MessageRegistryVo rocketMessageProperties() {
        return new MessageRegistryVo();
    }

    @Bean(value={"kafkaMessageProperties"})
    @ConditionalOnProperty(prefix="huieryun.mq.kafka.registryvo", name={"type"}, havingValue="KAFKA")
    @ConfigurationProperties(prefix="huieryun.mq.kafka.registryvo")
    public MessageRegistryVo kafkaMessageProperties() {
        return new MessageRegistryVo();
    }

    @Bean
    @ConditionalOnMissingBean
    public IProducer producerBean(@Qualifier(value="createIMQService") IMQService createIMQService) {
        return createIMQService.createProducer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IConsumer consumerBean(@Qualifier(value="createIMQService") IMQService createIMQService) {
        return createIMQService.createConsumer();
    }

    @Bean
    @DependsOn(value={"springBeanUtil"})
    @ConditionalOnMissingBean
    public IMQService createIMQService() {
        logger.info("messageRegistryVo \uff1a {}", (Object)this.messageRegistryVo);
        return MQFactory.createMQ((MessageRegistryVo)this.messageRegistryVo);
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public ICommonsMqService commonsMqService(@Qualifier(value="producerBean") IProducer commonsProducer, @Qualifier(value="consumerBean") IConsumer commonsConsumer) {
        return new CommonsMqServiceImpl(commonsProducer, commonsConsumer, this.messageRegistryVo, this.globalProfile, this.topicRegistryVo);
    }

    @Bean
    @DependsOn(value={"springBeanUtil"})
    public IMQConsumerRegister defaultMQConsumerRegister() {
        return new DefaultMQConsumerRegister(this.messageRegistryVo, this.topicRegistryVo, this.getConsumer());
    }

    @Bean
    @ConditionalOnProperty(prefix="cube.starter.mq", value={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    @DependsOn(value={"springBeanUtil"})
    public MQRegisterRunner mqRegisterRunner(@Qualifier(value="commonsMqService") ICommonsMqService commonsMqService, List<IMQConsumerRegister> consumerRegisterList) {
        return new MQRegisterRunner(commonsMqService, consumerRegisterList);
    }

    private String getConsumer() {
        return CommonsMqHelper.parseConsumer(this.messageRegistryVo, this.defaultConsumer, this.envModule);
    }

    @Bean(name={"rocketCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.rocket.registryvo", name={"type"}, havingValue="ROCKET")
    @DependsOn(value={"springBeanUtil"})
    public ICommonsMqService rocketCommonsMqService(@Qualifier(value="rocketMessageProperties") MessageRegistryVo messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }

    @Bean(name={"rabbitCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.rabbit.registryvo", name={"type"}, havingValue="RABBIT")
    @DependsOn(value={"springBeanUtil"})
    public ICommonsMqService rabbitCommonsMqService(@Qualifier(value="rabbitMessageProperties") MessageRegistryVo messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }

    @Bean(name={"aliyunCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.aliyun.registryvo", name={"type"}, havingValue="ALIYUN")
    @DependsOn(value={"springBeanUtil"})
    public ICommonsMqService aliyunCommonsMqService(@Qualifier(value="aliyunMessageProperties") MessageRegistryVo messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }

    @Bean(name={"kafkaCommonsMqService"})
    @ConditionalOnProperty(prefix="huieryun.mq.kafka.registryvo", name={"type"}, havingValue="KAFKA")
    @DependsOn(value={"springBeanUtil"})
    public ICommonsMqService kafkaCommonsMqService(@Qualifier(value="kafkaMessageProperties") MessageRegistryVo messageProperties) {
        IMQService imqService = MQFactory.createMQ((MessageRegistryVo)messageProperties);
        return new CommonsMqServiceImpl(imqService.createProducer(), imqService.createConsumer(), messageProperties, this.globalProfile, this.topicRegistryVo);
    }
}

