/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.api;

import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.base.BaseService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumer
extends BaseService
implements IConsumer {
    private static Logger logger = LoggerFactory.getLogger(AbstractConsumer.class);

    @Override
    public <T> MessageResponse receiveMessage(String queueName, IMessageProcessor<T> processor) {
        return this.receiveMessage(this.getDirectName(), queueName, processor);
    }

    @Override
    public <T> MessageResponse receiveMessage(String topic, String queueName, String routingKey, IMessageProcessor<T> processor) {
        return this.receiveMessage(topic, routingKey, processor);
    }

    @Override
    public MessageResponse receiveMessage(String topic, String queueName, Map<String, IMessageProcessor> processorMap) {
        try {
            for (String routingKey : processorMap.keySet()) {
                this.receiveMessage(topic, routingKey, processorMap.get(routingKey));
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topic, (Object)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public <T> MessageResponse subscribe(String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(this.getTopicName(), routingKey, processor);
    }

    @Override
    public <T> MessageResponse subscribe(String[] routingKeys, IMessageProcessor<T> processor) {
        return this.subscribe(this.getTopicName(), routingKeys, processor);
    }

    @Override
    public MessageResponse subscribe(String topic, Map<String, IMessageProcessor> messageProcessorMap) {
        try {
            for (String routingKey : messageProcessorMap.keySet()) {
                this.subscribe(topic, routingKey, messageProcessorMap.get(routingKey));
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topic, (Object)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public MessageResponse subscribe(String topic, String queueName, Map<String, IMessageProcessor> messageProcessorMap) {
        try {
            for (String routingKey : messageProcessorMap.keySet()) {
                this.subscribe(topic, routingKey, messageProcessorMap.get(routingKey));
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topic, (Object)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public MessageResponse unsubscribe(String routingKey) {
        return this.unsubscribe(this.getTopicName(), routingKey);
    }

    protected String getSubExpression(Object[] routingKeys) {
        StringBuilder sb = new StringBuilder();
        if (routingKeys != null) {
            for (int i = 0; i < routingKeys.length; ++i) {
                if (i == routingKeys.length - 1) {
                    sb.append(routingKeys[i]);
                    continue;
                }
                sb.append(routingKeys[i]).append("||");
            }
        }
        return sb.toString();
    }
}

