/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.das;

import com.dtyunxi.huieryun.mq.dao.MqLogQueryDto;
import com.dtyunxi.huieryun.mq.eo.MqLogEo;
import com.dtyunxi.huieryun.mq.provider.base.MqLogConfig;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.DateUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;

@Service(value="mqLogQueryDas")
public class MqLogQueryDas {
    private static final String sqlQuery = "select id,mq_topic,mq_queue,mq_routing_key,mq_message,mq_send_type,mq_send_status,fail_reason,class_name,remark,send_time,tenant_id,create_person,update_person,create_time,update_time from cmpt_mq_log where dr=0 ";
    private static final String countSql = "select count(*) from cmpt_mq_log where dr=0";
    private static final Logger logger = LoggerFactory.getLogger(MqLogQueryDas.class);

    public List<MqLogEo> queryMqLog(MqLogQueryDto queryDto) {
        return this.queryPageByEo(queryDto, null, null);
    }

    public long queryCount(MqLogQueryDto queryDto) {
        long total = 0L;
        DataSource dataSource = (DataSource)MqLogConfig.getInstance().getBean("dataSource");
        try {
            if (null != dataSource) {
                Connection conn = dataSource.getConnection();
                Statement statement = conn.createStatement();
                String sql = this.getCountSql(queryDto);
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    total = resultSet.getLong(1);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u603b\u6761\u6570\u65f6\u5f02\u5e38");
            throw new BusinessRuntimeException("\u67e5\u8be2\u65e5\u5fd7\u603b\u6761\u6570\u65f6\u5f02\u5e38", (Throwable)e);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MqLogEo> queryPageByEo(MqLogQueryDto queryDto, Integer pageNo, Integer pageSize) {
        LinkedList<MqLogEo> listResult = null;
        Connection conn = null;
        DataSource dataSource = (DataSource)MqLogConfig.getInstance().getBean("dataSource");
        try {
            if (null != dataSource) {
                conn = dataSource.getConnection();
                Statement statement = conn.createStatement();
                String sql = this.getQuerySql(queryDto, pageNo, pageSize);
                ResultSet resultSet = statement.executeQuery(sql);
                listResult = new LinkedList<MqLogEo>();
                while (resultSet.next()) {
                    MqLogEo eo = new MqLogEo();
                    eo.setId(resultSet.getLong(1));
                    eo.setMqTopic(resultSet.getString(2));
                    eo.setMqQueue(resultSet.getString(3));
                    eo.setMqRoutingKey(resultSet.getString(4));
                    eo.setMqMessage(resultSet.getString(5));
                    eo.setMqSendType(resultSet.getInt(6));
                    eo.setMqSendStatus(resultSet.getInt(7));
                    eo.setFailReason(resultSet.getString(8));
                    eo.setClassName(resultSet.getString(9));
                    eo.setRemark(resultSet.getString(10));
                    Timestamp ts = resultSet.getTimestamp(11);
                    if (ts != null) {
                        eo.setSendTime(new Date(ts.getTime()));
                    }
                    eo.setTenantId(resultSet.getLong(12));
                    eo.setCreatePerson(resultSet.getString(13));
                    eo.setUpdatePerson(resultSet.getString(14));
                    ts = resultSet.getTimestamp(15);
                    if (ts != null) {
                        eo.setCreateTime(new Date(ts.getTime()));
                    }
                    if ((ts = resultSet.getTimestamp(16)) != null) {
                        eo.setUpdateTime(new Date(ts.getTime()));
                    }
                    listResult.add(eo);
                }
            }
        }
        catch (Exception e) {
            logger.error("MqLogDas::queryMqLog", (Throwable)e);
        }
        finally {
            this.closeConnection(conn, dataSource);
        }
        return listResult;
    }

    private String getQuerySql(MqLogQueryDto queryDto, Integer pageNo, Integer pageSize) {
        StringBuilder sql = new StringBuilder(sqlQuery);
        this.setCondition(queryDto, sql);
        sql.append(" order by create_time ");
        if (pageNo != null && pageSize != null) {
            sql.append(" limit ").append((pageNo - 1) * pageSize).append(",").append(pageSize);
        }
        return sql.toString();
    }

    private String getCountSql(MqLogQueryDto queryDto) {
        StringBuilder sql = new StringBuilder(countSql);
        this.setCondition(queryDto, sql);
        return sql.toString();
    }

    private void setCondition(MqLogQueryDto queryDto, StringBuilder sql) {
        if (queryDto != null) {
            if (StringUtils.isNotEmpty((CharSequence)queryDto.getMqTopic())) {
                sql.append(" and mq_topic=").append("'").append(this.getFilterVal(queryDto.getMqTopic())).append("'");
            }
            if (StringUtils.isNotEmpty((CharSequence)queryDto.getMqQueue())) {
                sql.append(" and mq_queue=").append("'").append(this.getFilterVal(queryDto.getMqQueue())).append("'");
            }
            if (StringUtils.isNotEmpty((CharSequence)queryDto.getMqRoutingKey())) {
                sql.append(" and mq_routing_key=").append("'").append(this.getFilterVal(queryDto.getMqRoutingKey())).append("'");
            }
            if (StringUtils.isNotEmpty((CharSequence)queryDto.getMqMessage())) {
                sql.append(" and mq_message like ").append("'%").append(this.getFilterVal(queryDto.getMqMessage())).append("%'");
            }
            if (queryDto.getMqSendType() != null) {
                sql.append(" and mq_send_type=").append(queryDto.getMqSendType());
            }
            if (queryDto.getMqSendStatus() != null) {
                sql.append(" and mq_send_status=").append(queryDto.getMqSendStatus());
            }
            if (CollectionUtils.isNotEmpty(queryDto.getIds())) {
                queryDto.getIds().removeAll(Collections.singleton(null));
                sql.append(" and id in (").append(StringUtils.join(queryDto.getIds(), (String)",")).append(")");
            }
            if (queryDto.getId() != null) {
                sql.append(" and id=").append(queryDto.getId());
            }
            if (StringUtils.isNotEmpty((CharSequence)queryDto.getBeginTime()) && StringUtils.isNotEmpty((CharSequence)queryDto.getEndTime())) {
                String endTime = queryDto.getEndTime();
                if (queryDto.getBeginTime().equals(queryDto.getEndTime())) {
                    endTime = DateUtil.format((Date)DateUtil.addDay((Date)DateUtil.parse((String)endTime), (int)1), (String)"yyyy-MM-dd");
                }
                sql.append(" and create_time > ").append("'").append(this.getFilterVal(queryDto.getBeginTime())).append("'");
                sql.append(" and create_time < ").append("'").append(this.getFilterVal(endTime)).append("'");
            }
        }
    }

    private void closeConnection(Connection conn, DataSource dataSource) {
        if (conn != null) {
            try {
                DataSourceUtils.doCloseConnection((Connection)conn, (DataSource)dataSource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getFilterVal(String val) {
        String strCode = "'";
        String filterCode = "\"";
        if (StringUtils.isNotEmpty((CharSequence)val) && val.indexOf(strCode) > -1) {
            return val.replaceAll(strCode, filterCode);
        }
        return val;
    }
}

