/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.util;

import java.util.Date;
import java.util.UUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzManager {
    private static Logger logger = LoggerFactory.getLogger(QuartzManager.class);
    private static String JOB_GROUP_NAME = "EXTJWEB_JOBGROUP_NAME";
    private static String TRIGGER_GROUP_NAME = "EXTJWEB_TRIGGERGROUP_NAME";

    public static void addJobOnce(Scheduler sched, String jobName, Class cls) {
        try {
            JobDetail jobDetail = JobBuilder.newJob((Class)cls).withIdentity(jobName, JOB_GROUP_NAME).usingJobData("uuId", UUID.randomUUID().toString()).build();
            Date startTime = DateBuilder.nextGivenSecondDate(null, (int)5);
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).startAt(startTime).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void addJob(Scheduler sched, String jobName, Class cls, String cronTime) {
        try {
            JobDetail jobDetail = JobBuilder.newJob((Class)cls).withIdentity(jobName, JOB_GROUP_NAME).usingJobData("uuId", UUID.randomUUID().toString()).build();
            Date startTime = DateBuilder.nextGivenSecondDate(null, (int)10);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronTime)).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void addJob(Scheduler sched, String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String time) {
        try {
            JobDetail jobDetail = JobBuilder.newJob((Class)jobClass).withIdentity(jobName, jobGroupName).build();
            Date startTime = DateBuilder.nextGivenSecondDate(null, (int)10);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            sched.scheduleJob(jobDetail, (Trigger)trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void modifyJobTime(Scheduler sched, String jobName, String cronTime) {
        try {
            CronTrigger trigger = (CronTrigger)sched.getTrigger(new TriggerKey(jobName, TRIGGER_GROUP_NAME));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cronTime)) {
                JobDetail jobDetail = sched.getJobDetail(new JobKey(jobName, JOB_GROUP_NAME));
                Class objJobClass = jobDetail.getJobClass();
                QuartzManager.removeJob(sched, jobName);
                QuartzManager.addJob(sched, jobName, objJobClass, cronTime);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u4e00\u4e2a\u4efb\u52a1\u7684\u89e6\u53d1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void modifyJobTime(Scheduler sched, String triggerName, String triggerGroupName, String cronTime) {
        try {
            CronTrigger trigger = (CronTrigger)sched.getTrigger(new TriggerKey(triggerName, triggerGroupName));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cronTime)) {
                Date startTime = DateBuilder.nextGivenSecondDate(null, (int)15);
                CronTrigger ct = trigger;
                ct.getTriggerBuilder().startAt(startTime).usingJobData("uuId", UUID.randomUUID().toString());
                sched.resumeTrigger(new TriggerKey(triggerName, triggerGroupName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(Scheduler sched, String jobName) {
        try {
            TriggerKey triggerKey = new TriggerKey(jobName, TRIGGER_GROUP_NAME);
            sched.pauseTrigger(triggerKey);
            sched.unscheduleJob(triggerKey);
            sched.deleteJob(new JobKey(jobName, JOB_GROUP_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(Scheduler sched, String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
            sched.pauseTrigger(triggerKey);
            sched.unscheduleJob(triggerKey);
            sched.deleteJob(new JobKey(jobName, jobGroupName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startJobs(Scheduler sched) {
        try {
            sched.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shutdownJobs(Scheduler sched) {
        try {
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

