/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.api;

import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.SendCallback;
import com.dtyunxi.huieryun.mq.provider.base.BaseService;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.retry.vo.RetryerRegistryVo;
import java.util.concurrent.Callable;

public abstract class AbstractProducer
extends BaseService
implements IProducer {
    protected SerializeCode serializeCode;

    public void createProducer(MessageRegistryVo messageRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
        this.serializeCode = messageRegistryVo.getSerializeCode();
        this.start();
    }

    protected void start() {
        Boolean result = this.connectMQServer();
        if (result == null || !result.booleanValue()) {
            RetryerRegistryVo retryerRegistryVo = this.getRetryerRegistryVo();
            this.getRetryService().retryWithResultAndIncreaseStrategy((Object)true, retryerRegistryVo.getInitialSleepTime(), retryerRegistryVo.getIncrementSleepTime(), retryerRegistryVo.getAttemptNumber(), this.createConnectMQServerCallable());
        }
    }

    protected abstract Boolean connectMQServer();

    protected Callable<Boolean> createConnectMQServerCallable() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AbstractProducer.this.connectMQServer();
            }
        };
    }

    @Override
    public MessageResponse sendSingleMessage(String queueName, Object message) {
        return this.sendSingleMessage(this.getDirectName(), queueName, message, 0L);
    }

    @Override
    public MessageResponse sendSingleMessage(String queueName, Object message, long delayTime) {
        return this.sendSingleMessage(this.getDirectName(), queueName, message, delayTime);
    }

    @Override
    public MessageResponse sendSingleMessage(String topic, String queueName, Object message) {
        return this.sendSingleMessage(topic, queueName, message, 0L);
    }

    @Override
    public MessageResponse sendMessage(String routingKey, Object message) {
        return this.sendMessage(this.getTopicName(), routingKey, message, 0L);
    }

    @Override
    public MessageResponse sendMessage(String routingKey, Object message, long delayTime) {
        return this.sendMessage(this.getTopicName(), routingKey, message, delayTime);
    }

    @Override
    public MessageResponse sendMessage(String topic, String routingKey, Object message) {
        return this.sendMessage(topic, routingKey, message, 0L);
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, SendCallback callback) {
        return this.sendAsyncMessage(routingKey, message, 0L, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String topic, String routingKey, Object message, SendCallback callback) {
        return this.sendAsyncMessage(topic, routingKey, message, 0L, callback);
    }

    @Override
    public MessageResponse sendBroadcastMessage(String routingKey, Object message) {
        return this.sendBroadcastMessage(this.getTopicName(), routingKey, message, 0L);
    }

    @Override
    public MessageResponse sendBroadcastMessage(String routingKey, Object message, long delayTime) {
        return this.sendBroadcastMessage(this.getTopicName(), routingKey, message, delayTime);
    }

    @Override
    public MessageResponse sendBroadcastMessage(String topic, String routingKey, Object message) {
        return this.sendBroadcastMessage(topic, routingKey, message, 0L);
    }

    @Override
    public MessageResponse sendAsyncBroadcastMessage(String routingKey, Object message, SendCallback callback) {
        return this.sendAsyncBroadcastMessage(this.getTopicName(), routingKey, message, 0L, callback);
    }

    @Override
    public MessageResponse sendAsyncBroadcastMessage(String routingKey, Object message, long delayTime, SendCallback callback) {
        return this.sendAsyncBroadcastMessage(this.getTopicName(), routingKey, message, delayTime, callback);
    }

    @Override
    public MessageResponse sendAsyncBroadcastMessage(String topic, String routingKey, Object message, SendCallback callback) {
        return this.sendAsyncBroadcastMessage(topic, routingKey, message, 0L, callback);
    }

    @Override
    public void shutdown() {
    }
}

