/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.api;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.JacksonUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public interface IMessageProcessor<T> {
    public static final Map<String, Type> CLAZZ_GENERIC_TYPES = new ConcurrentHashMap<String, Type>();

    public MessageResponse process(T var1);

    default public boolean isDuplicationMessage(String msgId, T message) {
        return false;
    }

    default public MessageResponse process(MQMessageVo message) {
        this.addServiceContext(message.getHeaderList());
        T messageBody = this.unpackMessage(message);
        if (this.isDuplicationMessage(message.getMessageId(), messageBody)) {
            return MessageResponse.SUCCESS;
        }
        return this.process(messageBody);
    }

    default public T unpackMessage(MQMessageVo message) {
        Object messageBody;
        if (message.getSerializeCode().isJdkSerializer()) {
            messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), null);
        } else {
            String clazzJson = message.getUserProperty("mqMessageBodyClassInfo");
            if (StringUtils.isEmpty((Object)clazzJson)) {
                messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), this.getMsgType());
            } else {
                Class msgType = (Class)JacksonUtil.readValue((String)clazzJson, Class.class);
                messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), msgType);
            }
        }
        return (T)messageBody;
    }

    default public void addServiceContext(Map<String, String> headerList) {
        if (headerList != null && headerList.size() > 0) {
            ServiceContext serviceContext = ServiceContext.getContext();
            headerList.forEach((k, v) -> {
                if (k.startsWith("_context-") && v != null) {
                    k = k.substring("_context-".length());
                    serviceContext.set(k, v);
                }
            });
        }
    }

    default public Type getMsgType() {
        Class<?> clazz = this.getClass();
        String clazzName = clazz.getName();
        if (CLAZZ_GENERIC_TYPES.containsKey(clazzName)) {
            return CLAZZ_GENERIC_TYPES.get(clazzName);
        }
        Type[] genTypes = clazz.getGenericInterfaces();
        while (genTypes.length == 0 && !clazz.equals(Object.class)) {
            clazz = clazz.getSuperclass();
            genTypes = clazz.getGenericInterfaces();
        }
        if (genTypes.length == 0) {
            return null;
        }
        for (Type genType : genTypes) {
            ParameterizedType prmType;
            if (!(genType instanceof ParameterizedType) || !IMessageProcessor.class.isAssignableFrom((Class)(prmType = (ParameterizedType)genType).getRawType())) continue;
            Type typeArgument = prmType.getActualTypeArguments()[0];
            CLAZZ_GENERIC_TYPES.put(clazzName, typeArgument);
            return typeArgument;
        }
        return null;
    }
}

