/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.api;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.SpringBeanUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public interface IMessageProcessor<T> {
    public static final Logger LOG = LoggerFactory.getLogger(IMessageProcessor.class);
    public static final Map<String, Type> CLAZZ_GENERIC_TYPES = new ConcurrentHashMap<String, Type>();

    public MessageResponse process(T var1);

    default public boolean isDuplicationMessage(String msgId, T message) {
        ICacheService cacheService = (ICacheService)SpringBeanUtil.getBean(ICacheService.class);
        String key = "_dtmqconsume/" + msgId;
        String flag = cacheService.getAndSet(key, "1");
        int expireSeconds = 28800;
        cacheService.expire(key, 28800);
        return flag != null && "1".equals(flag);
    }

    default public void cleanMessageConsumeFlag(String msgId) {
        ICacheService cacheService = (ICacheService)SpringBeanUtil.getBean(ICacheService.class);
        String key = "_dtmqconsume/" + msgId;
        cacheService.delCache(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public MessageResponse process(MQMessageVo message) {
        MessageResponse response;
        try {
            this.addServiceContext(message.getHeaderList());
            T messageBody = this.unpackMessage(message);
            if (this.isDuplicationMessage(message.getMessageId(), messageBody)) {
                LOG.info("\u91cd\u590d\u6d88\u606f\uff0cmsgId:{},msgKey:{}", (Object)message.getMessageId(), (Object)message.getMessageKey());
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            response = this.process(messageBody);
            if (response == null || "error".equals(response.getResultMsg())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c(response is {})\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217\uff01", (Object)(response == null ? null : response.getResultMsg()));
                }
                this.cleanMessageConsumeFlag(message.getMessageId());
                MessageResponse messageResponse = MessageResponse.ERROR;
                return messageResponse;
            }
            if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                LOG.debug("\u5904\u7406\u6210\u529f\uff0c\u6b63\u5e38\u6d88\u8d39\uff01");
            }
        }
        catch (BusinessRuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u5f02\u5e38\u6d88\u606f\uff1a", (Throwable)e);
            } else {
                LOG.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)e.getMessage());
            }
            MessageResponse messageResponse = MessageResponse.SUCCESS;
            return messageResponse;
        }
        catch (Error error) {
            if (LOG.isDebugEnabled()) {
                LOG.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u9519\u8bef\u6d88\u606f\uff1a", (Throwable)error);
            } else {
                LOG.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u9519\u8bef\u6d88\u606f\uff1a{}", (Object)error.getMessage());
            }
            MessageResponse messageResponse = MessageResponse.SUCCESS;
            return messageResponse;
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a", e);
            } else {
                LOG.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)e.getMessage());
            }
            this.cleanMessageConsumeFlag(message.getMessageId());
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            if (message.isPassSvcContext()) {
                ServiceContext.removeContext();
            }
        }
        return response;
    }

    default public T unpackMessage(MQMessageVo message) {
        Object messageBody;
        if (message.getSerializeCode().isJdkSerializer()) {
            messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), null);
        } else {
            String clazzJson = message.getUserProperty("mqMessageBodyClassInfo");
            if (StringUtils.isEmpty((Object)clazzJson)) {
                messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), this.getMsgType());
            } else {
                Class msgType = (Class)JacksonUtil.readValue((String)clazzJson, Class.class);
                messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), msgType);
            }
        }
        return (T)messageBody;
    }

    default public void addServiceContext(Map<String, String> headerList) {
        if (headerList != null && headerList.size() > 0) {
            ServiceContext serviceContext = ServiceContext.getContext();
            headerList.forEach((k, v) -> {
                if (k.startsWith("_context-") && v != null) {
                    k = k.substring("_context-".length());
                    serviceContext.set(k, v);
                }
            });
        }
    }

    default public Type getMsgType() {
        Class<?> clazz = this.getClass();
        String clazzName = clazz.getName();
        if (CLAZZ_GENERIC_TYPES.containsKey(clazzName)) {
            return CLAZZ_GENERIC_TYPES.get(clazzName);
        }
        Type[] genTypes = clazz.getGenericInterfaces();
        while (genTypes.length == 0 && !clazz.equals(Object.class)) {
            clazz = clazz.getSuperclass();
            genTypes = clazz.getGenericInterfaces();
        }
        if (genTypes.length == 0) {
            return null;
        }
        for (Type genType : genTypes) {
            ParameterizedType prmType;
            if (!(genType instanceof ParameterizedType) || !IMessageProcessor.class.isAssignableFrom((Class)(prmType = (ParameterizedType)genType).getRawType())) continue;
            Type typeArgument = prmType.getActualTypeArguments()[0];
            CLAZZ_GENERIC_TYPES.put(clazzName, typeArgument);
            return typeArgument;
        }
        return null;
    }
}

