/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.packer;

import com.dtyunxi.huieryun.mq.packer.ISerializeBytePacker;
import com.dtyunxi.util.FastJsonUtil;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializeBytePacker
implements ISerializeBytePacker {
    private static Logger logger = LoggerFactory.getLogger(JsonSerializeBytePacker.class);
    private static Charset CHARSET = Charset.forName("utf8");

    @Override
    public byte[] serialize(Object obj) {
        String jsonString = FastJsonUtil.toJSONString((Object)obj);
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            return jsonString.getBytes(CHARSET);
        }
        return new byte[0];
    }

    @Override
    public <T> Object deSerialize(byte[] in, Class<?> clazz) {
        if (in != null && in.length > 0) {
            String jsonString = new String(in, CHARSET);
            return FastJsonUtil.parseObject((String)jsonString, clazz);
        }
        return null;
    }

    @Override
    public <T> Object deSerialize(byte[] in, Type type) {
        if (in != null && in.length > 0) {
            String jsonString = new String(in, CHARSET);
            return FastJsonUtil.parseObject((String)jsonString, (Type)type);
        }
        return null;
    }
}

