/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.vo;

import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.util.JacksonUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Transient;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MQMessageVo {
    private String topic;
    private String tag;
    private String messageId;
    private String messageKey;
    private String messageType;
    private long delayTime;
    private Map<String, String> headerList;
    private byte[] messageBody;
    private String messageBodyClass;
    @Transient
    private final SerializeCode serializeCode;
    @Transient
    private boolean passSvcContext = false;

    public String getUserProperty(String propertyName) {
        if (CollectionUtils.isEmpty(this.headerList)) {
            return null;
        }
        return this.headerList.get(propertyName);
    }

    public MQMessageVo(SerializeCode serializeCode) {
        this.serializeCode = serializeCode;
    }

    public MQMessageVo(String topic, String tag, Object message, SerializeCode serializeCode) {
        this(topic, tag, message, 0L, serializeCode);
    }

    public static MQMessageVo build(String topic, String tag, Object message, SerializeCode serializeCode) {
        return new MQMessageVo(topic, tag, message, 0L, serializeCode);
    }

    public static MQMessageVo build(String topic, String tag, Object message, long delayTime, SerializeCode serializeCode) {
        return new MQMessageVo(topic, tag, message, delayTime, serializeCode);
    }

    public MQMessageVo(String topic, String tag, Object message, long delayTime, SerializeCode serializeCode) {
        this.topic = topic;
        this.tag = tag;
        this.delayTime = delayTime;
        this.serializeCode = serializeCode;
        this.messageKey = "ORDERID_" + UUID.randomUUID().toString();
        if (message == null) {
            return;
        }
        if (message instanceof Byte[]) {
            this.messageBody = (byte[])message;
            return;
        }
        this.messageBody = serializeCode.serialize(message);
        this.messageBodyClass = JacksonUtil.toJson(message.getClass());
    }

    public String getMessageKey() {
        if (StringUtils.isEmpty((Object)this.messageKey)) {
            this.messageKey = "ORDERID_" + UUID.randomUUID().toString();
        }
        return this.messageKey;
    }

    public SerializeCode getSerializeCode() {
        return this.serializeCode;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTag() {
        return this.tag;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public Map<String, String> getHeaderList() {
        return this.headerList;
    }

    public byte[] getMessageBody() {
        return this.messageBody;
    }

    public String getMessageBodyClass() {
        return this.messageBodyClass;
    }

    public boolean isPassSvcContext() {
        return this.passSvcContext;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public void setHeaderList(Map<String, String> headerList) {
        this.headerList = headerList;
    }

    public void setMessageBody(byte[] messageBody) {
        this.messageBody = messageBody;
    }

    public void setMessageBodyClass(String messageBodyClass) {
        this.messageBodyClass = messageBodyClass;
    }

    public void setPassSvcContext(boolean passSvcContext) {
        this.passSvcContext = passSvcContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MQMessageVo)) {
            return false;
        }
        MQMessageVo other = (MQMessageVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDelayTime() != other.getDelayTime()) {
            return false;
        }
        if (this.isPassSvcContext() != other.isPassSvcContext()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$messageKey = this.getMessageKey();
        String other$messageKey = other.getMessageKey();
        if (this$messageKey == null ? other$messageKey != null : !this$messageKey.equals(other$messageKey)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        Map<String, String> this$headerList = this.getHeaderList();
        Map<String, String> other$headerList = other.getHeaderList();
        if (this$headerList == null ? other$headerList != null : !((Object)this$headerList).equals(other$headerList)) {
            return false;
        }
        if (!Arrays.equals(this.getMessageBody(), other.getMessageBody())) {
            return false;
        }
        String this$messageBodyClass = this.getMessageBodyClass();
        String other$messageBodyClass = other.getMessageBodyClass();
        if (this$messageBodyClass == null ? other$messageBodyClass != null : !this$messageBodyClass.equals(other$messageBodyClass)) {
            return false;
        }
        SerializeCode this$serializeCode = this.getSerializeCode();
        SerializeCode other$serializeCode = other.getSerializeCode();
        return !(this$serializeCode == null ? other$serializeCode != null : !this$serializeCode.equals(other$serializeCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MQMessageVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $delayTime = this.getDelayTime();
        result = result * 59 + (int)($delayTime >>> 32 ^ $delayTime);
        result = result * 59 + (this.isPassSvcContext() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $messageKey = this.getMessageKey();
        result = result * 59 + ($messageKey == null ? 43 : $messageKey.hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        Map<String, String> $headerList = this.getHeaderList();
        result = result * 59 + ($headerList == null ? 43 : ((Object)$headerList).hashCode());
        result = result * 59 + Arrays.hashCode(this.getMessageBody());
        String $messageBodyClass = this.getMessageBodyClass();
        result = result * 59 + ($messageBodyClass == null ? 43 : $messageBodyClass.hashCode());
        SerializeCode $serializeCode = this.getSerializeCode();
        result = result * 59 + ($serializeCode == null ? 43 : $serializeCode.hashCode());
        return result;
    }

    public String toString() {
        return "MQMessageVo(topic=" + this.getTopic() + ", tag=" + this.getTag() + ", messageId=" + this.getMessageId() + ", messageKey=" + this.getMessageKey() + ", messageType=" + this.getMessageType() + ", delayTime=" + this.getDelayTime() + ", headerList=" + this.getHeaderList() + ", messageBody=" + Arrays.toString(this.getMessageBody()) + ", messageBodyClass=" + this.getMessageBodyClass() + ", serializeCode=" + this.getSerializeCode() + ", passSvcContext=" + this.isPassSvcContext() + ")";
    }
}

