/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.config.root;

import com.dtyunxi.app.AppEnv;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryServiceFactory;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages={"com.dtyunxi.huieryun.oss"})
@PropertySource(value={"classpath:config/objectstorage/config.properties"})
public class RootContextConfig {
    private static final Logger logger = LoggerFactory.getLogger(RootContextConfig.class);
    @Autowired
    private Environment env;

    @Bean
    public IRegistryService registryService() {
        return RegistryServiceFactory.createRegistryService((Environment)this.env);
    }

    @Bean
    public AppEnv appEnv(IRegistryService registryService) {
        OssRegistryVo ossRegistryVo;
        AppEnv appEnv = new AppEnv();
        OssConstant.registryVo = ossRegistryVo = (OssRegistryVo)registryService.getObject("huieryun.ossregistryvo", OssRegistryVo.class);
        OssConstant.APP_ID = registryService.get("huieryun.ossregistry.appId");
        OssConstant.DIR = registryService.get("huieryun.ossregistry.dir");
        logger.info("OssConstant.DIR\uff1a{}, OssConstant.APP_ID:{}", (Object)OssConstant.DIR, (Object)OssConstant.APP_ID);
        String fileHome = registryService.get("huieryun.objectstorage.simpleobjectstorage.filehome");
        if (fileHome == null) {
            String msg = "No configration item huieryun.objectstorage.simpleobjectstorage.filehome";
            logger.debug("Set data source as {}", (Object)msg);
            throw new BusinessRuntimeException(msg);
        }
        logger.debug("Set SimpleFileStorage fileHome as {}", (Object)fileHome);
        appEnv.putObject("huieryun.objectstorage.simpleobjectstorage.filehome", (Object)fileHome);
        return appEnv;
    }
}

