/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.rest;

import com.dtyunxi.huieryun.oss.vo.ProcessStyleVo;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageResizer {
    public static void resize(File fileSource, String processStyle, OutputStream outputStream) throws IOException {
        ProcessStyleVo processStyleVo = ProcessStyleVo.parse(processStyle);
        BufferedImage inputImage = ImageIO.read(fileSource);
        BufferedImage outputImage = new BufferedImage(processStyleVo.getW(), processStyleVo.getH(), inputImage.getType());
        Graphics2D g2d = outputImage.createGraphics();
        g2d.drawImage(inputImage, 0, 0, processStyleVo.getW(), processStyleVo.getH(), null);
        g2d.dispose();
        String formatName = ImageResizer.getFileExt(fileSource);
        ImageIO.write((RenderedImage)outputImage, formatName, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resize(File fileSource, String processStyle, File fileTarget) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileTarget);
            ImageResizer.resize(fileSource, processStyle, fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getFileExt(File file) {
        String filePath = file.getPath();
        return filePath.substring(filePath.lastIndexOf(".") + 1);
    }
}

