/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.provider.es68;

import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class RestSearchClientUtils {
    private static Map<Integer, RestHighLevelClient> clientMap = new ConcurrentHashMap<Integer, RestHighLevelClient>(1);

    public static RestHighLevelClient createClient(OpenSearchVo openSearchVo) {
        RestHighLevelClient client;
        if (!clientMap.isEmpty() && (client = clientMap.get(openSearchVo.hashCode())) != null) {
            return client;
        }
        String[] addresses = openSearchVo.getAddresses();
        if (addresses == null || addresses.length == 0) {
            throw new RuntimeException("\u8fde\u63a5\u5730\u5740[addresses]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHost[] hosts = (HttpHost[])Arrays.stream(addresses).map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        RestSearchClientUtils.setHttpClientConfigCallback(openSearchVo, addresses, builder);
        List customizers = openSearchVo.getCustomizers();
        if (!CollectionUtils.isEmpty((Collection)customizers)) {
            customizers.forEach(customizer -> customizer.customize((Object)builder));
        }
        client = new RestHighLevelClient(builder);
        clientMap.put(openSearchVo.hashCode(), client);
        return client;
    }

    private static void setHttpClientConfigCallback(OpenSearchVo openSearchVo, String[] addresses, RestClientBuilder builder) {
        if (StringUtils.hasText((String)openSearchVo.getAccessKey())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(openSearchVo.getAccessKey(), openSearchVo.getSecret()));
            if (addresses[0].startsWith("https://")) {
                SSLContext sslContext;
                try {
                    SSLContextBuilder contextBuilder = new SSLContextBuilder();
                    contextBuilder.setProtocol("SSL");
                    contextBuilder.setSecureRandom(new SecureRandom());
                    contextBuilder.loadTrustMaterial(new TrustStrategy(){

                        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            return true;
                        }
                    });
                    sslContext = contextBuilder.build();
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new RuntimeException("Get SSLContext failed", e);
                }
                SSLIOSessionStrategy sslStrategy = new SSLIOSessionStrategy(sslContext, (s, sslSession) -> true);
                builder.setHttpClientConfigCallback(arg_0 -> RestSearchClientUtils.lambda$setHttpClientConfigCallback$3((CredentialsProvider)credentialsProvider, sslContext, sslStrategy, arg_0));
            } else {
                builder.setHttpClientConfigCallback(arg_0 -> RestSearchClientUtils.lambda$setHttpClientConfigCallback$4((CredentialsProvider)credentialsProvider, arg_0));
            }
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$setHttpClientConfigCallback$4(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder b) {
        return b.setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$setHttpClientConfigCallback$3(CredentialsProvider credentialsProvider, SSLContext sslContext, SSLIOSessionStrategy sslStrategy, HttpAsyncClientBuilder b) {
        b.setDefaultCredentialsProvider(credentialsProvider);
        b.setSSLContext(sslContext);
        b.setSSLStrategy((SchemeIOSessionStrategy)sslStrategy);
        return b;
    }
}

