/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.provider.es68;

import com.dtyunxi.huieryun.opensearch.api.AbstractOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.vo.AggFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.AggResult;
import com.dtyunxi.huieryun.opensearch.vo.AggResultItem;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoDistanceFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.QueryFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.RangeVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchSuggestVo;
import com.dtyunxi.huieryun.opensearch.vo.SortFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.SuggestResultVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSearchService
extends AbstractOpenSearchService {
    private static final Logger logger = LoggerFactory.getLogger(RestSearchService.class);
    protected RestHighLevelClient client = null;

    protected Logger getLogger() {
        return logger;
    }

    public void init(OpenSearchVo openSearchVo) {
        this.openSearchVo = openSearchVo;
        this.client = RestSearchClientUtils.createClient(openSearchVo);
    }

    public SearchResultVo search(OSSearchVo vo) {
        SearchResponse response;
        if (logger.isDebugEnabled()) {
            logger.debug("ES search \u641c\u7d22\u6570\u636e\u4f20\u5165\u53c2\u6570\uff1aindexName={},osSearchVo={}", (Object)vo.getIndexName(), (Object)JacksonUtil.toJson((Object)vo));
        }
        this.prepareIndexMapping(vo.getIndexName(), "_doc");
        BoolQueryBuilder boolQueryBuilder = this.buildBoolQuery(vo);
        if (vo.getQueryFields() != null && !vo.getQueryFields().isEmpty()) {
            this.addQuery(boolQueryBuilder, vo.getQueryFields());
        }
        if (vo.getGeoDistanceFields() != null && !vo.getGeoDistanceFields().isEmpty()) {
            this.addGeoDistanceQuery(vo.getGeoDistanceFields(), boolQueryBuilder);
        }
        if (vo.getGeoShapeFields() != null && !vo.getGeoShapeFields().isEmpty()) {
            this.addGeoShapeQuery(vo.getGeoShapeFields(), boolQueryBuilder);
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(3L, TimeUnit.SECONDS)).from(vo.getStartIndex()).size(vo.getPageSize()).explain(Boolean.valueOf(false)).fetchSource(vo.isFetchSource()).query((QueryBuilder)boolQueryBuilder);
        if (vo.getSortFields() != null && !vo.getSortFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(vo.getSortFields());
            this.addSort(vo.getSortFields(), sourceBuilder);
        }
        if (vo.getHighlightField() != null) {
            HighlightBuilder highlightBuilder = new HighlightBuilder().field(vo.getHighlightField());
            sourceBuilder.highlighter(highlightBuilder);
        }
        if (vo.getAggFields() != null && !vo.getAggFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(vo.getAggFields());
            this.addAgg(Objects.requireNonNull(vo.getAggFieldAsArray())).forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).aggregation(arg_0));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("builder={}", (Object)sourceBuilder);
        }
        SearchRequest request = new SearchRequest(new String[]{vo.getIndexName()}).source(sourceBuilder);
        if (null != vo.getRouting()) {
            request.routing(vo.getRouting());
        }
        if (vo.isFetchSource()) {
            sourceBuilder.fetchSource(vo.getIncludeFields(), vo.getExcludeFields());
            if (vo.isUseScroll()) {
                TimeValue keepAlive = this.parseTimeValue(vo.getKeepAlive());
                request.scroll(keepAlive);
            }
        }
        this.beforeSearch(vo, request, boolQueryBuilder);
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("response={}", (Object)response);
        }
        SearchResultVo result = this.wrapSearchResultVo(vo, response);
        this.afterSearch(vo, response, result);
        return result;
    }

    private void addGeoShapeQuery(List<GeoShapeFieldVo> geoShapeFields, BoolQueryBuilder boolQueryBuilder) {
        geoShapeFields.forEach(geoShapeFieldVo -> {
            if (geoShapeFieldVo.getShapeType() == null) {
                logger.warn("GeoShapeFieldVo shapeType is null!");
                return;
            }
            PointBuilder shapeBuilder = null;
            switch (geoShapeFieldVo.getShapeType()) {
                case POINT: {
                    GeoShapeFieldVo.PointType pointType = geoShapeFieldVo.getPointType();
                    shapeBuilder = new PointBuilder(pointType.getLon(), pointType.getLat());
                }
            }
            GeoShapeQueryBuilder geoShapeQueryBuilder = null;
            try {
                geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)geoShapeFieldVo.getFieldName(), shapeBuilder).relation(ShapeRelation.valueOf((String)geoShapeFieldVo.getShapeRelation().name()));
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            if (geoShapeQueryBuilder != null) {
                boolQueryBuilder.filter((QueryBuilder)geoShapeQueryBuilder);
            }
        });
    }

    private void addGeoDistanceQuery(List<GeoDistanceFieldVo> geoDistanceFields, BoolQueryBuilder boolQueryBuilder) {
        geoDistanceFields.forEach(geoDistanceFieldVo -> {
            GeoPoint geoPoint = new GeoPoint(geoDistanceFieldVo.getLat(), geoDistanceFieldVo.getLon());
            DistanceUnit distanceUnit = DistanceUnit.valueOf((String)geoDistanceFieldVo.getDistanceUnit().name());
            GeoDistanceQueryBuilder geoDistanceQueryBuilder = QueryBuilders.geoDistanceQuery((String)geoDistanceFieldVo.getFieldName()).point(geoPoint).distance(geoDistanceFieldVo.getDistance(), distanceUnit).geoDistance(GeoDistance.PLANE);
            boolQueryBuilder.filter((QueryBuilder)geoDistanceQueryBuilder);
        });
    }

    private DistanceUnit getDistanceUnit(com.dtyunxi.huieryun.opensearch.enums.DistanceUnit distanceUnit) {
        DistanceUnit unit = DistanceUnit.KILOMETERS;
        if (distanceUnit == null) {
            return unit;
        }
        switch (distanceUnit) {
            case METERS: {
                unit = DistanceUnit.METERS;
                break;
            }
            case KILOMETERS: {
                unit = DistanceUnit.KILOMETERS;
            }
        }
        return unit;
    }

    protected SearchResultVo wrapSearchResultVo(OSSearchVo vo, SearchResponse response) {
        Aggregations aggregations;
        SearchHits hits = response.getHits();
        long totalSize = this.getTotalSize(hits);
        if (totalSize == 0L) {
            return null;
        }
        SearchResultVo result = new SearchResultVo();
        result.setTotalSize(totalSize);
        result.setPageSize(vo.getPageSize());
        result.setStartIndex(vo.getStartIndex());
        if (vo.isFetchSource()) {
            result.setDocValues(this.wrapDocValue(hits));
            if (vo.isUseScroll()) {
                result.setScrollId(response.getScrollId());
            }
        }
        if (vo.getAggFields() != null && !vo.getAggFields().isEmpty() && (aggregations = response.getAggregations()) != null) {
            result.setAggResults(this.wrapAggResult(aggregations, Objects.requireNonNull(vo.getAggFieldAsArray())));
        }
        return result;
    }

    protected BoolQueryBuilder buildBoolQuery(OSSearchVo vo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (vo.getFilterFields() != null && !vo.getFilterFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(vo.getFilterFields());
            if (null != vo.getFilterFieldAsArray()) {
                this.buildQFilters(vo.getFilterFieldAsArray()).forEach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
            }
            if (null != vo.getMustNoFilterFieldAsArray()) {
                this.buildQFilters(vo.getMustNoFilterFieldAsArray()).forEach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).mustNot(arg_0));
            }
        }
        if (vo.getOrFilterFields() != null && !vo.getOrFilterFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(vo.getOrFilterFields());
            BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
            this.buildQFilters(Objects.requireNonNull(vo.getOrFilterFieldAsArray())).forEach(arg_0 -> ((BoolQueryBuilder)subBoolQueryBuilder).should(arg_0));
            boolQueryBuilder.filter((QueryBuilder)subBoolQueryBuilder);
        }
        return boolQueryBuilder;
    }

    protected void beforeSearch(OSSearchVo vo, SearchRequest searchRequest, BoolQueryBuilder boolQueryBuilder) {
    }

    protected void afterSearch(OSSearchVo vo, SearchResponse response, SearchResultVo result) {
    }

    public SearchResultVo searchWithScrollId(String scrollId, String keepAlive) {
        SearchHits hits;
        long totalSize;
        SearchResponse response;
        logger.debug("\u6e38\u6807\u7ee7\u7eed\u641c\u7d22, scrollId={},keepAlive={}", (Object)scrollId, (Object)keepAlive);
        if (StringUtils.isBlank((CharSequence)scrollId)) {
            throw new IllegalArgumentException("ElasticSearch\u6e38\u6807\u5b9e\u4f8bId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SearchScrollRequest request = new SearchScrollRequest(scrollId).scroll(this.parseTimeValue(keepAlive));
        try {
            response = this.client.scroll(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("searchWithScrollId", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("response={}", (Object)response);
        }
        if ((totalSize = this.getTotalSize(hits = response.getHits())) == 0L) {
            this.closeScrollId(scrollId);
            return null;
        }
        SearchResultVo result = new SearchResultVo();
        result.setTotalSize(totalSize);
        result.setDocValues(this.wrapDocValue(hits));
        result.setScrollId(response.getScrollId());
        return result;
    }

    protected TimeValue parseTimeValue(String keepAlive) {
        TimeValue timeValue;
        if (StringUtils.isNotBlank((CharSequence)keepAlive)) {
            Matcher m = PATTERN_TIME.matcher(keepAlive);
            if (!m.find()) {
                return TimeValue.timeValueHours((long)5L);
            }
            long time = Long.parseLong(m.group(1));
            String timeUnit = m.group(2);
            timeValue = new TimeValue(time * this.getTimeLevel(timeUnit));
        } else {
            timeValue = TimeValue.timeValueHours((long)5L);
        }
        return timeValue;
    }

    public void closeScrollId(String scrollId) {
        logger.debug("\u5173\u95ed\u6e38\u6807, scrollId={}", (Object)scrollId);
        if (StringUtils.isBlank((CharSequence)scrollId)) {
            throw new IllegalArgumentException("ElasticSearch\u6e38\u6807\u5b9e\u4f8bId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        try {
            this.client.clearScroll(request, RequestOptions.DEFAULT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected List<AggResult> wrapAggResult(Aggregations aggregations, AggFieldVo ... aggFields) {
        ArrayList<AggResult> aggResults = new ArrayList<AggResult>(aggFields.length);
        for (AggFieldVo aggField : aggFields) {
            AggResult aggResult = new AggResult();
            aggResult.setAggType(aggField.getAggType());
            aggResult.setFieldName(aggField.getFieldName());
            List<AggResultItem> aggResultItems = null;
            switch (aggField.getAggType()) {
                case TERMS: {
                    aggResultItems = this.wrapTermsAggResult(aggregations, aggField);
                    break;
                }
                case RANGE: {
                    aggResultItems = this.wrapRangAggResult(aggregations, aggField);
                    break;
                }
                case NESTED: {
                    aggResultItems = this.wrapNestedAggResult(aggregations, aggField);
                    break;
                }
                case STATS: {
                    aggResultItems = this.wrapStatsAggResult(aggregations, aggField);
                    break;
                }
                case MULTIPLE: {
                    aggResultItems = this.wrapMultipleAggResult(aggregations, aggField);
                    break;
                }
                case DATE: {
                    aggResult.setFieldName(aggField.getDateFiledName());
                    aggResultItems = this.wrapDateHistogramAggResult(aggregations, aggField);
                    break;
                }
                case TOPHITS: {
                    aggResultItems = this.wrapTopHitsAggResult(aggregations, aggField);
                }
            }
            aggResult.setAggResultItems(aggResultItems);
            aggResults.add(aggResult);
        }
        return aggResults;
    }

    protected List<AggResultItem> wrapStatsAggResult(Aggregations aggregations, AggFieldVo aggField) {
        Stats stats = (Stats)aggregations.get(aggField.getFieldName());
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>(1);
        AggResultItem aggResultItem = new AggResultItem();
        aggResultItem.setAvgValue(Double.valueOf(stats.getAvg()));
        aggResultItem.setDocCount(Long.valueOf(stats.getCount()));
        aggResultItem.setMaxValue(Double.valueOf(stats.getMax()));
        aggResultItem.setMinValue(Double.valueOf(stats.getMin()));
        aggResultItem.setSumValue(Double.valueOf(stats.getSum()));
        aggResultItems.add(aggResultItem);
        return aggResultItems;
    }

    protected List<AggResultItem> wrapMultipleAggResult(Aggregations aggregations, AggFieldVo aggField) {
        Terms termsAgg;
        try {
            termsAgg = (Terms)aggregations.get(aggField.getFieldName());
        }
        catch (Exception e) {
            return new ArrayList<AggResultItem>(0);
        }
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>(termsAgg.getBuckets().size());
        for (Terms.Bucket bucket : termsAgg.getBuckets()) {
            List<AggResult> subAggResults;
            AggResultItem aggResultItem = new AggResultItem();
            aggResultItem.setFieldValue(bucket.getKeyAsString());
            aggResultItem.setDocCount(Long.valueOf(bucket.getDocCount()));
            Terms leafAgg = (Terms)bucket.getAggregations().get(aggField.getSubFieldName());
            AggResult subAggResult = new AggResult();
            subAggResult.setFieldName(aggField.getSubFieldName());
            ArrayList<AggResultItem> leafAggResultItems = new ArrayList<AggResultItem>(leafAgg.getBuckets().size());
            for (Terms.Bucket subBucket : leafAgg.getBuckets()) {
                AggResultItem leafAggResultItem = new AggResultItem();
                leafAggResultItem.setFieldValue(subBucket.getKeyAsString());
                leafAggResultItem.setDocCount(Long.valueOf(subBucket.getDocCount()));
                leafAggResultItems.add(leafAggResultItem);
            }
            subAggResult.setAggResultItems(leafAggResultItems);
            aggResultItem.setSubAggResult(subAggResult);
            if (aggField.getSubAggFieldVos() != null && bucket.getAggregations() != null && (subAggResults = this.wrapAggResult(bucket.getAggregations(), aggField.getSubAggFieldVos().toArray(new AggFieldVo[0]))) != null && !subAggResults.isEmpty()) {
                aggResultItem.setSubAggResults(subAggResults);
            }
            aggResultItems.add(aggResultItem);
        }
        return aggResultItems;
    }

    protected List<AggResultItem> wrapNestedAggResult(Aggregations aggregations, AggFieldVo aggField) {
        InternalNested nestedAgg = (InternalNested)aggregations.get(aggField.getNestedFieldName() + "_" + aggField.getFieldName() + "_" + aggField.getSubFieldName());
        Terms subAgg = (Terms)nestedAgg.getAggregations().get(aggField.getFieldName());
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>(subAgg.getBuckets().size());
        for (Terms.Bucket bucket : subAgg.getBuckets()) {
            AggResultItem aggResultItem = new AggResultItem();
            aggResultItem.setFieldValue(bucket.getKeyAsString());
            aggResultItem.setDocCount(Long.valueOf(bucket.getDocCount()));
            Terms leafAgg = (Terms)bucket.getAggregations().get(aggField.getSubFieldName());
            AggResult subAggResult = new AggResult();
            subAggResult.setFieldName(aggField.getSubFieldName());
            ArrayList<AggResultItem> leafAggResultItems = new ArrayList<AggResultItem>(leafAgg.getBuckets().size());
            for (Terms.Bucket subBucket : leafAgg.getBuckets()) {
                AggResultItem leafAggResultItem = new AggResultItem();
                leafAggResultItem.setFieldValue(subBucket.getKeyAsString());
                leafAggResultItem.setDocCount(Long.valueOf(subBucket.getDocCount()));
                leafAggResultItems.add(leafAggResultItem);
            }
            subAggResult.setAggResultItems(leafAggResultItems);
            aggResultItem.setSubAggResult(subAggResult);
            aggResultItems.add(aggResultItem);
        }
        return aggResultItems;
    }

    protected List<AggResultItem> wrapRangAggResult(Aggregations aggregations, AggFieldVo aggField) {
        Range rang;
        try {
            rang = (Range)aggregations.get(aggField.getFieldName());
        }
        catch (Exception e) {
            return new ArrayList<AggResultItem>(0);
        }
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>(rang.getBuckets().size());
        for (Range.Bucket bucket : rang.getBuckets()) {
            List<AggResult> subAggResults;
            AggResultItem aggResultItem = new AggResultItem();
            aggResultItem.setFieldValue(this.buildRangAggKey(bucket));
            aggResultItem.setDocCount(Long.valueOf(bucket.getDocCount()));
            if (aggField.getSubAggFieldVos() != null && bucket.getAggregations() != null && (subAggResults = this.wrapAggResult(bucket.getAggregations(), aggField.getSubAggFieldVos().toArray(new AggFieldVo[0]))) != null && !subAggResults.isEmpty()) {
                aggResultItem.setSubAggResults(subAggResults);
            }
            aggResultItems.add(aggResultItem);
        }
        return aggResultItems;
    }

    protected String buildRangAggKey(Range.Bucket bucket) {
        if (!bucket.getClass().equals(InternalRange.Bucket.class)) {
            return bucket.getFromAsString();
        }
        StringBuilder sb = new StringBuilder();
        Double from = (Double)bucket.getFrom();
        sb.append(Double.isInfinite(from) ? "*" : new BigDecimal(from).toString());
        sb.append("-");
        Double to = (Double)bucket.getTo();
        sb.append(Double.isInfinite(to) ? "*" : new BigDecimal(to).toString());
        return sb.toString();
    }

    protected List<AggResultItem> wrapTopHitsAggResult(Aggregations aggregations, AggFieldVo aggField) {
        TopHits agg;
        try {
            agg = (TopHits)aggregations.get(aggField.getFieldName());
        }
        catch (Exception e) {
            return new ArrayList<AggResultItem>(0);
        }
        if (agg == null || agg.getHits() == null) {
            logger.warn("wrap topHits agg result,fieldName={}", (Object)aggField.getFieldName());
            return new ArrayList<AggResultItem>(0);
        }
        long totalSize = this.getTotalSize(agg.getHits());
        if (totalSize == 0L) {
            logger.warn("wrap topHits agg result,fieldName={}", (Object)aggField.getFieldName());
            return new ArrayList<AggResultItem>(0);
        }
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>((int)totalSize);
        for (SearchHit searchHit : agg.getHits().getHits()) {
            AggResultItem item = new AggResultItem();
            item.setFieldValue(String.valueOf(searchHit.getSourceAsMap().get(aggField.getFieldName())));
            if (aggField.isFetchSource()) {
                item.setDocValue(searchHit.getSourceAsMap());
            }
            item.setDocCount(Long.valueOf(1L));
            aggResultItems.add(item);
        }
        return aggResultItems;
    }

    protected List<AggResultItem> wrapTermsAggResult(Aggregations aggregations, AggFieldVo aggField) {
        Terms agg;
        try {
            agg = (Terms)aggregations.get(aggField.getFieldName());
        }
        catch (Exception e) {
            return new ArrayList<AggResultItem>(0);
        }
        if (agg == null || agg.getBuckets() == null || agg.getBuckets().size() == 0) {
            logger.warn("wrap terms agg result,fieldName={}", (Object)aggField.getFieldName());
            return new ArrayList<AggResultItem>(0);
        }
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>(agg.getBuckets().size());
        for (Terms.Bucket bucket : agg.getBuckets()) {
            List<AggResult> subAggResults;
            AggResultItem aggResultItem = new AggResultItem();
            aggResultItem.setFieldValue(bucket.getKeyAsString());
            aggResultItem.setDocCount(Long.valueOf(bucket.getDocCount()));
            if (aggField.getSubAggFieldVos() != null && bucket.getAggregations() != null && (subAggResults = this.wrapAggResult(bucket.getAggregations(), aggField.getSubAggFieldVos().toArray(new AggFieldVo[0]))) != null && !subAggResults.isEmpty()) {
                aggResultItem.setSubAggResults(subAggResults);
            }
            aggResultItems.add(aggResultItem);
        }
        return aggResultItems;
    }

    protected List<AggResultItem> wrapDateHistogramAggResult(Aggregations aggregations, AggFieldVo aggField) {
        ParsedDateHistogram agg;
        try {
            agg = (ParsedDateHistogram)aggregations.get(aggField.getDateFiledName());
        }
        catch (Exception e) {
            return new ArrayList<AggResultItem>(0);
        }
        if (agg == null || agg.getBuckets() == null || agg.getBuckets().size() == 0) {
            logger.warn("wrap terms agg result,fieldName={}", (Object)aggField.getDateFiledName());
            return new ArrayList<AggResultItem>(0);
        }
        ArrayList<AggResultItem> aggResultItems = new ArrayList<AggResultItem>(agg.getBuckets().size());
        for (Histogram.Bucket bucket : agg.getBuckets()) {
            List<AggResult> subAggResults;
            if (bucket.getDocCount() == 0L) continue;
            AggResultItem aggResultItem = new AggResultItem();
            aggResultItem.setFieldValue(bucket.getKeyAsString());
            aggResultItem.setDocCount(Long.valueOf(bucket.getDocCount()));
            if (aggField.getSubAggFieldVos() != null && bucket.getAggregations() != null && (subAggResults = this.wrapAggResult(bucket.getAggregations(), aggField.getSubAggFieldVos().toArray(new AggFieldVo[0]))) != null && !subAggResults.isEmpty()) {
                aggResultItem.setSubAggResults(subAggResults);
            }
            aggResultItems.add(aggResultItem);
        }
        return aggResultItems;
    }

    protected List<Map<String, Object>> wrapDocValue(SearchHits hits) {
        SearchHit[] searchHits = hits.getHits();
        ArrayList<Map<String, Object>> docValue = new ArrayList<Map<String, Object>>(searchHits.length);
        for (SearchHit searchHit : searchHits) {
            Map highlightFields = searchHit.getHighlightFields();
            Map item = searchHit.getSourceAsMap();
            if (!highlightFields.isEmpty()) {
                StringBuilder highlightFieldStringBuilder = new StringBuilder();
                for (String key : highlightFields.keySet()) {
                    for (Text text : ((HighlightField)highlightFields.get(key)).fragments()) {
                        highlightFieldStringBuilder.append(text.string());
                    }
                    item.put(key, highlightFieldStringBuilder.toString());
                }
            }
            item.put("_score", Float.valueOf(searchHit.getScore()));
            docValue.add(item);
        }
        return docValue;
    }

    protected List<AggregationBuilder> addAgg(AggFieldVo[] aggFields) {
        ArrayList<AggregationBuilder> aggregationBuilders = new ArrayList<AggregationBuilder>(aggFields.length);
        for (AggFieldVo aggField : aggFields) {
            if (aggField.isNotFoundField()) continue;
            if (aggField.getAggType().equals((Object)AggFieldVo.AggType.NESTED) && !aggField.isNestedType()) {
                aggField.setAggType(AggFieldVo.AggType.MULTIPLE);
            }
            AggregationBuilder aggBuilder = null;
            switch (aggField.getAggType()) {
                case TERMS: {
                    aggBuilder = this.buildTermsAgg(aggField);
                    break;
                }
                case RANGE: {
                    aggBuilder = this.buildRangeAgg(aggField);
                    break;
                }
                case NESTED: {
                    aggBuilder = this.buildNestedAgg(aggField);
                    break;
                }
                case STATS: {
                    aggBuilder = AggregationBuilders.stats((String)aggField.getFieldName()).field(aggField.getFieldName());
                    break;
                }
                case MULTIPLE: {
                    aggBuilder = this.buildMultipleAgg(aggField);
                    break;
                }
                case DATE: {
                    aggBuilder = this.buildDateHistogramAgg(aggField);
                    break;
                }
                case TOPHITS: {
                    aggBuilder = this.buildTopHitsAgg(aggField);
                }
            }
            if (aggBuilder == null) continue;
            if (aggField.getSubAggFieldVos() != null) {
                ArrayList<AggFieldVo> subAggFields = new ArrayList<AggFieldVo>(aggField.getSubAggFieldVos().size());
                subAggFields.add(aggField.getSubAggFieldVo());
                this.getMetaNameAndNestedFieldName(subAggFields);
                List<AggregationBuilder> subAggBuilders = this.addAgg(aggField.getSubAggFieldVos().toArray(new AggFieldVo[0]));
                if (subAggBuilders != null && !subAggBuilders.isEmpty()) {
                    for (AggregationBuilder subAggBuilder : subAggBuilders) {
                        aggBuilder.subAggregation(subAggBuilder);
                    }
                }
            }
            aggregationBuilders.add(aggBuilder);
        }
        return aggregationBuilders;
    }

    protected AggregationBuilder buildTopHitsAgg(AggFieldVo aggField) {
        if (aggField.isFetchSource()) {
            return AggregationBuilders.topHits((String)aggField.getFieldName()).sort(aggField.getFieldMetaName(), SortOrder.valueOf((String)aggField.getOrder().name())).size(aggField.getSize()).fetchSource(aggField.getIncludeFields(), aggField.getExcludeFields());
        }
        return AggregationBuilders.topHits((String)aggField.getFieldName()).sort(aggField.getFieldMetaName(), SortOrder.valueOf((String)aggField.getOrder().name())).size(aggField.getSize()).fetchSource(aggField.getFieldMetaName(), null);
    }

    protected AggregationBuilder buildDateHistogramAgg(AggFieldVo aggField) {
        DateHistogramAggregationBuilder dateAgg = AggregationBuilders.dateHistogram((String)aggField.getDateFiledName());
        dateAgg.field(aggField.getFieldMetaName());
        dateAgg.dateHistogramInterval(new DateHistogramInterval(aggField.getDateIntervalExpression()));
        dateAgg.format(aggField.getDataFormate());
        String timeZoneStr = this.openSearchVo.getTimeZone();
        if (StringUtils.isNotBlank((CharSequence)timeZoneStr)) {
            this.setTimeZone(dateAgg, timeZoneStr);
        }
        return dateAgg;
    }

    protected AggregationBuilder buildMultipleAgg(AggFieldVo aggField) {
        TermsAggregationBuilder teamAgg2 = (TermsAggregationBuilder)AggregationBuilders.terms((String)aggField.getFieldName()).field(aggField.getFieldMetaName());
        teamAgg2.size(aggField.getSize());
        teamAgg2.collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST);
        if (aggField.getSize() < 1000) {
            teamAgg2.executionHint("map");
        }
        TermsAggregationBuilder subTermAgg2 = (TermsAggregationBuilder)AggregationBuilders.terms((String)aggField.getSubFieldName()).field(aggField.getSubFieldMetaName());
        subTermAgg2.size(aggField.getSize());
        subTermAgg2.collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST);
        if (aggField.getSize() < 1000) {
            subTermAgg2.executionHint("map");
        }
        teamAgg2.subAggregation((AggregationBuilder)subTermAgg2);
        return teamAgg2;
    }

    protected AggregationBuilder buildNestedAgg(AggFieldVo aggField) {
        NestedAggregationBuilder nestedAgg = AggregationBuilders.nested((String)(aggField.getNestedFieldName() + "_" + aggField.getFieldName() + "_" + aggField.getSubFieldName()), (String)aggField.getNestedFieldName());
        TermsAggregationBuilder subTermAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)aggField.getFieldName()).field(aggField.getFieldMetaName());
        subTermAgg.size(aggField.getSize());
        subTermAgg.collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST);
        if (aggField.getSize() < 1000) {
            subTermAgg.executionHint("map");
        }
        TermsAggregationBuilder leafTermAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)aggField.getSubFieldName()).field(aggField.getSubFieldMetaName());
        leafTermAgg.size(aggField.getSize());
        leafTermAgg.collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST);
        if (aggField.getSize() < 1000) {
            leafTermAgg.executionHint("map");
        }
        subTermAgg.subAggregation((AggregationBuilder)leafTermAgg);
        nestedAgg.subAggregation((AggregationBuilder)subTermAgg);
        return nestedAgg;
    }

    protected AggregationBuilder buildRangeAgg(AggFieldVo aggField) {
        RangeAggregationBuilder rangAgg = AggregationBuilders.range((String)aggField.getFieldName());
        rangAgg.field(aggField.getFieldMetaName());
        for (int i = 0; i < aggField.getRangs().length; ++i) {
            RangeVo range = aggField.getRangs()[i];
            rangAgg.addRange(range.getFromValue(), range.getToValue());
        }
        return rangAgg;
    }

    protected AggregationBuilder buildTermsAgg(AggFieldVo aggField) {
        TermsAggregationBuilder teamAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)aggField.getFieldName()).field(aggField.getFieldMetaName());
        teamAgg.size(aggField.getSize());
        teamAgg.collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST);
        if (aggField.getSize() < 1000) {
            teamAgg.executionHint("map");
        }
        return teamAgg;
    }

    protected void addSort(List<SortFieldVo> sortFields, SearchSourceBuilder builder) {
        for (SortFieldVo sortFiled : sortFields) {
            if (sortFiled.isNotFoundField()) continue;
            if (sortFiled.isGeoDistanceSort()) {
                DistanceUnit distanceUnit = DistanceUnit.valueOf((String)sortFiled.getDistanceUnit().name());
                builder.sort((SortBuilder)((GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)sortFiled.getFieldMetaName(), (double)sortFiled.getLat(), (double)sortFiled.getLon()).unit(distanceUnit).order(SortOrder.valueOf((String)sortFiled.getOrder().name()))).geoDistance(GeoDistance.PLANE));
                continue;
            }
            if (sortFiled.getFieldMetaName() != null) {
                FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)sortFiled.getFieldMetaName()).order(SortOrder.valueOf((String)sortFiled.getOrder().name()));
                if (sortFiled.isNestedType()) {
                    NestedSortBuilder nestedSort = new NestedSortBuilder(sortFiled.getNestedFieldName());
                    fieldSortBuilder.setNestedSort(nestedSort);
                }
                builder.sort((SortBuilder)fieldSortBuilder);
                continue;
            }
            builder.sort(sortFiled.getFieldName(), SortOrder.valueOf((String)sortFiled.getOrder().name()));
        }
    }

    protected void addQuery(BoolQueryBuilder boolQueryBuilder, List<QueryFieldVo> queryFields) {
        for (QueryFieldVo queryField : queryFields) {
            if (queryField.getQueryFields().length > 1) {
                BoolQueryBuilder subBoolQueryBuilder = QueryBuilders.boolQuery();
                for (String queryFieldName : queryField.getQueryFields()) {
                    MatchQueryBuilder matchQuery = this.genMatchQuery(queryFieldName, queryField.getKeyWord(), queryField.getBoost(), queryField.isEscape());
                    matchQuery.cutoffFrequency(1.0f);
                    matchQuery.operator(Operator.AND);
                    matchQuery.fuzzyTranspositions(false);
                    subBoolQueryBuilder.should((QueryBuilder)matchQuery);
                }
                if (queryField.getLogicalSymbol().equals((Object)LogicalSymbol.AND)) {
                    boolQueryBuilder.must((QueryBuilder)subBoolQueryBuilder);
                    continue;
                }
                boolQueryBuilder.should((QueryBuilder)subBoolQueryBuilder);
                continue;
            }
            MatchQueryBuilder matchQuery = this.genMatchQuery(queryField.getQueryFields()[0], queryField.getKeyWord(), queryField.getBoost(), queryField.isEscape());
            matchQuery.cutoffFrequency(1.0f);
            matchQuery.operator(Operator.AND);
            matchQuery.fuzzyTranspositions(false);
            if (queryField.getLogicalSymbol().equals((Object)LogicalSymbol.AND)) {
                boolQueryBuilder.must((QueryBuilder)matchQuery);
                continue;
            }
            boolQueryBuilder.should((QueryBuilder)matchQuery);
        }
    }

    protected MatchQueryBuilder genMatchQuery(String queryFieldName, String keyWord, float boots, boolean escape) {
        if (escape) {
            return (MatchQueryBuilder)QueryBuilders.matchQuery((String)queryFieldName, (Object)QueryParser.escape((String)keyWord)).boost(boots);
        }
        return (MatchQueryBuilder)QueryBuilders.matchQuery((String)queryFieldName, (Object)keyWord).boost(boots);
    }

    protected List<QueryBuilder> buildQFilters(FilterFieldVo[] filterFields) {
        ArrayList<QueryBuilder> filters = new ArrayList<QueryBuilder>(filterFields.length);
        HashMap<String, QueryBuilder> nestedQueries = new HashMap<String, QueryBuilder>();
        for (FilterFieldVo filterField : filterFields) {
            if (filterField.isNotFoundField() && !filterField.getFilterType().equals((Object)FilterFieldVo.FilterType.COMPOUND)) continue;
            QueryBuilder queryBuilder = null;
            switch (filterField.getFilterType()) {
                case EXISTS: {
                    ExistsQueryBuilder subQuery = QueryBuilders.existsQuery((String)filterField.getFieldMetaName());
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)subQuery);
                    break;
                }
                case TERM: {
                    ExistsQueryBuilder subQuery = QueryBuilders.termQuery((String)filterField.getFieldMetaName(), (String)filterField.getEqualValue());
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)subQuery);
                    break;
                }
                case TERMS: {
                    ExistsQueryBuilder subQuery = QueryBuilders.termsQuery((String)filterField.getFieldMetaName(), (String[])filterField.getInValues());
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)subQuery);
                    break;
                }
                case RANGE: {
                    RangeQueryBuilder rq = QueryBuilders.rangeQuery((String)filterField.getFieldMetaName());
                    if (StringUtils.isNotEmpty((CharSequence)filterField.getFromValue())) {
                        rq.from((Object)filterField.getFromValue());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)filterField.getToValue())) {
                        rq.to((Object)filterField.getToValue());
                    }
                    String fieldType = this.getFieldType(filterField.getFieldName());
                    String timeZoneStr = this.openSearchVo.getTimeZone();
                    if (StringUtils.isNotBlank((CharSequence)timeZoneStr) && fieldType != null && fieldType.equalsIgnoreCase("date")) {
                        rq.timeZone(timeZoneStr);
                    }
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)rq);
                    break;
                }
                case REGEXP: {
                    ExistsQueryBuilder subQuery = QueryBuilders.regexpQuery((String)filterField.getFieldMetaName(), (String)filterField.getEqualValue());
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)subQuery);
                    break;
                }
                case WILDCARD: {
                    ExistsQueryBuilder subQuery = QueryBuilders.wildcardQuery((String)filterField.getFieldMetaName(), (String)filterField.getEqualValue());
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)subQuery);
                    break;
                }
                case PREFIX: {
                    ExistsQueryBuilder subQuery = QueryBuilders.prefixQuery((String)filterField.getFieldMetaName(), (String)filterField.getEqualValue());
                    queryBuilder = this.addFilterQuery(filters, nestedQueries, filterField, (QueryBuilder)subQuery);
                }
            }
            if (queryBuilder != null) {
                filters.add(queryBuilder);
            }
            if (filterField.getSubFilterFields() == null && filterField.getSubOrFilterFields() == null) continue;
            filters.add(this.buildSubFilters(filterField));
        }
        return filters;
    }

    private QueryBuilder addFilterQuery(List<QueryBuilder> filters, Map<String, QueryBuilder> nestedQueries, FilterFieldVo filterField, QueryBuilder subQuery) {
        QueryBuilder queryBuilder;
        if (filterField.isNestedType()) {
            if (nestedQueries.containsKey(filterField.getNestedFieldName())) {
                queryBuilder = nestedQueries.get(filterField.getNestedFieldName());
                filters.remove(queryBuilder);
                queryBuilder = ((NestedQueryBuilder)queryBuilder).query();
                if (queryBuilder.getClass().equals(BoolQueryBuilder.class)) {
                    ((BoolQueryBuilder)queryBuilder).must(subQuery);
                } else {
                    BoolQueryBuilder boolFilter = QueryBuilders.boolQuery();
                    boolFilter.must(subQuery);
                    boolFilter.must(queryBuilder);
                    queryBuilder = boolFilter;
                }
                queryBuilder = QueryBuilders.nestedQuery((String)filterField.getNestedFieldName(), (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.None);
            } else {
                queryBuilder = QueryBuilders.nestedQuery((String)filterField.getNestedFieldName(), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None);
            }
            nestedQueries.put(filterField.getNestedFieldName(), queryBuilder);
        } else {
            queryBuilder = subQuery;
        }
        return queryBuilder;
    }

    protected QueryBuilder buildSubFilters(FilterFieldVo filterField) {
        List<QueryBuilder> subFilters = null;
        List<QueryBuilder> subOrFilters = null;
        if (filterField.getSubFilterFields() != null && !filterField.getSubFilterFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(filterField.getSubFilterFields());
            subFilters = this.buildQFilters(Objects.requireNonNull(filterField.getSubFilterFieldAsArray()));
        }
        if (filterField.getSubOrFilterFields() != null && !filterField.getSubOrFilterFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(filterField.getSubOrFilterFields());
            subOrFilters = this.buildQFilters(Objects.requireNonNull(filterField.getSubOrFilterFieldAsArray()));
        }
        BoolQueryBuilder boolFilter = QueryBuilders.boolQuery();
        if (subFilters != null) {
            subFilters.forEach(arg_0 -> ((BoolQueryBuilder)boolFilter).filter(arg_0));
        }
        if (subOrFilters != null) {
            BoolQueryBuilder subBoolFilter = QueryBuilders.boolQuery();
            subOrFilters.forEach(arg_0 -> ((BoolQueryBuilder)subBoolFilter).should(arg_0));
            boolFilter.filter((QueryBuilder)subBoolFilter);
        }
        return boolFilter;
    }

    protected Map<String, Object> getIndexMapping(String indexName, String typeName) {
        Map mapping;
        GetMappingsResponse response;
        String actualIndexName = indexName;
        String[] indices = this.getIndexNames(indexName);
        if (indices != null && indices.length > 0) {
            actualIndexName = indices[0];
        }
        try {
            GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{actualIndexName});
            response = this.client.indices().getMapping(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("prepareIndexMapping", e);
        }
        try {
            mapping = ((MappingMetaData)response.mappings().get(actualIndexName)).getSourceAsMap();
        }
        catch (Exception e) {
            String message = String.format("Get Mappings Properties Failure,indexName=%s,typeName=%s", indexName, typeName);
            logger.error(message, (Throwable)e);
            throw new BusinessRuntimeException(message);
        }
        return mapping;
    }

    private String[] getIndexNames(String aliases) {
        try {
            return this.client.indices().get(new GetIndexRequest(new String[]{aliases}), RequestOptions.DEFAULT).getIndices();
        }
        catch (IOException e) {
            throw new RuntimeException("getIndexNames", e);
        }
    }

    public void closeSearchClient() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("closeSearchClient", e);
        }
    }

    public List<SuggestResultVo> searchSuggest(SearchSuggestVo vo) {
        SearchResponse searchResponse;
        if (StringUtils.isBlank((CharSequence)vo.getIndexName()) || StringUtils.isBlank((CharSequence)vo.getFieldName()) || StringUtils.isBlank((CharSequence)vo.getKeyWord())) {
            String message = String.format("ES searchSuggest \u641c\u7d22\u6570\u636e\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5\uff1aindexName=%s,typeName=%s,fieldName=%s,keyWord=%s", vo.getIndexName(), vo.getTypeName(), vo.getFieldName(), vo.getKeyWord());
            logger.error(message);
            throw new BusinessRuntimeException(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ES searchSuggest \u641c\u7d22\u6570\u636e\u4f20\u5165\u53c2\u6570\uff1aindexName={},typeName={},fieldName={},keyWord={}", new Object[]{vo.getIndexName(), vo.getTypeName(), vo.getFieldName(), vo.getKeyWord()});
        }
        SuggestionBuilder suggestion = null;
        switch (vo.getSuggestType()) {
            case COMPLETION: {
                suggestion = SuggestBuilders.completionSuggestion((String)vo.getFieldName()).prefix(vo.getKeyWord()).size(vo.getPageSize());
                break;
            }
            case PHRASE: {
                suggestion = ((PhraseSuggestionBuilder)SuggestBuilders.phraseSuggestion((String)vo.getFieldName()).text(vo.getKeyWord())).size(vo.getPageSize());
                break;
            }
            case TERM: {
                suggestion = ((TermSuggestionBuilder)SuggestBuilders.termSuggestion((String)vo.getFieldName()).text(vo.getKeyWord())).size(vo.getPageSize());
            }
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion(vo.getFieldName(), suggestion);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().suggest(suggestBuilder).fetchSource(false);
        SearchRequest request = new SearchRequest(new String[]{vo.getIndexName()}).source(sourceBuilder);
        if (null != vo.getRouting()) {
            request.routing(vo.getRouting());
        }
        try {
            searchResponse = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("searchSuggest", e);
        }
        Suggest suggest = searchResponse.getSuggest();
        List list = suggest.getSuggestion(vo.getFieldName()).getEntries();
        if (list == null) {
            return null;
        }
        return this.wrapSuggestionResult(list);
    }

    protected List<SuggestResultVo> wrapSuggestionResult(List<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> list) {
        ArrayList<SuggestResultVo> suggestResults = new ArrayList<SuggestResultVo>(list.size());
        for (Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option> entry : list) {
            for (Suggest.Suggestion.Entry.Option option : entry) {
                SuggestResultVo vo = new SuggestResultVo();
                vo.setKeyword(option.getText().string());
                suggestResults.add(vo);
            }
        }
        return suggestResults;
    }

    public long getTotalSize(SearchHits hits) {
        return hits.totalHits;
    }

    public void setTimeZone(DateHistogramAggregationBuilder dateAgg, String timeZoneStr) {
        DateTimeZone timeZone = new DateTimeZoneBuilder().toDateTimeZone(timeZoneStr, true);
        dateAgg.timeZone(timeZone);
    }
}

