/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.vo;

import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.CommonFiledVo;
import com.dtyunxi.huieryun.opensearch.vo.RangeVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="AggFieldVo", description="\u805a\u5408\u5b57\u6bb5")
public class AggFieldVo
extends CommonFiledVo {
    protected static final String AGG_FIELD_NAME_NOT_NULL_TIP = "\u805a\u5408\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    @ApiModelProperty(value="\u805a\u5408\u7c7b\u578b")
    protected AggType aggType;
    @ApiModelProperty(value="\u805a\u5408\u533a\u95f4")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected RangeVo[] rangs;
    @ApiModelProperty(value="\u805a\u5408\u4e2a\u6570")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected int rangeColumeCount;
    @ApiModelProperty(value="\u805a\u5408\u8303\u56f4\u4e0b\u9650")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected double minValue;
    @ApiModelProperty(value="\u805a\u5408\u8303\u56f4\u4e0a\u9650")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected double maxValue;
    @ApiModelProperty(value="\u5b50\u805a\u5408\u51fd\u6570")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<AggFieldVo> subAggFieldVos;
    @ApiModelProperty(value="\u65e5\u671f\u7c7b\u578b\u7edf\u8ba1\u533a\u95f4\u8868\u8fbe\u5f0f\uff0c\u4f8b\u59821s,1m,1h,1d,1M,1Y\u7b49\u7b49")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String dateIntervalExpression;
    @ApiModelProperty(value="\u5b57\u6bb5\u503c\u65e5\u671f\u663e\u793a\u683c\u5f0f")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String dataFormate;
    @ApiModelProperty(value="\u805a\u5408\u7ed3\u6784\u96c6\u5927\u5c0f")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected int size = 10000;
    @ApiModelProperty(value="\u6392\u5e8f\u65b9\u5f0f")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected SortOrder order;
    @ApiModelProperty(value="\u67e5\u8be2\u9700\u8981\u8fd4\u56de\u5b57\u6bb5\u5217\u8868", dataType="String[]", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String[] includeFields;
    @ApiModelProperty(value="\u67e5\u8be2\u4e0d\u9700\u8981\u8fd4\u56de\u5b57\u6bb5\u5217\u8868", dataType="String[]", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String[] excludeFields;
    @ApiModelProperty(value="\u662f\u5426\u6293\u53d6\u6e90\u6570\u636e", dataType="boolean", required=false)
    protected boolean fetchSource = false;

    protected AggFieldVo(AggType aggType, String fieldName) {
        this.fieldName = fieldName;
        this.aggType = aggType;
    }

    protected AggFieldVo(String fieldName, String dateIntervalExpression, String dataFormate) {
        this.aggType = AggType.DATE;
        this.fieldName = fieldName;
        this.dateIntervalExpression = dateIntervalExpression;
        this.dataFormate = dataFormate;
    }

    protected AggFieldVo(String fieldName, String subFieldName) {
        this.aggType = AggType.NESTED;
        this.fieldName = fieldName;
        this.subFieldName = subFieldName;
    }

    protected AggFieldVo(RangeVo[] rangs, String fieldName) {
        this.aggType = AggType.RANGE;
        this.rangs = rangs;
        this.fieldName = fieldName;
    }

    protected AggFieldVo(String fieldName, int size, SortOrder order) {
        this.fieldName = fieldName;
        this.size = size;
        this.order = order;
        this.aggType = AggType.TOPHITS;
    }

    protected AggFieldVo(String fieldName, int size, SortOrder order, String[] includeFields, String[] excludeFields, boolean fetchSource) {
        this.fieldName = fieldName;
        this.size = size;
        this.order = order;
        this.includeFields = includeFields;
        this.excludeFields = excludeFields;
        this.fetchSource = fetchSource;
        this.aggType = AggType.TOPHITS;
    }

    @ApiOperation(value="\u6784\u5efa\u6309\u5b57\u6bb5\u503c\u8fdb\u884c\u53bb\u91cd\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public static final AggFieldVo terms(String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(AggType.TERMS, fieldName);
    }

    @ApiOperation(value="\u6784\u5efa\u7edf\u8ba1\u805a\u5408\u51fd\u6570--\u6c42\u6700\u5927\u503c\u3001\u6700\u5c0f\u503c\u3001\u603b\u6570\u91cf\u3001\u5e73\u5747\u503c\u3001\u6c42\u548c", response=AggFieldVo.class)
    public static final AggFieldVo stat(String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(AggType.STATS, fieldName);
    }

    @ApiOperation(value="\u6784\u5efa\u6307\u5b9a\u533a\u95f4\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="rangs", value="\u805a\u5408\u533a\u95f4", dataType="RangeVo", required=true), @ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public static final AggFieldVo range(RangeVo[] rangs, String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        if (rangs == null || rangs.length == 0) {
            throw new BusinessRuntimeException(String.format("\u805a\u5408\u7ed3\u679c\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e\u96f6\uff01\u5b57\u6bb5\u540d\uff1a%s", fieldName));
        }
        return new AggFieldVo(rangs, fieldName);
    }

    @ApiOperation(value="\u6784\u5efa\u6309\u7167\u4e24\u7ea7\u65b9\u5f0f\u8fdb\u884c\u5d4c\u5957\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="subFieldName", value="\u5d4c\u5957\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public static final AggFieldVo nested(String fieldName, String subFieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName) || StringUtils.isEmpty((CharSequence)subFieldName)) {
            throw new BusinessRuntimeException("\u805a\u5408\u5b57\u6bb5\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return new AggFieldVo(fieldName, subFieldName);
    }

    @ApiOperation(value="\u6309\u65e5\u671f\u7c7b\u578b\u8fdb\u884c\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="dateIntervalExpression", value="\u65e5\u671f\u7c7b\u578b\u7edf\u8ba1\u533a\u95f4\u8868\u8fbe\u5f0f", dataType="String", required=true), @ApiImplicitParam(name="dataFormate", value="\u5b57\u6bb5\u503c\u65e5\u671f\u663e\u793a\u683c\u5f0f", dataType="String", required=true)})
    public static final AggFieldVo dateHistogram(String fieldName, String dateIntervalExpression, String dataFormate) {
        if (StringUtils.isEmpty((CharSequence)fieldName) || StringUtils.isEmpty((CharSequence)dateIntervalExpression) || StringUtils.isEmpty((CharSequence)dataFormate)) {
            throw new BusinessRuntimeException("\u65e5\u671f\u805a\u5408\u5b57\u6bb5\u76f8\u5173\u5b57\u6bb5\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return new AggFieldVo(fieldName, dateIntervalExpression, dataFormate);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public static final AggFieldVo topHits(String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, 1, SortOrder.DESC);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fetchSource", value="\u662f\u5426\u6293\u53d6\u6574\u4e2a\u6587\u6863\u6e90\u6570\u636e", dataType="fetchSource", required=true)})
    public static final AggFieldVo topHits(String fieldName, boolean fetchSource) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, 1, SortOrder.DESC, null, null, fetchSource);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true)})
    public static final AggFieldVo topHits(String fieldName, int size, SortOrder order) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, size, order);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true), @ApiImplicitParam(name="fetchSource", value="\u662f\u5426\u6293\u53d6\u6574\u4e2a\u6587\u6863\u6e90\u6570\u636e", dataType="fetchSource", required=true)})
    public static final AggFieldVo topHits(String fieldName, int size, SortOrder order, boolean fetchSource) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, size, order, null, null, fetchSource);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true), @ApiImplicitParam(name="includeFields", value="\u6293\u53d6\u5b57\u6bb5", dataType="String[]", required=false)})
    public static final AggFieldVo topHitsWithInclude(String fieldName, int size, SortOrder order, String[] includeFields) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, size, order, includeFields, null, true);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true), @ApiImplicitParam(name="excludeFields", value="\u4e0d\u6293\u53d6\u5b57\u6bb5", dataType="String[]", required=false)})
    public static final AggFieldVo topHitsWithExclude(String fieldName, int size, SortOrder order, String[] excludeFields) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, size, order, null, excludeFields, true);
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=AggFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true), @ApiImplicitParam(name="includeFields", value="\u6293\u53d6\u5b57\u6bb5", dataType="String[]", required=false), @ApiImplicitParam(name="excludeFields", value="\u4e0d\u6293\u53d6\u5b57\u6bb5", dataType="String[]", required=false), @ApiImplicitParam(name="fetchSource", value="\u662f\u5426\u6293\u53d6\u6574\u4e2a\u6587\u6863\u6e90\u6570\u636e", dataType="fetchSource", required=true)})
    public static final AggFieldVo topHits(String fieldName, int size, SortOrder order, String[] includeFields, String[] excludeFields, boolean fetchSource) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(AGG_FIELD_NAME_NOT_NULL_TIP);
        }
        return new AggFieldVo(fieldName, size, order, includeFields, excludeFields, fetchSource);
    }

    public final AggType getAggType() {
        return this.aggType;
    }

    public final void setAggType(AggType aggType) {
        this.aggType = aggType;
    }

    public final RangeVo[] getRangs() {
        return this.rangs;
    }

    public final void setRangs(RangeVo[] rangs) {
        this.rangs = rangs;
    }

    public final int getRangeColumeCount() {
        return this.rangeColumeCount;
    }

    public final void setRangeColumeCount(int rangeColumeCount) {
        this.rangeColumeCount = rangeColumeCount;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public final AggFieldVo getSubAggFieldVo() {
        if (this.subAggFieldVos != null && this.subAggFieldVos.size() > 0) {
            return this.subAggFieldVos.get(0);
        }
        return null;
    }

    public final void setSubAggFieldVo(AggFieldVo subAggFieldVo) {
        if (this.aggType.equals((Object)AggType.MULTIPLE) || this.aggType.equals((Object)AggType.STATS) || this.aggType.equals((Object)AggType.NESTED)) {
            throw new BusinessRuntimeException("\u7236\u7ea7\u805a\u5408\u51fd\u6570\u5fc5\u987b\u4e3a\u6309\u5b57\u6bb5/\u65e5\u671f/\u671f\u95f4\u805a\u5408");
        }
        if (this.subAggFieldVos == null) {
            this.subAggFieldVos = new ArrayList<AggFieldVo>(5);
        }
        this.subAggFieldVos.add(subAggFieldVo);
    }

    public final void addSubAggFieldVo(AggFieldVo subAggFieldVo) {
        if (this.aggType.equals((Object)AggType.MULTIPLE) || this.aggType.equals((Object)AggType.STATS) || this.aggType.equals((Object)AggType.NESTED)) {
            throw new BusinessRuntimeException("\u7236\u7ea7\u805a\u5408\u51fd\u6570\u5fc5\u987b\u4e3a\u6309\u5b57\u6bb5/\u65e5\u671f/\u671f\u95f4\u805a\u5408");
        }
        if (this.subAggFieldVos == null) {
            this.subAggFieldVos = new ArrayList<AggFieldVo>(5);
        }
        this.subAggFieldVos.add(subAggFieldVo);
    }

    public List<AggFieldVo> getSubAggFieldVos() {
        return this.subAggFieldVos;
    }

    public void setSubAggFieldVos(List<AggFieldVo> subAggFieldVos) {
        if (!this.aggType.equals((Object)AggType.TERMS)) {
            throw new BusinessRuntimeException("\u7236\u7ea7\u805a\u5408\u51fd\u6570\u5fc5\u987b\u4e3a\u6309\u5b57\u6bb5\u805a\u5408");
        }
        this.subAggFieldVos = subAggFieldVos;
    }

    public String getDateIntervalExpression() {
        return this.dateIntervalExpression;
    }

    public String getDataFormate() {
        return this.dataFormate;
    }

    public String getDateFiledName() {
        return this.fieldName + this.dateIntervalExpression;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public String[] getIncludeFields() {
        return this.includeFields;
    }

    public String[] getExcludeFields() {
        return this.excludeFields;
    }

    public boolean isFetchSource() {
        return this.fetchSource;
    }

    @ApiModel(value="AggType", description="\u805a\u5408\u7c7b\u578b\u679a\u4e3e\u7c7b")
    public static enum AggType {
        TERMS,
        RANGE,
        NESTED,
        STATS,
        MULTIPLE,
        DATE,
        TOPHITS;

    }
}

