/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.vo;

import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchConditionVo
extends BaseVo {
    protected static final long serialVersionUID = -3699492508527928233L;
    protected static final Logger logger = LoggerFactory.getLogger(SearchConditionVo.class);
    protected static final String DATA_INVALID = "\u4e0a\u4f20\u6570\u636e\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5\uff1aindexName=%s typeName=%s";
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u540d\u79f0")
    protected String indexName;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u7c7b\u578b\u540d\u79f0")
    protected String typeName;
    @ApiModelProperty(value="\u7d22\u5f15UUID\u96c6\u5408==_id")
    protected String[] ids;
    @ApiModelProperty(value="\u8def\u7531\u952e")
    protected String routing;
    @ApiModelProperty(value="\u8fc7\u6ee4\u5b57\u6bb5\u5217\u8868", dataType="List<FilterField>", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<FilterFieldVo> filterFields;

    public SearchConditionVo(String indexName, String typeName) {
        this.indexName = indexName;
        this.typeName = typeName;
    }

    @ApiOperation(value="\u6dfb\u52a0\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addEqualFilter(String fieldName, String equalValue) {
        this.initFilterFields();
        this.filterFields.add(FilterFieldVo.equal(fieldName, equalValue, LogicalSymbol.AND));
    }

    protected final void initFilterFields() {
        if (this.filterFields == null) {
            this.filterFields = new ArrayList<FilterFieldVo>(2);
        }
    }

    public final List<FilterFieldVo> getFilterFields() {
        return this.filterFields;
    }

    public void setFilterFields(List<FilterFieldVo> filterFields) {
        this.filterFields = filterFields;
    }

    public final String getIndexName() {
        return this.indexName;
    }

    public final void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public final String[] getIds() {
        return this.ids;
    }

    public final void setIds(String[] ids) {
        this.ids = ids;
    }

    public final String getRouting() {
        return this.routing;
    }

    public final void setRouting(String routing) {
        this.routing = routing;
    }

    public final void validate() {
        if (StringUtils.isBlank((CharSequence)this.indexName) || StringUtils.isBlank((CharSequence)this.typeName)) {
            this.throwErrorTip();
        }
        if (!(this.ids != null && this.ids.length != 0 || this.filterFields != null && !this.filterFields.isEmpty())) {
            this.throwErrorTip();
        }
    }

    protected final void throwErrorTip() {
        String message = String.format(DATA_INVALID, this.indexName, this.typeName);
        logger.error(message);
        throw new BusinessRuntimeException(message);
    }
}

