/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.vo;

import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.vo.CommonFiledVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ApiModel(value="FilterFieldVo", description="\u8fc7\u6ee4\u5b57\u6bb5\u7c7b")
public class FilterFieldVo
extends CommonFiledVo {
    protected static final String FILTER_VALUE_NOT_NULL_TIP = "\u8fc7\u6ee4\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5b57\u6bb5\u540d\uff1a%s";
    protected static final String FILTER_FIELD_NAME_NOT_NULL_TIP = "\u8fc7\u6ee4\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    @ApiModelProperty(value="\u5b57\u6bb5\u503c\uff08\u7b49\u4e8e\uff09")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String equalValue;
    @ApiModelProperty(value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff0c\u591a\u503c\u4efb\u610f\u5339\u914d\uff09")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String[] inValues;
    @ApiModelProperty(value="\u5b57\u6bb5\u503c\uff08\u5927\u4e8e\u6216\u7b49\u4e8e\uff09")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String fromValue;
    @ApiModelProperty(value="\u5b57\u6bb5\u503c\uff08\u5c0f\u4e8e\uff09")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String toValue;
    @ApiModelProperty(value="\u903b\u8f91\u64cd\u4f5c\u7b26", dataType="LogicalSymbol")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected LogicalSymbol logicalSymbol = LogicalSymbol.AND;
    @ApiModelProperty(value="\u8fc7\u6ee4\u7c7b\u578b", dataType="FilterType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected FilterType filterType;
    @ApiModelProperty(value="\u5b50\u8fc7\u6ee4\u6761\u4ef6(\u4e0e\u7ec4\u5408)", dataType="List")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<FilterFieldVo> subFilterFields;
    @ApiModelProperty(value="\u5b50\u8fc7\u6ee4\u6761\u4ef6(\u6216\u7ec4\u5408)", dataType="List")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<FilterFieldVo> subOrFilterFields;
    @ApiModelProperty(value="\u903b\u8f91\u975e\u64cd\u4f5c\u7b26", dataType="Boolean")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Boolean non;

    protected FilterFieldVo() {
    }

    @ApiOperation(value="\u6dfb\u52a0\u5b57\u6bb5\u503c\u4e0d\u4e3a\u7a7a\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public static final FilterFieldVo exists(String fieldName) {
        return FilterFieldVo.exists(fieldName, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5b57\u6bb5\u503c\u4e0d\u4e3a\u7a7a\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u903b\u8f91\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo exists(String fieldName, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.filterType = FilterType.EXISTS;
        return filter;
    }

    @ApiOperation(value="\u6784\u5efa\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public static final FilterFieldVo equal(String fieldName, String equalValue) {
        return FilterFieldVo.equal(fieldName, equalValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo equal(String fieldName, String equalValue, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (StringUtils.isBlank((CharSequence)equalValue)) {
            throw new BusinessRuntimeException(String.format(FILTER_VALUE_NOT_NULL_TIP, fieldName));
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.equalValue = equalValue;
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.TERM;
        return filter;
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="String", required=true)})
    public static final FilterFieldVo in(String fieldName, String[] inValues) {
        return FilterFieldVo.in(fieldName, inValues, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="List<String>", required=true)})
    public static final FilterFieldVo in(String fieldName, List<String> inValues) {
        return FilterFieldVo.in(fieldName, inValues, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="List<String>", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u903b\u8f91\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo in(String fieldName, List<String> inValues, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (inValues == null || inValues.isEmpty()) {
            throw new BusinessRuntimeException(String.format(FILTER_VALUE_NOT_NULL_TIP, fieldName));
        }
        return FilterFieldVo.in(fieldName, inValues.toArray(new String[inValues.size()]), logicalSymbol);
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u903b\u8f91\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo in(String fieldName, String[] inValues, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (inValues == null || inValues.length == 0) {
            throw new BusinessRuntimeException(String.format(FILTER_VALUE_NOT_NULL_TIP, fieldName));
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.inValues = inValues;
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.TERMS;
        return filter;
    }

    @ApiOperation(value="\u6dfb\u52a0\u533a\u95f4\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fromValue", value="\u5b57\u6bb5\u503c\uff08\u5927\u4e8e\u7b49\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="toValue", value="\u5b57\u6bb5\u503c\uff08\u5c0f\u4e8e\uff09", dataType="String", required=true)})
    public static final FilterFieldVo range(String fieldName, String fromValue, String toValue) {
        return FilterFieldVo.range(fieldName, fromValue, toValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u533a\u95f4\u8fc7\u6ee4\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fromValue", value="\u5b57\u6bb5\u503c\uff08\u5927\u4e8e\u7b49\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="toValue", value="\u5b57\u6bb5\u503c\uff08\u5c0f\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u903b\u8f91\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo range(String fieldName, String fromValue, String toValue, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (StringUtils.isBlank((CharSequence)fromValue) && StringUtils.isEmpty((CharSequence)toValue)) {
            throw new BusinessRuntimeException(String.format("\u8fc7\u6ee4\u5b57\u6bb5\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff01\u5b57\u6bb5\u540d\uff1a%s", fieldName));
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.fromValue = fromValue;
        filter.toValue = toValue;
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.RANGE;
        return filter;
    }

    @ApiOperation(value="\u6784\u5efa\u5355\u503c\u524d\u7f00\u5339\u914d", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public static final FilterFieldVo prefix(String fieldName, String likeValue) {
        return FilterFieldVo.prefix(fieldName, likeValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u524d\u7f00\u5339\u914d\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo prefix(String fieldName, String likeValue, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (StringUtils.isBlank((CharSequence)likeValue)) {
            throw new BusinessRuntimeException(String.format(FILTER_VALUE_NOT_NULL_TIP, fieldName));
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.equalValue = likeValue;
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.PREFIX;
        return filter;
    }

    @ApiOperation(value="\u6784\u5efa\u5355\u503c\u524d\u7f00\u5339\u914d", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public static final FilterFieldVo wildcard(String fieldName, String likeValue) {
        return FilterFieldVo.wildcard(fieldName, likeValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u901a\u914d\u7b26\u5339\u914d\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo wildcard(String fieldName, String likeValue, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (StringUtils.isBlank((CharSequence)likeValue)) {
            throw new BusinessRuntimeException(String.format(FILTER_VALUE_NOT_NULL_TIP, fieldName));
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.equalValue = likeValue;
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.WILDCARD;
        return filter;
    }

    @ApiOperation(value="\u5355\u503c\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public static final FilterFieldVo regexp(String fieldName, String likeValue) {
        return FilterFieldVo.regexp(fieldName, likeValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public static final FilterFieldVo regexp(String fieldName, String likeValue, LogicalSymbol logicalSymbol) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new BusinessRuntimeException(FILTER_FIELD_NAME_NOT_NULL_TIP);
        }
        if (StringUtils.isBlank((CharSequence)likeValue)) {
            throw new BusinessRuntimeException(String.format(FILTER_VALUE_NOT_NULL_TIP, fieldName));
        }
        FilterFieldVo filter = new FilterFieldVo();
        filter.fieldName = fieldName;
        filter.equalValue = likeValue;
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.REGEXP;
        return filter;
    }

    public static final FilterFieldVo compound(LogicalSymbol logicalSymbol) {
        FilterFieldVo filter = new FilterFieldVo();
        filter.logicalSymbol = logicalSymbol;
        filter.filterType = FilterType.COMPOUND;
        return filter;
    }

    public final String getEqualValue() {
        return this.equalValue;
    }

    public final void setEqualValue(String equalValue) {
        this.equalValue = equalValue;
    }

    public final String[] getInValues() {
        return this.inValues;
    }

    public final void setInValues(String[] inValues) {
        this.inValues = inValues;
    }

    public final String getFromValue() {
        return this.fromValue;
    }

    public final void setFromValue(String fromValue) {
        this.fromValue = fromValue;
    }

    public final String getToValue() {
        return this.toValue;
    }

    public final void setToValue(String toValue) {
        this.toValue = toValue;
    }

    public final LogicalSymbol getLogicalSymbol() {
        return this.logicalSymbol;
    }

    public final void setLogicalSymbol(LogicalSymbol logicalSymbol) {
        this.logicalSymbol = logicalSymbol;
    }

    public final FilterType getFilterType() {
        return this.filterType;
    }

    public final void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public final Boolean getNon() {
        return this.non;
    }

    public final void setNon(Boolean non) {
        this.non = non;
    }

    public final void addSubFilterFieldVos(FilterFieldVo ... subFilterFieldVos) {
        if (subFilterFieldVos == null || subFilterFieldVos.length == 0) {
            return;
        }
        for (FilterFieldVo filterFieldVo : subFilterFieldVos) {
            if (filterFieldVo.getLogicalSymbol().equals((Object)LogicalSymbol.AND)) {
                this.initFilterFields();
                this.subFilterFields.add(filterFieldVo);
                continue;
            }
            this.initOrFilterFields();
            this.subOrFilterFields.add(filterFieldVo);
        }
    }

    protected final void initOrFilterFields() {
        if (this.subOrFilterFields == null) {
            this.subOrFilterFields = new ArrayList<FilterFieldVo>(5);
        }
    }

    protected final void initFilterFields() {
        if (this.subFilterFields == null) {
            this.subFilterFields = new ArrayList<FilterFieldVo>(5);
        }
    }

    public final List<FilterFieldVo> getSubFilterFields() {
        return this.subFilterFields;
    }

    @JsonIgnore
    public final FilterFieldVo[] getSubFilterFieldAsArray() {
        if (this.subFilterFields == null) {
            return null;
        }
        return this.subFilterFields.toArray(new FilterFieldVo[this.subFilterFields.size()]);
    }

    public final List<FilterFieldVo> getSubOrFilterFields() {
        return this.subOrFilterFields;
    }

    @JsonIgnore
    public final FilterFieldVo[] getSubOrFilterFieldAsArray() {
        if (this.subOrFilterFields == null) {
            return null;
        }
        return this.subOrFilterFields.toArray(new FilterFieldVo[this.subOrFilterFields.size()]);
    }

    @ApiModel(value="FilterType", description="\u8fc7\u6ee4\u7c7b\u578b\u679a\u4e3e\u7c7b")
    public static enum FilterType {
        TERM,
        TERMS,
        RANGE,
        NESTED,
        EXISTS,
        REGEXP,
        WILDCARD,
        PREFIX,
        COMPOUND;

    }
}

