/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.api;

import com.dtyunxi.huieryun.lock.api.AbstractLockService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.huieryun.registry.vo.LockRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(LockServiceFactory.class);

    public static ILockService createLockService(IRegistryService registryService) {
        LockRegistryVo lockVo = registryService.getObject("huieryun.service.lock.lockregistryvo", LockRegistryVo.class);
        logger.debug("Set lock provider as {}", (Object)lockVo);
        if (lockVo == null || lockVo.getEndpoints() == null) {
            throw new BusinessRuntimeException("Please registry lock service provider");
        }
        AbstractLockService lockService = null;
        if (lockVo.getProvider() == null) {
            logger.warn("Fallback to default lock service {} ", (Object)"etcd");
            lockVo.setProvider("etcd");
        }
        String className = null;
        switch (lockVo.getProvider()) {
            case "etcd": {
                className = "com.dtyunxi.huieryun.lock.provider.etcd.EtcdLockService";
                break;
            }
            case "redis": {
                className = "com.dtyunxi.huieryun.lock.provider.redis.RedisLockService";
                break;
            }
        }
        try {
            lockService = (AbstractLockService)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        lockService.init(lockVo);
        return lockService;
    }
}

