/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.provider.etcd;

import com.coreos.jetcd.EtcdClient;
import com.coreos.jetcd.EtcdClientBuilder;
import com.coreos.jetcd.EtcdKV;
import com.coreos.jetcd.api.KeyValue;
import com.coreos.jetcd.api.RangeResponse;
import com.coreos.jetcd.api.WatchCreateRequest;
import com.coreos.jetcd.api.WatchRequest;
import com.coreos.jetcd.options.GetOption;
import com.dtyunxi.huieryun.registry.api.AbstractRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.huieryun.registry.provider.etcd.EtcdKeyValue;
import com.dtyunxi.huieryun.registry.provider.etcd.EtcdStreamObserver;
import com.dtyunxi.huieryun.registry.vo.RegistryItemVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.CipherTextUtil;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdRegistryService
extends AbstractRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(EtcdRegistryService.class);
    private EtcdClient client;
    private EtcdKV kvClient;
    private StreamObserver<WatchRequest> watchReuqest;

    public void init(String[] endpoints, String group) {
        try {
            this.group = group;
            this.client = EtcdClientBuilder.newBuilder().endpoints(endpoints).build();
            this.kvClient = this.client.getKVClient();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean put(String group, String key, String value) {
        try {
            ByteString bsKey = EtcdKeyValue.toByteString(group, key);
            ByteString bsValue = EtcdKeyValue.toByteString(value);
            this.kvClient.put(bsKey, bsValue).get();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public String get(String group, String key) {
        try {
            ByteString bsKey = EtcdKeyValue.toByteString(group, key);
            ListenableFuture listenableFuture = this.kvClient.get(bsKey);
            RangeResponse response = (RangeResponse)listenableFuture.get();
            if (response.getKvsCount() > 0) {
                String value = EtcdKeyValue.toString(response.getKvs(0).getValue());
                return CipherTextUtil.decode((String)this.cipherDecodeKey, (String)value);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public RegistryItemVo[] getPrefix(String group, String key) {
        try {
            ByteString bsKey = EtcdKeyValue.toByteString(group, key);
            ByteString bsEndKey = EtcdKeyValue.toByteString(group, EtcdKeyValue.getEndKey(key));
            GetOption getOption = GetOption.newBuilder().withRange(bsEndKey).build();
            ListenableFuture listenableFuture = this.kvClient.get(bsKey, getOption);
            RangeResponse response = (RangeResponse)listenableFuture.get();
            if (response.getKvsCount() > 0) {
                RegistryItemVo[] itemVos = new RegistryItemVo[response.getKvsCount()];
                for (int i = 0; i < response.getKvsCount(); ++i) {
                    KeyValue kv = response.getKvs(i);
                    itemVos[i] = new RegistryItemVo(EtcdKeyValue.toString(kv.getKey()), EtcdKeyValue.toString(kv.getValue()));
                    itemVos[i].setVersion(kv.getVersion());
                }
                return itemVos;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return new RegistryItemVo[0];
    }

    public void delete(String group, String key) {
        this.kvClient.delete(EtcdKeyValue.toByteString(group, key));
    }

    public void registerChangeListner(String group, String key, RegistryChangeListener registryChangeListener) {
        if (this.watchReuqest == null) {
            EtcdStreamObserver streamObserver = new EtcdStreamObserver(this);
            this.watchReuqest = this.client.getWatchStub().watch((StreamObserver)streamObserver);
        }
        ByteString bsKey = EtcdKeyValue.toByteString(group, key);
        ByteString bsEndKey = EtcdKeyValue.toByteString(group, EtcdKeyValue.getEndKey(key));
        this.watchReuqest.onNext((Object)WatchRequest.newBuilder().setCreateRequest(WatchCreateRequest.newBuilder().setKey(bsKey).setRangeEnd(bsEndKey)).build());
    }
}

