/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.dtyunxi.huieryun.localcache.api.ILocalCacheService;
import com.dtyunxi.huieryun.starter.localcache.CacheMessage;
import com.dtyunxi.huieryun.starter.localcache.LocalCache;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheManager;
import com.dtyunxi.util.FastJsonUtil;
import com.dtyunxi.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEventListener
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CacheEventListener.class);
    protected static Logger LOGGER = LoggerFactory.getLogger(CacheEventListener.class);
    private final LocalCacheManager cacheManager;

    public CacheEventListener(LocalCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        if (this.cacheManager.getProperties().getLocalCache() != null) {
            this.subscribeKeyEvictEvent();
            if (this.cacheManager.getProperties().isRemoteCache() && this.cacheManager.getCacheService() != null) {
                this.subscribeKeyExpiredEvent();
            }
        }
    }

    protected void subscribeKeyEvictEvent() {
        IRedisSubProcessor<String> processor = new IRedisSubProcessor<String>(){

            public void process(String channel, String message) {
                log.debug("process key evict event,channel={},message={}", (Object)channel, (Object)message);
                CacheMessage cacheMessage = (CacheMessage)JacksonUtil.readValue((String)message, CacheMessage.class);
                if (cacheMessage.getPublisher().equals(LocalCacheManager.COMMON_SRC)) {
                    return;
                }
                ILocalCacheService localCacheService = ((LocalCache)CacheEventListener.this.cacheManager.getCacheMap().get(cacheMessage.getCacheName())).getLocalCacheService();
                if (localCacheService == null) {
                    return;
                }
                switch (cacheMessage.getEvent()) {
                    case EVICT: {
                        if (cacheMessage.getGroup() != null) {
                            localCacheService.delCache(cacheMessage.getGroup(), cacheMessage.getKey());
                            return;
                        }
                        localCacheService.delCache(cacheMessage.getKey());
                        return;
                    }
                    case CLEAR: {
                        localCacheService.cleanUp();
                        return;
                    }
                    case PUT: {
                        Object value = null;
                        try {
                            value = cacheMessage.getParameterTypes() == null ? cacheMessage.getValue() : FastJsonUtil.parseObject((String)cacheMessage.getValue(), Class.forName(cacheMessage.getParameterTypes()));
                        }
                        catch (ClassNotFoundException e) {
                            value = cacheMessage.getValue();
                            LOGGER.warn("redis\u7f13\u5b58\u540c\u6b65\u672c\u5730\u6570\u636e\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
                        }
                        if (cacheMessage.getGroup() != null) {
                            localCacheService.setCache(cacheMessage.getGroup(), cacheMessage.getKey(), value);
                            return;
                        }
                        localCacheService.setCache(cacheMessage.getKey(), value);
                        return;
                    }
                }
            }
        };
        if (this.cacheManager.getProperties().getCacheSyncGroups() != null) {
            for (String group : this.cacheManager.getProperties().getCacheSyncGroups()) {
                this.cacheManager.getCacheService().subscribe(group, this.cacheManager.getProperties().getCacheSyncTopic(), (IRedisSubProcessor)processor);
            }
        }
        this.cacheManager.getCacheService().subscribe(this.cacheManager.getProperties().getCacheSyncTopic(), (IRedisSubProcessor)processor);
    }

    protected void subscribeKeyExpiredEvent() {
        IRedisSubProcessor<String> processor = new IRedisSubProcessor<String>(){

            public void process(String channel, String message) {
                log.debug("process key expired event,channel={},message={}", (Object)channel, (Object)message);
                String[] messages = message.split(":");
                if (messages != null && messages.length >= 3) {
                    ILocalCacheService localCacheService = ((LocalCache)CacheEventListener.this.cacheManager.getCacheMap().get(messages[1])).getLocalCacheService();
                    if (messages.length > 3) {
                        localCacheService.delCache(messages[2], messages[3]);
                    } else {
                        localCacheService.delCache(messages[2]);
                    }
                }
            }
        };
        this.cacheManager.getCacheService().subscribeKeyExpiredEvent((IRedisSubProcessor)processor);
    }
}

