/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.mojo;

import com.dtyunxi.huieryun.meta.annotation.ModuleType;
import com.dtyunxi.huieryun.xmeta.fodel.AbstractTypeFodel;
import com.dtyunxi.huieryun.xmeta.fodel.FodelBuilder;
import com.dtyunxi.huieryun.xmeta.fodel.FodelDumper;
import com.dtyunxi.huieryun.xmeta.mojo.AbstractMetaMojo;
import com.dtyunxi.huieryun.xmeta.mojo.ModuleDependency;
import com.dtyunxi.huieryun.xmeta.mojo.summary.Summary;
import com.dtyunxi.huieryun.xmeta.mojo.summary.SummaryTool;
import com.dtyunxi.huieryun.xmeta.mojo.util.ModuleUtils;
import com.dtyunxi.huieryun.xmeta.rase.mojo.impl.GenJava4Ver5;
import com.dtyunxi.huieryun.xmeta.util.FileLocation;
import com.dtyunxi.huieryun.xmeta.util.LoadYamlUtils;
import com.dtyunxi.huieryun.xmeta.util.LogUtil;
import com.dtyunxi.huieryun.xmeta.util.MvnPrjUtil;
import com.dtyunxi.huieryun.xmeta.util.ZipFileReader;
import com.dtyunxi.huieryun.xmeta.yaml.MetaYamlLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="gen-meta-java", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GenMetaJavaMojo
extends AbstractMetaMojo {
    @Parameter(property="xmeta.skipGen", defaultValue="false")
    private boolean skipGen = false;
    private Boolean singleModule;

    public Boolean getSingleModule() {
        if (this.singleModule == null) {
            this.singleModule = MvnPrjUtil.isSingleModuleProject((MavenProject)this.mavenProject);
        }
        return this.singleModule;
    }

    protected void executeInner() throws IOException, DependencyResolutionRequiredException {
        if (this.getSingleModule().booleanValue()) {
            this.getLog().info((CharSequence)"xmetaInfo: \u5355\u6a21\u5757\u5de5\u7a0b,\u7ee7\u7eed.");
        } else {
            ModuleType moduleType = ModuleUtils.getModuleType((MavenProject)this.mavenProject);
            if (moduleType == null) {
                this.getLog().info((CharSequence)"xmetaInfo: \u4e0d\u53ef\u8bc6\u522b\u7684maven\u5de5\u7a0b\u6216\u6a21\u5757\uff0cxmeta\u63d2\u4ef6\u4e0d\u6267\u884c");
                return;
            }
            this.getLog().info((CharSequence)("xmetaInfo Recognize module as " + moduleType.getValue()));
        }
        this.addSourceRoot();
        if (this.skipGen) {
            this.getLog().info((CharSequence)"\u63a5\u6536\u5230xmeta.skipGen,\u8df3\u8fc7\u6e90\u7801\u751f\u6210");
            return;
        }
        try {
            ModuleDependency moduleDependency = new ModuleDependency();
            List dependencyApiJars = moduleDependency.collect(this.getMavenProject());
            TreeMap typeDefBuckets = new TreeMap();
            List fileLocations = LoadYamlUtils.collectYamlsFromDir((MavenProject)this.mavenProject, (File)this.getBasedir());
            MetaYamlLoader.loadTypeDefs((List)fileLocations, typeDefBuckets);
            MetaYamlLoader.loadTypeDefs(this.collectYamlsFromDependencies(dependencyApiJars), typeDefBuckets);
            FodelBuilder fodelBuilder = new FodelBuilder();
            Map mapTypeFodel = fodelBuilder.convertTypeDef(typeDefBuckets);
            Summary summary = this.dumpJavaSourceFiles(mapTypeFodel, moduleDependency);
            String strSumarry = SummaryTool.dumpSummary(summary, SummaryTool.getSummaryPath(this.getOutputDirectory()));
            this.getLog().info((CharSequence)("xmetaInfo Generated java sources \n" + strSumarry));
            if (ModuleUtils.isBootModule((MavenProject)this.mavenProject) && this.genDoJavaEnabled) {
                this.getLog().info((CharSequence)"5.x\u7248\u672c\u6570\u636e\u5bf9\u8c61\u4ee3\u7801\u751f\u6210");
                GenJava4Ver5 genJava = new GenJava4Ver5(this.projectCode, this.mavenProject, this.getLog());
                genJava.clearRaseObject();
                genJava.execute();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private List<FileLocation> collectYamlsFromDependencies(List<Artifact> dependencyApiJars) throws IOException {
        ArrayList<FileLocation> allFileLocations = new ArrayList<FileLocation>(64);
        for (Artifact artifact : dependencyApiJars) {
            String strJarFile = artifact.getFile().getAbsolutePath();
            String zipFileShortName = artifact.getArtifactId();
            if (!strJarFile.endsWith(".jar")) continue;
            List fileLocations = ZipFileReader.scanEntriesBySuffix((String)zipFileShortName, (String)strJarFile, (String)".xmeta.yaml");
            allFileLocations.addAll(fileLocations);
        }
        if (LogUtil.isDebugEnabled()) {
            for (FileLocation fileLocation : allFileLocations) {
                LogUtil.debug((String)("prepare load xmeta in dependence:" + fileLocation.getFullPath()));
            }
        }
        return allFileLocations;
    }

    public Summary dumpJavaSourceFiles(Map<String, AbstractTypeFodel> mapTypeFodel, ModuleDependency moduleDependency) throws IOException {
        ModuleType currentModuleType;
        Summary summary = new Summary();
        boolean isPackaging = this.isPackaging();
        boolean isSingleModule = MvnPrjUtil.isSingleModuleProject((MavenProject)this.mavenProject);
        if (isSingleModule) {
            currentModuleType = ModuleType.BOOT;
        } else {
            currentModuleType = ModuleUtils.getModuleType((MavenProject)this.mavenProject);
            if (currentModuleType == null) {
                this.getLog().info((CharSequence)"\u4e0d\u652f\u6301\u7684\u6a21\u5757,\u4e0d\u5904\u7406");
                return summary;
            }
        }
        String artifactId = this.mavenProject.getArtifactId();
        String parentArtifactId = this.mavenProject.getParentArtifact() != null ? this.mavenProject.getParentArtifact().getArtifactId() : artifactId;
        for (AbstractTypeFodel typeFodel : mapTypeFodel.values()) {
            ModuleType typeLocation = typeFodel.getModuleType();
            boolean isDump = false;
            if (isSingleModule) {
                if (ModuleType.API.equals((Object)typeFodel.getModuleType())) {
                    isDump = true;
                } else if (MvnPrjUtil.isCallDep((String)typeFodel.getContainers(), (MavenProject)this.mavenProject)) {
                    this.getLog().debug((CharSequence)("\u5355\u6a21\u5757\u5de5\u7a0b,\u4ec5\u8c03\u7528api,\u4e0d\u662f\u53e0\u52a0\u529f\u80fd\u5305\uff0c\u8df3\u8fc7\u4f9d\u8d56jar\u7684\u5b9a\u4e49:" + typeFodel.getClazz()));
                } else {
                    isDump = true;
                }
            } else {
                isDump = this.checkDump4multilModule(moduleDependency, isPackaging, currentModuleType, parentArtifactId, typeFodel, typeLocation);
            }
            if (!isDump) continue;
            FodelDumper.dumpJavaSourceFile((String)this.mavenProject.getBasedir().getAbsolutePath(), (AbstractTypeFodel)typeFodel);
            summary.addType(typeFodel.getClazz(), typeFodel.getModuleType());
        }
        return summary;
    }

    private boolean checkDump4multilModule(ModuleDependency moduleDependency, boolean isPackaging, ModuleType currentModuleType, String parentArtifactId, AbstractTypeFodel typeFodel, ModuleType typeLocation) {
        boolean isDump = false;
        switch (currentModuleType) {
            case API: {
                if (ModuleType.API != typeLocation) break;
                isDump = true;
                break;
            }
            case BIZ: {
                if (ModuleType.API == typeLocation) {
                    if (isPackaging) {
                        isDump = true;
                        break;
                    }
                    if (!this.isRpcApi(typeFodel, parentArtifactId)) break;
                    isDump = true;
                    break;
                }
                if (ModuleType.BIZ != typeLocation || !this.isContainerDepended(typeFodel, ModuleType.BIZ, moduleDependency.getMapBizArtifacts())) break;
                isDump = true;
                break;
            }
            case BOOT: {
                if (ModuleType.API == typeLocation) {
                    if (!isPackaging && ModuleUtils.isSiblingModuleExists((MavenProject)this.mavenProject, (ModuleType)ModuleType.BIZ)) break;
                    isDump = true;
                    break;
                }
                if (ModuleType.BIZ != typeLocation || !isPackaging && ModuleUtils.isSiblingModuleExists((MavenProject)this.mavenProject, (ModuleType)ModuleType.BIZ) || !this.isContainerDepended(typeFodel, ModuleType.BIZ, moduleDependency.getMapBizArtifacts())) break;
                isDump = true;
                break;
            }
            default: {
                this.getLog().warn((CharSequence)("module\u7c7b\u578b\u672a\u652f\u6301:" + currentModuleType));
            }
        }
        return isDump;
    }

    private boolean isRpcApi(AbstractTypeFodel typeFodel, String parentArtifactId) {
        boolean fromRemote;
        Set containerNames = typeFodel.getContainerNames();
        if (CollectionUtils.isNotEmpty((Collection)containerNames)) {
            fromRemote = true;
            for (String containerName : containerNames) {
                if (!containerName.startsWith(parentArtifactId)) continue;
                fromRemote = false;
                break;
            }
        } else {
            fromRemote = false;
        }
        return fromRemote;
    }

    private boolean isContainerDepended(AbstractTypeFodel typeFodel, ModuleType moduleType, Map<String, Artifact> mapDependencies) {
        for (String containerName : typeFodel.getContainerNames()) {
            String targetArtifactId = ModuleUtils.convertArtifactIdAs((String)containerName, (ModuleType)moduleType);
            if (!mapDependencies.containsKey(targetArtifactId)) continue;
            return true;
        }
        return false;
    }
}

