/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.mojo;

import com.dtyunxi.huieryun.meta.annotation.ModuleType;
import com.dtyunxi.huieryun.xmeta.mojo.AbstractMetaMojo;
import com.dtyunxi.huieryun.xmeta.mojo.MetaConsts;
import com.dtyunxi.huieryun.xmeta.mojo.summary.Summary;
import com.dtyunxi.huieryun.xmeta.mojo.summary.SummaryTool;
import com.dtyunxi.huieryun.xmeta.mojo.util.ModuleUtils;
import com.dtyunxi.huieryun.xmeta.util.FileUtils;
import com.dtyunxi.huieryun.xmeta.util.PackageUtils;
import com.dtyunxi.huieryun.xmeta.util.YamlUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="mvout-meta-type", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class MoveOutMetaTypeMojo
extends AbstractMetaMojo {
    protected void executeInner() throws IOException {
        if (ModuleUtils.isPom((MavenProject)this.mavenProject) || ModuleUtils.isBootModule((MavenProject)this.mavenProject) || ModuleUtils.isExecutableTarget((MavenProject)this.mavenProject)) {
            return;
        }
        String outpuDir = this.getOutputDirectory();
        File fileSummary = new File(SummaryTool.getSummaryPath(outpuDir));
        if (!fileSummary.exists()) {
            String error = " \u4e0d\u652f\u6301\u5f53\u524d\u7684\u6a21\u5757\uff0c\u4ec5\u652f\u6301biz\u3001api\u3001boot\u6a21\u5757";
            this.getLog().debug((CharSequence)error);
            throw new RuntimeException(error);
        }
        Summary summary = (Summary)YamlUtils.loadYaml((File)fileSummary, Summary.class);
        ModuleType currentModuleType = ModuleUtils.getModuleType((MavenProject)this.mavenProject);
        switch (currentModuleType) {
            case API: {
                this.deleteClassFiles(summary.getApiTypes());
                break;
            }
            case BIZ: {
                this.deleteClassFiles(summary.getApiTypes());
                this.deleteJavaFiles(summary.getApiTypes());
                this.deleteClassFiles(summary.getBizTypes());
                break;
            }
            case BOOT: {
                break;
            }
        }
    }

    private void deleteClassFiles(Collection<String> typeClazzs) {
        String outputDir = this.getOutputDirectory();
        for (String typeClazz : typeClazzs) {
            String clazzPath = PackageUtils.clazz2Path((String)typeClazz) + ".class";
            File fileClazz = new File(outputDir + FS + clazzPath);
            if (fileClazz.exists()) {
                if (fileClazz.delete()) {
                    this.getLog().info((CharSequence)("xmetaInfo deleted class " + clazzPath));
                } else {
                    this.getLog().info((CharSequence)("xmetaInfo failed to delete class " + clazzPath));
                }
            }
            FileUtils.deleteEmptyDir((File)fileClazz.getParentFile());
        }
    }

    private void deleteJavaFiles(Collection<String> typeClazzs) {
        String parentDir = this.getMavenProject().getBasedir().getAbsolutePath();
        for (String typeClazz : typeClazzs) {
            String javaPath = PackageUtils.clazz2Path((String)typeClazz) + ".java";
            String filePath = parentDir + FS + MetaConsts.XMETA_GEN_ROOT;
            File fileJava = new File(filePath + FS + javaPath);
            if (fileJava.exists()) {
                if (fileJava.delete()) {
                    this.getLog().info((CharSequence)("xmetaInfo deleted java " + javaPath));
                } else {
                    this.getLog().info((CharSequence)("xmetaInfo failed to delete java " + javaPath));
                }
            }
            FileUtils.deleteEmptyDir((File)fileJava.getParentFile());
        }
    }
}

