/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.rase.mojo;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.meta.annotation.ModuleType;
import com.dtyunxi.huieryun.rase.annotation.RaseObject;
import com.dtyunxi.huieryun.xmeta.fodel.AbstractTypeFodel;
import com.dtyunxi.huieryun.xmeta.fodel.ApiFodel;
import com.dtyunxi.huieryun.xmeta.fodel.FemplateUsage;
import com.dtyunxi.huieryun.xmeta.fodel.FodelBuilder;
import com.dtyunxi.huieryun.xmeta.mojo.MetaConsts;
import com.dtyunxi.huieryun.xmeta.mojo.util.ModuleUtils;
import com.dtyunxi.huieryun.xmeta.rase.fodel.EoApiMergeFodel;
import com.dtyunxi.huieryun.xmeta.rase.mojo.IGenDoJava;
import com.dtyunxi.huieryun.xmeta.rase.yaml.ApiDefBucket;
import com.dtyunxi.huieryun.xmeta.rase.yaml.DataYamlLoader;
import com.dtyunxi.huieryun.xmeta.util.ClazzUtils;
import com.dtyunxi.huieryun.xmeta.util.FileUtils;
import com.dtyunxi.huieryun.xmeta.yaml.MetaYaml;
import com.dtyunxi.huieryun.xmeta.yaml.TypeDefBucket;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;

public abstract class AbstractGenJava
implements IGenDoJava {
    private static final String FS = File.separator;
    protected String projectCode;
    protected MavenProject mavenProject;
    protected Log log;

    public AbstractGenJava(String projectCode, MavenProject mavenProject, Log log) {
        this.projectCode = projectCode;
        this.mavenProject = mavenProject;
        this.log = log;
    }

    @Override
    public Map<String, ApiFodel> convertApiDef(Map<String, ApiDefBucket> mapApiDefBucket, Map<String, AbstractTypeFodel> mapTypeFodel, FodelBuilder buildFodel) throws IOException {
        String projectName = this.projectCode;
        if (this.projectCode == null) {
            MavenProject project = this.mavenProject.getParent();
            projectName = project.getArtifactId();
        }
        Map mapApiFodel = buildFodel.convertApiDef(mapApiDefBucket, mapTypeFodel, projectName);
        for (ApiFodel apiFodel : mapApiFodel.values()) {
            this.log.info((CharSequence)("--- api Def = " + JSON.toJSONString((Object)apiFodel)));
        }
        return mapApiFodel;
    }

    @Override
    public Map<String, TypeDefBucket> mergeEoDtoMetaYaml(List<MetaYaml> metaYamlList) {
        HashMap<String, TypeDefBucket> typeDefBuckets = new HashMap<String, TypeDefBucket>();
        metaYamlList.forEach(metaYaml -> {
            if (!metaYaml.getImmutable().booleanValue()) {
                DataYamlLoader.mergeEoDtoMetaYaml((MetaYaml)metaYaml, (Map)typeDefBuckets);
            }
        });
        return typeDefBuckets;
    }

    @Override
    public Map<String, ApiDefBucket> mergeApiMetaYaml(List<MetaYaml> metaYamlList) {
        HashMap<String, ApiDefBucket> apiDefBuckets = new HashMap<String, ApiDefBucket>();
        metaYamlList.forEach(metaYaml -> {
            if (!metaYaml.getImmutable().booleanValue()) {
                DataYamlLoader.mergeApiMetaYaml((MetaYaml)metaYaml, (Map)apiDefBuckets);
            }
        });
        return apiDefBuckets;
    }

    @Override
    public void rebuildMetaBasePackage(Map<String, AbstractTypeFodel> toMapTypeFodel, Map<String, ApiFodel> fromMapApiFodel) {
        Iterator<ApiFodel> apiIt = fromMapApiFodel.values().iterator();
        if (apiIt.hasNext()) {
            ApiFodel apiFodel = apiIt.next();
            Set<String> typeKeySet = toMapTypeFodel.keySet();
            for (String key : typeKeySet) {
                AbstractTypeFodel typeFodel = toMapTypeFodel.get(key);
                typeFodel.setBasePackage(apiFodel.getBasePackage());
                toMapTypeFodel.put(key, typeFodel);
            }
        }
    }

    @Override
    public List<String> dumpApiJavaSourceFiles(Map<String, ApiFodel> mapApiFodel) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (ApiFodel apiFodel : mapApiFodel.values()) {
            String apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
            String apiFullPath = this.buildIApiFullPath(parentBasePath + File.separator + apiArtifactId, apiFodel);
            String filePath = this.dumpJavaSourceFile(apiFodel, "iapi.ftl", apiFullPath);
            if (filePath != null) {
                fileFullPathList.add(filePath);
            }
            String bizArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.BIZ);
            String apiImplFilePath = this.buildApiImplFullPath(parentBasePath + File.separator + bizArtifactId, apiFodel);
            filePath = this.dumpJavaSourceFile(apiFodel, "apiImpl3.ftl", apiImplFilePath);
            if (filePath == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }

    @Override
    public String dumpJavaSourceFile(Object dataModel, String ftlName, String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            this.log.info((CharSequence)("------ \u5b58\u5728\u540c\u540d\u6587\u4ef6\u4e0d\u8986\u76d6, \u6587\u4ef6\u540d\uff1a" + filePath));
            return null;
        }
        FileUtils.createParentDirs((String)filePath);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
            Template template = FemplateUsage.getInstance().getTemplateConfiguraion().getTemplate(ftlName);
            template.process(dataModel, (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException te) {
            try {
                throw new IOException(te);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuitely(out);
                throw throwable;
            }
        }
        FileUtils.closeQuitely((Closeable)out);
        return filePath;
    }

    @Override
    public String buildEoDtoFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String relativePath = MetaConsts.SRC_MAIN_JAVA + FS + typeFodel.getClazz().replace(".", FS) + ".java";
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildDtoFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String relativePath = MetaConsts.SRC_MAIN_JAVA + FS + typeFodel.getClazz().replace(".", FS) + ".java";
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildExtEoDtoFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String relativePath = MetaConsts.SRC_MAIN_JAVA + FS + typeFodel.getTypePackage().replace(".", FS) + FS + "ext" + FS + typeFodel.getTypeName() + "ExtDef" + typeFodel.getRandomNum() + ".java";
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildIApiFullPath(String baseDir, ApiFodel apiFodel) {
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(apiFodel.getClazz().replace(".", FS)).append(".java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildApiImplFullPath(String baseDir, ApiFodel apiFodel) {
        String packageStr = apiFodel.getBasePackage() + ".biz.apiimpl.";
        if (apiFodel.getClazz().contains(".query.")) {
            packageStr = packageStr + "query.";
        }
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append(apiFodel.getApiName().substring(1)).append("Impl.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildIServiceFullPath(String baseDir, EoApiMergeFodel eoApiMergeFodel) {
        String packageStr = eoApiMergeFodel.getBasePackage() + ".biz.service.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append("I").append(eoApiMergeFodel.getEntityName()).append("Service.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildServiceImplFullPath(String baseDir, EoApiMergeFodel eoApiMergeFodel) {
        String packageStr = eoApiMergeFodel.getBasePackage() + ".biz.service.impl.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append(eoApiMergeFodel.getEntityName()).append("ServiceImpl.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildMapperFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String packageStr = typeFodel.getBasePackage() + ".dao.mapper.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append(typeFodel.getEntityName()).append("Mapper.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildDasFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String packageStr = typeFodel.getBasePackage() + ".dao.das.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append(typeFodel.getEntityName()).append("Das.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildDslFullPath(String baseDir, EoApiMergeFodel eoApiMergeFodel) {
        String packageStr = eoApiMergeFodel.getBasePackage() + ".biz.dsl.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append(eoApiMergeFodel.getEntityName()).append("Dsl.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildRestFullPath(String baseDir, EoApiMergeFodel eoApiMergeFodel) {
        String packageStr = eoApiMergeFodel.getBasePackage() + ".svr.rest.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(FS).append(packageStr.replace(".", FS)).append(eoApiMergeFodel.getEntityName()).append("Rest.java").toString();
        String fullPath = baseDir + FS + relativePath;
        return fullPath;
    }

    @Override
    public void clearRaseObject() {
        ClassLoader classLoader = ClazzUtils.getProjectClassLoader((MavenProject)this.mavenProject);
        List classpathElements = null;
        try {
            classpathElements = this.mavenProject.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            this.log.error((CharSequence)"\u83b7\u53d6\u7f16\u8bd1\u8def\u5f84\u7684\u5143\u7d20\u5f02\u5e38", (Throwable)e);
        }
        if (classpathElements != null && classLoader != null) {
            List<String> classFilePathList = classpathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> this.findRaseObjectByAnnotation(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), classLoader).stream()).collect(Collectors.toList());
            ArrayList javaFilePathList = new ArrayList();
            classFilePathList.forEach(filePath -> {
                this.log.debug((CharSequence)("\u67e5\u627e\u5230\u6ce8\u89e3RaseObject\u7684class\u6587\u4ef6 = " + filePath));
                String javaFilePath = filePath.replace(".class", ".java").replace(MetaConsts.TARGET_CLASSES, MetaConsts.SRC_MAIN_JAVA);
                javaFilePathList.add(javaFilePath);
            });
            javaFilePathList.forEach(filePath -> {
                File file = new File((String)filePath);
                if (file.exists() && file.isFile()) {
                    this.log.info((CharSequence)("--- delete java file = " + filePath));
                    file.delete();
                }
            });
        }
    }

    @Override
    public List<String> findRaseObjectByAnnotation(int classpathLenth, File file, ClassLoader classLoader) {
        ArrayList<String> classFilePathList = new ArrayList<String>();
        if (file == null || !file.exists() || !file.isDirectory()) {
            return classFilePathList;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return classFilePathList;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                classFilePathList.addAll(this.findRaseObjectByAnnotation(classpathLenth, f, classLoader));
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".class")) continue;
            String currentFileAbsolutePath = f.getAbsolutePath();
            String className = currentFileAbsolutePath.substring(classpathLenth + 1, currentFileAbsolutePath.length() - 6).replaceAll("[/|\\\\]", ".");
            this.log.debug((CharSequence)("----------- className = " + className));
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)classLoader);
                RaseObject raseObject = clazz.getAnnotation(RaseObject.class);
                if (raseObject == null) continue;
                classFilePathList.add(currentFileAbsolutePath);
            }
            catch (ClassNotFoundException e) {
                this.log.error((CharSequence)"\u52a0\u8f7d\u7c7b\u5f02\u5e38", (Throwable)e);
            }
        }
        return classFilePathList;
    }
}

