/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.rase.mojo.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.meta.annotation.ModuleType;
import com.dtyunxi.huieryun.meta.annotation.ObjectType;
import com.dtyunxi.huieryun.xmeta.fodel.AbstractTypeFodel;
import com.dtyunxi.huieryun.xmeta.fodel.ApiFodel;
import com.dtyunxi.huieryun.xmeta.fodel.DtoAttrFodel;
import com.dtyunxi.huieryun.xmeta.fodel.DtoFodel;
import com.dtyunxi.huieryun.xmeta.fodel.EoFodel;
import com.dtyunxi.huieryun.xmeta.fodel.FodelBuilder;
import com.dtyunxi.huieryun.xmeta.mojo.MetaConsts;
import com.dtyunxi.huieryun.xmeta.mojo.util.ModuleUtils;
import com.dtyunxi.huieryun.xmeta.rase.fodel.EoApiMergeFodel;
import com.dtyunxi.huieryun.xmeta.rase.mojo.AbstractGenJava;
import com.dtyunxi.huieryun.xmeta.rase.mojo.IGenDoJava;
import com.dtyunxi.huieryun.xmeta.rase.yaml.ApiDefBucket;
import com.dtyunxi.huieryun.xmeta.rase.yaml.DataYamlLoader;
import com.dtyunxi.huieryun.xmeta.util.FileLocation;
import com.dtyunxi.huieryun.xmeta.util.FileUtils;
import com.dtyunxi.huieryun.xmeta.yaml.TypeDefBucket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.CollectionUtils;

public class GenJava4Ver3
extends AbstractGenJava
implements IGenDoJava {
    public GenJava4Ver3(String projectCode, MavenProject mavenProject, Log log) {
        super(projectCode, mavenProject, log);
    }

    @Override
    public void execute() throws IOException {
        try {
            List metaYamlList = DataYamlLoader.loadTypeDefs(this.collectYamlsFromDir());
            Map<String, TypeDefBucket> typeDefBuckets = this.mergeEoDtoMetaYaml(metaYamlList);
            Map<String, ApiDefBucket> apiDefBuckets = this.mergeApiMetaYaml(metaYamlList);
            FodelBuilder buildFodel = new FodelBuilder();
            Map mapTypeFodel = buildFodel.convertTypeDef4ver3(typeDefBuckets);
            for (AbstractTypeFodel typeFodel : mapTypeFodel.values()) {
                this.log.info((CharSequence)("--- EO+DTO Def = " + JSON.toJSONString((Object)typeFodel)));
            }
            Map<String, ApiFodel> mapApiFodel = this.convertApiDef(apiDefBuckets, mapTypeFodel, buildFodel);
            this.rebuildMetaBasePackage(mapTypeFodel, mapApiFodel);
            ArrayList<String> filePathList = new ArrayList<String>();
            List<String> eoDtoFilePathList = this.dumpEoDtoJavaSourceFiles(mapTypeFodel);
            filePathList.addAll(eoDtoFilePathList);
            eoDtoFilePathList.clear();
            if (!CollectionUtils.isEmpty(mapApiFodel)) {
                List<String> mapperAndDasFilePathList = this.dumpMapperAndDasJavaSourceFiles(mapTypeFodel);
                filePathList.addAll(mapperAndDasFilePathList);
                mapperAndDasFilePathList.clear();
            }
            List<String> apiFilePathList = this.dumpApiJavaSourceFiles(mapApiFodel);
            filePathList.addAll(apiFilePathList);
            apiFilePathList.clear();
            Map eoApiMergeFodelMap = buildFodel.mergeEoApi(mapApiFodel);
            List<String> serviceFilePathList = this.dumpServiceAndRestJavaSourceFiles(eoApiMergeFodelMap);
            filePathList.addAll(serviceFilePathList);
            serviceFilePathList.clear();
            this.log.info((CharSequence)("generator files:" + filePathList));
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private List<FileLocation> collectYamlsFromDir() {
        String apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
        String strXmetaFolder = this.mavenProject.getBasedir().getParentFile().getAbsolutePath() + MetaConsts.FS + apiArtifactId + MetaConsts.FS + MetaConsts.META_DIR;
        return FileUtils.scanFilesBySuffix((String)strXmetaFolder, (String)apiArtifactId, (String)".paas.yaml");
    }

    public List<String> dumpEoDtoJavaSourceFiles(Map<String, AbstractTypeFodel> mapTypeFodel) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (AbstractTypeFodel typeFodel : mapTypeFodel.values()) {
            String dtoFullPath;
            String apiArtifactId;
            String filePath;
            String objectType = typeFodel.getObjectType().getValue();
            if (ObjectType.EO.getValue().equals(objectType)) {
                String eoArtifactId;
                EoFodel eoFodel = (EoFodel)typeFodel;
                if (StringUtils.isNotBlank((CharSequence)eoFodel.getTable())) {
                    eoArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.EO);
                    String eoFullPath = this.buildEoDtoFullPath(parentBasePath + File.separator + eoArtifactId, typeFodel);
                    filePath = this.dumpJavaSourceFile(typeFodel, "eo3.ftl", eoFullPath);
                    if (filePath == null) continue;
                    fileFullPathList.add(filePath);
                    continue;
                }
                eoArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.EO);
                String extEoFullPath = this.buildExtEoDtoFullPath(parentBasePath + File.separator + eoArtifactId, typeFodel);
                filePath = this.dumpJavaSourceFile(typeFodel, "exteo.ftl", extEoFullPath);
                if (filePath == null) continue;
                fileFullPathList.add(filePath);
                continue;
            }
            if (!ObjectType.DTO.getValue().equals(objectType)) continue;
            DtoFodel dtoFodel = (DtoFodel)typeFodel;
            if (!dtoFodel.isAppend().booleanValue()) {
                List idAttrs;
                apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
                dtoFullPath = this.buildEoDtoFullPath(parentBasePath + File.separator + apiArtifactId, typeFodel);
                if (!((DtoFodel)typeFodel).getSkipAttrAutoAppend().booleanValue() && org.apache.commons.collections.CollectionUtils.isEmpty(idAttrs = typeFodel.getAttrs().stream().filter(attr -> attr.getCode().equals("id")).collect(Collectors.toList()))) {
                    DtoAttrFodel fodel = new DtoAttrFodel();
                    fodel.setCode("id");
                    fodel.setName("id");
                    fodel.setType("Long");
                    typeFodel.getAttrs().add(0, fodel);
                }
                if ((filePath = this.dumpJavaSourceFile(typeFodel, "dto3.ftl", dtoFullPath)) == null) continue;
                fileFullPathList.add(filePath);
                continue;
            }
            apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
            dtoFullPath = this.buildExtEoDtoFullPath(parentBasePath + File.separator + apiArtifactId, typeFodel);
            filePath = this.dumpJavaSourceFile(typeFodel, "extdto.ftl", dtoFullPath);
            if (filePath == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }

    public List<String> dumpMapperAndDasJavaSourceFiles(Map<String, AbstractTypeFodel> mapTypeFodel) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (AbstractTypeFodel typeFodel : mapTypeFodel.values()) {
            String dasFullPath;
            EoFodel eoFodel;
            String objectType = typeFodel.getObjectType().getValue();
            if (!ObjectType.EO.getValue().equals(objectType) || !StringUtils.isNotBlank((CharSequence)(eoFodel = (EoFodel)typeFodel).getTable())) continue;
            String daoArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.DAO);
            String mapperFullPath = this.buildMapperFullPath(parentBasePath + File.separator + daoArtifactId, typeFodel);
            String filePath = this.dumpJavaSourceFile(typeFodel, "mapper3.ftl", mapperFullPath);
            if (filePath != null) {
                fileFullPathList.add(filePath);
            }
            if ((filePath = this.dumpJavaSourceFile(typeFodel, "das3.ftl", dasFullPath = this.buildDasFullPath(parentBasePath + File.separator + daoArtifactId, typeFodel))) == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }

    public List<String> dumpServiceAndRestJavaSourceFiles(Map<String, EoApiMergeFodel> eoApiMergeFodelMap) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (EoApiMergeFodel eoApiMergeFodel : eoApiMergeFodelMap.values()) {
            String serviceImplFilePath;
            String bizArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.BIZ);
            String serviceFilePath = this.buildIServiceFullPath(parentBasePath + File.separator + bizArtifactId, eoApiMergeFodel);
            String filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "iservice3.ftl", serviceFilePath);
            if (filePath != null) {
                fileFullPathList.add(filePath);
            }
            if ((filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "serviceImpl3.ftl", serviceImplFilePath = this.buildServiceImplFullPath(parentBasePath + File.separator + bizArtifactId, eoApiMergeFodel))) != null) {
                fileFullPathList.add(filePath);
            }
            String serviceArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.SERVICE);
            String restFilePath = this.buildRestFullPath(parentBasePath + File.separator + serviceArtifactId, eoApiMergeFodel);
            filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "rest3.ftl", restFilePath);
            if (filePath == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }
}

