/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.rase.mojo.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.meta.annotation.ModuleType;
import com.dtyunxi.huieryun.meta.annotation.ObjectType;
import com.dtyunxi.huieryun.xmeta.fodel.AbstractTypeFodel;
import com.dtyunxi.huieryun.xmeta.fodel.ApiFodel;
import com.dtyunxi.huieryun.xmeta.fodel.FodelBuilder;
import com.dtyunxi.huieryun.xmeta.mojo.MetaConsts;
import com.dtyunxi.huieryun.xmeta.mojo.util.ModuleUtils;
import com.dtyunxi.huieryun.xmeta.rase.fodel.EoApiMergeFodel;
import com.dtyunxi.huieryun.xmeta.rase.mojo.AbstractGenJava;
import com.dtyunxi.huieryun.xmeta.rase.mojo.IGenDoJava;
import com.dtyunxi.huieryun.xmeta.rase.yaml.ApiDefBucket;
import com.dtyunxi.huieryun.xmeta.rase.yaml.DataYamlLoader;
import com.dtyunxi.huieryun.xmeta.util.FileLocation;
import com.dtyunxi.huieryun.xmeta.util.FileUtils;
import com.dtyunxi.huieryun.xmeta.util.ZipFileReader;
import com.dtyunxi.huieryun.xmeta.yaml.TypeDefBucket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.CollectionUtils;

public class GenJava4Ver5
extends AbstractGenJava
implements IGenDoJava {
    public GenJava4Ver5(String projectCode, MavenProject mavenProject, Log log) {
        super(projectCode, mavenProject, log);
    }

    @Override
    public void execute() throws IOException {
        try {
            List metaYamlList = DataYamlLoader.loadTypeDefs(this.collectYamlsFromDir());
            List apiMetaYamlList = DataYamlLoader.loadTypeDefs(this.collectApiYamlsFromDir());
            metaYamlList.addAll(apiMetaYamlList);
            Map<String, TypeDefBucket> typeDefBuckets = this.mergeEoDtoMetaYaml(metaYamlList);
            Map<String, ApiDefBucket> apiDefBuckets = this.mergeApiMetaYaml(metaYamlList);
            FodelBuilder buildFodel = new FodelBuilder();
            Map mapTypeFodel = buildFodel.convertTypeDef4ver5(typeDefBuckets);
            for (AbstractTypeFodel typeFodel : mapTypeFodel.values()) {
                this.log.info((CharSequence)("--- EO+DTO Def = " + JSON.toJSONString((Object)typeFodel)));
            }
            Map<String, ApiFodel> mapApiFodel = this.convertApiDef(apiDefBuckets, mapTypeFodel, buildFodel);
            this.rebuildMetaBasePackage(mapTypeFodel, mapApiFodel);
            ArrayList<String> filePathList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(mapApiFodel)) {
                List<String> eoDtoFilePathList = this.dumpMapperAndDasJavaSourceFiles(mapTypeFodel);
                filePathList.addAll(eoDtoFilePathList);
                eoDtoFilePathList.clear();
            }
            List<String> apiFilePathList = this.dumpApiJavaSourceFiles(mapApiFodel);
            filePathList.addAll(apiFilePathList);
            apiFilePathList.clear();
            Map eoApiMergeFodelMap = buildFodel.mergeEoApi(mapApiFodel);
            List<String> serviceFilePathList = this.dumpServiceAndRestJavaSourceFiles(eoApiMergeFodelMap);
            filePathList.addAll(serviceFilePathList);
            serviceFilePathList.clear();
            this.log.info((CharSequence)("generator files:" + filePathList));
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private List<FileLocation> collectYamlsFromDir() {
        String apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
        String strXmetaFolder = this.mavenProject.getBasedir().getParentFile().getAbsolutePath() + MetaConsts.FS + apiArtifactId + MetaConsts.FS + MetaConsts.META_DIR;
        return FileUtils.scanFilesBySuffix((String)strXmetaFolder, (String)apiArtifactId, (String)".xmeta.yaml");
    }

    private List<FileLocation> collectApiYamlsFromDir() {
        String apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
        String strXmetaFolder = this.mavenProject.getBasedir().getParentFile().getAbsolutePath() + MetaConsts.FS + apiArtifactId + MetaConsts.FS + MetaConsts.META_DIR;
        return FileUtils.scanFilesBySuffix((String)strXmetaFolder, (String)apiArtifactId, (String)".paas.yaml");
    }

    public List<String> dumpMapperAndDasJavaSourceFiles(Map<String, AbstractTypeFodel> mapTypeFodel) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (AbstractTypeFodel typeFodel : mapTypeFodel.values()) {
            String dasFullPath;
            String objectType = typeFodel.getObjectType().getValue();
            if (!ObjectType.EO.getValue().equals(objectType)) continue;
            String bizArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.BIZ);
            String mapperFullPath = this.buildMapperFullPath(parentBasePath + File.separator + bizArtifactId, typeFodel);
            String filePath = this.dumpJavaSourceFile(typeFodel, "mapper.ftl", mapperFullPath);
            if (filePath != null) {
                fileFullPathList.add(filePath);
            }
            if ((filePath = this.dumpJavaSourceFile(typeFodel, "das.ftl", dasFullPath = this.buildDasFullPath(parentBasePath + File.separator + bizArtifactId, typeFodel))) == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }

    @Override
    public List<String> dumpApiJavaSourceFiles(Map<String, ApiFodel> mapApiFodel) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (ApiFodel apiFodel : mapApiFodel.values()) {
            String apiArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.API);
            String apiFullPath = this.buildIApiFullPath(parentBasePath + File.separator + apiArtifactId, apiFodel);
            String filePath = this.dumpJavaSourceFile(apiFodel, "iapi.ftl", apiFullPath);
            if (filePath != null) {
                fileFullPathList.add(filePath);
            }
            String bizArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.BIZ);
            String apiImplFilePath = this.buildApiImplFullPath(parentBasePath + File.separator + bizArtifactId, apiFodel);
            filePath = this.dumpJavaSourceFile(apiFodel, "apiImpl.ftl", apiImplFilePath);
            if (filePath == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }

    public List<String> dumpServiceAndRestJavaSourceFiles(Map<String, EoApiMergeFodel> eoApiMergeFodelMap) throws IOException {
        ArrayList<String> fileFullPathList = new ArrayList<String>();
        String parentBasePath = this.mavenProject.getParent().getBasedir().getAbsolutePath();
        for (EoApiMergeFodel eoApiMergeFodel : eoApiMergeFodelMap.values()) {
            String restFilePath;
            String dslFilePath;
            String serviceImplFilePath;
            String bizArtifactId = ModuleUtils.getChildModuleName((MavenProject)this.mavenProject.getParent(), (ModuleType)ModuleType.BIZ);
            String serviceFilePath = this.buildIServiceFullPath(parentBasePath + File.separator + bizArtifactId, eoApiMergeFodel);
            String filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "iservice.ftl", serviceFilePath);
            if (filePath != null) {
                fileFullPathList.add(filePath);
            }
            if ((filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "serviceImpl.ftl", serviceImplFilePath = this.buildServiceImplFullPath(parentBasePath + File.separator + bizArtifactId, eoApiMergeFodel))) != null) {
                fileFullPathList.add(filePath);
            }
            if ((filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "dsl.ftl", dslFilePath = this.buildDslFullPath(parentBasePath + File.separator + bizArtifactId, eoApiMergeFodel))) != null) {
                fileFullPathList.add(filePath);
            }
            if ((filePath = this.dumpJavaSourceFile(eoApiMergeFodel, "rest.ftl", restFilePath = this.buildRestFullPath(parentBasePath + File.separator + bizArtifactId, eoApiMergeFodel))) == null) continue;
            fileFullPathList.add(filePath);
        }
        return fileFullPathList;
    }

    private List<FileLocation> collectXmetaYamlsFromDependencies(List<Artifact> dependencyApiJars) throws IOException {
        ArrayList<FileLocation> xmetaFileLocations = new ArrayList<FileLocation>(64);
        for (Artifact artifact : dependencyApiJars) {
            String strJarFile = artifact.getFile().getAbsolutePath();
            String zipFileShortName = artifact.getArtifactId();
            if (!strJarFile.endsWith(".jar")) continue;
            List yamlFileLocations = ZipFileReader.scanEntriesBySuffix((String)zipFileShortName, (String)strJarFile, (String)".xmeta.yaml");
            for (FileLocation fileLocation : yamlFileLocations) {
                if (!fileLocation.getFilePath().startsWith("xmeta")) continue;
                xmetaFileLocations.add(fileLocation);
            }
            yamlFileLocations.clear();
        }
        return xmetaFileLocations;
    }

    @Override
    public String buildRestFullPath(String baseDir, EoApiMergeFodel eoApiMergeFodel) {
        String packageStr = eoApiMergeFodel.getBasePackage() + ".rest.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(MetaConsts.FS).append(packageStr.replace(".", MetaConsts.FS)).append(eoApiMergeFodel.getEntityName()).append("Rest.java").toString();
        String fullPath = baseDir + MetaConsts.FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildApiImplFullPath(String baseDir, ApiFodel apiFodel) {
        String packageStr = apiFodel.getBasePackage() + ".apiimpl.";
        if (apiFodel.getClazz().contains(".query.")) {
            packageStr = packageStr + "query.";
        }
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(MetaConsts.FS).append(packageStr.replace(".", MetaConsts.FS)).append(apiFodel.getApiName().substring(1)).append("Impl.java").toString();
        String fullPath = baseDir + MetaConsts.FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildMapperFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String packageStr = typeFodel.getBasePackage() + ".biz.mapper.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(MetaConsts.FS).append(packageStr.replace(".", MetaConsts.FS)).append(typeFodel.getEntityName()).append("Mapper.java").toString();
        String fullPath = baseDir + MetaConsts.FS + relativePath;
        return fullPath;
    }

    @Override
    public String buildDasFullPath(String baseDir, AbstractTypeFodel typeFodel) {
        String packageStr = typeFodel.getBasePackage() + ".biz.das.";
        String relativePath = new StringBuffer(MetaConsts.SRC_MAIN_JAVA).append(MetaConsts.FS).append(packageStr.replace(".", MetaConsts.FS)).append(typeFodel.getEntityName()).append("Das.java").toString();
        String fullPath = baseDir + MetaConsts.FS + relativePath;
        return fullPath;
    }
}

