/**
 * @(#)${entityName}Dsl.java 1.0
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ${basePackage}.biz.dsl;


import ${basePackage}.biz.das.${entityName}Das;
import ${eoClazz};
<#list typeImports as oneImport>
import ${oneImport};
</#list>
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.cube.commons.dto.ObjectConvertor;
import com.github.pagehelper.PageHelper;
import javax.annotation.Resource;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.dtyunxi.huieryun.rase.annotation.RaseObject;
import com.dtyunxi.huieryun.rase.annotation.RaseObjectType;

/**
* ${eoRemark} 领域服务实现类
*
* @author YUNXI.xOne
*/
@Service
@RaseObject(type = RaseObjectType.DSL)
public class ${entityName}Dsl {

    @Resource
    private ${entityName}Das ${entityName?uncap_first}Das;

<#list apiFodels as oneApiFodel>
  <#list oneApiFodel.methods as oneMethod>
    /**
     * ${oneMethod.descr!''}
     *
    <#if oneMethod.requestParams??>
      <#list oneMethod.requestParams as reqParam>
     * @param ${reqParam.name} ${reqParam.descr}
      </#list>
    </#if>
     * @return
     */
    public <#if oneMethod.respTypeName == 'Void'>void<#else>${oneMethod.respTypeName}</#if> ${oneMethod.code}(<#if oneMethod.requestParams??><#list oneMethod.requestParams as reqParam><#if (reqParam_index > 0)>, </#if>${reqParam.typeName}<#assign reqDto="${reqParam.name}" /> ${reqParam.name}</#list></#if>) {
      <#if oneMethod.code=='add'>
        ${entityName}Eo ${entityName?uncap_first}Eo = ObjectConvertor.convert(${reqDto}, ${entityName}Eo.class);
        ${entityName?uncap_first}Das.insert(${entityName?uncap_first}Eo);
        return ${entityName?uncap_first}Eo.getId();
      <#elseif oneMethod.code=='modify'>
        ${entityName}Eo ${entityName?uncap_first}Eo = ObjectConvertor.convert(${reqDto}, ${entityName}Eo.class);
        ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
      <#elseif oneMethod.code=='save'>
        ${entityName}Eo ${entityName?uncap_first}Eo = ObjectConvertor.convert(${reqDto}, ${entityName}Eo.class);
        if(${reqDto}.getId() == null) {
            ${entityName?uncap_first}Das.insert(${entityName?uncap_first}Eo);
            return ${entityName?uncap_first}Eo.getId();
        }else {
            ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
            return ${reqDto}.getId();
        }
      <#elseif oneMethod.code=='remove'>
        ${entityName?uncap_first}Das.logicDeleteById(${reqDto});
      <#elseif oneMethod.code=='batchAdd'>
        List<${entityName}Eo> eoList = ObjectConvertor.convertObjects(${reqDto}, ${entityName}Eo.class);
        ${entityName?uncap_first}Das.insertBatch(eoList);
      <#elseif oneMethod.code=='batchModify'>
        for (${oneMethod.requestParams[0].generics[0].typeName} modifyreqDto : ${reqDto}) {
            ${entityName}Eo ${entityName?uncap_first}Eo = ObjectConvertor.convert(modifyreqDto, ${entityName}Eo.class);
            ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
        }
      <#elseif oneMethod.code=='batchSave'>
        for (${oneMethod.requestParams[0].generics[0].typeName} saveReqDto : ${reqDto}) {
            ${entityName}Eo ${entityName?uncap_first}Eo = ObjectConvertor.convert(saveReqDto, ${entityName}Eo.class);
            if(saveReqDto.getId() == null) {
                ${entityName?uncap_first}Das.insert(${entityName?uncap_first}Eo);
            }else {
                ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
            }
        }
      <#elseif oneMethod.code=='batchRemove'>
        ${entityName?uncap_first}Das.logicDeleteByIds(${reqDto});
      <#elseif oneMethod.code=='enable'>
        ${entityName}Eo selectEo = ${entityName?uncap_first}Das.selectByPrimaryKey(${reqDto});
        if (selectEo == null) {
            throw new BusinessRuntimeException(BusinessRuntimeException.RECORD_NOTEXIST, "数据不存在，id = " + ${reqDto});
        }
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        ${entityName?uncap_first}Eo.setId(${reqDto});
        ${entityName?uncap_first}Eo.setStatus(new Integer(1));
        ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
      <#elseif oneMethod.code=='disable'>
        ${entityName}Eo selectEo = ${entityName?uncap_first}Das.selectByPrimaryKey(${reqDto});
        if (selectEo == null) {
            throw new BusinessRuntimeException(BusinessRuntimeException.RECORD_NOTEXIST, "数据不存在，id = " + ${reqDto});
        }
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        ${entityName?uncap_first}Eo.setId(${reqDto});
        ${entityName?uncap_first}Eo.setStatus(new Integer(2));
        ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
      <#elseif oneMethod.code=='queryById'>
        ${entityName}Eo ${entityName?uncap_first}Eo = ${entityName?uncap_first}Das.selectByPrimaryKey(${reqDto});
        ${oneMethod.respTypeName} ${oneMethod.respTypeName?uncap_first} = ObjectConvertor.convert(${entityName?uncap_first}Eo, ${oneMethod.respTypeName}.class);
        return ${oneMethod.respTypeName?uncap_first};
      <#elseif oneMethod.code=='queryByIds'>
        if(CollectionUtils.isEmpty(${reqDto})) {
            return Lists.newArrayList();
        }
        List<${entityName}Eo> ${entityName?uncap_first}Eos = ${entityName?uncap_first}Das.selectByIds(${reqDto});
        ${oneMethod.respTypeName} dtos = ObjectConvertor.convertObjects(${entityName?uncap_first}Eos, ${oneMethod.generics[0].typeName}.class);
        return dtos;
      <#elseif oneMethod.code=='queryByPage' || oneMethod.code=='pageQueryByCond'>
        ${entityName}Eo queryEo = ObjectConvertor.convert(${oneMethod.requestParams[0].name}, ${entityName}Eo.class);
        PageInfo<${entityName}Eo> eoPageInfo = ${entityName?uncap_first}Das.selectPage(queryEo, pageNum, pageSize);
        PageInfo<${oneMethod.generics[0].typeName}> pageInfo = ObjectConvertor.convertPageInfo(eoPageInfo, ${oneMethod.generics[0].typeName}.class);
        return pageInfo;
      <#elseif oneMethod.code=='pageQueryByIds'>
        PageInfo<${entityName}Eo> eoPageInfo = ${entityName?uncap_first}Das.filter().in("id", ${oneMethod.requestParams[0].name}).page(pageNum, pageSize);
        PageInfo<${oneMethod.generics[0].typeName}> dtoPageInfo = ObjectConvertor.convertPageInfo(eoPageInfo, ${oneMethod.generics[0].typeName}.class);
        return dtoPageInfo;
      </#if>
    }

  </#list>

</#list>

}
