/**
 * @(#)${apiName}.java 1.0 
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ${apiPackage};

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;
import com.dtyunxi.huieryun.rase.annotation.RaseObject;
import com.dtyunxi.huieryun.rase.annotation.RaseObjectType;
<#list typeImports as oneImport>
import ${oneImport};
</#list>


/**
* ${groupName}
*
* @author YUNXI.xOne
*/
@Api(tags = {"${groupName}"})
@FeignClient(
        contextId="${contextId}",
        name = "${feignName}",
        path = "${path}",
        url = "${feignUrl}"
)
@RaseObject(type = RaseObjectType.API)
public interface ${apiName} {
<#if methods??>
  <#list methods as oneMethod>
    /**
     * ${oneMethod.descr!''}
     *
  <#if oneMethod.requestParams??>
    <#list oneMethod.requestParams as reqParam>
     * @param ${reqParam.name} ${reqParam.descr}
    </#list>
  </#if>
     * @return 
     */
    ${oneMethod.httpMethodAnno}("${oneMethod.path!''}")
    @ApiOperation(value = "${oneMethod.name}", notes = "${oneMethod.descr}")
    RestResponse<${oneMethod.respTypeName}> ${oneMethod.code}(<#if oneMethod.requestParams??><#list oneMethod.requestParams as reqParam><#if (reqParam_index > 0)>, </#if>${reqParam.paramType}<#if reqParam.paramType != '@RequestBody' && reqParam.paramType != '@SpringQueryMap' && reqParam.required??>(name = "${reqParam.name}", required = ${reqParam.required?string("true","false")}<#if reqParam.defaultValue??>, defaultValue = "${reqParam.defaultValue}"</#if>)</#if> ${reqParam.typeName} ${reqParam.name}</#list></#if>);

</#list>
</#if>
}
