/**
 * @(#)${entityName}ServiceImpl.java 1.0
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ${basePackage}.biz.service.impl;

import org.springframework.stereotype.Service;
import ${basePackage}.biz.service.I${entityName}Service;
import ${basePackage}.dao.das.${entityName}Das;
import ${eoClazz};
<#list typeImports as oneImport>
import ${oneImport};
</#list>
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import java.util.ArrayList;
import java.util.List;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import com.dtyunxi.huieryun.rase.annotation.RaseObject;
import com.dtyunxi.huieryun.rase.annotation.RaseObjectType;

/**
* ${eoRemark}服务实现类
*
* @author YUNXI.xOne
*/
@Service
@RaseObject(type = RaseObjectType.SERVICEIMPL)
public class ${entityName}ServiceImpl implements I${entityName}Service {

    @Resource
    private ${entityName}Das ${entityName?uncap_first}Das;

<#list apiFodels as oneApiFodel>
  <#list oneApiFodel.methods as oneMethod>
    /**
     * ${oneMethod.descr!''}
     *
    <#if oneMethod.requestParams??>
      <#list oneMethod.requestParams as reqParam>
     * @param ${reqParam.name} ${reqParam.descr}
      </#list>
    </#if>
     * @return
     */
    @Override
    <#if oneMethod.code=='add' || oneMethod.code=='modify' || oneMethod.code=='remove' || oneMethod.code=='save' || oneMethod.code=='batchAdd' || oneMethod.code=='batchModify' || oneMethod.code=='batchSave' || oneMethod.code=='batchRemove'>
    @Transactional(rollbackFor = Exception.class)
    </#if>
    public <#if oneMethod.respTypeName == 'Void'>void<#else>${oneMethod.respTypeName}</#if> ${oneMethod.code}(<#if oneMethod.requestParams??><#list oneMethod.requestParams as reqParam><#if (reqParam_index > 0)>, </#if>${reqParam.typeName}<#assign reqDto="${reqParam.name}" /> ${reqParam.name}</#list></#if>) {
      <#if oneMethod.code=='add'>
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        DtoHelper.dto2Eo(${reqDto}, ${entityName?uncap_first}Eo);
        ${entityName?uncap_first}Das.insert(${entityName?uncap_first}Eo);
        return ${entityName?uncap_first}Eo.getId();
      <#elseif oneMethod.code=='modify'>
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        DtoHelper.dto2Eo(${reqDto}, ${entityName?uncap_first}Eo);
        ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
      <#elseif oneMethod.code=='save'>
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        DtoHelper.dto2Eo(${reqDto}, ${entityName?uncap_first}Eo);
        if(${reqDto}.getId() == null) {
            ${entityName?uncap_first}Das.insert(${entityName?uncap_first}Eo);
            return ${entityName?uncap_first}Eo.getId();
        }else {
            ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
            return ${reqDto}.getId();
        }
      <#elseif oneMethod.code=='remove'>
        ${entityName?uncap_first}Das.logicDeleteById(${reqDto});
      <#elseif oneMethod.code=='batchAdd'>
        List<${entityName}Eo> eoList = new ArrayList<>();
        DtoHelper.dtoList2EoList(${reqDto}, eoList, ${entityName}Eo.class);
        ${entityName?uncap_first}Das.insertBatch(eoList);
      <#elseif oneMethod.code=='batchModify'>
        for (${oneMethod.requestParams[0].generics[0].typeName} modifyreqDto : ${reqDto}) {
            ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
            DtoHelper.dto2Eo(modifyreqDto, ${entityName?uncap_first}Eo);
            ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
        }
      <#elseif oneMethod.code=='batchSave'>
        for (${oneMethod.requestParams[0].generics[0].typeName} modifyreqDto : ${reqDto}) {
            ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
            DtoHelper.dto2Eo(modifyreqDto, ${entityName?uncap_first}Eo);
            if(modifyreqDto.getId() == null) {
                ${entityName?uncap_first}Das.insert(${entityName?uncap_first}Eo);
            }else {
                ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
            }
        }
      <#elseif oneMethod.code=='batchRemove'>
        ${entityName?uncap_first}Das.logicDeleteByIds(${reqDto});
      <#elseif oneMethod.code=='enable'>
        ${entityName}Eo selectEo = ${entityName?uncap_first}Das.selectByPrimaryKey(${reqDto});
        if (selectEo == null) {
            throw new BusinessRuntimeException(BusinessRuntimeException.RECORD_NOTEXIST, "数据不存在，id = " + ${reqDto});
        }
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        ${entityName?uncap_first}Eo.setId(${reqDto});
        ${entityName?uncap_first}Eo.setStatus(new Integer(1));
        ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
      <#elseif oneMethod.code=='disable'>
        ${entityName}Eo selectEo = ${entityName?uncap_first}Das.selectByPrimaryKey(${reqDto});
        if (selectEo == null) {
            throw new BusinessRuntimeException(BusinessRuntimeException.RECORD_NOTEXIST, "数据不存在，id = " + ${reqDto});
        }
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        ${entityName?uncap_first}Eo.setId(${reqDto});
        ${entityName?uncap_first}Eo.setStatus(new Integer(2));
        ${entityName?uncap_first}Das.updateSelective(${entityName?uncap_first}Eo);
      <#elseif oneMethod.code=='queryById'>
        ${entityName}Eo ${entityName?uncap_first}Eo = ${entityName?uncap_first}Das.selectByPrimaryKey(${reqDto});
        ${oneMethod.respTypeName} ${oneMethod.respTypeName?uncap_first} = new ${oneMethod.respTypeName}();
        DtoHelper.eo2Dto(${entityName?uncap_first}Eo, ${oneMethod.respTypeName?uncap_first});
        return ${oneMethod.respTypeName?uncap_first};
      <#elseif oneMethod.code=='queryByIds'>
        if(CollectionUtils.isEmpty(${reqDto})) {
            return Lists.newArrayList();
        }
        List<SqlFilter> filters = Lists.newArrayList();
        filters.add(SqlFilter.in("id", StringUtils.join(${reqDto}, ",")));
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        ${entityName?uncap_first}Eo.setSqlFilters(filters);
        List<${entityName}Eo> results = ${entityName?uncap_first}Das.select(${entityName?uncap_first}Eo);
        ${oneMethod.respTypeName} dtos = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(results)) {
            DtoHelper.eoList2DtoList(results, dtos, ${oneMethod.generics[0].typeName}.class);
        }
        return dtos;
      <#elseif oneMethod.code=='queryByPage' || oneMethod.code=='pageQueryByCond'>
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        DtoHelper.dto2Eo(${oneMethod.requestParams[0].name}, ${entityName?uncap_first}Eo);
        PageInfo<${entityName}Eo> eoPageInfo = ${entityName?uncap_first}Das.selectPage(${entityName?uncap_first}Eo, pageNum, pageSize);

        ${oneMethod.respTypeName} dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties(dtoPageInfo, eoPageInfo, "list", "navigatepageNums");
        List<${oneMethod.generics[0].typeName}> dtoList = new ArrayList<>();
        DtoHelper.eoList2DtoList(eoPageInfo.getList(), dtoList, ${oneMethod.generics[0].typeName}.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
      <#elseif oneMethod.code=='pageQueryByIds'>
        List<SqlFilter> filters = Lists.newArrayList();
        filters.add(SqlFilter.in("id", StringUtils.join(${oneMethod.requestParams[0].name}, ",")));
        ${entityName}Eo ${entityName?uncap_first}Eo = new ${entityName}Eo();
        ${entityName?uncap_first}Eo.setSqlFilters(filters);
        PageInfo<${entityName}Eo> eoPageInfo = ${entityName?uncap_first}Das.selectPage(${entityName?uncap_first}Eo, pageNum, pageSize);
        ${oneMethod.respTypeName} dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties(dtoPageInfo, eoPageInfo, "list", "navigatepageNums");
        List<${oneMethod.generics[0].typeName}> dtoList = new ArrayList<>();
        DtoHelper.eoList2DtoList(eoPageInfo.getList(), dtoList, ${oneMethod.generics[0].typeName}.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
      </#if>
    }

  </#list>

</#list>

}
