/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.common.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class UrlWhiteList {
    private List<Pattern> wildcards = new ArrayList<Pattern>();
    private Map<String, Boolean> precisionMap = new HashMap<String, Boolean>();

    public List<Pattern> getWildcards() {
        return this.wildcards;
    }

    public Map<String, Boolean> getPrecisionMap() {
        return this.precisionMap;
    }

    public void init(List<String> apiPaths, String urlRegexPattern) {
        String URL_FRAGMENT_WILDCARD = urlRegexPattern == null || urlRegexPattern.isEmpty() ? "((/[a-zA-Z0-9-|_]+)*|(/\\{[a-zA-Z0-9-|_]+\\}))*" : urlRegexPattern;
        String MULTI_WILDCARD = "(" + URL_FRAGMENT_WILDCARD + ")+";
        for (String path : apiPaths) {
            if (path.indexOf("/**") >= 0) {
                path = path.replace("/**", MULTI_WILDCARD);
                path = path.replace("/*", URL_FRAGMENT_WILDCARD);
                this.wildcards.add(Pattern.compile(path));
                continue;
            }
            if (path.indexOf("/*") >= 0) {
                path = path.replace("/*", URL_FRAGMENT_WILDCARD);
                this.wildcards.add(Pattern.compile(path));
                continue;
            }
            this.precisionMap.put(path, true);
        }
    }

    public boolean isWhiteList(String url) {
        return this.precisionMap.containsKey(url) || this.wildcards.stream().anyMatch(pattern -> pattern.matcher(url).matches());
    }
}

