/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.common.utils;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.module.context.biz.ServiceContextUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextCommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextCommonUtils.class);

    public static String getLocalIp() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("\u83b7\u53d6\u672c\u673a\u57df\u540d\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            return "";
        }
    }

    public static boolean fillContextByHeader(String requestUrl, Map<String, String> headerMap, boolean trustHeaderApp) {
        ServiceContext context = ServiceContext.getContext();
        context.getAttachments().clear();
        String applicationKey = headerMap.get("Application-Key");
        String xRealHostname = headerMap.get("X-Real-Hostname");
        String referer = headerMap.get("Referer".toLowerCase());
        LOGGER.info("url={}, X-Real-Hostname={}, Application-Key={},referer={}", new Object[]{requestUrl, xRealHostname, applicationKey, referer});
        int count = 0;
        StringBuilder identityInfo = new StringBuilder("\u4f7f\u7528header\u900f\u4f20\u7684instance\u4fe1\u606f: ");
        for (String heeadName : ServiceContextUtil.PACKING_HEADERS) {
            String headValue = headerMap.get(heeadName);
            if (StrUtil.isBlank((CharSequence)headValue)) continue;
            if (ServiceContextUtil.IDENTITY_HEADERS.contains(heeadName)) {
                if (!trustHeaderApp) continue;
                if (count > 0) {
                    identityInfo.append(",");
                }
                identityInfo.append(heeadName);
                identityInfo.append("=");
                identityInfo.append(headValue);
                ++count;
            }
            ServiceContext.getContext().setAttachment(heeadName, headValue);
        }
        for (Map.Entry entry : headerMap.entrySet()) {
            if (StrUtil.isBlank((CharSequence)((CharSequence)entry.getKey())) || StrUtil.isBlank((CharSequence)((CharSequence)entry.getValue())) || !((String)entry.getKey()).startsWith("yes.req.cus.")) continue;
            ServiceContext.getContext().setAttachment((String)entry.getKey(), (String)entry.getValue());
        }
        if (trustHeaderApp) {
            LOGGER.info(identityInfo.toString());
            return count < 3;
        }
        return true;
    }
}

