/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.module.dao.das.PictureConfigDas;
import com.dtyunxi.icommerce.module.dao.eo.PictureConfigEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBPictureConfigService;
import com.dtyunxi.yundt.module.bitem.api.dto.response.PictureConfigRespDto;
import com.dtyunxi.yundt.module.bitem.api.enums.PictureConfigEnum;
import com.dtyunxi.yundt.module.bitem.biz.constants.PictureConfigConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BPictureConfigServiceImpl
implements IBPictureConfigService {
    private static Logger logger = LoggerFactory.getLogger(BPictureConfigServiceImpl.class);
    @Resource
    private PictureConfigDas das;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    public List<PictureConfigRespDto> queryPictureByType(String type) {
        PictureConfigEo eo = new PictureConfigEo();
        eo.setStatus(PictureConfigConstant.USE);
        eo.setType(PictureConfigEnum.getPictureConfigType((String)type));
        List list = this.das.select((BaseEo)eo);
        ArrayList dtoList = ListUtil.toList((Object[])new PictureConfigRespDto[0]);
        DtoHelper.eoList2DtoList((Collection)list, (Collection)dtoList, PictureConfigRespDto.class);
        return dtoList;
    }

    public List<PictureConfigRespDto> queryPictureByOrg(String type, Long organizationId) {
        if (Objects.isNull(organizationId)) {
            throw new BizException("\u53c2\u6570[organizationId]\u4e3a\u7a7a");
        }
        Long parentOrgId = this.getOrgParentId(organizationId);
        PictureConfigEo eo = new PictureConfigEo();
        eo.setStatus(PictureConfigConstant.USE);
        eo.setType(PictureConfigEnum.getPictureConfigType((String)type));
        eo.setOrganizationId(parentOrgId);
        logger.info("queryPictureByOrg==where:{}", (Object)JSON.toJSONString((Object)eo));
        List list = this.das.select((BaseEo)eo);
        ArrayList dtoList = ListUtil.toList((Object[])new PictureConfigRespDto[0]);
        DtoHelper.eoList2DtoList((Collection)list, (Collection)dtoList, PictureConfigRespDto.class);
        return dtoList;
    }

    private Long getOrgParentId(Long organizationId) {
        List merchantIds = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryUpperOrgIdsByOrgId(organizationId));
        if (CollectionUtils.isEmpty((Collection)merchantIds)) {
            return organizationId;
        }
        organizationId = (Long)merchantIds.get(0);
        return organizationId;
    }
}

