/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.CouponTemplateItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.TargetCustomerInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ExchangeItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponHierarchyEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponItemRange;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponMutexTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateGenerateTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplatePurposeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.GroupPurchaseTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBatchSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponSendTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateCreateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushErrorDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateBrandDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ReceiveRuleDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponTemplateExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.constant.UserConstant;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.ICouponTemplate;
import com.dtyunxi.yundt.module.marketing.api.common.CouponTemplateTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.CouponUseTimeTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.ConditionAmount;
import com.dtyunxi.yundt.module.marketing.api.dto.ConditionBrand;
import com.dtyunxi.yundt.module.marketing.api.dto.ConditionItem;
import com.dtyunxi.yundt.module.marketing.api.dto.CouponTemplateExtDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponGrantReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponReceiveRecordReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponTemplateExtQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponExtTobRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CustomerCouponRespDto;
import com.dtyunxi.yundt.module.marketing.api.enums.SelectTypeEnum;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.condition.exchange.ReceiveCondition;
import com.dtyunxi.yundt.module.marketing.biz.constant.CouponTemplateConstant;
import com.dtyunxi.yundt.module.marketing.biz.constant.MarketingConstant;
import com.dtyunxi.yundt.module.marketing.biz.enums.CollectionMethodEnum;
import com.dtyunxi.yundt.module.marketing.biz.enums.CouponRangeEnum;
import com.dtyunxi.yundt.module.marketing.biz.enums.CouponUseTypeEnum;
import com.dtyunxi.yundt.module.marketing.biz.enums.ItemRangeEnum;
import com.dtyunxi.yundt.module.marketing.biz.enums.MarketingModuleExcpCode;
import com.dtyunxi.yundt.module.marketing.biz.enums.QueryCouponTpStatusEnum;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.marketing.biz.impl.serializa.SerializeCouPonUseTimeValueDistribute;
import com.dtyunxi.yundt.module.marketing.biz.impl.validate.ValidateCouPonUseTimeParamDistribute;
import com.dtyunxi.yundt.module.marketing.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponTemplateImpl
implements ICouponTemplate {
    private static Logger logger = LoggerFactory.getLogger(CouponTemplateImpl.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    private ICouponTemplateExtApi couponTemplateExtApi;
    @Resource
    private ICouponTemplateExtQueryApi couponTemplateExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICouponExtApi couponExtApi;
    @Resource
    private ICouponExtQueryApi couponExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private IActivityApi activityApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IBitemService itemService;
    @Resource
    private IActivityService activityService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    public Long create(CouponTemplateTobDto couponTemplateTobDto) {
        this.validateParam(couponTemplateTobDto);
        CouponTemplateCreateExtReqDto createExtReqDto = this.getCouponTemplateCreateExtReqDto(couponTemplateTobDto);
        logger.info("\u65b0\u589e\u4f18\u60e0\u5238\u53c2\u6570\uff1a{}", (Object)ObjectHelper.bean2Json((Object)createExtReqDto));
        RestResponse restResponse = this.couponTemplateExtApi.addCouponTemplate(createExtReqDto);
        return (Long)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public void modify(CouponTemplateTobDto couponTemplateTobDto) {
        ActivityRespDto activityRespDto = (ActivityRespDto)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.queryActivityDetail(couponTemplateTobDto.getActivityId().longValue()));
        if (ActivityStatusEnum.READY.getKey().equals(activityRespDto.getActivityStatus()) || ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus())) {
            couponTemplateTobDto.setFirstActivityId(activityRespDto.getFirstActivityId());
            couponTemplateTobDto.setOriginalActivityId(couponTemplateTobDto.getActivityId());
            couponTemplateTobDto.setId(null);
            couponTemplateTobDto.setCouponCode(null);
            this.create(couponTemplateTobDto);
        } else {
            Assert.notNull((Object)couponTemplateTobDto.getId(), (String)"\u4f18\u60e0\u5238\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)couponTemplateTobDto.getCouponCode(), (String)"\u4f18\u60e0\u5238\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.validateParam(couponTemplateTobDto);
            CouponTemplateCreateExtReqDto createExtReqDto = this.getCouponTemplateCreateExtReqDto(couponTemplateTobDto);
            logger.info("\u4fee\u6539\u4f18\u60e0\u5238\u53c2\u6570\uff1a{}>>>{}", (Object)couponTemplateTobDto.getId(), (Object)ObjectHelper.bean2Json((Object)createExtReqDto));
            RestResponse restResponse = this.couponTemplateExtApi.modifyCouponTemplateById(couponTemplateTobDto.getId(), createExtReqDto);
            RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        }
    }

    public void delete(Long id) {
        Assert.notNull((Object)id, (String)"\u4f18\u60e0\u5238\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse restResponse = this.couponTemplateExtApi.delete(id);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public PageInfo<CouponRespDto> queryCustomerCouponPage(Long customerId, Long shopId, String couponName, Integer type, Integer pageNum, Integer pageSize) {
        CustomerCouponRespDto customerCouponRespDto = this.queryCustomerCouponList(customerId, shopId, couponName);
        CouponUseTypeEnum typeEnum = CouponUseTypeEnum.toCouponUseTypeEnum(type);
        List result = ListUtil.toList((Object[])new CouponRespDto[0]);
        if (ObjectUtil.isNotEmpty((Object)((Object)typeEnum))) {
            switch (typeEnum) {
                case USABLE: {
                    result = customerCouponRespDto.getNormalCouponList();
                    break;
                }
                case USED: {
                    result = customerCouponRespDto.getUsedCouponList();
                    break;
                }
                case EXPIRED: {
                    result = customerCouponRespDto.getExpiredCouponList();
                }
            }
        }
        PageInfo pageInfo = new PageInfo();
        int startPage = (pageNum - 1) * pageSize + 1;
        ArrayList respDtoList = new ArrayList(pageSize);
        for (int i = startPage; i <= pageNum * pageSize; ++i) {
            if (result.size() < i || i - 1 < 0) continue;
            respDtoList.add(result.get(i - 1));
        }
        pageInfo.setList(respDtoList);
        pageInfo.setTotal((long)result.size());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPageNum(pageNum.intValue());
        return pageInfo;
    }

    private CouponTemplateCreateExtReqDto getCouponTemplateCreateExtReqDto(CouponTemplateTobDto couponTemplateTobDto) {
        Long sellerId = null;
        Integer roleType = this.marketingModuleHelper.getRoleType();
        if (UserConstant.MERCHANT.equals(roleType)) {
            sellerId = this.marketingModuleHelper.getSellerId();
        }
        List<ActionReqDto> actionList = this.getActionList();
        List<ConditionReqDto> conditionList = this.getConditionList(couponTemplateTobDto);
        if (StringUtils.isEmpty((CharSequence)couponTemplateTobDto.getCouponCode())) {
            String couponCode = this.marketingModuleHelper.generateCode("YHQ");
            couponTemplateTobDto.setCouponCode(couponCode);
        }
        CouponTemplateCreateExtReqDto createExtReqDto = new CouponTemplateCreateExtReqDto();
        SerializeCouPonUseTimeValueDistribute.serialize(couponTemplateTobDto);
        CubeBeanUtils.copyProperties((Object)createExtReqDto, (Object)couponTemplateTobDto, (String[])new String[0]);
        createExtReqDto.setCouponCode(couponTemplateTobDto.getCouponCode());
        createExtReqDto.setActivityStatusEnum(ActivityStatusEnum.NEW);
        createExtReqDto.setMarketingCode("");
        createExtReqDto.setConditions(conditionList);
        createExtReqDto.setActions(actionList);
        createExtReqDto.setActivityTemplateId(MarketingConstant.ACTIVITY_TP_ID);
        createExtReqDto.setAuditStatusEnum(AuditStatusEnum.WAIT_AUDIT);
        createExtReqDto.setCouponTemplateStatus(CouponTemplateStatusEnum.CREATE.getStatus());
        createExtReqDto.setIsGenerateCode(CouponTemplateGenerateTypeEnum.IS_NOT_GENERATE.getType());
        createExtReqDto.setIsGroupPurchase(GroupPurchaseTypeEnum.IS_NOT_GROUP.getType());
        createExtReqDto.setIsStoreMutex(Integer.valueOf(0));
        createExtReqDto.setIsDirectional(Integer.valueOf(0));
        createExtReqDto.setSellerId(sellerId);
        createExtReqDto.setShopId(couponTemplateTobDto.getShopId());
        if (Objects.nonNull(couponTemplateTobDto.getShopId())) {
            RestResponse shopDtoRestResponse = this.shopExtQueryApi.queryBaseById(couponTemplateTobDto.getShopId());
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)shopDtoRestResponse);
            if (shopDto == null) {
                throw new BizException("\u9009\u62e9\u5e97\u94fa\u5df2\u88ab\u7981\u7528\u6216\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
            }
            createExtReqDto.setOrganizationId(shopDto.getOrganizationId());
            createExtReqDto.setOrganizationName(shopDto.getOrganizationName());
        }
        if (CouponItemRange.SHOP.getKey().equals(couponTemplateTobDto.getItemRange())) {
            createExtReqDto.setShopType(CouponTemplateShopTypeEnum.CUSTOM_SHOP.getType());
        } else {
            createExtReqDto.setShopType(CouponTemplateShopTypeEnum.ALL_SHOP.getType());
        }
        if (CollectionMethodEnum.PRIVATE.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
            createExtReqDto.setCouponType(CouponTypeEnum.COUPON_PUSHED.getType());
        } else {
            createExtReqDto.setCouponType(CouponTypeEnum.COUPON.getType());
        }
        if (CouponCategoryEnum.EXTRACT.getCategory().equals(couponTemplateTobDto.getCouponCategory())) {
            createExtReqDto.setCouponRange(CouponRangeEnum.SELLER.getKey());
        }
        createExtReqDto.setHierarchy(CouponHierarchyEnum.GENERAL.getHierarchy());
        createExtReqDto.setMutexType(CouponMutexTypeEnum.NO_MUTEX.getMutex());
        createExtReqDto.setPurpose(CouponTemplatePurposeEnum.OTHER.getPurpose());
        createExtReqDto.setGroupPurchasePrice(BigDecimal.ZERO);
        createExtReqDto.setInstanceId(this.context.instanceId());
        createExtReqDto.setTenantId(this.context.tenantId());
        createExtReqDto.setEffectiveTime(couponTemplateTobDto.getCouponUseBeginTime());
        createExtReqDto.setInvalidTime(couponTemplateTobDto.getCouponUseEndTime());
        CouponTemplateExtDto extension = new CouponTemplateExtDto();
        BeanUtils.copyProperties((Object)couponTemplateTobDto, (Object)extension);
        createExtReqDto.setExtFields(ObjectHelper.bean2Map((Object)extension));
        ArrayList activityRelations = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)activityRelations, (Collection)couponTemplateTobDto.getActivityRelations(), ActivityRelationReqDto.class);
        createExtReqDto.setActivityRelations((List)activityRelations);
        return createExtReqDto;
    }

    private void validateParam(CouponTemplateTobDto couponTemplateTobDto) {
        ValidateCouPonUseTimeParamDistribute.validateParam(couponTemplateTobDto);
        if (ItemRangeEnum.SHOP.getKey().equals(couponTemplateTobDto.getItemRange())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getShopIdList())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.SHOP_NOT_EMPTY);
            }
        } else if (ItemRangeEnum.CATEGORY.getKey().equals(couponTemplateTobDto.getItemRange())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getDirIdList()) && CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getBrandIdList()) && CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getBlackItems())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.DIT_OR_BRAND_NOT_EMPTY);
            }
        } else if (ItemRangeEnum.ITEM.getKey().equals(couponTemplateTobDto.getItemRange())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getCouponItems())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.ITEM_NOT_EMPTY);
            }
            couponTemplateTobDto.getCouponItems().forEach(couponItemDto -> {
                if (null == couponItemDto.getShopId()) {
                    BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.ITEM_SHOP_ID_NOT_EMPTY);
                }
            });
        }
        if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
            if (couponTemplateTobDto.getReceiveStartTime().after(couponTemplateTobDto.getReceiveEndTime())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_TIME_INVALID);
            }
            if (new Date().compareTo(couponTemplateTobDto.getReceiveEndTime()) > -1) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_END_TIME_GT_NOW_TIME);
            }
        }
        if (CouponCategoryEnum.DISCOUNT.getCategory().equals(couponTemplateTobDto.getCouponCategory()) && (couponTemplateTobDto.getCouponValue().compareTo(BigDecimal.ONE) < 0 || couponTemplateTobDto.getCouponValue().compareTo(BigDecimal.TEN) >= 0)) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.DISCOUNT_VALUE_INVALID);
        }
        if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
            if (null == couponTemplateTobDto.getLimitNum() || null == couponTemplateTobDto.getDailyLimitNum()) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.LIMIT_NUM_NOT_EMPTY);
            }
            if ((long)couponTemplateTobDto.getLimitNum().intValue() > couponTemplateTobDto.getTotalIssueQuantity()) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.LIMIT_NUM_INVALID);
            }
            if ((long)couponTemplateTobDto.getDailyLimitNum().intValue() > couponTemplateTobDto.getTotalIssueQuantity()) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.DAILY_LIMIT_NUM_INVALID);
            }
        }
        if (CouponCategoryEnum.EXTRACT.getCategory().equals(couponTemplateTobDto.getCouponCategory())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getExchangeItems())) {
                throw new BizException("\u5151\u6362\u5546\u54c1\u4e0d\u80fd\u4e0d\u7a7a");
            }
            couponTemplateTobDto.getExchangeItems().forEach(item -> {
                if (CollectionUtils.isEmpty((Collection)item.getSkus())) {
                    throw new BizException("\u5151\u6362\u5546\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                item.getSkus().forEach(sku -> {
                    if (null == sku.getSkuId()) {
                        throw new BizException("\u5151\u6362\u5546\u54c1\u89c4\u683cID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            });
            Set shopIds = couponTemplateTobDto.getExchangeItems().stream().map(CouponItemDto::getShopId).collect(Collectors.toSet());
            if (shopIds.size() > 1) {
                throw new BizException("\u5151\u6362\u5546\u54c1\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u5e97\u94fa\u4e0b\u7684\u5546\u54c1");
            }
        }
    }

    private List<ActionReqDto> getActionList() {
        ArrayList actionList = Lists.newArrayList();
        ActionReqDto receiveAction = new ActionReqDto();
        receiveAction.setActionParams("{}");
        receiveAction.setActionTemplateId(MarketingConstant.ACTION_RECEIVE_TP_ID);
        actionList.add(receiveAction);
        ActionReqDto emptyAction = new ActionReqDto();
        emptyAction.setActionParams("{}");
        emptyAction.setActionTemplateId(MarketingConstant.ACTION_EMPTY_TP_ID);
        actionList.add(emptyAction);
        ActionReqDto writeOffAction = new ActionReqDto();
        writeOffAction.setActionParams("{}");
        writeOffAction.setActionTemplateId(MarketingConstant.ACTION_WRITE_OFF_TP_ID);
        actionList.add(writeOffAction);
        ActionReqDto joinSuccess = new ActionReqDto();
        joinSuccess.setActionParams("{}");
        joinSuccess.setActionTemplateId(MarketingConstant.ACTION_JOIN_SUCCESS_ID);
        actionList.add(joinSuccess);
        return actionList;
    }

    private List<ConditionReqDto> getConditionList(CouponTemplateTobDto couponTemplateTobDto) {
        List<Object> itemList;
        ArrayList conditionList = Lists.newArrayList();
        ConditionReqDto limitCondition = new ConditionReqDto();
        HashMap limitConditionParam = Maps.newHashMap();
        if (null == couponTemplateTobDto.getLimitNum() || null == couponTemplateTobDto.getDailyLimitNum()) {
            couponTemplateTobDto.setLimitNum(Integer.valueOf(0));
            couponTemplateTobDto.setDailyLimitNum(Integer.valueOf(0));
        }
        limitConditionParam.put("CouponReceiveLimitCondition.limit", couponTemplateTobDto.getLimitNum());
        limitConditionParam.put("CouponReceiveLimitCondition.dayLimit", couponTemplateTobDto.getDailyLimitNum());
        limitCondition.setConditionParams(ObjectHelper.bean2Json((Object)limitConditionParam));
        limitCondition.setConditionTemplateId(MarketingConstant.CONDITION_LIMIT_TP_ID);
        conditionList.add(limitCondition);
        ConditionReqDto categoriesCondition = new ConditionReqDto();
        HashMap categoriesConditionParam = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Collection)couponTemplateTobDto.getDirIdList())) {
            couponTemplateTobDto.setDirIdList((List)Lists.newArrayList());
        }
        categoriesConditionParam.put("CouponCategoryCondition.categories", couponTemplateTobDto.getDirIdList());
        categoriesCondition.setConditionParams(JSON.toJSONString((Object)categoriesConditionParam));
        categoriesCondition.setConditionTemplateId(MarketingConstant.CONDITION_DIR_TP_ID);
        conditionList.add(categoriesCondition);
        ConditionReqDto brandCondition = new ConditionReqDto();
        ArrayList brandList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getBrandIdList())) {
            couponTemplateTobDto.getBrandIdList().forEach(branId -> {
                ConditionBrand brand = new ConditionBrand();
                brand.setBrandId(branId);
                brandList.add(brand);
            });
        }
        HashMap brandConditionParam = Maps.newHashMap();
        brandConditionParam.put("CouponBrandCondition.brands", brandList);
        brandCondition.setConditionParams(JSON.toJSONString((Object)brandConditionParam));
        brandCondition.setConditionTemplateId(MarketingConstant.CONDITION_BRAND_TP_ID);
        conditionList.add(brandCondition);
        ConditionReqDto blackCondition = new ConditionReqDto();
        ArrayList blackList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getBlackItems())) {
            couponTemplateTobDto.getBlackItems().forEach(item -> {
                CouponTemplateItemSkuDto itemSkuDto = new CouponTemplateItemSkuDto();
                itemSkuDto.setItemCode(item.getItemId().toString());
                itemSkuDto.setShopId(item.getShopId());
                itemSkuDto.setSkuId(item.getSkuId());
                itemSkuDto.setExclude(true);
                blackList.add(itemSkuDto);
            });
        }
        HashMap blackConditionParam = Maps.newHashMap();
        blackConditionParam.put("CouponBlackSkuCondition.items", blackList);
        blackCondition.setConditionParams(JSON.toJSONString((Object)blackConditionParam));
        blackCondition.setConditionTemplateId(MarketingConstant.CONDITION_BLACK_SKU_TP_ID);
        conditionList.add(blackCondition);
        ConditionReqDto mallCondition = new ConditionReqDto();
        HashMap mallConditionParam = Maps.newHashMap();
        mallConditionParam.put("TargetMallCondition.mallTypes", couponTemplateTobDto.getMallTypes());
        mallCondition.setConditionParams(JSON.toJSONString((Object)mallConditionParam));
        mallCondition.setConditionTemplateId(MarketingConstant.TARGET_MALL_TP_ID);
        conditionList.add(mallCondition);
        ConditionReqDto disCountAmount = new ConditionReqDto();
        disCountAmount.setConditionTemplateId(MarketingConstant.CONDITION_COUPON_COUNT_ID);
        disCountAmount.setConditionParams("{}");
        conditionList.add(disCountAmount);
        ConditionReqDto itemCondition = new ConditionReqDto();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getCouponItems())) {
            itemList = couponTemplateTobDto.getCouponItems().stream().map(couponItemDto -> {
                ConditionItem item = new ConditionItem();
                item.setItemCode(couponItemDto.getItemId().toString());
                item.setShopId(couponItemDto.getShopId());
                item.setSkuId(couponItemDto.getSkuId());
                return item;
            }).collect(Collectors.toList());
        } else {
            itemList = Lists.newArrayList();
            if (SelectTypeEnum.ALL.getCode().equals(couponTemplateTobDto.getSelectType())) {
                List items = this.activityService.queryAllItem(couponTemplateTobDto.getShopId(), null, null, null);
                items = items.stream().filter(e -> Objects.equals(SubTypeEnum.PRODUCT.getType(), e.getSubType())).collect(Collectors.toList());
                for (ItemShelfQueryRespDto itemShelfRespDto : items) {
                    List skuList = itemShelfRespDto.getSkuList();
                    for (ItemShelfSkuRespDto skuRespDto : skuList) {
                        ConditionItem item2 = new ConditionItem();
                        item2.setItemCode(itemShelfRespDto.getItemId().toString());
                        item2.setShopId(itemShelfRespDto.getShopId());
                        item2.setSkuId(skuRespDto.getId());
                        itemList.add(item2);
                    }
                }
            }
        }
        HashMap itemConditionParam = Maps.newHashMap();
        itemConditionParam.put("CouponItemSkusCondition.items", itemList);
        itemCondition.setConditionTemplateId(MarketingConstant.CONDITION_ITEM_TP_ID);
        itemCondition.setConditionParams(JSON.toJSONString((Object)itemConditionParam));
        conditionList.add(itemCondition);
        ConditionReqDto trueCondition = new ConditionReqDto();
        trueCondition.setConditionTemplateId(MarketingConstant.CONDITION_TRUE_ID);
        trueCondition.setConditionParams("{}");
        conditionList.add(trueCondition);
        BigDecimal discountValue = null;
        if (CouponCategoryEnum.DISCOUNT.getCategory().equals(couponTemplateTobDto.getCouponCategory())) {
            BigDecimal discountRate = couponTemplateTobDto.getCouponValue().divide(BigDecimal.TEN, 2, 4);
            discountValue = BigDecimal.ONE.subtract(discountRate);
        } else {
            discountValue = couponTemplateTobDto.getCouponValue();
            if (null == couponTemplateTobDto.getAmount()) {
                couponTemplateTobDto.setAmount(BigDecimal.ZERO);
            }
        }
        ConditionReqDto amountCondition = new ConditionReqDto();
        HashMap amountConditionParam = Maps.newHashMap();
        ConditionAmount amount = new ConditionAmount();
        amount.setLimitAmount(couponTemplateTobDto.getAmount());
        amount.setDiscountValue(discountValue);
        amountConditionParam.put("CouponMoneyOffCondition.type", couponTemplateTobDto.getCouponCategory());
        amountConditionParam.put("CouponMoneyOffCondition.condition", amount);
        amountCondition.setConditionTemplateId(MarketingConstant.CONDITION_AMOUNT_TP_ID);
        amountCondition.setConditionParams(JSON.toJSONString((Object)amountConditionParam));
        conditionList.add(amountCondition);
        ConditionReqDto effectiveCondition = new ConditionReqDto();
        effectiveCondition.setConditionTemplateId(MarketingConstant.CONDITION_EFFECTIVE_TP_ID);
        effectiveCondition.setConditionParams("{}");
        conditionList.add(effectiveCondition);
        ConditionReqDto memberCondition = new ConditionReqDto();
        if (Objects.isNull(couponTemplateTobDto.getSelectCustomer())) {
            couponTemplateTobDto.setSelectCustomer(Integer.valueOf(0));
        }
        memberCondition.setConditionTemplateId(Long.valueOf(1196944771412880293L));
        HashMap param = Maps.newHashMap();
        TargetCustomerInfoDto customerInfoDto = new TargetCustomerInfoDto();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getActivityCustomers())) {
            List customerIds = couponTemplateTobDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            customerInfoDto.setCustomerIds(customerIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getCustomerTypeIds())) {
            customerInfoDto.setCustomerTypeIds(couponTemplateTobDto.getCustomerTypeIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getCustomerAreaCodes())) {
            customerInfoDto.setCustomerAreaCodes(couponTemplateTobDto.getCustomerAreaCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getBlackCustomers())) {
            List blackCustomerIds = couponTemplateTobDto.getBlackCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            customerInfoDto.setBlackCustomerIds(blackCustomerIds);
        }
        param.put("TargetCustomerCondition.type", couponTemplateTobDto.getSelectCustomer());
        param.put("TargetCustomerCondition.value", customerInfoDto);
        memberCondition.setConditionParams(JSON.toJSONString((Object)param));
        conditionList.add(memberCondition);
        ConditionReqDto exchangeItemCondition = new ConditionReqDto();
        ArrayList exchangeItems = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateTobDto.getExchangeItems())) {
            couponTemplateTobDto.getExchangeItems().forEach(exchangeItem -> exchangeItem.getSkus().forEach(sku -> {
                ExchangeItemDto exItem = new ExchangeItemDto();
                exItem.setItemId(exchangeItem.getItemId());
                exItem.setShopId(exchangeItem.getShopId());
                exItem.setSkuId(sku.getSkuId());
                exItem.setExchangeNum(sku.getExchangeNum());
                exchangeItems.add(exItem);
            }));
        }
        HashMap exchangeItemConditionParam = Maps.newHashMap();
        exchangeItemConditionParam.put("ExchangeItemCondition.items", exchangeItems);
        exchangeItemCondition.setConditionTemplateId(MarketingConstant.EXCHANGE_ITEM_TP_ID);
        exchangeItemCondition.setConditionParams(JSON.toJSONString((Object)exchangeItemConditionParam));
        conditionList.add(exchangeItemCondition);
        ConditionReqDto receiveCondition = new ConditionReqDto();
        HashMap receiveConditionParam = Maps.newHashMap();
        ReceiveRuleDto receiveRuleDto = new ReceiveRuleDto();
        receiveRuleDto.setPoint(couponTemplateTobDto.getSendPoint());
        receiveRuleDto.setType(Integer.valueOf(couponTemplateTobDto.getSendPoint() == null ? 0 : 1));
        receiveConditionParam.put("ReceiveCondition.rule", receiveRuleDto);
        receiveCondition.setConditionTemplateId(MarketingConstant.RECEIVE_TP_ID);
        receiveCondition.setConditionParams(JSON.toJSONString((Object)receiveConditionParam));
        conditionList.add(receiveCondition);
        ConditionReqDto couponGift = new ConditionReqDto();
        couponGift.setConditionTemplateId(Long.valueOf(1096944771412880289L));
        couponGift.setConditionParams("{}");
        ConditionReqDto couponPieceGift = new ConditionReqDto();
        couponPieceGift.setConditionTemplateId(Long.valueOf(1096944771412880290L));
        couponPieceGift.setConditionParams("{}");
        conditionList.add(couponGift);
        conditionList.add(couponPieceGift);
        ConditionReqDto mutex = new ConditionReqDto();
        mutex.setConditionTemplateId(Long.valueOf(5196944771412880295L));
        mutex.setConditionParams("{}");
        conditionList.add(mutex);
        return conditionList;
    }

    public PageInfo<CouponTemplateTobDto> query(CouponTemplateTobDto couponTemplateTobDto, Integer pageNum, Integer pageSize) {
        PageInfo result = new PageInfo();
        List<SqlFilter> sqlFilters = this.getSqlFilters(couponTemplateTobDto);
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilters);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        criteria.setOrderByDesc("createTime");
        String filter = JSON.toJSONString((Object)criteria);
        logger.info("\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u53c2\u6570\uff1a{}", (Object)filter);
        PageInfo pageInfo = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(filter, pageNum, pageSize).getData();
        if (null == pageInfo) {
            return result;
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return result;
        }
        List list = pageInfo.getList().stream().map(couponTemplateExtRespDto -> {
            CouponTemplateTobDto template = new CouponTemplateTobDto();
            BeanUtils.copyProperties((Object)couponTemplateExtRespDto, (Object)template);
            template.setCouponUseBeginTime(couponTemplateExtRespDto.getEffectiveTime());
            template.setCouponUseEndTime(couponTemplateExtRespDto.getInvalidTime());
            CouponTemplateExtDto couponTemplateExtDto = (CouponTemplateExtDto)ObjectHelper.Json2Bean((String)couponTemplateExtRespDto.getExtension(), CouponTemplateExtDto.class);
            if (null != couponTemplateExtDto) {
                template.setCollectionMethod(couponTemplateExtDto.getCollectionMethod());
                template.setForPeople(couponTemplateExtDto.getForPeople());
            }
            String tag = this.getTag(couponTemplateExtRespDto.getActivityId());
            template.setTag(tag);
            return template;
        }).collect(Collectors.toList());
        result.setList(list);
        return result;
    }

    private void trans2UseTimeDtoList(List<CouponTemplateTobDto> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        list.stream().forEach(o -> this.trans2UseTimeDto((CouponTemplateTobDto)o));
    }

    private void trans2UseTimeDto(CouponTemplateTobDto couponTemplateTobDto) {
        SerializeCouPonUseTimeValueDistribute.deserialization(couponTemplateTobDto);
    }

    public PageInfo<CouponTemplateTobDto> queryWithActivity(CouponTemplateTobDto couponTemplateTobDto, Integer pageNum, Integer pageSize) {
        List shopIds;
        CouponTemplateQueryReqDto queryReqDto = new CouponTemplateQueryReqDto();
        if (null != couponTemplateTobDto) {
            CubeBeanUtils.copyProperties((Object)queryReqDto, (Object)couponTemplateTobDto, (String[])new String[0]);
            queryReqDto.setReceiveStartTime(couponTemplateTobDto.getReceiveStartTime());
            queryReqDto.setReceiveEndTime(couponTemplateTobDto.getReceiveEndTime());
            QueryCouponTpStatusEnum couponTpStatusEnum = QueryCouponTpStatusEnum.getByStatus(couponTemplateTobDto.getCouponTemplateStatus());
            if (null != couponTpStatusEnum) {
                queryReqDto.setCouponTemplateStatus(couponTpStatusEnum.getCouponTemplateStatus());
                queryReqDto.setAuditStatus(couponTpStatusEnum.getAuditStatus());
            } else {
                queryReqDto.setCouponTemplateStatusList(QueryCouponTpStatusEnum.LIST_ALL_STATUS);
            }
            if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
                queryReqDto.setCouponType(CouponTypeEnum.COUPON.getType());
            } else if (CollectionMethodEnum.PRIVATE.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
                queryReqDto.setCouponType(CouponTypeEnum.COUPON_PUSHED.getType());
            }
            if (couponTemplateTobDto.getCouponCategory() == null) {
                ArrayList categoryList = Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()});
                queryReqDto.setCouponCategoryList((List)categoryList);
            }
        }
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        Long currentUserOrgId = this.activityService.getCurrentUserOrgId(this.context.userId());
        queryReqDto.setOrganizationId(currentUserOrgId);
        PageInfo pageInfo = (PageInfo)this.couponTemplateExtQueryApi.queryWithActivity(queryReqDto, pageNum, pageSize).getData();
        PageInfo result = new PageInfo();
        List<Object> list = Lists.newArrayList();
        if (PageInfoUtil.isNotEmpty(pageInfo) && CollectionUtils.isNotEmpty(shopIds = (list = pageInfo.getList().stream().map(template -> {
            ActivityRespDto activityRespDto;
            CouponTemplateTobDto couponTp = new CouponTemplateTobDto();
            CubeBeanUtils.copyProperties((Object)couponTp, (Object)template, (String[])new String[0]);
            couponTp.setCouponUseBeginTime(template.getEffectiveTime());
            couponTp.setCouponUseEndTime(template.getInvalidTime());
            couponTp.setCouponTemplateStatus(QueryCouponTpStatusEnum.getStatus(template.getCouponTemplateStatus(), template.getAuditStatus()));
            if (CouponTypeEnum.COUPON.getType().equals(template.getCouponType())) {
                couponTp.setCollectionMethod(CollectionMethodEnum.PUBLIC.getKey());
            } else if (CouponTypeEnum.COUPON_PUSHED.getType().equals(template.getCouponType())) {
                couponTp.setCollectionMethod(CollectionMethodEnum.PRIVATE.getKey());
            }
            if (CouponCategoryEnum.EXTRACT.getCategory().equals(template.getCouponCategory()) && null != (activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(template.getActivityId().longValue()).getData())) {
                ReceiveCondition receiveCondition = new ReceiveCondition();
                CouponTemplateDetailRespDto detail = new CouponTemplateDetailRespDto();
                receiveCondition.parseCondition(activityRespDto.getConditionDtos(), detail);
                couponTp.setSendPoint(detail.getSendPoint());
            }
            return couponTp;
        }).collect(Collectors.toList())).stream().map(CouponTemplateTobDto::getShopId).collect(Collectors.toList()))) {
            RestResponse response = this.shopQueryApi.queryBaseListByIds(new HashSet(shopIds));
            List shopBaseDtoList = (List)RestResponseHelper.extractData((RestResponse)response);
            Map<Long, String> maps = shopBaseDtoList.stream().collect(Collectors.toMap(ShopBaseDto::getId, ShopBaseDto::getName));
            list.forEach(tobDto -> {
                if (tobDto.getShopId() != null) {
                    tobDto.setShopName((String)maps.get(tobDto.getShopId()));
                }
            });
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        this.trans2UseTimeDtoList((List<CouponTemplateTobDto>)list);
        result.setList((List)list);
        return result;
    }

    private String getTag(Long activityId) {
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
            return activityRespDto.getTag();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<SqlFilter> getSqlFilters(CouponTemplateTobDto couponTemplateTobDto) {
        ArrayList sqlFilterList = Lists.newArrayList();
        Integer roleType = this.marketingModuleHelper.getRoleType();
        if (UserConstant.MERCHANT.equals(roleType)) {
            Long sellerId = this.marketingModuleHelper.getSellerId();
            sqlFilterList.add(SqlFilter.eq((String)"seller_id", (Object)sellerId));
        }
        if (StringUtils.isNotBlank((CharSequence)couponTemplateTobDto.getCouponTemplateStatus())) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)couponTemplateTobDto.getCouponTemplateStatus()));
        }
        if (null != couponTemplateTobDto.getCollectionMethod()) {
            String couponType = null;
            if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
                couponType = CouponTypeEnum.COUPON.getType();
            } else if (CollectionMethodEnum.PRIVATE.getKey().equals(couponTemplateTobDto.getCollectionMethod())) {
                couponType = CouponTypeEnum.COUPON_PUSHED.getType();
            }
            sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)couponType));
        }
        if (StringUtils.isNotBlank((CharSequence)couponTemplateTobDto.getCouponName())) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_name", (Object)(couponTemplateTobDto.getCouponName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)couponTemplateTobDto.getCouponCode())) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_code", (Object)(couponTemplateTobDto.getCouponCode() + "%")));
        }
        if (null != couponTemplateTobDto.getCouponRange()) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_range", (Object)couponTemplateTobDto.getCouponRange()));
        }
        if (null != couponTemplateTobDto.getCouponCategory()) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_category", (Object)couponTemplateTobDto.getCouponCategory()));
        } else {
            ArrayList categoryList = Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()});
            sqlFilterList.add(SqlFilter.in((String)"coupon_category", (Object)categoryList));
        }
        return sqlFilterList;
    }

    public CouponTemplateDetailRespDto getDetail(Long id) {
        ShopBaseDto shopBaseDto;
        CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryById(id));
        if (null == couponTemplateExtRespDto) {
            return null;
        }
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(couponTemplateExtRespDto.getActivityId().longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        CouponTemplateDetailRespDto detail = new CouponTemplateDetailRespDto();
        BeanUtils.copyProperties((Object)couponTemplateExtRespDto, (Object)detail);
        detail.setCouponUseBeginTime(couponTemplateExtRespDto.getEffectiveTime());
        detail.setCouponUseEndTime(couponTemplateExtRespDto.getInvalidTime());
        CouponTemplateExtDto couponTemplateExtDto = (CouponTemplateExtDto)JSON.parseObject((String)couponTemplateExtRespDto.getExtension(), CouponTemplateExtDto.class);
        detail.setSharedDiscountList(couponTemplateExtDto.getSharedDiscountList());
        detail.setForPeople(couponTemplateExtDto.getForPeople());
        detail.setCollectionMethod(couponTemplateExtDto.getCollectionMethod());
        detail.setDailyLimitNum(couponTemplateExtDto.getDailyLimitNum());
        detail.setLimitNum(couponTemplateExtDto.getLimitNum());
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateExtRespDto.getCouponShopList())) {
            Set shopIds = couponTemplateExtRespDto.getCouponShopList().stream().map(couponTemplateShopDto -> Long.valueOf(couponTemplateShopDto.getShopCode())).collect(Collectors.toSet());
            List shopDtoList = (List)this.shopQueryApi.queryBaseListByIds(shopIds).getData();
            detail.setShopList(shopDtoList);
        }
        if (couponTemplateExtRespDto.getShopId() != null && (shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(couponTemplateExtRespDto.getShopId()))) != null) {
            detail.setShopId(couponTemplateExtRespDto.getShopId());
            detail.setShopName(shopBaseDto.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateExtRespDto.getCouponTemplateCatalogDtoList())) {
            String dirIds = StringUtils.join((Iterable)couponTemplateExtRespDto.getCouponTemplateCatalogDtoList(), (String)",");
            List dirList = (List)this.directoryQueryApi.queryDirByIds(dirIds).getData();
            detail.setDirList(dirList);
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateExtRespDto.getCouponTemplateBrandDtoList())) {
            List brandIdList = couponTemplateExtRespDto.getCouponTemplateBrandDtoList().stream().map(CouponTemplateBrandDto::getBrandId).collect(Collectors.toList());
            String brandIds = StringUtils.join(brandIdList, (String)",");
            List brandRespDtoList = (List)this.brandQueryApi.queryByIds(brandIds).getData();
            detail.setBrandList(brandRespDtoList);
        }
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.COUPON_TOB_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), detail));
        CouponReqDto couponReqDto = new CouponReqDto();
        couponReqDto.setCouponTemplateId(id);
        Integer receivedQuantity = (Integer)this.couponExtQueryApi.countCouponNum(couponReqDto).getData();
        couponReqDto.setCouponStatus(CouponStatusEnum.STOP.getStatus());
        Integer usedQuantity = (Integer)this.couponExtQueryApi.countCouponNum(couponReqDto).getData();
        detail.setReceivedQuantity(receivedQuantity);
        detail.setUsedQuantity(usedQuantity);
        String tag = this.getTag(couponTemplateExtRespDto.getActivityId());
        detail.setTag(tag);
        detail.setOrganizationIds((List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList()));
        this.trans2UseTimeDto((CouponTemplateTobDto)detail);
        detail.setSelectType(activityRespDto.getSelectType());
        detail.setSelectCustomer(activityRespDto.getSelectCustomer());
        detail.setAuditStatus(activityRespDto.getAuditStatus());
        if (SelectTypeEnum.ALL.getCode().equals(detail.getSelectType())) {
            detail.setItemList(null);
        }
        return detail;
    }

    public void enable(Long id) {
        CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)this.couponTemplateExtQueryApi.queryById(id).getData();
        if (null == couponTemplateExtRespDto) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_NOT_EXIST);
        }
        RestResponse restResponse = null;
        restResponse = CouponTemplateStatusEnum.CREATE.getStatus().equals(couponTemplateExtRespDto.getCouponTemplateStatus()) ? this.couponTemplateExtApi.batchActivate((List)Lists.newArrayList((Object[])new Long[]{id})) : this.couponTemplateExtApi.setStatus(id, CouponTemplateStatusEnum.ACTIVATE.getStatus());
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public void disable(Long id) {
        RestResponse restResponse = this.couponTemplateExtApi.setStatus(id, CouponTemplateStatusEnum.STOP.getStatus());
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public void invalid(String ids) {
        String[] idArr = StringUtils.split((String)ids.trim(), (String)",");
        for (int i = 0; i < idArr.length; ++i) {
            RestResponse restResponse = this.couponTemplateExtApi.invalid(Long.valueOf(idArr[i]));
            RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        }
    }

    public void grant(CouponGrantReqDto couponGrantReqDto) {
        if (CollectionUtils.isEmpty((Collection)couponGrantReqDto.getMemberIdList())) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.GRANT_MEMBER_NOT_NULL);
        }
        RestResponse templateResponse = this.couponTemplateExtQueryApi.queryById(couponGrantReqDto.getTemplateId());
        CouponTemplateExtRespDto template = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)templateResponse);
        Integer grantTotalNum = couponGrantReqDto.getGrantNum() * couponGrantReqDto.getMemberIdList().size();
        if ((long)grantTotalNum.intValue() > template.getRemainingQuantity()) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.GRANT_NUM_GT_THAN_STOCK);
        }
        CouponSendTemplateReqDto couponSendTemplateReqDto = new CouponSendTemplateReqDto();
        couponSendTemplateReqDto.setCouponTemplateId(couponGrantReqDto.getTemplateId());
        couponSendTemplateReqDto.setSendNum(couponGrantReqDto.getGrantNum());
        CouponBatchSendReqDto couponBatchSendReqDto = new CouponBatchSendReqDto();
        couponBatchSendReqDto.setMemberIds(couponGrantReqDto.getMemberIdList());
        couponBatchSendReqDto.setIsValidate(false);
        couponBatchSendReqDto.setCheckPointCode("IC_RECEIVE_COUPON");
        couponBatchSendReqDto.setTemplates((List)Lists.newArrayList((Object[])new CouponSendTemplateReqDto[]{couponSendTemplateReqDto}));
        RestResponse restResponse = this.couponExtApi.pushCoupon(couponBatchSendReqDto);
        CouponPushRespDto couponPushRespDto = (CouponPushRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (couponPushRespDto.getFailNum() > 0) {
            CouponPushErrorDto errMsg = couponPushRespDto.getFailData().stream().filter(couponPushErrorDto -> couponGrantReqDto.getTemplateId().equals(couponPushErrorDto.getCouponTemplateId())).findFirst().orElseGet(() -> null);
            if (null == errMsg) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.GRANT_COUPON_FAIL);
            } else {
                BizExceptionHelper.throwBizException((String)errMsg.getErrorCode(), (String)errMsg.getErrorMsg());
            }
        }
    }

    public PageInfo<CouponExtTobRespDto> queryReceiveRecord(CouponReceiveRecordReqDto couponReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        ArrayList sqlFilterList = Lists.newArrayList();
        String phone = couponReqDto.getUserPhone();
        if (null != couponReqDto.getReceiveTimeBegin()) {
            String receiveTimeBegin = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)couponReqDto.getReceiveTimeBegin());
            sqlFilterList.add(SqlFilter.ge((String)"receive_time", (Object)receiveTimeBegin));
        }
        if (null != couponReqDto.getReceiveTimeEnd()) {
            String receiveTimeEnd = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)couponReqDto.getReceiveTimeEnd());
            sqlFilterList.add(SqlFilter.le((String)"receive_time", (Object)receiveTimeEnd));
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getCouponStatus())) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)couponReqDto.getCouponStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getCouponCode())) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_code", (Object)couponReqDto.getCouponCode()));
        }
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_id", (Object)couponReqDto.getCouponTemplateId()));
        if (StringUtils.isNotEmpty((CharSequence)couponReqDto.getCustomerName())) {
            CustomerSearchReqDto queryReqDto = new CustomerSearchReqDto();
            queryReqDto.setTenantId(this.context.tenantId());
            queryReqDto.setInstanceId(this.context.instanceId());
            queryReqDto.setName(couponReqDto.getCustomerName());
            queryReqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(true));
            RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPage(JSON.toJSONString((Object)queryReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo customerPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            if (Objects.isNull(customerPageInfo) || CollectionUtils.isEmpty((Collection)customerPageInfo.getList())) {
                return pageInfo;
            }
            List orgInfoIds = customerPageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
            sqlFilterList.add(SqlFilter.in((String)"user_id", orgInfoIds));
        }
        Criteria criteria = new Criteria();
        criteria.setFilters((List)sqlFilterList);
        String filter = ObjectHelper.bean2Json((Object)criteria);
        PageInfo data = (PageInfo)this.couponExtQueryApi.queryByPage(filter, pageNum, pageSize).getData();
        if (null == data || CollectionUtils.isEmpty((Collection)data.getList())) {
            return pageInfo;
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)data, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList respDtoList = new ArrayList(data.getList().size());
        CubeBeanUtils.copyCollection(respDtoList, (Collection)data.getList(), CouponExtTobRespDto.class);
        pageInfo.setList(respDtoList);
        Set orgIds = pageInfo.getList().stream().map(CouponExtTobRespDto::getUserId).collect(Collectors.toSet());
        JSONObject jsonObject = new JSONObject();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"id", orgIds));
        jsonObject.put("filters", (Object)filters);
        RestResponse pageInfoRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPage(jsonObject.toJSONString(), Integer.valueOf(1), Integer.valueOf(orgIds.size()));
        PageInfo bizOrgPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (CollectionUtils.isNotEmpty((Collection)bizOrgPageInfo.getList())) {
            Map<Long, BizOrganizationRespDto> orgMap = bizOrgPageInfo.getList().stream().collect(Collectors.toMap(BizOrganizationRespDto::getId, item -> item, (e1, e2) -> e1));
            pageInfo.getList().forEach(couponExtRespDto -> {
                BizOrganizationRespDto organizationRespDto = (BizOrganizationRespDto)orgMap.get(couponExtRespDto.getUserId());
                if (Objects.nonNull(organizationRespDto)) {
                    couponExtRespDto.setCustomerCode(organizationRespDto.getCode());
                    couponExtRespDto.setCustomerName(organizationRespDto.getName());
                }
            });
        }
        return pageInfo;
    }

    public PageInfo<CouponTemplateTobDto> platFormcouponGather(CouponTemplateExtQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        Criteria criteria = this.getCouponTemplateReqDto(queryReqDto);
        PageInfo couponTemplatePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), pageNum, pageSize));
        PageInfo<CouponTemplateTobDto> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTemplatePage);
        this.trans2UseTimeDtoList(pageInfo.getList());
        return pageInfo;
    }

    private Criteria getCouponTemplateReqDto(CouponTemplateExtQueryReqDto queryReqDto) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)"20"));
        if (queryReqDto.getCouponRange() != null) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_range", (Object)queryReqDto.getCouponRange()));
        }
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)dateFormat.format(new Date())));
        logger.info("\u67e5\u8be2\u4f18\u60e0\u5238\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getCouponTemplateIds())) {
            String[] idArr = StringUtils.split((String)queryReqDto.getCouponTemplateIds().trim(), (String)",");
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)idArr));
        }
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        return criteria;
    }

    private PageInfo<CouponTemplateTobDto> convertToCouponTemplatePage(PageInfo<CouponTemplateExtRespDto> couponTemplatePage) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(couponTemplatePage, (Object)pageInfo);
        CouponTemplateTobDto couponTemplateTobDto = null;
        ArrayList<CouponTemplateTobDto> couponTemplateTobDtoList = new ArrayList<CouponTemplateTobDto>();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplatePage.getList())) {
            ArrayList activityIds = Lists.newArrayList();
            for (CouponTemplateExtRespDto templateExtRespDto : couponTemplatePage.getList()) {
                couponTemplateTobDto = new CouponTemplateTobDto();
                CubeBeanUtils.copyProperties((Object)couponTemplateTobDto, (Object)templateExtRespDto, (String[])new String[0]);
                couponTemplateTobDto.setCouponUseBeginTime(templateExtRespDto.getEffectiveTime());
                couponTemplateTobDto.setCouponUseEndTime(templateExtRespDto.getInvalidTime());
                couponTemplateTobDto.setTag(templateExtRespDto.getActivityTag());
                activityIds.add(templateExtRespDto.getActivityId());
                couponTemplateTobDtoList.add(couponTemplateTobDto);
            }
        }
        pageInfo.setList(couponTemplateTobDtoList);
        return pageInfo;
    }

    public List<CouponTemplateTobDto> couponGather(String shopId) {
        ShopBaseDto shopDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(shopId)));
        if (shopDto == null) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u5e97\u94fa\u4fe1\u606f");
        }
        CouponTemplateTobDto couponTemplateTobDto = null;
        ArrayList<CouponTemplateTobDto> resultList = new ArrayList<CouponTemplateTobDto>();
        CouponTemplateExtQueryReqDto queryReqDto = new CouponTemplateExtQueryReqDto();
        queryReqDto.setCouponRange(CouponTemplateConstant.SHOP_COUPON);
        Criteria criteria = this.getCouponTemplateReqDto(queryReqDto);
        criteria.getFilters().add(SqlFilter.eq((String)"seller_id", (Object)shopDto.getSellerId()));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(1)));
        int total = (int)pageInfo.getTotal();
        int count = total % 100 == 0 ? total / 100 : total / 100 + 1;
        for (int pageNum = 1; pageNum <= count; ++pageNum) {
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(pageNum), Integer.valueOf(100)));
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            for (CouponTemplateExtRespDto couponExtDto : pageInfo.getList()) {
                if (!this.validBelongShop(shopId, couponExtDto.getId())) continue;
                couponTemplateTobDto = new CouponTemplateTobDto();
                CubeBeanUtils.copyProperties((Object)couponTemplateTobDto, (Object)couponExtDto, (String[])new String[0]);
                couponTemplateTobDto.setCouponUseBeginTime(couponExtDto.getEffectiveTime());
                couponTemplateTobDto.setCouponUseEndTime(couponExtDto.getInvalidTime());
                resultList.add(couponTemplateTobDto);
            }
        }
        this.trans2UseTimeDtoList(resultList);
        return resultList;
    }

    private boolean validBelongShop(String shopId, Long templateId) {
        CouponTemplateExtRespDto templateExtRespDto = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryById(templateId));
        if (templateExtRespDto != null && CollectionUtils.isNotEmpty((Collection)templateExtRespDto.getCouponShopList())) {
            for (CouponTemplateShopDto templateShopDto : templateExtRespDto.getCouponShopList()) {
                if (!shopId.equals(templateShopDto.getShopCode())) continue;
                return true;
            }
        }
        return false;
    }

    public PageInfo<CouponRespDto> queryCouponPage(Integer pageNum, Integer pageSize) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        Long memberId = this.marketingModuleHelper.getMemberIdByContext();
        sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)memberId));
        sqlFilterList.add(SqlFilter.ge((String)"invalid_time", (Object)dateFormat.format(new Date())));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)"10"));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        criteria.setOrderByDesc("id");
        PageInfo couponExtPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), pageNum, pageSize));
        if (CollectionUtils.isNotEmpty((Collection)couponExtPageInfo.getList())) {
            couponExtPageInfo.setList(couponExtPageInfo.getList().stream().filter(couponExtRespDto -> !couponExtRespDto.getCouponTemplate().getCouponTemplateStatus().equals("40")).collect(Collectors.toList()));
        }
        PageInfo<CouponRespDto> pageInfo = this.convertToCouponPage((PageInfo<CouponExtRespDto>)couponExtPageInfo);
        return pageInfo;
    }

    public CustomerCouponRespDto queryCustomerCouponList(Long customerId, Long shopId, String couponName) {
        RestResponse shopListResponse;
        CustomerCouponRespDto customerCouponRespDto = new CustomerCouponRespDto();
        customerId = this.marketingModuleHelper.getOrgIdByContext();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)customerId));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)"10"));
        if (StrUtil.isNotEmpty((CharSequence)couponName)) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_name", (Object)("%" + couponName + "%")));
        }
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        criteria.setOrderByDesc("id");
        PageInfo couponExtPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (CollectionUtils.isNotEmpty((Collection)couponExtPageInfo.getList())) {
            couponExtPageInfo.setList(couponExtPageInfo.getList().stream().filter(couponExtRespDto -> !couponExtRespDto.getCouponTemplate().getCouponTemplateStatus().equals("40")).collect(Collectors.toList()));
        }
        Set<Object> shopIds = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)couponExtPageInfo.getList())) {
            if (ObjectUtil.isNotEmpty((Object)shopId)) {
                List respDtos = couponExtPageInfo.getList().stream().filter(bean -> bean.getShopId().equals(shopId)).collect(Collectors.toList());
                couponExtPageInfo.setList(respDtos);
                shopIds.add(shopId);
            } else {
                shopIds = couponExtPageInfo.getList().stream().map(CouponExtRespDto::getShopId).collect(Collectors.toSet());
            }
        }
        ArrayList<SqlFilter> usedSqlFilterList = new ArrayList<SqlFilter>();
        usedSqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)customerId));
        ArrayList couponStatusList = Lists.newArrayList((Object[])new String[]{"20", "50"});
        usedSqlFilterList.add(SqlFilter.in((String)"coupon_status", (Object)couponStatusList));
        if (StrUtil.isNotEmpty((CharSequence)couponName)) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_name", (Object)("%" + couponName + "%")));
        }
        Criteria usedCriteria = new Criteria();
        usedCriteria.setFilters(usedSqlFilterList);
        usedCriteria.setInstanceId(this.context.instanceId());
        usedCriteria.setTenantId(this.context.tenantId());
        usedCriteria.setOrderByDesc("id");
        PageInfo usedCouponExtPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponExtQueryApi.queryByPage(JSON.toJSONString((Object)usedCriteria), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        logger.info("sanqiu->\u4f18\u60e0\u5238\u67e5\u8be2\u7ed3\u679c\u4e3a[{}]", (Object)JSON.toJSONString((Object)usedCouponExtPageInfo));
        if (CollectionUtils.isNotEmpty((Collection)usedCouponExtPageInfo.getList())) {
            usedCouponExtPageInfo.setList(usedCouponExtPageInfo.getList().stream().filter(couponExtRespDto -> !couponExtRespDto.getCouponTemplate().getCouponTemplateStatus().equals("40")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)usedCouponExtPageInfo.getList())) {
            if (ObjectUtil.isNotEmpty((Object)shopId)) {
                logger.info("sanqiu->\u8bf7\u6c42\u7684\u5e97\u94fa\u4fe1\u606f\u4e3a[{}]", (Object)shopId);
                List respDtos = usedCouponExtPageInfo.getList().stream().filter(bean -> bean.getShopId().equals(shopId)).collect(Collectors.toList());
                logger.info("sanqiu->\u6839\u636e\u5e97\u94fa\u8fc7\u6ee4\u540e\uff0c\u4f18\u60e0\u5238\u67e5\u8be2\u7ed3\u679c\u4e3a[{}]", (Object)JSON.toJSONString(respDtos));
                usedCouponExtPageInfo.setList(respDtos);
                shopIds.add(shopId);
            } else {
                shopIds.addAll(usedCouponExtPageInfo.getList().stream().map(CouponExtRespDto::getShopId).collect(Collectors.toSet()));
            }
        }
        Map<Long, Object> shopMap = new HashMap<Long, ShopDto>();
        if (CollectionUtils.isNotEmpty(shopIds) && Objects.nonNull(shopListResponse = this.shopQueryApi.queryByIds(shopIds)) && CollUtil.isNotEmpty((Collection)((Collection)shopListResponse.getData()))) {
            shopMap = ((List)shopListResponse.getData()).stream().collect(Collectors.toMap(ShopDto::getId, Function.identity(), (o1, o2) -> o2));
        }
        ArrayList usedCouponList = Lists.newArrayList();
        this.createUsedCoupon((PageInfo<CouponExtRespDto>)usedCouponExtPageInfo, usedCouponList, shopMap);
        ArrayList normalCouponList = Lists.newArrayList();
        ArrayList expiredCouponList = Lists.newArrayList();
        this.createNormalAndExpiredCoupon((PageInfo<CouponExtRespDto>)couponExtPageInfo, normalCouponList, expiredCouponList, shopMap);
        customerCouponRespDto.setNormalCouponList((List)normalCouponList);
        customerCouponRespDto.setUsedCouponList((List)usedCouponList);
        customerCouponRespDto.setExpiredCouponList((List)expiredCouponList);
        return customerCouponRespDto;
    }

    private void createUsedCoupon(PageInfo<CouponExtRespDto> usedCouponExtPageInfo, List<CouponRespDto> usedCouponList, Map<Long, ShopDto> shopMap) {
        List couuponExtList = usedCouponExtPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)couuponExtList)) {
            for (CouponExtRespDto couponExtRespDto : couuponExtList) {
                if (couponExtRespDto.getCouponTemplate() == null) continue;
                CouponRespDto couponRespDto = new CouponRespDto();
                CubeBeanUtils.copyProperties((Object)couponRespDto, (Object)couponExtRespDto.getCouponTemplate(), (String[])new String[]{"id"});
                couponRespDto.setId(couponExtRespDto.getId());
                couponRespDto.setCouponTemplateId(couponExtRespDto.getCouponTemplateId());
                couponRespDto.setCouponCategory(couponExtRespDto.getCouponTemplate().getCouponCategory());
                couponRespDto.setCouponUseBeginTime(couponExtRespDto.getEffectiveTime());
                couponRespDto.setCouponUseEndTime(couponExtRespDto.getInvalidTime());
                this.setCouponUseTimeDto(couponRespDto, couponExtRespDto);
                couponRespDto.setStatusFlag(Integer.valueOf(3));
                if (Objects.nonNull(couponExtRespDto.getShopId()) && shopMap.containsKey(couponExtRespDto.getShopId())) {
                    couponRespDto.setShopId(couponExtRespDto.getShopId());
                    couponRespDto.setShopName(shopMap.get(couponExtRespDto.getShopId()).getName());
                }
                usedCouponList.add(couponRespDto);
            }
        }
    }

    private void createNormalAndExpiredCoupon(PageInfo<CouponExtRespDto> couponExtPageInfo, List<CouponRespDto> normalCouponList, List<CouponRespDto> expiredCouponList, Map<Long, ShopDto> shopMap) {
        List couuponExtList = couponExtPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)couuponExtList)) {
            for (CouponExtRespDto couponExtRespDto : couuponExtList) {
                if (couponExtRespDto.getCouponTemplate() == null) continue;
                CouponRespDto couponRespDto = new CouponRespDto();
                CubeBeanUtils.copyProperties((Object)couponRespDto, (Object)couponExtRespDto.getCouponTemplate(), (String[])new String[]{"id"});
                couponRespDto.setId(couponExtRespDto.getId());
                couponRespDto.setCouponTemplateId(couponExtRespDto.getCouponTemplateId());
                couponRespDto.setCouponCategory(couponExtRespDto.getCouponTemplate().getCouponCategory());
                couponRespDto.setCouponUseBeginTime(couponExtRespDto.getEffectiveTime());
                couponRespDto.setCouponUseEndTime(couponExtRespDto.getInvalidTime());
                if (Objects.nonNull(couponExtRespDto.getShopId()) && shopMap.containsKey(couponExtRespDto.getShopId())) {
                    couponRespDto.setShopId(couponExtRespDto.getShopId());
                    couponRespDto.setShopName(shopMap.get(couponExtRespDto.getShopId()).getName());
                }
                this.setCouponUseTimeDto(couponRespDto, couponExtRespDto);
                if (new Date().after(couponRespDto.getCouponUseEndTime())) {
                    couponRespDto.setStatusFlag(Integer.valueOf(4));
                    expiredCouponList.add(couponRespDto);
                    continue;
                }
                if (new Date().before(couponRespDto.getCouponUseBeginTime())) {
                    couponRespDto.setStatusFlag(Integer.valueOf(2));
                } else {
                    couponRespDto.setStatusFlag(Integer.valueOf(1));
                }
                normalCouponList.add(couponRespDto);
            }
        }
    }

    private void setCouponUseTimeDto(CouponRespDto couponRespDto, CouponExtRespDto couponExtRespDto) {
        if (couponRespDto == null) {
            return;
        }
        if (couponExtRespDto == null) {
            return;
        }
        CouponUseTimeTobDto couponUseTimeTobDto = new CouponUseTimeTobDto();
        JSONObject value = new JSONObject();
        value.put("couponUseBeginTime", (Object)couponRespDto.getCouponUseBeginTime());
        value.put("couponUseEndTime", (Object)couponExtRespDto.getInvalidTime());
        couponUseTimeTobDto.setValue((Object)value);
        if (couponExtRespDto.getValidityType().equals(CouponValidityTypeEnum.FOREVER_DATE.getType())) {
            couponUseTimeTobDto.setType(Integer.valueOf(3));
        } else {
            couponUseTimeTobDto.setType(Integer.valueOf(0));
        }
        couponRespDto.setCouponUseTimeDto(couponUseTimeTobDto);
    }

    private PageInfo<CouponRespDto> convertToCouponPage(PageInfo<CouponExtRespDto> couponExtPageInfo) {
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, couponExtPageInfo, (String[])new String[]{"navigatepageNums", "list"});
        CouponRespDto couponRespDto = null;
        ArrayList<CouponRespDto> couponList = new ArrayList<CouponRespDto>();
        List couuponExtList = couponExtPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)couuponExtList)) {
            for (CouponExtRespDto couponExtRespDto : couuponExtList) {
                if (couponExtRespDto.getCouponTemplate() == null) continue;
                couponRespDto = new CouponRespDto();
                CubeBeanUtils.copyProperties((Object)couponRespDto, (Object)couponExtRespDto.getCouponTemplate(), (String[])new String[]{"id"});
                couponRespDto.setId(couponExtRespDto.getId());
                couponRespDto.setCouponTemplateId(couponExtRespDto.getCouponTemplateId());
                couponRespDto.setCouponCategory(couponExtRespDto.getCouponTemplate().getCouponCategory());
                couponRespDto.setCouponUseBeginTime(couponExtRespDto.getEffectiveTime());
                couponRespDto.setCouponUseEndTime(couponExtRespDto.getInvalidTime());
                this.setCouponUseTimeDto(couponRespDto, couponExtRespDto);
                couponList.add(couponRespDto);
            }
        }
        pageInfo.setList(couponList);
        return pageInfo;
    }

    public CouponPushRespDto receiveCoupon(Long couponTemplateId, String placeType, Long customerId) {
        CouponPushRespDto couponPushDto;
        CouponBatchSendReqDto example = new CouponBatchSendReqDto();
        example.setIsValidate(false);
        ArrayList<Long> memberIds = new ArrayList<Long>();
        memberIds.add(this.marketingModuleHelper.getOrgIdByContext());
        example.setMemberIds(memberIds);
        ArrayList<CouponSendTemplateReqDto> couponSendReqDtoList = new ArrayList<CouponSendTemplateReqDto>();
        CouponSendTemplateReqDto couponSendDto = new CouponSendTemplateReqDto();
        couponSendDto.setCouponTemplateId(couponTemplateId);
        couponSendDto.setSendNum(Integer.valueOf(1));
        couponSendReqDtoList.add(couponSendDto);
        example.setTemplates(couponSendReqDtoList);
        example.setCheckPointCode("IC_RECEIVE_COUPON");
        example.setReturnSucess(Integer.valueOf(1));
        RestResponse restResponse = this.couponExtApi.reviceCoupon2C(example);
        if (restResponse.getResultCode().equals(CouponTemplateErrorEnum.COUPON_TEMPLATE_NOT_ACTIVATE.getCode())) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_INVENTORY_LACK);
        }
        if ((couponPushDto = (CouponPushRespDto)RestResponseHelper.extractData((RestResponse)restResponse)) != null && CollectionUtils.isNotEmpty((Collection)couponPushDto.getFailData())) {
            CouponPushErrorDto errorDto = (CouponPushErrorDto)couponPushDto.getFailData().get(0);
            if (CouponTemplateErrorEnum.COUPON_TEMPLATE_NOT_ACTIVATE.getCode().equals(errorDto.getErrorCode())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_INVENTORY_LACK);
            } else if (CouponTemplateErrorEnum.OUPON_TEMPLATE_RECEIVE_NUM_INSUFFICIENT.getCode().equals(errorDto.getErrorCode())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_NUM_LIMIT);
            } else if (CouponTemplateErrorEnum.COUPON_TEMPLATE_IS_EXPIRE.getCode().equals(errorDto.getErrorCode())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_TIME_INVALID);
            } else {
                if (CouponTemplateErrorEnum.COUPON_BEFORE_RECEIVE_START_TIME.getCode().equals(errorDto.getErrorCode())) {
                    String msg = "\u8fd8\u672a\u5230\u9886\u53d6\u65f6\u95f4";
                    throw new BizException(msg);
                }
                throw new BizException(errorDto.getErrorCode(), errorDto.getErrorMsg());
            }
        }
        return couponPushDto;
    }

    private CouponTemplateExtRespDto validReceiveTime(Long couponTemplateId) {
        CouponTemplateExtRespDto templateExtRespDto = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryById(couponTemplateId));
        Date startTime = templateExtRespDto.getReceiveStartTime();
        Date endTime = templateExtRespDto.getReceiveEndTime();
        if (endTime.compareTo(new Date()) < 0) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_TIME_INVALID);
        }
        return templateExtRespDto;
    }

    public List<CouponTemplateTobDto> queryByActivityIds(List<Long> activityIds) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)dateFormat.format(new Date())));
        sqlFilterList.add(SqlFilter.in((String)"activity_id", activityIds));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)CouponTypeEnum.COUPON.getType()));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        PageInfo couponTpPage = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(activityIds.size())).getData();
        PageInfo<CouponTemplateTobDto> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTpPage);
        this.trans2UseTimeDtoList(pageInfo.getList());
        return pageInfo.getList();
    }

    public List<CouponTemplateTobDto> queryByIds(List<Long> ids) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", ids));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        PageInfo couponTpPage = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(ids.size())).getData();
        PageInfo<CouponTemplateTobDto> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTpPage);
        this.trans2UseTimeDtoList(pageInfo.getList());
        return pageInfo.getList();
    }

    private List<String> getCustomerIdsBySalesmanId(Long salesmanId) {
        List<Object> customerIds = Lists.newArrayList();
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setSalesmanId(salesmanId);
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse listRestResp = this.customerQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            customerIds = customerRespDtos.stream().map(o -> o.getId().toString()).collect(Collectors.toList());
        }
        return customerIds;
    }
}

