/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountCustomerConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.query.ICrAccountCustomerConfigQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditNodeApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.AccountOccupyInfo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineResult;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.OrderSkuInfo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OrderNodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderRebateAmountQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRebateAmountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DefaultValue;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.IExchangeBalanceAccountApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderItemService;
import com.dtyunxi.yundt.module.trade.api.IShoppingCart;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.CreditBatchPayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.CreditPayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.CancelOrderForControlReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderItemBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderJoinActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderSubmitItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderSubmitRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.shop.ShopInfo;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeTobEnum;
import com.dtyunxi.yundt.module.trade.api.enums.OrderBizTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.OrderSubmitErrorTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PayMethodEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PayStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.SubmitTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.IControlService;
import com.dtyunxi.yundt.module.trade.biz.IPriceLimitService;
import com.dtyunxi.yundt.module.trade.biz.IPriceService;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import com.dtyunxi.yundt.module.trade.biz.pay.PayFactory;
import com.dtyunxi.yundt.module.trade.biz.storageHelper.IStorageHelper;
import com.dtyunxi.yundt.module.trade.biz.util.DeliveryRuleUtils;
import com.dtyunxi.yundt.module.trade.biz.util.KeyGenerator;
import com.dtyunxi.yundt.module.trade.biz.util.SeckillActivityUtil;
import com.dtyunxi.yundt.module.trade.biz.util.TradeUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountRollBackReqDto;
import com.yx.tcbj.center.rebate.api.query.IOfflineBalanceAccountQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SubmitOrderHandler
implements IServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(SubmitOrderHandler.class);
    @Resource
    private IOrderApi orderApi;
    @Value(value="${item.storage.userItemCenter:true}")
    private boolean userItemCenter;
    @Resource
    private IContext context;
    @Resource
    private ICargoQueryApi iCargoQueryApi;
    @Resource
    private IStorageHelper iStorageHelper;
    @Value(value="${order.create.order.module:CHECK}")
    private String CREATE_ORDER_MODULE;
    @Resource
    private ICommonService commonService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ICustomerExtQueryApi iCustomerQueryApi;
    @Resource
    private IShoppingCart shoppingCart;
    @Resource
    private IOrderItemService itemService;
    @Resource
    private ICreditNodeApi creditNodeApi;
    @Resource
    private PayFactory payFactory;
    @Resource
    private IPriceLimitService priceLimitService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IControlService controlService;
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Autowired
    private IOfflineBalanceAccountQueryApi offlineBalanceAccountQueryApi;
    @Resource
    private IPriceService priceService;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Resource
    private ILockService lockService;
    @Resource
    private IBalanceQueryApi balanceQueryApi;
    @Resource
    private ICrAccountCustomerConfigQueryApi accountCustomerConfigQueryApi;
    @Autowired
    private IExchangeBalanceAccountApi exchangeBalanceAccountApi;
    @Autowired
    private SeckillActivityUtil seckillActivityUtil;
    @Autowired
    private DeliveryRuleUtils deliveryRuleUtils;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    private final String LOCK_PRE = "CUSTOMER_ID:%s";

    public Object handle(ServiceEvent<?> serviceEvent) {
        boolean isFail;
        OrderSubmitRespDto orderSubmitRespDto = new OrderSubmitRespDto();
        SubmitOrderReqDto mainOrderInfoDto = (SubmitOrderReqDto)serviceEvent.getData();
        ArrayList<OrderSubmitItemRespDto> list = new ArrayList<OrderSubmitItemRespDto>();
        boolean isSingleOrder = mainOrderInfoDto.getSonOrder().size() == 1;
        this.setPreOrderNo(mainOrderInfoDto.getSonOrder());
        mainOrderInfoDto.setOrderNo(isSingleOrder ? ((SubmitOrderReqDto)mainOrderInfoDto.getSonOrder().get(0)).getOrderNo() : TradeUtil.generateOrderNo(mainOrderInfoDto.getCustomerCode()));
        mainOrderInfoDto.setCreditBatchPayList(this.getCreditBatchPayReqDtos(mainOrderInfoDto));
        mainOrderInfoDto.setTotalRebateAmount(this.getTotalRebateAmount(mainOrderInfoDto));
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), String.format("CUSTOMER_ID:%s", mainOrderInfoDto.getCustomerId()), 2000, 5000, TimeUnit.MILLISECONDS);
        this.buildOrderParam(mainOrderInfoDto);
        OrderSubmitItemRespDto orderSubmitItemRespDto = this.addMainOrder(mainOrderInfoDto);
        boolean bl = isFail = orderSubmitItemRespDto.getOrderSubmitErrorType() != null && !orderSubmitItemRespDto.getOrderSubmitErrorType().equals("SUCCESS");
        if (isSingleOrder || isFail) {
            list.add(orderSubmitItemRespDto);
            this.lockService.unlock(lock);
            return this.buildSuccessReturn(orderSubmitRespDto, list, orderSubmitItemRespDto);
        }
        if ("N".equals(mainOrderInfoDto.getSubmitOrNot())) {
            list.add(orderSubmitItemRespDto);
            orderSubmitRespDto.setSubmitNum(Integer.valueOf(0));
            orderSubmitRespDto.setSaveNum(Integer.valueOf(list.size()));
            orderSubmitRespDto.setFailNum(Integer.valueOf(0));
            orderSubmitRespDto.setSaveOrders(list);
            this.lockService.unlock(lock);
            return orderSubmitRespDto;
        }
        AtomicInteger submitNum = new AtomicInteger(0);
        AtomicInteger saveNum = new AtomicInteger(0);
        AtomicInteger failNum = new AtomicInteger(0);
        ArrayList submitOrders = new ArrayList();
        ArrayList saveOrders = new ArrayList();
        ArrayList failOrders = new ArrayList();
        String finalParentOrderNo = orderSubmitItemRespDto.getOrderNo();
        Long userId = this.context.userId();
        Long applicationId = this.context.applicationId();
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        String userName = this.context.userName();
        mainOrderInfoDto.getSonOrder().stream().map(saveOrderReqDto -> {
            this.context.userId(userId);
            this.context.applicationId(applicationId);
            this.context.instanceId(instanceId);
            this.context.tenantId(tenantId);
            this.context.userName(userName);
            saveOrderReqDto.setParentOrderNo(finalParentOrderNo);
            saveOrderReqDto.setIsSplit(DefaultValue.NO);
            saveOrderReqDto.setDeliveryDate(saveOrderReqDto.getDeliveryDate() == null ? new Date() : saveOrderReqDto.getDeliveryDate());
            OrderSubmitItemRespDto sunOrderSubmitItem = new OrderSubmitItemRespDto();
            try {
                sunOrderSubmitItem = this.addSonOrder((SubmitOrderReqDto)saveOrderReqDto);
                if (sunOrderSubmitItem.getIsSubmit().equals(YesNoEnum.YES.getValue())) {
                    submitNum.incrementAndGet();
                    submitOrders.add(sunOrderSubmitItem);
                } else if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sunOrderSubmitItem.getOrderNo())) {
                    saveNum.incrementAndGet();
                    saveOrders.add(sunOrderSubmitItem);
                } else {
                    failOrders.add(sunOrderSubmitItem);
                    failNum.incrementAndGet();
                }
            }
            catch (Exception e) {
                sunOrderSubmitItem.setOrderSubmitErrorType(OrderSubmitErrorTypeEnum.SYSTEM_ERROR.getCode());
                sunOrderSubmitItem.setErrorMsg(e.getMessage());
                failOrders.add(sunOrderSubmitItem);
                logger.info("\u521b\u5efa\u5b50\u8ba2\u5355\u4e0e\u652f\u4ed8\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)saveOrderReqDto));
                this.lockService.unlock(lock);
                logger.error("[\u521b\u5efa\u5b50\u8ba2\u5355\u4e0e\u652f\u4ed8\u5931\u8d25]", (Throwable)e);
            }
            return null;
        }).collect(Collectors.toList());
        orderSubmitRespDto.setSubmitOrders(submitOrders);
        orderSubmitRespDto.setSaveOrders(saveOrders);
        orderSubmitRespDto.setFailOrders(failOrders);
        orderSubmitRespDto.setSubmitNum(Integer.valueOf(submitNum.get()));
        orderSubmitRespDto.setSaveNum(Integer.valueOf(saveNum.get()));
        orderSubmitRespDto.setFailNum(Integer.valueOf(failNum.get()));
        this.lockService.unlock(lock);
        return orderSubmitRespDto;
    }

    private OrderSubmitRespDto buildSuccessReturn(OrderSubmitRespDto orderSubmitRespDto, List<OrderSubmitItemRespDto> list, OrderSubmitItemRespDto orderSubmitItemRespDto) {
        if (orderSubmitItemRespDto.getOrderSubmitErrorType() != null && !orderSubmitItemRespDto.getOrderSubmitErrorType().equals("SUCCESS")) {
            orderSubmitRespDto.setFailOrders(list);
            orderSubmitRespDto.setFailNum(Integer.valueOf(1));
        } else {
            orderSubmitRespDto.setSubmitNum(Integer.valueOf(list.size()));
            orderSubmitRespDto.setSubmitOrders(list);
        }
        return orderSubmitRespDto;
    }

    private void buildOrderParam(SubmitOrderReqDto mainOrderInfoDto) {
        this.batchChangeSubmitData(mainOrderInfoDto);
        this.buildMutOrderParam(mainOrderInfoDto);
    }

    private void buildMutOrderParam(SubmitOrderReqDto mainOrderInfoDto) {
        List<OrderItemInfoDto> totalItemList = this.buildParentOrderItems(mainOrderInfoDto.getSonOrder());
        mainOrderInfoDto.setItemList(totalItemList);
        mainOrderInfoDto.setIsParentOrder("Y");
        if (CollectionUtils.isNotEmpty((Collection)mainOrderInfoDto.getSonOrder()) && mainOrderInfoDto.getSonOrder().size() > 1) {
            mainOrderInfoDto.setIsSplit(DefaultValue.YES);
            mainOrderInfoDto.setGiftAccount(false);
            mainOrderInfoDto.setDeduction(false);
            mainOrderInfoDto.setPayMethod(PayMethodEnum.NORMAL_PAY_HELP.getCode());
            mainOrderInfoDto.setOrderActivity(null);
        } else {
            mainOrderInfoDto.setIsSplit(DefaultValue.NO);
        }
        mainOrderInfoDto.setOrderReqDto(this.getOrderReqDto(mainOrderInfoDto));
        mainOrderInfoDto.setDeliveryDate(mainOrderInfoDto.getDeliveryDate() == null ? new Date() : mainOrderInfoDto.getDeliveryDate());
    }

    private OrderReqDto getOrderReqDto(SubmitOrderReqDto mainOrderInfoDto) {
        OrderReqDto orderReqDto = ((SubmitOrderReqDto)mainOrderInfoDto.getSonOrder().get(0)).getOrderReqDto();
        OrderReqDto mainOrderReqDto = new OrderReqDto();
        BeanUtils.copyProperties((Object)orderReqDto, (Object)mainOrderReqDto);
        ArrayList list = new ArrayList();
        for (SubmitOrderReqDto submitOrderReqDto : mainOrderInfoDto.getSonOrder()) {
            list.addAll(submitOrderReqDto.getOrderReqDto().getOrderItems());
        }
        if (mainOrderInfoDto.getSonOrder().size() > 1) {
            mainOrderReqDto.setActivity(null);
        }
        mainOrderReqDto.setOrderItems(list);
        mainOrderReqDto.setIsSplitBySys("N");
        return mainOrderReqDto;
    }

    private OrderSubmitItemRespDto addMainOrder(SubmitOrderReqDto mainOrderInfoDto) {
        OrderSubmitItemRespDto orderSubmitItemRespDto = null;
        if (!"N".equals(mainOrderInfoDto.getSubmitOrNot())) {
            orderSubmitItemRespDto = this.preController(mainOrderInfoDto);
            if (!OrderSubmitErrorTypeEnum.SUCCESS.getCode().equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
                this.stockCallBack(orderSubmitItemRespDto, mainOrderInfoDto);
                this.controlCallBack(orderSubmitItemRespDto, mainOrderInfoDto);
                return orderSubmitItemRespDto;
            }
        }
        orderSubmitItemRespDto = this.addOrder(mainOrderInfoDto);
        if (!"N".equals(mainOrderInfoDto.getSubmitOrNot())) {
            this.callBack(mainOrderInfoDto, orderSubmitItemRespDto);
            if (mainOrderInfoDto.getOfflineAmount() != null && BigDecimal.ZERO.compareTo(mainOrderInfoDto.getOfflineAmount()) < 0) {
                this.offlineAccountCallBack(mainOrderInfoDto, orderSubmitItemRespDto);
            }
        }
        return orderSubmitItemRespDto;
    }

    private void controlCallBack(OrderSubmitItemRespDto orderSubmitItemRespDto, SubmitOrderReqDto mainOrderInfoDto) {
        if (!OrderSubmitErrorTypeEnum.SUCCESS.getCode().equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
            if ("N".equals(mainOrderInfoDto.getIsParentOrder()) && mainOrderInfoDto.isPassControl()) {
                logger.info("[\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25][\u5b50\u8ba2\u5355\u5931\u8d25\u7ba1\u63a7\u56de\u8c03]\uff1a {} ", (Object)JSON.toJSONString((Object)mainOrderInfoDto));
                CancelOrderForControlReqDto amountControlReqDto = new CancelOrderForControlReqDto();
                amountControlReqDto.setOrderNo(mainOrderInfoDto.getOrderNo());
                amountControlReqDto.setCustomerId(mainOrderInfoDto.getCustomerId());
                this.controlService.cancelOrder(amountControlReqDto);
            }
            for (SubmitOrderReqDto submitOrderReqDto : mainOrderInfoDto.getSonOrder()) {
                if (!submitOrderReqDto.isPassControl()) continue;
                logger.info("[\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25][\u7236\u8ba2\u5355\u5931\u8d25\u7ba1\u63a7\u56de\u8c03]\uff1a {} ", (Object)JSON.toJSONString((Object)submitOrderReqDto));
                CancelOrderForControlReqDto amountControlReqDto = new CancelOrderForControlReqDto();
                amountControlReqDto.setOrderNo(submitOrderReqDto.getOrderNo());
                amountControlReqDto.setCustomerId(submitOrderReqDto.getCustomerId());
                this.controlService.cancelOrder(amountControlReqDto);
            }
        }
    }

    private void callBack(SubmitOrderReqDto orderInfoDto, OrderSubmitItemRespDto orderSubmitItemRespDto) {
        this.stockCallBack(orderSubmitItemRespDto, orderInfoDto);
        this.creditCallBack(orderSubmitItemRespDto, orderInfoDto);
        this.controlCallBack(orderSubmitItemRespDto, orderInfoDto);
    }

    private void creditCallBack(OrderSubmitItemRespDto orderSubmitItemRespDto, SubmitOrderReqDto orderInfoDto) {
        logger.info("\u4fe1\u7528\u652f\u4ed8\u7edf\u4e00\u56de\u8c03, param is {} ", (Object)JSON.toJSONString((Object)orderInfoDto));
        this.returnCreditPay(orderSubmitItemRespDto.getOrderSubmitErrorType(), orderInfoDto);
    }

    private void stockCallBack(OrderSubmitItemRespDto orderSubmitItemRespDto, SubmitOrderReqDto mainOrderInfoDto) {
        if (!"SUCCESS".equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
            if ("N".equals(mainOrderInfoDto.getIsParentOrder()) && "Y".equals(mainOrderInfoDto.getIsUseStock())) {
                logger.info("\u5e93\u5b58\u7edf\u4e00\u56de\u6eda, mainOrderInfoDto is {} ", (Object)JSON.toJSONString((Object)mainOrderInfoDto));
                this.iStorageHelper.rollbackVirSotrage(mainOrderInfoDto, mainOrderInfoDto.getOrderNo(), mainOrderInfoDto.getOrderReqDto().getOrderItems());
            }
            for (SubmitOrderReqDto submitOrderReqDto : mainOrderInfoDto.getSonOrder()) {
                if (!"Y".equals(submitOrderReqDto.getIsUseStock())) continue;
                logger.info("\u5e93\u5b58\u7edf\u4e00\u56de\u6eda, mainOrderInfoDto is {} ", (Object)JSON.toJSONString((Object)submitOrderReqDto));
                this.iStorageHelper.rollbackVirSotrage(submitOrderReqDto, submitOrderReqDto.getOrderNo(), submitOrderReqDto.getOrderReqDto().getOrderItems());
            }
        }
    }

    private OrderSubmitItemRespDto preController(SubmitOrderReqDto mainOrderInfoDto) {
        OrderReqDto orderReqDto = mainOrderInfoDto.getOrderReqDto();
        for (SubmitOrderReqDto submitOrderReqDto : mainOrderInfoDto.getSonOrder()) {
            submitOrderReqDto.setPassControl(true);
            Integer isControlError = YesOrNoEnum.NO.getCode();
            String controlErrorMsg = "";
            String controlErrorCode = "";
            try {
                RestResponse<Void> restResponse = this.checkControl(submitOrderReqDto, submitOrderReqDto.getOrderReqDto());
                if (restResponse == null || "0".equals(restResponse.getResultCode())) continue;
                isControlError = YesOrNoEnum.YES.getCode();
                controlErrorMsg = restResponse.getResultMsg();
                controlErrorCode = restResponse.getResultCode();
                throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
            }
            catch (Exception e) {
                logger.error("[\u7ba1\u63a7\u6821\u9a8c\u62a5\u9519]\uff1a{}", (Throwable)e);
                OrderSubmitItemRespDto contorlFail = this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), OrderSubmitErrorTypeEnum.ORDER_SUBMIT_FAIL, OrderSubmitErrorTypeEnum.CONTROL_FAIL.getName(), null);
                contorlFail.setIsControlError(isControlError);
                contorlFail.setControlErrorMsg(controlErrorMsg);
                contorlFail.setControlErrorCode(controlErrorCode);
                return contorlFail;
            }
        }
        OrderSubmitItemRespDto orderSubmitItemRespDto = this.preOccupyStock(mainOrderInfoDto, mainOrderInfoDto.getOrderReqDto().getOrderItems());
        if (!"SUCCESS".equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
            return orderSubmitItemRespDto;
        }
        if (!CollectionUtils.isEmpty((Collection)mainOrderInfoDto.getCreditBatchPayList())) {
            orderSubmitItemRespDto = this.batchCreditPay(mainOrderInfoDto, orderReqDto);
            logger.info("---------------\u4e3b\u8ba2\u5355\u4fe1\u7528\u6279\u91cf\u652f\u4ed8:{}", (Object)JSONObject.toJSONString((Object)orderSubmitItemRespDto));
            if (!"SUCCESS".equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
                return orderSubmitItemRespDto;
            }
        }
        if (mainOrderInfoDto.getTotalRebateAmount() != null && mainOrderInfoDto.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
            orderSubmitItemRespDto = this.batchRebate(mainOrderInfoDto, orderReqDto);
            logger.info("---------------\u4e3b\u8ba2\u5355\u6821\u9a8c\u8fd4\u5229\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)orderSubmitItemRespDto));
            if (!"SUCCESS".equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
                return orderSubmitItemRespDto;
            }
        }
        if (mainOrderInfoDto.getAccountPeriodPayAmount() != null && mainOrderInfoDto.getAccountPeriodPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            orderSubmitItemRespDto = this.getAccountCustomerConfig(mainOrderInfoDto, orderReqDto);
            logger.info("---------------\u4e3b\u8ba2\u5355\u6821\u9a8c\u8d26\u671f\u652f\u4ed8:[{}]", (Object)JSONObject.toJSONString((Object)orderSubmitItemRespDto));
            if (orderSubmitItemRespDto != null && !"SUCCESS".equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
                return orderSubmitItemRespDto;
            }
        }
        return orderSubmitItemRespDto;
    }

    @Nullable
    private OrderSubmitItemRespDto getAccountCustomerConfig(SubmitOrderReqDto mainOrderInfoDto, OrderReqDto orderReqDto) {
        OrderSubmitErrorTypeEnum submitErrorTypeEnum = OrderSubmitErrorTypeEnum.SUCCESS;
        CrAccountCustomerConfigRespDto respDto = (CrAccountCustomerConfigRespDto)RestResponseHelper.extractData((RestResponse)this.accountCustomerConfigQueryApi.queryAccountByCustomerCode(mainOrderInfoDto.getCustomerCode()));
        logger.info("\u5ba2\u6237\u7f16\u7801:[{}]\u662f\u5426\u8d26\u671f\u652f\u4ed8\uff0c\u5176\u5173\u8054\u8d26\u671f\u6a21\u578b\u4fe1\u606f\u662f[{}]", (Object)mainOrderInfoDto.getCustomerCode(), (Object)JSONObject.toJSONString((Object)respDto));
        if (ObjectUtil.isEmpty((Object)respDto.getId())) {
            submitErrorTypeEnum = OrderSubmitErrorTypeEnum.PAY_REJECT;
            return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, "\u65e0\u53ef\u7528\u8d26\u671f", null);
        }
        return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, "", null);
    }

    private void returnCreditPay(String errorType, SubmitOrderReqDto orderInfoDto) {
        boolean isParentOrder;
        ArrayList<SubmitOrderReqDto> orderInfoList = new ArrayList<SubmitOrderReqDto>();
        boolean bl = isParentOrder = Objects.equals("Y", orderInfoDto.getIsParentOrder()) && Integer.valueOf(1).equals(orderInfoDto.getIsSplit());
        if (isParentOrder || Objects.equals("N", orderInfoDto.getIsParentOrder())) {
            logger.info("\u4fe1\u7528\u652f\u4ed8\u63d0\u4ea4\u7c7b\u578b\uff1a{}\uff0c\u591a\u5e97\u94fa\u7236\u8ba2\u5355\u6216\u8005\u591a\u5e97\u94fa\u5b50\u8ba2\u5355:{}", (Object)errorType, (Object)JSON.toJSONString((Object)orderInfoDto));
            orderInfoList.add(orderInfoDto);
        } else {
            logger.info("\u4fe1\u7528\u652f\u4ed8\u63d0\u4ea4\u7c7b\u578b\uff1a{}\uff0c\u5355\u5e97\u94fa\u4e0b\u5355:{}", (Object)errorType, (Object)JSON.toJSONString((Object)orderInfoDto.getSonOrder()));
            orderInfoList.addAll(orderInfoDto.getSonOrder());
        }
        AbstractPayHelp abstractPayHelp = null;
        for (SubmitOrderReqDto creditBatchPayReqDto : orderInfoList) {
            if (creditBatchPayReqDto.getSimplePayReqDto() == null || creditBatchPayReqDto.getSimplePayReqDto().getCreditPayReqDto() == null || "N".equals(creditBatchPayReqDto.getSimplePayReqDto().getCreditPayReqDto().getCreditPayRespDto().getIsUseCreditPay())) continue;
            abstractPayHelp = this.payFactory.create(PayMethodEnum.CREDIT_PAY.getCode());
            SimplePayReqDto simplePayReqDto = creditBatchPayReqDto.getSimplePayReqDto();
            logger.info("\u4fe1\u7528\u652f\u4ed8\u56de\u6eda\u53c2\u6570, param is {} ", (Object)JSON.toJSONString((Object)simplePayReqDto));
            if (!"SUCCESS".equals(errorType)) {
                simplePayReqDto.getCreditPayReqDto().setRemark("\u8ba2\u5355\u521b\u5efa\u5931\u8d25,\u8fdb\u884c\u56de\u6eda");
                abstractPayHelp.errorCallBack(simplePayReqDto);
                continue;
            }
            simplePayReqDto.getCreditPayReqDto().setRemark("\u8ba2\u5355\u521b\u5efa\u5931\u8d25,\u8fdb\u884c\u56de\u6eda");
            abstractPayHelp.successCallBack(simplePayReqDto);
        }
    }

    private OrderSubmitItemRespDto addSonOrder(SubmitOrderReqDto sonOrderInfoDto) {
        OrderSubmitItemRespDto orderSubmitItemRespDto = this.addOrder(sonOrderInfoDto);
        if (!"N".equals(sonOrderInfoDto.getSubmitOrNot())) {
            this.callBack(sonOrderInfoDto, orderSubmitItemRespDto);
            if (BigDecimal.ZERO.compareTo(sonOrderInfoDto.getOfflineAmount()) < 0) {
                this.offlineAccountCallBack(sonOrderInfoDto, orderSubmitItemRespDto);
            }
        }
        return orderSubmitItemRespDto;
    }

    private void offlineAccountCallBack(SubmitOrderReqDto sonOrderInfoDto, OrderSubmitItemRespDto orderSubmitItemRespDto) {
        if ("SUCCESS".equals(orderSubmitItemRespDto.getOrderSubmitErrorType())) {
            AbstractPayHelp abstractPayHelp = this.payFactory.create(PayMethodEnum.OFFLINE_ACCOUNT_PAY.getCode());
            SimplePayReqDto simplePayReqDto = abstractPayHelp.initParam(sonOrderInfoDto);
            logger.info("\u7ebf\u4e0b\u4f59\u989d\u8d26\u6237\u652f\u4ed8\u53c2\u6570 {} ", (Object)JSON.toJSONString((Object)simplePayReqDto));
            abstractPayHelp.successCallBack(simplePayReqDto);
        }
    }

    private SubmitOrderReqDto batchChangeSubmitData(SubmitOrderReqDto mainOrderInfoDto) {
        for (SubmitOrderReqDto submitOrderReqDto : mainOrderInfoDto.getSonOrder()) {
            this.changeSubmitData(submitOrderReqDto, mainOrderInfoDto.getOrderNo());
            OrderDeliveryTypeEnum orderDeliveryTypeEnum = this.checkDeliveryType(submitOrderReqDto);
            submitOrderReqDto.getOrderReqDto().setDeliveryType(orderDeliveryTypeEnum.getType());
        }
        return mainOrderInfoDto;
    }

    private void changeSubmitData(SubmitOrderReqDto submitOrderReqDto, String orderParentNo) {
        Map<Long, ItemDetailRespDto> itemDetails = this.buildOrderItem(submitOrderReqDto);
        this.validateOrderInfo(submitOrderReqDto, itemDetails);
        OrderReqDto orderReqDto = this.convertToOrderReqDto(submitOrderReqDto, itemDetails);
        orderReqDto.setParentOrderNo(orderParentNo);
        submitOrderReqDto.setOrderReqDto(orderReqDto);
    }

    private void setPreOrderNo(List<SubmitOrderReqDto> saveOrderReqDtos) {
        for (SubmitOrderReqDto saveOrderReqDto : saveOrderReqDtos) {
            saveOrderReqDto.setOrderNo(TradeUtil.generateOrderNo(saveOrderReqDto.getCustomerCode()));
        }
    }

    private List<CreditBatchPayReqDto> getCreditBatchPayReqDtos(SubmitOrderReqDto mainOrder) {
        List saveOrderReqDtos = mainOrder.getSonOrder();
        return saveOrderReqDtos.stream().filter(data -> PayMethodEnum.CREDIT_PAY.getCode().equals(data.getPayMethod())).map(data -> {
            CreditBatchPayReqDto newData = new CreditBatchPayReqDto();
            newData.setCreditAccountId(data.getCreditAccountId());
            newData.setCreditPayAmount(data.getCreditPayAmount());
            newData.setOrderNo(data.getOrderNo());
            return newData;
        }).collect(Collectors.toList());
    }

    private BigDecimal getTotalRebateAmount(SubmitOrderReqDto mainOrder) {
        BigDecimal totalRebateAmountBySon = mainOrder.getSonOrder().stream().map(item -> item.getTotalRebateAmount() == null ? BigDecimal.ZERO : item.getTotalRebateAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalRebateAmountBySon;
    }

    private List<OrderItemInfoDto> buildParentOrderItems(List<SubmitOrderReqDto> saveOrderReqDtos) {
        ArrayList<OrderItemInfoDto> totalItemList = new ArrayList<OrderItemInfoDto>();
        for (SubmitOrderReqDto saveOrderReqDto : saveOrderReqDtos) {
            totalItemList.addAll(saveOrderReqDto.getItemList());
        }
        return totalItemList;
    }

    @NotNull
    private OrderSubmitItemRespDto addOrder(SubmitOrderReqDto orderInfoDto) {
        String payType;
        String orderNo = null;
        SimplePayReqDto simplePayReqDto = null;
        Assert.isTrue((orderInfoDto != null ? 1 : 0) != 0, (String)TradeModuleExcpCode.ORDER_INFO_NOT_VALID.getMsg(), (Object[])new Object[0]);
        orderInfoDto.setSubmitDate(new Date());
        OrderSubmitErrorTypeEnum submitErrorTypeEnum = OrderSubmitErrorTypeEnum.SUCCESS;
        String errorMsg = null;
        OrderRespDto orderRespDto = null;
        SubmitTypeEnum orderSubmitType = "N".equals(orderInfoDto.getSubmitOrNot()) ? SubmitTypeEnum.SAVE : SubmitTypeEnum.SUBMIT;
        boolean isP = orderInfoDto.getSonOrder().size() > 1;
        boolean isOrder = CollectionUtils.isEmpty((Collection)orderInfoDto.getSonOrder()) || orderInfoDto.getSonOrder().size() == 1;
        this.buildData(orderInfoDto);
        this.buildAgainOrder(orderInfoDto);
        OrderReqDto orderReqDto = orderInfoDto.getOrderReqDto();
        orderReqDto.setOrderNo(StringUtils.isEmpty((String)orderInfoDto.getOrderNo()) ? TradeUtil.generateOrderNo(orderInfoDto.getCustomerCode()) : orderInfoDto.getOrderNo());
        orderInfoDto.setOrderNo(orderReqDto.getOrderNo());
        logger.info("\u9884\u8bbe\u8ba2\u5355\u53f7\uff1a\u5ba2\u6237\u7f16\u7801[{}],\u9884\u5360\u8ba2\u5355\u7f16\u7801[{}],\u4e0a\u7ea7\u7f16\u7801[{}]", new Object[]{orderInfoDto.getCustomerCode(), orderReqDto.getOrderNo(), orderInfoDto.getMerchantId()});
        orderReqDto.setIsSplit(orderInfoDto.getIsSplit());
        orderReqDto.setTotalRebateAmount(SubmitTypeEnum.SAVE == orderSubmitType ? BigDecimal.ZERO : orderReqDto.getTotalRebateAmount());
        orderReqDto.setUseRebateDeduct(SubmitTypeEnum.SAVE != orderSubmitType && orderReqDto.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0);
        orderReqDto.setIsCycleBuy(Integer.valueOf(0));
        this.buildSubmitResult(orderInfoDto, orderReqDto);
        AbstractPayHelp abstractPayHelp = null;
        String oriPayType = payType = isP || "N".equals(orderInfoDto.getSubmitOrNot()) || StringUtils.isBlank((String)orderInfoDto.getPayMethod()) ? PayMethodEnum.NORMAL_PAY_HELP.getCode() : orderInfoDto.getPayMethod();
        try {
            if (payType.equals(PayMethodEnum.CREDIT_PAY.getCode())) {
                payType = PayMethodEnum.NORMAL_PAY_HELP.getCode();
            }
            logger.info("---------------\u4f7f\u7528\u652f\u4ed8\u65b9\u5f0f:" + JSONObject.toJSONString((Object)payType));
            if ("ACCOUNT_PERIOD".equals(payType)) {
                orderReqDto.setBizType(OrderBizTypeEnum.NO_PAY_RETURN.getCode().toString());
            }
            abstractPayHelp = this.payFactory.create(payType);
            simplePayReqDto = abstractPayHelp.initParam(orderInfoDto, orderReqDto);
            abstractPayHelp.prePay(simplePayReqDto);
            if (!abstractPayHelp.allowSubmitOrder(simplePayReqDto)) {
                submitErrorTypeEnum = OrderSubmitErrorTypeEnum.PAY_REJECT;
                errorMsg = simplePayReqDto.getPayMsg();
                if (StringUtils.isBlank((String)simplePayReqDto.getPayMsg())) {
                    errorMsg = "\u8be5\u652f\u4ed8\u65b9\u5f0f:" + this.getPayName(orderInfoDto) + "\u4e0d\u5141\u8bb8\u652f\u4ed8";
                }
                return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, errorMsg, null);
            }
        }
        catch (Exception e) {
            submitErrorTypeEnum = OrderSubmitErrorTypeEnum.PAY_ERROR;
            errorMsg = "\u8be5\u652f\u4ed8\u65b9\u5f0f:" + this.getPayName(orderInfoDto) + "  " + e.getMessage();
            logger.info("\u652f\u4ed8\u89e6\u53d1\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)abstractPayHelp));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        if ("SKILL_ORDER".equals(orderReqDto.getFlowType())) {
            this.increaseJoinAcitvityNum(orderInfoDto, 1);
        }
        try {
            orderReqDto.setSubmitType(orderSubmitType.getCode());
            orderReqDto.setDeduction(orderInfoDto.isDeduction());
            orderReqDto.setParentOrderNo("Y".equalsIgnoreCase(orderInfoDto.getIsParentOrder()) ? null : orderReqDto.getParentOrderNo());
            orderInfoDto.setWarehouseId(((ShopInfo)orderInfoDto.getShopList().get(0)).getWarehouseId());
            orderInfoDto.setWarehouseCode(((ShopInfo)orderInfoDto.getShopList().get(0)).getWarehouseCode());
            orderInfoDto.setWarehouseName("\u9ed8\u8ba4\u4ed3\u5e93");
            logger.info("\u8c03\u7528\u4ea4\u6613\u4e2d\u5fc3\u63a5\u53e3,data----:{}", (Object)orderReqDto.toString());
            this.filterReqParam(orderReqDto);
            logger.info("\u8c03\u7528\u4ea4\u6613\u4e2d\u5fc3\u63a5\u53e3,\u8fc7\u6ee4\u540e\u6570\u636e:{}", (Object)orderReqDto);
            RestResponse stringRestResponse = this.orderApi.addOrderReturnEo(orderReqDto);
            orderRespDto = (OrderRespDto)RestResponseHelper.extractData((RestResponse)stringRestResponse);
            orderNo = orderRespDto.getOrderNo();
            simplePayReqDto.setOrderNo(orderNo);
            if (orderSubmitType == SubmitTypeEnum.SUBMIT && isOrder) {
                try {
                    logger.info("\u4e0b\u5355\u5904\u7406\u5b8c\u6210\u540e\uff0c\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u63a5\u53e3\uff0c\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)orderNo);
                    Long id = this.iStorageHelper.noticeInventoryAddOrder(orderNo);
                    logger.info("\u4e0b\u5355\u5904\u7406\u5b8c\u6210\u540e\uff0c\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u63a5\u53e3\uff0c\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,createDeliveryResp:{}", (Object)id);
                }
                catch (Exception e) {
                    logger.error("\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5f02\u5e38,e:{}", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            BigDecimal offlineAmount;
            e.printStackTrace();
            submitErrorTypeEnum = OrderSubmitErrorTypeEnum.ORDER_SUBMIT_FAIL;
            errorMsg = "\u521b\u5efa\u8ba2\u5355\u5931\u8d25: " + e.toString();
            if (Objects.nonNull(simplePayReqDto) && Objects.nonNull(simplePayReqDto.getCreditPayReqDto())) {
                simplePayReqDto.getCreditPayReqDto().setRemark(e.toString());
            }
            abstractPayHelp.errorCallBack(simplePayReqDto);
            if ("SKILL_ORDER".equals(orderReqDto.getFlowType())) {
                this.increaseJoinAcitvityNum(orderInfoDto, -1);
            }
            BigDecimal bigDecimal = offlineAmount = Objects.isNull(orderReqDto.getOfflineAmount()) ? BigDecimal.ZERO : orderReqDto.getOfflineAmount();
            if (BigDecimal.ZERO.compareTo(offlineAmount) < 0) {
                OfflineBalanceAccountRollBackReqDto offlineRollBack = new OfflineBalanceAccountRollBackReqDto();
                offlineRollBack.setCustomerId(Long.valueOf(orderReqDto.getCustomerId()));
                offlineRollBack.setRelationNo(orderReqDto.getOrderNo());
                RestResponseHelper.extractData((RestResponse)this.offlineBalanceAccountQueryApi.offlineBalanceAccountRollBack(offlineRollBack));
            }
            if (StringUtils.isNotBlank(orderNo)) {
                ExchangeBalanceRollBackReqDto rollBackReqDto = new ExchangeBalanceRollBackReqDto();
                rollBackReqDto.setOrderNo(orderNo);
                rollBackReqDto.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.ORDER_FAILED);
                logger.info("\u56de\u6eda\u6362\u8d2d\u7d2f\u8ba1\u989d\u5ea6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)rollBackReqDto);
                RestResponseHelper.extractData((RestResponse)this.exchangeBalanceAccountApi.rollbackExchangeAccount(rollBackReqDto));
            }
            OrderSubmitItemRespDto orderSubmitItemRespDto = this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, errorMsg, null);
            return orderSubmitItemRespDto;
        }
        try {
            if (!oriPayType.equals(PayMethodEnum.CREDIT_PAY.getCode())) {
                abstractPayHelp.successCallBack(simplePayReqDto);
            }
        }
        catch (Exception e) {
            submitErrorTypeEnum = OrderSubmitErrorTypeEnum.PAY_FAIL_CALLBACK;
            errorMsg = "\u8be5\u652f\u4ed8\u65b9\u5f0f:" + this.getPayName(orderInfoDto) + "\u652f\u4ed8\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0[" + e.getMessage() + "]";
            e.printStackTrace();
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        logger.info("\u6e05\u9664\u8d2d\u7269\u8f66\u5546\u54c1,\u662f\u5426\u6709\u5f02\u5e38[{}],\u6e05\u9664\u7684\u5546\u54c1[{}]", (Object)submitErrorTypeEnum.getCode(), (Object)orderInfoDto.getItemList());
        if (!submitErrorTypeEnum.getCode().equals(OrderSubmitErrorTypeEnum.SYSTEM_ERROR.getCode())) {
            this.clearShoppingCartItem(orderInfoDto.getItemList());
        }
        return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.YES.getValue(), submitErrorTypeEnum, errorMsg, orderSubmitType);
    }

    private void filterReqParam(OrderReqDto orderReqDto) {
        ArrayList orderItems = Lists.newArrayList();
        for (TradeItemReqDto e : orderReqDto.getOrderItems()) {
            e.setRebateAmount(BigDecimal.ZERO);
            if (SubmitTypeEnum.SAVE.getCode().equals(orderReqDto.getSubmitType()) && (ExchangeEnum.YES.getType().equals(e.getIfExchange()) || CombinationEnum.YES.getType().equals(e.getIsCombinedPackage()))) continue;
            orderItems.add(e);
        }
        orderReqDto.setOrderItems((List)orderItems);
    }

    private RestResponse<Void> checkControl(SubmitOrderReqDto orderInfoDto, OrderReqDto orderReqDto) {
        RestResponse<Void> controlStorageResult;
        OrderBaseReqDto orderBaseReqDto = new OrderBaseReqDto();
        orderBaseReqDto.setOrderNo(orderReqDto.getOrderNo());
        orderBaseReqDto.setCustomerId(ParamConverter.convertToLong((Object)orderReqDto.getCustomerId()));
        orderBaseReqDto.setPayAmount(orderInfoDto.getPayAmount());
        orderBaseReqDto.setTotalAmount(orderInfoDto.getTotalAmount());
        BigDecimal deductionAmount = BigDecimal.ZERO;
        if (orderInfoDto.getGiftInfoReqDto() != null && orderInfoDto.getGiftInfoReqDto().isDeduction()) {
            deductionAmount = orderInfoDto.getGiftInfoReqDto().getDeductionAmount();
        }
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getGiftItems())) {
            BigDecimal totalGiftOrigAmount = orderInfoDto.getGiftItems().stream().map(OrderItemInfoDto::getItemOrigPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderBaseReqDto.setTotalGiftOrigAmount(totalGiftOrigAmount);
        }
        orderBaseReqDto.setDeductionAmount(deductionAmount);
        List orderItemBaseReqDtos = orderReqDto.getOrderItems().stream().map(tradeItemReqDto -> {
            OrderItemBaseReqDto orderItemBaseReqDto = new OrderItemBaseReqDto();
            orderItemBaseReqDto.setItemId(ParamConverter.convertToLong((Object)tradeItemReqDto.getItemSerial()));
            orderItemBaseReqDto.setItemNum(tradeItemReqDto.getItemNum());
            orderItemBaseReqDto.setItemCode(tradeItemReqDto.getItemCode());
            return orderItemBaseReqDto;
        }).collect(Collectors.toList());
        orderBaseReqDto.setItemList(orderItemBaseReqDtos);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCustomerQueryApi.queryListByCustomerIds(Collections.singletonList(ParamConverter.convertToLong((Object)orderReqDto.getCustomerId()))));
        Long orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            orgId = ((CustomerRespDto)customerRespDtos.get(0)).getMerchantId();
        }
        if (OrderDeliveryTypeEnum.SELLER.getType().equals(orderReqDto.getDeliveryType()) && (controlStorageResult = this.controlService.checkInventoryControl(orderReqDto, orgId)) != null && !"0".equals(controlStorageResult.getResultCode())) {
            return controlStorageResult;
        }
        RestResponse<Void> restResponse = this.controlService.checkAmountAndGiftControl(orgId, orderInfoDto);
        if (restResponse != null && !"0".equals(restResponse.getResultCode())) {
            return restResponse;
        }
        this.controlService.checkControlRule(orderBaseReqDto, orgId, orderInfoDto.isIgnoreWarn(), false);
        return RestResponse.VOID;
    }

    private OrderSubmitItemRespDto batchCreditPay(SubmitOrderReqDto orderInfoDto, OrderReqDto orderReqDto) {
        SimplePayReqDto simplePayReqDto;
        AbstractPayHelp mutPayHelp = null;
        String errorMsg = "";
        OrderSubmitErrorTypeEnum submitErrorTypeEnum = OrderSubmitErrorTypeEnum.SUCCESS;
        mutPayHelp = this.payFactory.create(PayMethodEnum.CREDIT_PAY.getCode());
        boolean systemError = false;
        for (SubmitOrderReqDto orderReq : orderInfoDto.getSonOrder()) {
            if (!PayMethodEnum.CREDIT_PAY.getCode().equals(orderReq.getPayMethod())) continue;
            simplePayReqDto = null;
            try {
                simplePayReqDto = mutPayHelp.initParam(orderInfoDto, orderReqDto, orderReq);
                simplePayReqDto.setPayAmount(orderReq.getCreditPayAmount());
                mutPayHelp.prePay(simplePayReqDto);
            }
            catch (Exception e) {
                logger.info("[\u4fe1\u7528\u652f\u4ed8\u7cfb\u7edf\u5f02\u5e38],data----:" + JSONObject.toJSONString((Object)orderReq));
                simplePayReqDto.setPayMsg(e.toString());
                systemError = true;
            }
            if (systemError || !mutPayHelp.allowSubmitOrder(simplePayReqDto)) {
                submitErrorTypeEnum = OrderSubmitErrorTypeEnum.PAY_REJECT;
                errorMsg = simplePayReqDto.getPayMsg();
                if (!StringUtils.isBlank((String)simplePayReqDto.getPayMsg())) break;
                errorMsg = "\u8be5\u652f\u4ed8\u65b9\u5f0f:" + this.getPayName(orderInfoDto) + "\u4e0d\u5141\u8bb8\u652f\u4ed8";
                break;
            }
            simplePayReqDto.getCreditPayReqDto().getCreditPayRespDto().setIsUseCreditPay("Y");
            orderReq.setSimplePayReqDto(simplePayReqDto);
        }
        if (submitErrorTypeEnum == OrderSubmitErrorTypeEnum.PAY_REJECT) {
            for (SubmitOrderReqDto creditBatchPayReqDto : orderInfoDto.getSonOrder()) {
                if (creditBatchPayReqDto.getSimplePayReqDto() == null || creditBatchPayReqDto.getSimplePayReqDto().getCreditPayReqDto() == null || !"Y".equals(creditBatchPayReqDto.getSimplePayReqDto().getCreditPayReqDto().getCreditPayRespDto().getIsUseCreditPay())) continue;
                simplePayReqDto = creditBatchPayReqDto.getSimplePayReqDto();
                CreditPayReqDto creditPayReqDto = simplePayReqDto.getCreditPayReqDto();
                creditPayReqDto.setRemark(errorMsg);
                mutPayHelp.errorCallBack(simplePayReqDto);
            }
            return this.buildSubmitResult(null, YesNoEnum.NO.getValue(), submitErrorTypeEnum, errorMsg, null);
        }
        return this.buildSubmitResult(null, YesNoEnum.YES.getValue(), submitErrorTypeEnum, errorMsg, null);
    }

    private OrderSubmitItemRespDto batchRebate(SubmitOrderReqDto orderInfoDto, OrderReqDto orderReqDto) {
        OrderSubmitErrorTypeEnum submitErrorTypeEnum = OrderSubmitErrorTypeEnum.SUCCESS;
        if (orderInfoDto.getTotalRebateAmount() != null && orderInfoDto.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
            for (SubmitOrderReqDto submitOrderReqDto : orderInfoDto.getSonOrder()) {
                if (submitOrderReqDto.getTotalRebateAmount() == null || submitOrderReqDto.getTotalRebateAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                OrderRebateAmountQueryReqDto orderRebateAmountQueryReqDto = new OrderRebateAmountQueryReqDto();
                List collect = submitOrderReqDto.getItemList().stream().map(data -> {
                    com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto newData = new com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto();
                    BeanUtils.copyProperties((Object)data, (Object)newData);
                    return newData;
                }).collect(Collectors.toList());
                orderRebateAmountQueryReqDto.setShopId(((ShopInfo)submitOrderReqDto.getShopList().get(0)).getId());
                orderRebateAmountQueryReqDto.setItemList(collect);
                orderRebateAmountQueryReqDto.setCustomerId(submitOrderReqDto.getCustomerId());
                orderRebateAmountQueryReqDto.setExtFields((Map)Maps.newHashMap());
                try {
                    RestResponse orderRebateAmountRespDtoRestResponse = this.balanceQueryApi.queryUsableBalance(orderRebateAmountQueryReqDto);
                    OrderRebateAmountRespDto orderRebateAmountRespDto = (OrderRebateAmountRespDto)RestResponseHelper.extractData((RestResponse)orderRebateAmountRespDtoRestResponse);
                    if (orderRebateAmountRespDto.getBalance() != null && orderRebateAmountRespDto.getBalance().compareTo(submitOrderReqDto.getTotalRebateAmount()) >= 0) continue;
                    submitErrorTypeEnum = OrderSubmitErrorTypeEnum.REBATE_NO_ENOUGH;
                    String errorMsg = submitErrorTypeEnum.getName();
                    return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, errorMsg, null);
                }
                catch (Exception e) {
                    logger.info("\u67e5\u8be2\u8fd4\u5229\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)orderRebateAmountQueryReqDto));
                    submitErrorTypeEnum = OrderSubmitErrorTypeEnum.REBATE_NO_ENOUGH;
                    String errorMsg = e.getMessage();
                    e.printStackTrace();
                    return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, errorMsg, null);
                }
            }
        }
        return this.buildSubmitResult(orderReqDto.getOrderNo(), YesNoEnum.NO.getValue(), submitErrorTypeEnum, "", null);
    }

    private OrderSubmitItemRespDto preOccupyStock(SubmitOrderReqDto mainOrderInfoDto, List<TradeItemReqDto> mainOrderitemList) {
        HashMap<String, SubmitOrderReqDto> stringSubmitOrderReqDtoHashMap = new HashMap<String, SubmitOrderReqDto>();
        try {
            for (SubmitOrderReqDto submitOrderReqDto : mainOrderInfoDto.getSonOrder()) {
                Integer deliveryType = submitOrderReqDto.getOrderReqDto().getDeliveryType();
                this.iStorageHelper.subVirStorage(submitOrderReqDto.getActivityIdsMap(), submitOrderReqDto.getOrderNo(), submitOrderReqDto.getActivityIds(), (ShopInfo)submitOrderReqDto.getShopList().get(0), submitOrderReqDto.getOrderReqDto().getOrderItems(), deliveryType);
                stringSubmitOrderReqDtoHashMap.put(submitOrderReqDto.getOrderNo(), submitOrderReqDto);
                submitOrderReqDto.setIsUseStock("Y");
            }
            return this.buildSubmitResult(mainOrderInfoDto.getOrderNo(), YesNoEnum.NO.getValue(), OrderSubmitErrorTypeEnum.SUCCESS, null, null);
        }
        catch (Exception e) {
            logger.info("\u6263\u51cf\u5e93\u5b58\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            for (Map.Entry entry : stringSubmitOrderReqDtoHashMap.entrySet()) {
                SubmitOrderReqDto value = (SubmitOrderReqDto)entry.getValue();
                List itemList = value.getOrderReqDto().getOrderItems();
                this.iStorageHelper.rollbackVirSotrage(mainOrderInfoDto, (String)entry.getKey(), itemList);
            }
            mainOrderInfoDto.setIsUseStock("N");
            return this.buildSubmitResult(mainOrderInfoDto.getOrderNo(), YesNoEnum.NO.getValue(), OrderSubmitErrorTypeEnum.STOCK_NO_ENOUGH, e.getMessage(), null);
        }
    }

    private OrderDeliveryTypeEnum checkDeliveryType(SubmitOrderReqDto submitOrderReqDto) {
        for (TradeItemReqDto orderItem : submitOrderReqDto.getOrderReqDto().getOrderItems()) {
            if (!CombinationEnum.YES.getType().equals(orderItem.getIsCombinedPackage())) continue;
            return OrderDeliveryTypeEnum.SELLER;
        }
        return this.deliveryRuleUtils.isSellerDelivery(submitOrderReqDto.getCustomerId()) ? OrderDeliveryTypeEnum.SELLER : OrderDeliveryTypeEnum.FACTORY;
    }

    private Map<String, List<CargoRespDto>> buildCargosGroup(SubmitOrderReqDto orderInfoDto) {
        List cargoCodes = orderInfoDto.getItemList().stream().map(OrderItemInfoDto::getCargoCode).collect(Collectors.toList());
        RestResponse listRestResponse = this.iCargoQueryApi.listByCodes(cargoCodes);
        List cargos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<String, List<CargoRespDto>> cargosGroup = cargos.stream().collect(Collectors.groupingBy(CargoRespDto::getCode, Collectors.toList()));
        return cargosGroup;
    }

    private String changeToSaveOrder(String orderNo, boolean isChangeToSave, OrderReqDto orderReqDto) {
        if (isChangeToSave && StringUtils.isBlank((String)orderNo)) {
            try {
                orderReqDto.setTotalRebateAmount(null);
                orderReqDto.setUseRebateDeduct(false);
                orderReqDto.setActivity(new OrderActivityInfoJoinReqDto());
                orderReqDto.setSubmitType(SubmitTypeEnum.SAVE.getCode());
                orderNo = (String)RestResponseHelper.extractData((RestResponse)this.orderApi.addOrder(orderReqDto));
            }
            catch (Exception e) {
                logger.info("\u8ba2\u5355\u8f6c\u4fdd\u5b58\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)orderReqDto));
                logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            }
        }
        return orderNo;
    }

    private void buildSubmitResult(SubmitOrderReqDto orderInfoDto, OrderReqDto orderReqDto) {
        Integer shippingType = orderInfoDto.getShippingType();
        if (shippingType != null && ShippingTypeEnum.getByCode((int)shippingType) != null) {
            orderReqDto.setShippingType(ShippingTypeEnum.getByCode((int)shippingType).getType());
        } else {
            orderReqDto.setShippingType(ShippingTypeEnum.EXPRESS.getType());
        }
    }

    private String getPayName(SubmitOrderReqDto orderInfoDto) {
        return PayMethodEnum.toName((String)orderInfoDto.getPayMethod());
    }

    private OrderSubmitItemRespDto buildSubmitResult(String orderNo, Integer isPayed, OrderSubmitErrorTypeEnum submitErrorTypeEnum, String errorMsg, SubmitTypeEnum orderSubmitType) {
        OrderSubmitItemRespDto orderSubmitItemRespDto = new OrderSubmitItemRespDto();
        orderSubmitItemRespDto.setIsSubmit(orderSubmitType == null || SubmitTypeEnum.SAVE == orderSubmitType ? YesNoEnum.NO.getValue() : YesNoEnum.YES.getValue());
        orderSubmitItemRespDto.setOrderSubmitErrorType(submitErrorTypeEnum.getCode());
        orderSubmitItemRespDto.setErrorMsg(errorMsg);
        orderSubmitItemRespDto.setIsPayed(isPayed);
        orderSubmitItemRespDto.setOrderNo(OrderSubmitErrorTypeEnum.SUCCESS != submitErrorTypeEnum ? null : orderNo);
        return orderSubmitItemRespDto;
    }

    private void paySuccess(Integer isPayed, OrderSubmitErrorTypeEnum submitErrorTypeEnum, String errorMsg, SubmitTypeEnum orderSubmitType, SimplePayReqDto simplePayReqDto, SubmitOrderReqDto orderInfoDto, AbstractPayHelp abstractPayHelp) {
    }

    private Map<Long, ItemDetailRespDto> buildOrderItem(SubmitOrderReqDto orderInfoDto) {
        Set itemIdList = orderInfoDto.getItemList().stream().map(OrderItemInfoDto::getItemId).collect(Collectors.toSet());
        HashSet giftItemIdList = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getGiftItems())) {
            Set collect = orderInfoDto.getGiftItems().stream().map(OrderItemInfoDto::getItemId).collect(Collectors.toSet());
            giftItemIdList.addAll(collect);
        }
        itemIdList.addAll(giftItemIdList);
        Map<Long, ItemDetailRespDto> itemDetails = this.commonService.queryItemDetails(Lists.newArrayList(itemIdList));
        for (ItemDetailRespDto value : itemDetails.values()) {
            if (!giftItemIdList.contains(value.getItem().getId())) continue;
            HashMap<String, Integer> extFields = new HashMap<String, Integer>(value.getExtFields());
            extFields.put("gift", 1);
            value.setExtFields(extFields);
        }
        return itemDetails;
    }

    private void buildAgainOrder(SubmitOrderReqDto orderInfoDto) {
        if (null != orderInfoDto.getAddress() && null != orderInfoDto.getAddress().getAddressId()) {
            orderInfoDto.getAddress().setId(orderInfoDto.getAddress().getAddressId());
        }
        orderInfoDto.setAddress(null == orderInfoDto.getAddress() ? new OrderAddressReqDto() : orderInfoDto.getAddress());
    }

    private PriceAddOrModifyRespDto getPriceAddOrModifyRespDto(SubmitOrderReqDto orderInfoDto) {
        PriceAddOrModifyRespDto validate;
        if (orderInfoDto.getCheckPriceLimit().booleanValue() && null != (validate = this.priceLimitService.checkPriceLimitByOrder(orderInfoDto)) && CollectionUtils.isNotEmpty((Collection)validate.getPriceOfferLimitItemRespDtos())) {
            return validate;
        }
        return null;
    }

    private void buildData(SubmitOrderReqDto orderInfoDto) {
        if (CollectionUtils.isEmpty((Collection)orderInfoDto.getShopIds())) {
            orderInfoDto.setShopIds(Arrays.asList(((OrderItemInfoDto)orderInfoDto.getItemList().get(0)).getShopId()));
        }
    }

    private void findCustomerId(SubmitOrderReqDto orderInfoDto) {
        RestResponse shopDtoRestResponse = this.shopQueryApi.queryById(((OrderItemInfoDto)orderInfoDto.getItemList().get(0)).getShopId().longValue(), new String[0]);
        RestResponse sellerRespDtoRestResponse = this.sellerQueryApi.queryById(((ShopDto)shopDtoRestResponse.getData()).getSellerId());
        Long organizationId = ((SellerRespDto)sellerRespDtoRestResponse.getData()).getOrganizationId();
        RestResponse listRestResponse = this.iCustomerQueryApi.queryCustomerByOrgAndMerch(orderInfoDto.getOrgInfoId(), organizationId);
        orderInfoDto.setCustomerId(((CustomerRespDto)listRestResponse.getData()).getId());
        orderInfoDto.setCustomerCode(((CustomerRespDto)listRestResponse.getData()).getCode());
        orderInfoDto.setMerchantId(organizationId);
    }

    private EngineResult getEngineResultRestResponse(SubmitOrderReqDto submitOrderReqDto, OrderReqDto orderReqDto, EngineOrderReq engineOrderReq) {
        if (submitOrderReqDto.getCreditAccountId() == null) {
            throw new BizException("\u4fe1\u7528\u652f\u4ed8\u8bf7\u6307\u5b9a\u4fe1\u7528\u8d26\u53f7id");
        }
        engineOrderReq.setCreditAccountId(submitOrderReqDto.getCreditAccountId());
        engineOrderReq.setCustomerId(Long.valueOf(submitOrderReqDto.getCustomerId()));
        engineOrderReq.setIsPassOverdueStrategyRemind(submitOrderReqDto.getIsPassOverdueStrategyRemind());
        engineOrderReq.setIsPassQuotaStrategyRemind(submitOrderReqDto.getIsPassQuotaStrategyRemind());
        engineOrderReq.setOrderNode(OrderNodeEnum.SUBMIT_ORDER.getType());
        engineOrderReq.setOrderNo("");
        ArrayList<OrderSkuInfo> list = new ArrayList<OrderSkuInfo>();
        for (TradeItemReqDto orderItem : orderReqDto.getOrderItems()) {
            OrderSkuInfo orderSkuInfo = new OrderSkuInfo();
            orderSkuInfo.setDirId(null);
            orderSkuInfo.setIsFreight(Integer.valueOf(1));
            orderSkuInfo.setName(orderItem.getSkuName());
            orderSkuInfo.setNum(orderItem.getItemNum());
            orderSkuInfo.setOrganizationId("");
            orderSkuInfo.setPayAmount(orderItem.getItemPrice());
            orderSkuInfo.setPrice(orderItem.getPayTotalAmount());
            orderSkuInfo.setSkuCode(orderItem.getSkuCode());
            list.add(orderSkuInfo);
        }
        engineOrderReq.setOrderInfoList(list);
        engineOrderReq.setTotalAmount(orderReqDto.getPayAmount());
        RestResponse restResponse = this.creditNodeApi.doAction(engineOrderReq);
        EngineResult engineResult = (EngineResult)RestResponseHelper.extractData((RestResponse)restResponse);
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u524d\u7f00,\u67e5\u8be2\u4fe1\u7528\u4e2d\u5fc3:" + JSONObject.toJSONString((Object)engineResult));
        if (restResponse.getData() != null && !CollectionUtils.isEmpty((Collection)((EngineResult)restResponse.getData()).getAccountOccupyInfoList())) {
            AccountOccupyInfo accountOccupyInfo = (AccountOccupyInfo)((EngineResult)restResponse.getData()).getAccountOccupyInfoList().get(0);
            Map map = orderReqDto.getExtFields();
            map.put("creditAccountNo", accountOccupyInfo.getAccountCode());
            orderReqDto.setExtFields(map);
        }
        return (EngineResult)restResponse.getData();
    }

    private boolean isContainGroupActivity(SubmitOrderReqDto orderInfoDto) {
        if (orderInfoDto.getOrderActivity() != null && CollectionUtils.isNotEmpty((Collection)orderInfoDto.getOrderActivity().getActivityList())) {
            for (OrderActivityBizReqDto orderActivityBizReqDto : orderInfoDto.getOrderActivity().getActivityList()) {
                if (orderActivityBizReqDto.getType() == null || !orderActivityBizReqDto.getType().equals(1)) continue;
                return true;
            }
        }
        return false;
    }

    private void clearShoppingCartItem(List<OrderItemInfoDto> itemList) {
        List shoppingCartItemIdList = itemList.stream().map(OrderItemInfoDto::getShoppingCartItemId).collect(Collectors.toList());
        this.shoppingCart.batchRemoveItem(shoppingCartItemIdList);
    }

    private void validateOrderInfo(SubmitOrderReqDto orderInfoDto, Map<Long, ItemDetailRespDto> itemDetails) {
        this.findCustomerId(orderInfoDto);
        if (null != orderInfoDto.getIsUseCreditAccount() && orderInfoDto.getIsUseCreditAccount() == 1) {
            orderInfoDto.setPayType("CREDIT_PAY");
        }
        if ("Y".equalsIgnoreCase(orderInfoDto.getIsParentOrder())) {
            return;
        }
        if (Objects.isNull(orderInfoDto.getCustomerId())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_INFO_NOT_EMPTY);
        }
        if (CollectionUtils.isEmpty((Collection)orderInfoDto.getItemList())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.TRADE_ITEM_NOT_EMPTY);
        }
        if (Objects.nonNull(orderInfoDto.getOrderActivity()) && CollectionUtils.isNotEmpty((Collection)orderInfoDto.getOrderActivity().getActivityList()) && ActivityTypeEnum.SECKILL.getCode().equals(((OrderActivityBizReqDto)orderInfoDto.getOrderActivity().getActivityList().get(0)).getType())) {
            Long activityId = ((OrderActivityBizReqDto)orderInfoDto.getOrderActivity().getActivityList().get(0)).getActivityId();
            OrderItemInfoDto orderItemInfoDto = (OrderItemInfoDto)orderInfoDto.getItemList().get(0);
            this.seckillActivityUtil.validateItemLimit(activityId, orderItemInfoDto.getItemNum());
            this.seckillActivityUtil.validateItemStock(activityId, orderItemInfoDto.getSkuId(), orderItemInfoDto.getShopId(), orderItemInfoDto.getItemNum());
            Integer actvityLimit = this.getActivtyLimitNum(activityId);
            if (null != actvityLimit) {
                int joinNum = this.increaseJoinAcitvityNum(orderInfoDto, 1);
                if (joinNum > actvityLimit) {
                    this.increaseJoinAcitvityNum(orderInfoDto, -1);
                    BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.USER_JOIN_ACTIVITY_NO_EXCEED);
                } else {
                    this.increaseJoinAcitvityNum(orderInfoDto, -1);
                }
            }
        }
        for (OrderItemInfoDto orderItemInfoDto : orderInfoDto.getItemList()) {
            boolean isOnShelf;
            ItemSkuRespDto sku;
            ItemDetailRespDto itemDetailRespDto = itemDetails.get(orderItemInfoDto.getItemId());
            if (null == itemDetailRespDto || null == itemDetailRespDto.getItem() || null == itemDetailRespDto.getItemSkuList()) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
            }
            if (null == (sku = this.commonService.getItemSkuRespDto(orderItemInfoDto.getSkuId(), itemDetailRespDto))) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_SKU_NOT_EXIST);
            }
            if (isOnShelf = this.itemService.isOnshelf(orderItemInfoDto.getShopId(), orderItemInfoDto.getItemId(), orderItemInfoDto.getSkuId()).booleanValue()) continue;
            throw new BizException("\u5546\u54c1\u5df2\u4e0b\u67b6,\u5546\u54c1\u540d\u79f0\uff1a\u3010" + orderItemInfoDto.getItemName() + "\u3011");
        }
    }

    private OrderReqDto convertToOrderReqDto(SubmitOrderReqDto orderInfoDto, Map<Long, ItemDetailRespDto> itemDetails) {
        OrderJoinActivityBizReqDto orderActivity;
        ArrayList<OrderExtInfoDto> extInfos;
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Long userId = this.context.userId();
        OrderReqDto orderReqDto = new OrderReqDto();
        orderReqDto.setOrderNo(orderInfoDto.getOrderNo());
        orderReqDto.setGiftAccount(orderInfoDto.isGiftAccount());
        orderReqDto.setRuleId(orderInfoDto.getRuleId());
        orderReqDto.setIsSplitBySys(orderInfoDto.getIsSplitBySys());
        if (StringUtils.isEmpty((String)orderInfoDto.getPlaceType())) {
            orderInfoDto.setPlaceType("2");
        }
        orderInfoDto.setWarehouseId(((ShopInfo)orderInfoDto.getShopList().get(0)).getWarehouseId());
        orderInfoDto.setWarehouseCode(((ShopInfo)orderInfoDto.getShopList().get(0)).getWarehouseCode());
        orderInfoDto.setWarehouseName("\u9ed8\u8ba4\u4ed3\u5e93");
        Integer audit = 1;
        orderReqDto.setAuditType(audit);
        orderReqDto.setUserId(userId + "");
        orderReqDto.setInstanceId(instanceId);
        orderReqDto.setTenantId(tenantId);
        orderReqDto.setPayAmount(orderInfoDto.getPayAmount());
        orderReqDto.setTotalAmount(orderInfoDto.getTotalAmount());
        orderReqDto.setParentOrderNo(orderInfoDto.getParentOrderNo());
        orderReqDto.setTotalItemNum(orderInfoDto.getTotalItemNum());
        orderReqDto.setBuyerRemark(orderInfoDto.getBuyerRemark());
        if (Objects.nonNull(orderInfoDto.getWarehouseId())) {
            orderReqDto.setWarehouseSerial(orderInfoDto.getWarehouseId().toString());
        }
        orderReqDto.setWarehouseCode(orderInfoDto.getWarehouseCode());
        orderReqDto.setBizType(OrderBizTypeEnum.ORDER.getCode().toString());
        orderReqDto.setSaleChannel(SaleChannelEnum.SALECHANNEL_ZYSC.getCode());
        orderReqDto.setFreightAmount(BigDecimal.ZERO);
        orderReqDto.setUserSrc("icommerceb");
        orderReqDto.setPlatformDiscountAmount(BigDecimal.ZERO);
        orderReqDto.setShopDiscountAmount(BigDecimal.ZERO);
        orderReqDto.setTotalRebateAmount(orderInfoDto.getTotalRebateAmount());
        orderReqDto.setAmountDetail(null);
        if (Objects.nonNull(orderInfoDto.getInvoiceInfo()) && Objects.nonNull(orderInfoDto.getInvoiceInfo().getInvoiceTaxType())) {
            extInfos = new ArrayList();
            OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)orderInfoDto.getInvoiceInfo());
            jsonObject.put("invoiceLinkAddress", (Object)JSONObject.toJSONString((Object)orderInfoDto.getInvoiceLinkAddress()));
            orderExtInfoDto.setInvoice(jsonObject.toJSONString());
            extInfos.add(orderExtInfoDto);
            orderReqDto.setExtInfos(extInfos);
        }
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getExtInfos())) {
            extInfos = new ArrayList<OrderExtInfoDto>();
            CubeBeanUtils.copyCollection(extInfos, (Collection)orderInfoDto.getExtInfos(), OrderExtInfoDto.class);
            orderReqDto.setExtInfos(extInfos);
        }
        if ((orderActivity = orderInfoDto.getOrderActivity()) != null && CollectionUtils.isNotEmpty((Collection)orderActivity.getActivityList())) {
            if (ActivityTypeEnum.SECKILL.getCode().equals(((OrderActivityBizReqDto)orderActivity.getActivityList().get(0)).getType()) && CollectionUtils.isNotEmpty((Collection)orderInfoDto.getItemList()) && orderInfoDto.getItemList().size() == 1) {
                orderReqDto.setFlowType("SKILL_ORDER");
                orderInfoDto.setFlowType("SKILL_ORDER");
            }
            logger.info("\u9884\u89c8\u63a5\u53e3\u6d3b\u52a8\u6392\u5e8f\u524d\uff1a{}", (Object)JSON.toJSONString((Object)orderActivity.getActivityList()));
            ArrayList activityList = Lists.newArrayList();
            for (OrderActivityBizReqDto orderActivityBizReqDto : orderActivity.getActivityList()) {
                if (!"SKILL_ORDER".equals(orderReqDto.getFlowType()) && ActivityTypeTobEnum.SECKILL_TOB_ACTIVITY.getName().equals(orderActivityBizReqDto.getActivityType())) continue;
                orderActivityBizReqDto.setSort(ActivityTypeTobEnum.getSortByName((String)orderActivityBizReqDto.getActivityType()).intValue());
                activityList.add(orderActivityBizReqDto);
            }
            List activitySortedList = activityList.stream().sorted(Comparator.comparing(OrderActivityBizReqDto::getSort).reversed()).collect(Collectors.toList());
            orderActivity.setActivityList(activitySortedList);
            logger.info("\u9884\u89c8\u63a5\u53e3\u6d3b\u52a8\u6392\u5e8f\u540e\uff1a{}", (Object)JSON.toJSONString((Object)orderActivity.getActivityList()));
            ArrayList shopSkuActivityList = new ArrayList();
            HashSet activityIdSet = new HashSet();
            List list = orderActivity.getActivityList().stream().map(activity -> {
                if (Objects.nonNull(activity.getSkuId())) {
                    activity.setShopSkuStr(activity.getShopId() + "_" + activity.getSkuId());
                    shopSkuActivityList.add(activity);
                    activityIdSet.add(activity.getActivityId());
                } else {
                    List shopSkuList = activity.getShopSkuList();
                    if (CollectionUtils.isNotEmpty((Collection)shopSkuList)) {
                        for (String shopSku : shopSkuList) {
                            OrderActivityBizReqDto newActivity = new OrderActivityBizReqDto();
                            CubeBeanUtils.copyProperties((Object)newActivity, (Object)activity, (String[])new String[0]);
                            newActivity.setShopSkuStr(shopSku);
                            shopSkuActivityList.add(newActivity);
                        }
                        activityIdSet.add(activity.getActivityId());
                    }
                }
                if (activity.getType() == null) {
                    activity.setType(Integer.valueOf(6));
                }
                OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
                BeanUtils.copyProperties((Object)activity, (Object)orderActivityInfoReqDto);
                orderActivityInfoReqDto.setActivityId(activity.getActivityId());
                if (activity.getType() != null && activity.getType().equals(1)) {
                    orderReqDto.setBizType("2");
                }
                if (activity.getActivityGroupId() != null) {
                    ArrayList<String> groupIds = new ArrayList<String>();
                    groupIds.add(activity.getActivityGroupId().toString());
                    orderActivityInfoReqDto.setActivityItemIds(groupIds);
                    orderReqDto.setBizType("2");
                }
                if (CollectionUtils.isNotEmpty((Collection)activity.getCouponIds())) {
                    orderActivityInfoReqDto.setActivityItemIds(activity.getCouponIds());
                }
                orderActivityInfoReqDto.setType(activity.getType());
                return orderActivityInfoReqDto;
            }).collect(Collectors.toList());
            OrderActivityInfoJoinReqDto orderActivityInfoJoinReqDto = new OrderActivityInfoJoinReqDto();
            HashSet<Long> set = new HashSet<Long>();
            ArrayList<OrderActivityInfoReqDto> newActivityList = new ArrayList<OrderActivityInfoReqDto>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                OrderActivityInfoReqDto activity2 = (OrderActivityInfoReqDto)iterator.next();
                if (set.add(activity2.getActivityId())) {
                    newActivityList.add(activity2);
                    continue;
                }
                if (activity2.getType() != 2) continue;
                newActivityList.add(activity2);
            }
            orderActivityInfoJoinReqDto.setActivityList(newActivityList);
            orderReqDto.setActivity(orderActivityInfoJoinReqDto);
            Map activityJoinMap = shopSkuActivityList.stream().sorted(Comparator.comparingLong(OrderActivityBizReqDto::getActivityId)).collect(Collectors.groupingBy(OrderActivityBizReqDto::getShopSkuStr, Collectors.mapping(act -> act.getActivityId(), Collectors.toList())));
            orderInfoDto.setActivityIdsMap(activityJoinMap);
            orderInfoDto.setActivityIds(new ArrayList(activityIdSet));
        }
        Map<String, BigDecimal> brandSuggestRetailPriceMap = this.brandSuggestRetailPriceMap(orderInfoDto);
        HashMap<Long, ShopDto> shopMap = new HashMap<Long, ShopDto>();
        ArrayList orderItemList = this.convertToTradeItemReqDtoList(orderInfoDto, orderInfoDto.getItemList(), itemDetails, shopMap, orderInfoDto.getActivityIdsMap(), brandSuggestRetailPriceMap, 0);
        if ("SKILL_ORDER".equals(orderReqDto.getFlowType())) {
            Date closeTime = this.getCloseTime(((OrderActivityBizReqDto)orderActivity.getActivityList().get(0)).getActivityId());
            orderReqDto.setCloseTime(closeTime);
        } else {
            Integer effectiveTime = this.commonService.getEffectiveTime();
            if (effectiveTime != null && effectiveTime > 0) {
                orderReqDto.setCloseTime(DateTime.now().plusMinutes(effectiveTime.intValue()).toDate());
            }
        }
        BigDecimal totalAmount = null;
        if (CollectionUtil.isNotEmpty(orderItemList)) {
            totalAmount = BigDecimal.ZERO;
            for (TradeItemReqDto tradeItemReqDto : orderItemList) {
                totalAmount = totalAmount.add(tradeItemReqDto.getPayTotalAmount());
            }
        }
        if (ObjectUtil.isNotNull((Object)totalAmount) && !totalAmount.equals(orderInfoDto.getTotalAmount())) {
            orderReqDto.setTotalAmount(totalAmount);
        }
        HashMap<String, List<Long>> emptyMap = new HashMap<String, List<Long>>();
        List<TradeItemReqDto> giftItems = this.convertToTradeItemReqDtoList(orderInfoDto, orderInfoDto.getGiftItems(), itemDetails, shopMap, emptyMap, brandSuggestRetailPriceMap, 1);
        orderReqDto.setGiftItems(giftItems);
        orderItemList.addAll(giftItems);
        Integer busType = ((TradeItemReqDto)orderItemList.stream().findFirst().get()).getBusType();
        orderReqDto.setBusType(busType);
        Map<String, List<TradeItemReqDto>> tradeItemMap = orderItemList.stream().collect(Collectors.groupingBy(TradeItemReqDto::getShopId));
        if (tradeItemMap.size() == 1) {
            Long shopId = ((OrderItemInfoDto)orderInfoDto.getItemList().get(0)).getShopId();
            ShopDto shopDto = (ShopDto)shopMap.get(shopId);
            orderReqDto.setShopType(shopDto.getType().toString());
            orderReqDto.setSellerId(shopDto.getSellerId().toString());
            orderReqDto.setShopId(shopId.toString());
        } else {
            ArrayList tradeItemReqDtoList = Lists.newArrayList();
            tradeItemMap.forEach((k, v) -> {
                ShopDto shopDto = (ShopDto)shopMap.get(Long.valueOf(k));
                v.forEach(tradeItemReqDto -> {
                    tradeItemReqDto.setSellerId(String.valueOf(shopDto.getSellerId()));
                    tradeItemReqDto.setShopType(String.valueOf(shopDto.getType()));
                    tradeItemReqDtoList.add(tradeItemReqDto);
                });
            });
            orderItemList = tradeItemReqDtoList;
            orderReqDto.setShopId("0");
            orderReqDto.setSellerId("0");
        }
        orderReqDto.setOrderItems((List)orderItemList);
        this.setAddressDefaultValue(orderInfoDto.getAddress());
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("customerId", orderInfoDto.getCustomerId());
        addrExtFields.put("customerName", orderInfoDto.getCustomerName());
        orderInfoDto.getAddress().setExtFields(addrExtFields);
        orderReqDto.setDeliveryAddress(orderInfoDto.getAddress());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerId", orderInfoDto.getCustomerId());
        map.put("placeType", orderInfoDto.getPlaceType());
        map.put("payType", orderInfoDto.getPayType());
        map.put("payStatus", PayStatusEnum.WAIT_PAY.getCode());
        map.put("deliveryDate", orderInfoDto.getDeliveryDate());
        map.put("attachements", orderInfoDto.getAttachmentList());
        map.put("customerCode", orderInfoDto.getCustomerCode());
        map.put("origOrderId", orderInfoDto.getOrigOrderId());
        orderReqDto.setExtFields(map);
        orderReqDto.setCustomerId(orderInfoDto.getCustomerId().toString());
        orderReqDto.setSubmitType(StringUtils.isBlank((String)orderReqDto.getSubmitType()) ? SubmitTypeEnum.SUBMIT.getCode() : orderReqDto.getSubmitType());
        orderReqDto.setAmountDetail("");
        orderReqDto.setMktChannel("");
        orderReqDto.setPayUserId("");
        orderReqDto.setPlaceUserId(userId.toString());
        orderReqDto.setSellerSrc("");
        orderReqDto.setDeviceType(orderInfoDto.getDeviceType());
        orderReqDto.setOfflineAmount(orderInfoDto.getOfflineAmount());
        return orderReqDto;
    }

    private Date getCloseTime(Long activityId) {
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = "yundt-cube-center-common-" + pfile;
        Integer payOvertime = (Integer)this.cacheService.getCache(group, KeyGenerator.getOvertimePayKey(activityId), Integer.class);
        if (payOvertime == null) {
            payOvertime = 30;
        }
        return DateUtil.addMinutes((Date)new Date(), (int)payOvertime);
    }

    public Integer getActivtyLimitNum(Long activityId) {
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = "yundt-cube-center-common-" + pfile;
        Integer actvityLimit = (Integer)this.cacheService.getCache(group, KeyGenerator.getActivityLimitKey(activityId), Integer.class);
        return actvityLimit;
    }

    private Integer increaseJoinAcitvityNum(SubmitOrderReqDto orderInfoDto, int num) {
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = "yundt-cube-center-common-" + pfile;
        Long activityId = ((OrderActivityBizReqDto)orderInfoDto.getOrderActivity().getActivityList().get(0)).getActivityId();
        Long userId = orderInfoDto.getOrgInfoId();
        Long joinNum = this.cacheService.hincrBy(group, KeyGenerator.getCustomerJoinActivityNumKey(activityId), userId.toString(), num);
        return joinNum.intValue();
    }

    private ShopDto getShopDto(Long shopId) {
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        if (null == shopDto || null == shopDto.getId()) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        return shopDto;
    }

    private void setAddressDefaultValue(OrderAddressReqDto address) {
        address = address == null ? new OrderAddressReqDto() : address;
        address.setProvinceCode(address.getProvinceCode() == null ? "" : address.getProvinceCode());
        address.setProvinceName(address.getProvinceName() == null ? "" : address.getProvinceName());
        address.setCityCode(address.getCityCode() == null ? "" : address.getCityCode());
        address.setCityName(address.getCityName() == null ? "" : address.getCityName());
        address.setAreaCode(address.getAreaCode() == null ? "" : address.getAreaCode());
        address.setAreaName(address.getAreaName() == null ? "" : address.getAreaName());
        address.setCountryCode("");
        address.setDetailed("");
        address.setInstanceId(this.context.instanceId());
        address.setTenantId(this.context.tenantId());
        address.setPostcode("");
        address.setRemark("");
        address.setStreetCode("");
        address.setStreetName("");
    }

    private List<TradeItemReqDto> convertToTradeItemReqDtoList(SubmitOrderReqDto orderInfoDto, List<OrderItemInfoDto> itemList, Map<Long, ItemDetailRespDto> itemDetails, Map<Long, ShopDto> shopMap, Map<String, List<Long>> activityIdsMap, Map<String, BigDecimal> brandSuggestRetailPriceMap, int gift) {
        Map<Object, Object> itemPolicyPriceRespDtoMap = null;
        itemPolicyPriceRespDtoMap = "SKILL_ORDER".equals(orderInfoDto.getFlowType()) || gift == 1 ? Maps.newConcurrentMap() : this.priceService.getItemDistributePolicyMap2(orderInfoDto.getItemList(), orderInfoDto.getCustomerId(), orderInfoDto.getSubmitDate());
        ArrayList tradeItemReqDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(itemList)) {
            ConcurrentMap finalItemPolicyPriceRespDtoMap = itemPolicyPriceRespDtoMap;
            itemList.forEach(item -> {
                if (shopMap.get(item.getShopId()) == null) {
                    ShopDto shopDto = this.getShopDto(item.getShopId());
                    shopMap.put(item.getShopId(), shopDto);
                }
                ItemDetailRespDto itemDetail = (ItemDetailRespDto)itemDetails.get(item.getItemId());
                TradeItemReqDto tradeItemReqDto = this.commonService.covertToTradeItem((OrderItemInfoDto)item, itemDetail, shopMap);
                ItemPolicyPriceRespDto itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)finalItemPolicyPriceRespDtoMap.get(item.getSkuId());
                this.commonService.covertPrice(tradeItemReqDto, orderInfoDto, (OrderItemInfoDto)item, activityIdsMap, itemPolicyPriceRespDto);
                tradeItemReqDto.setBrandSuggestedRetailPrice((BigDecimal)brandSuggestRetailPriceMap.get(item.getShopId() + "_" + item.getSkuId()));
                if (tradeItemReqDto.getBrandSuggestedRetailPrice() != null) {
                    JSONObject jsonObject = StringUtils.isNotEmpty((String)tradeItemReqDto.getExtension()) ? JSONObject.parseObject((String)tradeItemReqDto.getExtension()) : new JSONObject();
                    jsonObject.put("brandReatilPrice", (Object)tradeItemReqDto.getBrandSuggestedRetailPrice());
                    tradeItemReqDto.setExtension(jsonObject.toJSONString());
                }
                tradeItemReqDtoList.add(tradeItemReqDto);
            });
        }
        return tradeItemReqDtoList;
    }

    private Map<String, BigDecimal> brandSuggestRetailPriceMap(SubmitOrderReqDto submitOrderReqDto) {
        Map<String, BigDecimal> suggestMap = new HashMap<String, BigDecimal>();
        ArrayList<ItemSkuPriceConditionQueryReqDto> shopConditionList = new ArrayList<ItemSkuPriceConditionQueryReqDto>();
        this.addSkuIdAndShopId(shopConditionList, submitOrderReqDto.getItemList());
        this.addSkuIdAndShopId(shopConditionList, submitOrderReqDto.getGiftItems());
        if (CollectionUtils.isNotEmpty(shopConditionList)) {
            ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
            itemSkuPriceQueryReqDto.setShopConditionList(shopConditionList);
            RestResponse listRestResponse = this.basePriceItemQueryApi.queryRetailSkuPrice(itemSkuPriceQueryReqDto);
            List skuPriceQueryRespList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            suggestMap = skuPriceQueryRespList.stream().filter(Objects::nonNull).filter(e -> e.getCostRetailPrice() != null).collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId(), ItemSkuPriceQueryRespDto::getCostRetailPrice, (o1, o2) -> o1));
        }
        return suggestMap;
    }

    private void addSkuIdAndShopId(List<ItemSkuPriceConditionQueryReqDto> shopConditionList, List<OrderItemInfoDto> itemList) {
        if (CollectionUtils.isNotEmpty(itemList)) {
            for (OrderItemInfoDto itemInfoDto : itemList) {
                ItemSkuPriceConditionQueryReqDto skuPriceConditionReqDto = new ItemSkuPriceConditionQueryReqDto();
                skuPriceConditionReqDto.setSkuId(itemInfoDto.getSkuId());
                skuPriceConditionReqDto.setShopId(itemInfoDto.getShopId());
                shopConditionList.add(skuPriceConditionReqDto);
            }
        }
    }
}

